/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Tuning Spec for Supervised Tuning for first party models.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.SupervisedTuningSpec}
 */
public final class SupervisedTuningSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.SupervisedTuningSpec)
    SupervisedTuningSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SupervisedTuningSpec.newBuilder() to construct.
  private SupervisedTuningSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SupervisedTuningSpec() {
    trainingDatasetUri_ = "";
    validationDatasetUri_ = "";
    tuningMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SupervisedTuningSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_SupervisedTuningSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.TuningJobProto
        .internal_static_google_cloud_aiplatform_v1beta1_SupervisedTuningSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.class,
            com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Supported tuning modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode}
   */
  public enum TuningMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Tuning mode is unspecified.
     * </pre>
     *
     * <code>TUNING_MODE_UNSPECIFIED = 0;</code>
     */
    TUNING_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Full fine-tuning mode.
     * </pre>
     *
     * <code>TUNING_MODE_FULL = 1;</code>
     */
    TUNING_MODE_FULL(1),
    /**
     *
     *
     * <pre>
     * PEFT adapter tuning mode.
     * </pre>
     *
     * <code>TUNING_MODE_PEFT_ADAPTER = 2;</code>
     */
    TUNING_MODE_PEFT_ADAPTER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Tuning mode is unspecified.
     * </pre>
     *
     * <code>TUNING_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int TUNING_MODE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Full fine-tuning mode.
     * </pre>
     *
     * <code>TUNING_MODE_FULL = 1;</code>
     */
    public static final int TUNING_MODE_FULL_VALUE = 1;

    /**
     *
     *
     * <pre>
     * PEFT adapter tuning mode.
     * </pre>
     *
     * <code>TUNING_MODE_PEFT_ADAPTER = 2;</code>
     */
    public static final int TUNING_MODE_PEFT_ADAPTER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TuningMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TuningMode forNumber(int value) {
      switch (value) {
        case 0:
          return TUNING_MODE_UNSPECIFIED;
        case 1:
          return TUNING_MODE_FULL;
        case 2:
          return TUNING_MODE_PEFT_ADAPTER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TuningMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TuningMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TuningMode>() {
          public TuningMode findValueByNumber(int number) {
            return TuningMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final TuningMode[] VALUES = values();

    public static TuningMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TuningMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode)
  }

  private int bitField0_;
  public static final int TRAINING_DATASET_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trainingDatasetUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. Training dataset used for tuning. The dataset can be specified as
   * either a Cloud Storage path to a JSONL file or as the resource name of a
   * Vertex Multimodal Dataset.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trainingDatasetUri.
   */
  @java.lang.Override
  public java.lang.String getTrainingDatasetUri() {
    java.lang.Object ref = trainingDatasetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trainingDatasetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Training dataset used for tuning. The dataset can be specified as
   * either a Cloud Storage path to a JSONL file or as the resource name of a
   * Vertex Multimodal Dataset.
   * </pre>
   *
   * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trainingDatasetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrainingDatasetUriBytes() {
    java.lang.Object ref = trainingDatasetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trainingDatasetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATION_DATASET_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationDatasetUri_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Validation dataset used for tuning. The dataset can be specified
   * as either a Cloud Storage path to a JSONL file or as the resource name of a
   * Vertex Multimodal Dataset.
   * </pre>
   *
   * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validationDatasetUri.
   */
  @java.lang.Override
  public java.lang.String getValidationDatasetUri() {
    java.lang.Object ref = validationDatasetUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationDatasetUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Validation dataset used for tuning. The dataset can be specified
   * as either a Cloud Storage path to a JSONL file or as the resource name of a
   * Vertex Multimodal Dataset.
   * </pre>
   *
   * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for validationDatasetUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationDatasetUriBytes() {
    java.lang.Object ref = validationDatasetUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationDatasetUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HYPER_PARAMETERS_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyperParameters_;

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for SFT.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hyperParameters field is set.
   */
  @java.lang.Override
  public boolean hasHyperParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for SFT.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hyperParameters.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters getHyperParameters() {
    return hyperParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.getDefaultInstance()
        : hyperParameters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Hyperparameters for SFT.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SupervisedHyperParametersOrBuilder
      getHyperParametersOrBuilder() {
    return hyperParameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.getDefaultInstance()
        : hyperParameters_;
  }

  public static final int EXPORT_LAST_CHECKPOINT_ONLY_FIELD_NUMBER = 6;
  private boolean exportLastCheckpointOnly_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If set to true, disable intermediate checkpoints for SFT and only
   * the last checkpoint will be exported. Otherwise, enable intermediate
   * checkpoints for SFT. Default is false.
   * </pre>
   *
   * <code>bool export_last_checkpoint_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The exportLastCheckpointOnly.
   */
  @java.lang.Override
  public boolean getExportLastCheckpointOnly() {
    return exportLastCheckpointOnly_;
  }

  public static final int EVALUATION_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.EvaluationConfig evaluationConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Evaluation Config for Tuning Job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the evaluationConfig field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Evaluation Config for Tuning Job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The evaluationConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationConfig getEvaluationConfig() {
    return evaluationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Evaluation Config for Tuning Job.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationConfigOrBuilder
      getEvaluationConfigOrBuilder() {
    return evaluationConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }

  public static final int TUNING_MODE_FIELD_NUMBER = 7;
  private int tuningMode_ = 0;

  /**
   *
   *
   * <pre>
   * Tuning mode.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;</code>
   *
   * @return The enum numeric value on the wire for tuningMode.
   */
  @java.lang.Override
  public int getTuningModeValue() {
    return tuningMode_;
  }

  /**
   *
   *
   * <pre>
   * Tuning mode.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;</code>
   *
   * @return The tuningMode.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode getTuningMode() {
    com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode result =
        com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode.forNumber(tuningMode_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingDatasetUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, trainingDatasetUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationDatasetUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, validationDatasetUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getHyperParameters());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getEvaluationConfig());
    }
    if (exportLastCheckpointOnly_ != false) {
      output.writeBool(6, exportLastCheckpointOnly_);
    }
    if (tuningMode_
        != com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode
            .TUNING_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, tuningMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trainingDatasetUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, trainingDatasetUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationDatasetUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, validationDatasetUri_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getHyperParameters());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEvaluationConfig());
    }
    if (exportLastCheckpointOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, exportLastCheckpointOnly_);
    }
    if (tuningMode_
        != com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode
            .TUNING_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, tuningMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec other =
        (com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) obj;

    if (!getTrainingDatasetUri().equals(other.getTrainingDatasetUri())) return false;
    if (!getValidationDatasetUri().equals(other.getValidationDatasetUri())) return false;
    if (hasHyperParameters() != other.hasHyperParameters()) return false;
    if (hasHyperParameters()) {
      if (!getHyperParameters().equals(other.getHyperParameters())) return false;
    }
    if (getExportLastCheckpointOnly() != other.getExportLastCheckpointOnly()) return false;
    if (hasEvaluationConfig() != other.hasEvaluationConfig()) return false;
    if (hasEvaluationConfig()) {
      if (!getEvaluationConfig().equals(other.getEvaluationConfig())) return false;
    }
    if (tuningMode_ != other.tuningMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRAINING_DATASET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getTrainingDatasetUri().hashCode();
    hash = (37 * hash) + VALIDATION_DATASET_URI_FIELD_NUMBER;
    hash = (53 * hash) + getValidationDatasetUri().hashCode();
    if (hasHyperParameters()) {
      hash = (37 * hash) + HYPER_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getHyperParameters().hashCode();
    }
    hash = (37 * hash) + EXPORT_LAST_CHECKPOINT_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExportLastCheckpointOnly());
    if (hasEvaluationConfig()) {
      hash = (37 * hash) + EVALUATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationConfig().hashCode();
    }
    hash = (37 * hash) + TUNING_MODE_FIELD_NUMBER;
    hash = (53 * hash) + tuningMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Tuning Spec for Supervised Tuning for first party models.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.SupervisedTuningSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.SupervisedTuningSpec)
      com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_SupervisedTuningSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_SupervisedTuningSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.class,
              com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHyperParametersFieldBuilder();
        getEvaluationConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      trainingDatasetUri_ = "";
      validationDatasetUri_ = "";
      hyperParameters_ = null;
      if (hyperParametersBuilder_ != null) {
        hyperParametersBuilder_.dispose();
        hyperParametersBuilder_ = null;
      }
      exportLastCheckpointOnly_ = false;
      evaluationConfig_ = null;
      if (evaluationConfigBuilder_ != null) {
        evaluationConfigBuilder_.dispose();
        evaluationConfigBuilder_ = null;
      }
      tuningMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.TuningJobProto
          .internal_static_google_cloud_aiplatform_v1beta1_SupervisedTuningSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec build() {
      com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec result =
          new com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.trainingDatasetUri_ = trainingDatasetUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.validationDatasetUri_ = validationDatasetUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hyperParameters_ =
            hyperParametersBuilder_ == null ? hyperParameters_ : hyperParametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.exportLastCheckpointOnly_ = exportLastCheckpointOnly_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.evaluationConfig_ =
            evaluationConfigBuilder_ == null ? evaluationConfig_ : evaluationConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.tuningMode_ = tuningMode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.getDefaultInstance())
        return this;
      if (!other.getTrainingDatasetUri().isEmpty()) {
        trainingDatasetUri_ = other.trainingDatasetUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getValidationDatasetUri().isEmpty()) {
        validationDatasetUri_ = other.validationDatasetUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasHyperParameters()) {
        mergeHyperParameters(other.getHyperParameters());
      }
      if (other.getExportLastCheckpointOnly() != false) {
        setExportLastCheckpointOnly(other.getExportLastCheckpointOnly());
      }
      if (other.hasEvaluationConfig()) {
        mergeEvaluationConfig(other.getEvaluationConfig());
      }
      if (other.tuningMode_ != 0) {
        setTuningModeValue(other.getTuningModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                trainingDatasetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                validationDatasetUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getHyperParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getEvaluationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                exportLastCheckpointOnly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            case 56:
              {
                tuningMode_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object trainingDatasetUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. Training dataset used for tuning. The dataset can be specified as
     * either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The trainingDatasetUri.
     */
    public java.lang.String getTrainingDatasetUri() {
      java.lang.Object ref = trainingDatasetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trainingDatasetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Training dataset used for tuning. The dataset can be specified as
     * either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for trainingDatasetUri.
     */
    public com.google.protobuf.ByteString getTrainingDatasetUriBytes() {
      java.lang.Object ref = trainingDatasetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trainingDatasetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Training dataset used for tuning. The dataset can be specified as
     * either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The trainingDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingDatasetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trainingDatasetUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Training dataset used for tuning. The dataset can be specified as
     * either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrainingDatasetUri() {
      trainingDatasetUri_ = getDefaultInstance().getTrainingDatasetUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Training dataset used for tuning. The dataset can be specified as
     * either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string training_dataset_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for trainingDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setTrainingDatasetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trainingDatasetUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object validationDatasetUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Validation dataset used for tuning. The dataset can be specified
     * as either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validationDatasetUri.
     */
    public java.lang.String getValidationDatasetUri() {
      java.lang.Object ref = validationDatasetUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationDatasetUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Validation dataset used for tuning. The dataset can be specified
     * as either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for validationDatasetUri.
     */
    public com.google.protobuf.ByteString getValidationDatasetUriBytes() {
      java.lang.Object ref = validationDatasetUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationDatasetUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Validation dataset used for tuning. The dataset can be specified
     * as either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validationDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDatasetUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationDatasetUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Validation dataset used for tuning. The dataset can be specified
     * as either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationDatasetUri() {
      validationDatasetUri_ = getDefaultInstance().getValidationDatasetUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Validation dataset used for tuning. The dataset can be specified
     * as either a Cloud Storage path to a JSONL file or as the resource name of a
     * Vertex Multimodal Dataset.
     * </pre>
     *
     * <code>string validation_dataset_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for validationDatasetUri to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDatasetUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationDatasetUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyperParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters,
            com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.SupervisedHyperParametersOrBuilder>
        hyperParametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the hyperParameters field is set.
     */
    public boolean hasHyperParameters() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The hyperParameters.
     */
    public com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters getHyperParameters() {
      if (hyperParametersBuilder_ == null) {
        return hyperParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.getDefaultInstance()
            : hyperParameters_;
      } else {
        return hyperParametersBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHyperParameters(
        com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters value) {
      if (hyperParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hyperParameters_ = value;
      } else {
        hyperParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHyperParameters(
        com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.Builder builderForValue) {
      if (hyperParametersBuilder_ == null) {
        hyperParameters_ = builderForValue.build();
      } else {
        hyperParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHyperParameters(
        com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters value) {
      if (hyperParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && hyperParameters_ != null
            && hyperParameters_
                != com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters
                    .getDefaultInstance()) {
          getHyperParametersBuilder().mergeFrom(value);
        } else {
          hyperParameters_ = value;
        }
      } else {
        hyperParametersBuilder_.mergeFrom(value);
      }
      if (hyperParameters_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHyperParameters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      hyperParameters_ = null;
      if (hyperParametersBuilder_ != null) {
        hyperParametersBuilder_.dispose();
        hyperParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.Builder
        getHyperParametersBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getHyperParametersFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.SupervisedHyperParametersOrBuilder
        getHyperParametersOrBuilder() {
      if (hyperParametersBuilder_ != null) {
        return hyperParametersBuilder_.getMessageOrBuilder();
      } else {
        return hyperParameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.getDefaultInstance()
            : hyperParameters_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Hyperparameters for SFT.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.SupervisedHyperParameters hyper_parameters = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters,
            com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.Builder,
            com.google.cloud.aiplatform.v1beta1.SupervisedHyperParametersOrBuilder>
        getHyperParametersFieldBuilder() {
      if (hyperParametersBuilder_ == null) {
        hyperParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters,
                com.google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.Builder,
                com.google.cloud.aiplatform.v1beta1.SupervisedHyperParametersOrBuilder>(
                getHyperParameters(), getParentForChildren(), isClean());
        hyperParameters_ = null;
      }
      return hyperParametersBuilder_;
    }

    private boolean exportLastCheckpointOnly_;

    /**
     *
     *
     * <pre>
     * Optional. If set to true, disable intermediate checkpoints for SFT and only
     * the last checkpoint will be exported. Otherwise, enable intermediate
     * checkpoints for SFT. Default is false.
     * </pre>
     *
     * <code>bool export_last_checkpoint_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The exportLastCheckpointOnly.
     */
    @java.lang.Override
    public boolean getExportLastCheckpointOnly() {
      return exportLastCheckpointOnly_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, disable intermediate checkpoints for SFT and only
     * the last checkpoint will be exported. Otherwise, enable intermediate
     * checkpoints for SFT. Default is false.
     * </pre>
     *
     * <code>bool export_last_checkpoint_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The exportLastCheckpointOnly to set.
     * @return This builder for chaining.
     */
    public Builder setExportLastCheckpointOnly(boolean value) {

      exportLastCheckpointOnly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, disable intermediate checkpoints for SFT and only
     * the last checkpoint will be exported. Otherwise, enable intermediate
     * checkpoints for SFT. Default is false.
     * </pre>
     *
     * <code>bool export_last_checkpoint_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExportLastCheckpointOnly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      exportLastCheckpointOnly_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.EvaluationConfig evaluationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EvaluationConfig,
            com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.EvaluationConfigOrBuilder>
        evaluationConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the evaluationConfig field is set.
     */
    public boolean hasEvaluationConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The evaluationConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationConfig getEvaluationConfig() {
      if (evaluationConfigBuilder_ == null) {
        return evaluationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      } else {
        return evaluationConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEvaluationConfig(com.google.cloud.aiplatform.v1beta1.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationConfig_ = value;
      } else {
        evaluationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEvaluationConfig(
        com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder builderForValue) {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfig_ = builderForValue.build();
      } else {
        evaluationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEvaluationConfig(
        com.google.cloud.aiplatform.v1beta1.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && evaluationConfig_ != null
            && evaluationConfig_
                != com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance()) {
          getEvaluationConfigBuilder().mergeFrom(value);
        } else {
          evaluationConfig_ = value;
        }
      } else {
        evaluationConfigBuilder_.mergeFrom(value);
      }
      if (evaluationConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEvaluationConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      evaluationConfig_ = null;
      if (evaluationConfigBuilder_ != null) {
        evaluationConfigBuilder_.dispose();
        evaluationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder
        getEvaluationConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEvaluationConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationConfigOrBuilder
        getEvaluationConfigOrBuilder() {
      if (evaluationConfigBuilder_ != null) {
        return evaluationConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Evaluation Config for Tuning Job.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EvaluationConfig evaluation_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EvaluationConfig,
            com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.EvaluationConfigOrBuilder>
        getEvaluationConfigFieldBuilder() {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EvaluationConfig,
                com.google.cloud.aiplatform.v1beta1.EvaluationConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.EvaluationConfigOrBuilder>(
                getEvaluationConfig(), getParentForChildren(), isClean());
        evaluationConfig_ = null;
      }
      return evaluationConfigBuilder_;
    }

    private int tuningMode_ = 0;

    /**
     *
     *
     * <pre>
     * Tuning mode.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for tuningMode.
     */
    @java.lang.Override
    public int getTuningModeValue() {
      return tuningMode_;
    }

    /**
     *
     *
     * <pre>
     * Tuning mode.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for tuningMode to set.
     * @return This builder for chaining.
     */
    public Builder setTuningModeValue(int value) {
      tuningMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tuning mode.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;
     * </code>
     *
     * @return The tuningMode.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode getTuningMode() {
      com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode result =
          com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode.forNumber(
              tuningMode_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Tuning mode.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;
     * </code>
     *
     * @param value The tuningMode to set.
     * @return This builder for chaining.
     */
    public Builder setTuningMode(
        com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      tuningMode_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Tuning mode.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.TuningMode tuning_mode = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTuningMode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      tuningMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.SupervisedTuningSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.SupervisedTuningSpec)
  private static final com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SupervisedTuningSpec> PARSER =
      new com.google.protobuf.AbstractParser<SupervisedTuningSpec>() {
        @java.lang.Override
        public SupervisedTuningSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SupervisedTuningSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SupervisedTuningSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.SupervisedTuningSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
