/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/evaluation_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The aggregation result for the entire dataset and all metrics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.AggregationOutput}
 */
public final class AggregationOutput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AggregationOutput)
    AggregationOutputOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AggregationOutput.newBuilder() to construct.
  private AggregationOutput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregationOutput() {
    aggregationResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregationOutput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AggregationOutput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AggregationOutput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.AggregationOutput.class,
            com.google.cloud.aiplatform.v1beta1.AggregationOutput.Builder.class);
  }

  private int bitField0_;
  public static final int DATASET_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset_;

  /**
   *
   *
   * <pre>
   * The dataset used for evaluation &amp; aggregation.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
   *
   * @return Whether the dataset field is set.
   */
  @java.lang.Override
  public boolean hasDataset() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The dataset used for evaluation &amp; aggregation.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationDataset getDataset() {
    return dataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
        : dataset_;
  }

  /**
   *
   *
   * <pre>
   * The dataset used for evaluation &amp; aggregation.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder getDatasetOrBuilder() {
    return dataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
        : dataset_;
  }

  public static final int AGGREGATION_RESULTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.AggregationResult> aggregationResults_;

  /**
   *
   *
   * <pre>
   * One AggregationResult per metric.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.AggregationResult>
      getAggregationResultsList() {
    return aggregationResults_;
  }

  /**
   *
   *
   * <pre>
   * One AggregationResult per metric.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder>
      getAggregationResultsOrBuilderList() {
    return aggregationResults_;
  }

  /**
   *
   *
   * <pre>
   * One AggregationResult per metric.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
   * </code>
   */
  @java.lang.Override
  public int getAggregationResultsCount() {
    return aggregationResults_.size();
  }

  /**
   *
   *
   * <pre>
   * One AggregationResult per metric.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AggregationResult getAggregationResults(int index) {
    return aggregationResults_.get(index);
  }

  /**
   *
   *
   * <pre>
   * One AggregationResult per metric.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder
      getAggregationResultsOrBuilder(int index) {
    return aggregationResults_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDataset());
    }
    for (int i = 0; i < aggregationResults_.size(); i++) {
      output.writeMessage(2, aggregationResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDataset());
    }
    for (int i = 0; i < aggregationResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, aggregationResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AggregationOutput)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.AggregationOutput other =
        (com.google.cloud.aiplatform.v1beta1.AggregationOutput) obj;

    if (hasDataset() != other.hasDataset()) return false;
    if (hasDataset()) {
      if (!getDataset().equals(other.getDataset())) return false;
    }
    if (!getAggregationResultsList().equals(other.getAggregationResultsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDataset()) {
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
    }
    if (getAggregationResultsCount() > 0) {
      hash = (37 * hash) + AGGREGATION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationResultsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.AggregationOutput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The aggregation result for the entire dataset and all metrics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AggregationOutput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AggregationOutput)
      com.google.cloud.aiplatform.v1beta1.AggregationOutputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AggregationOutput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AggregationOutput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AggregationOutput.class,
              com.google.cloud.aiplatform.v1beta1.AggregationOutput.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.AggregationOutput.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDatasetFieldBuilder();
        getAggregationResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dataset_ = null;
      if (datasetBuilder_ != null) {
        datasetBuilder_.dispose();
        datasetBuilder_ = null;
      }
      if (aggregationResultsBuilder_ == null) {
        aggregationResults_ = java.util.Collections.emptyList();
      } else {
        aggregationResults_ = null;
        aggregationResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AggregationOutput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AggregationOutput getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.AggregationOutput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AggregationOutput build() {
      com.google.cloud.aiplatform.v1beta1.AggregationOutput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AggregationOutput buildPartial() {
      com.google.cloud.aiplatform.v1beta1.AggregationOutput result =
          new com.google.cloud.aiplatform.v1beta1.AggregationOutput(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.AggregationOutput result) {
      if (aggregationResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          aggregationResults_ = java.util.Collections.unmodifiableList(aggregationResults_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.aggregationResults_ = aggregationResults_;
      } else {
        result.aggregationResults_ = aggregationResultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.AggregationOutput result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dataset_ = datasetBuilder_ == null ? dataset_ : datasetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.AggregationOutput) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.AggregationOutput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AggregationOutput other) {
      if (other == com.google.cloud.aiplatform.v1beta1.AggregationOutput.getDefaultInstance())
        return this;
      if (other.hasDataset()) {
        mergeDataset(other.getDataset());
      }
      if (aggregationResultsBuilder_ == null) {
        if (!other.aggregationResults_.isEmpty()) {
          if (aggregationResults_.isEmpty()) {
            aggregationResults_ = other.aggregationResults_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAggregationResultsIsMutable();
            aggregationResults_.addAll(other.aggregationResults_);
          }
          onChanged();
        }
      } else {
        if (!other.aggregationResults_.isEmpty()) {
          if (aggregationResultsBuilder_.isEmpty()) {
            aggregationResultsBuilder_.dispose();
            aggregationResultsBuilder_ = null;
            aggregationResults_ = other.aggregationResults_;
            bitField0_ = (bitField0_ & ~0x00000002);
            aggregationResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAggregationResultsFieldBuilder()
                    : null;
          } else {
            aggregationResultsBuilder_.addAllMessages(other.aggregationResults_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1beta1.AggregationResult m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.AggregationResult.parser(),
                        extensionRegistry);
                if (aggregationResultsBuilder_ == null) {
                  ensureAggregationResultsIsMutable();
                  aggregationResults_.add(m);
                } else {
                  aggregationResultsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset,
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder,
            com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder>
        datasetBuilder_;

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     *
     * @return Whether the dataset field is set.
     */
    public boolean hasDataset() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     *
     * @return The dataset.
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationDataset getDataset() {
      if (datasetBuilder_ == null) {
        return dataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
            : dataset_;
      } else {
        return datasetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    public Builder setDataset(com.google.cloud.aiplatform.v1beta1.EvaluationDataset value) {
      if (datasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
      } else {
        datasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    public Builder setDataset(
        com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder builderForValue) {
      if (datasetBuilder_ == null) {
        dataset_ = builderForValue.build();
      } else {
        datasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    public Builder mergeDataset(com.google.cloud.aiplatform.v1beta1.EvaluationDataset value) {
      if (datasetBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && dataset_ != null
            && dataset_
                != com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()) {
          getDatasetBuilder().mergeFrom(value);
        } else {
          dataset_ = value;
        }
      } else {
        datasetBuilder_.mergeFrom(value);
      }
      if (dataset_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    public Builder clearDataset() {
      bitField0_ = (bitField0_ & ~0x00000001);
      dataset_ = null;
      if (datasetBuilder_ != null) {
        datasetBuilder_.dispose();
        datasetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder getDatasetBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDatasetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder getDatasetOrBuilder() {
      if (datasetBuilder_ != null) {
        return datasetBuilder_.getMessageOrBuilder();
      } else {
        return dataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.EvaluationDataset.getDefaultInstance()
            : dataset_;
      }
    }

    /**
     *
     *
     * <pre>
     * The dataset used for evaluation &amp; aggregation.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EvaluationDataset dataset = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset,
            com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder,
            com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder>
        getDatasetFieldBuilder() {
      if (datasetBuilder_ == null) {
        datasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EvaluationDataset,
                com.google.cloud.aiplatform.v1beta1.EvaluationDataset.Builder,
                com.google.cloud.aiplatform.v1beta1.EvaluationDatasetOrBuilder>(
                getDataset(), getParentForChildren(), isClean());
        dataset_ = null;
      }
      return datasetBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.AggregationResult>
        aggregationResults_ = java.util.Collections.emptyList();

    private void ensureAggregationResultsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        aggregationResults_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.AggregationResult>(
                aggregationResults_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AggregationResult,
            com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder,
            com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder>
        aggregationResultsBuilder_;

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.AggregationResult>
        getAggregationResultsList() {
      if (aggregationResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregationResults_);
      } else {
        return aggregationResultsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public int getAggregationResultsCount() {
      if (aggregationResultsBuilder_ == null) {
        return aggregationResults_.size();
      } else {
        return aggregationResultsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AggregationResult getAggregationResults(int index) {
      if (aggregationResultsBuilder_ == null) {
        return aggregationResults_.get(index);
      } else {
        return aggregationResultsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder setAggregationResults(
        int index, com.google.cloud.aiplatform.v1beta1.AggregationResult value) {
      if (aggregationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationResultsIsMutable();
        aggregationResults_.set(index, value);
        onChanged();
      } else {
        aggregationResultsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder setAggregationResults(
        int index, com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder builderForValue) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregationResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder addAggregationResults(
        com.google.cloud.aiplatform.v1beta1.AggregationResult value) {
      if (aggregationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(value);
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder addAggregationResults(
        int index, com.google.cloud.aiplatform.v1beta1.AggregationResult value) {
      if (aggregationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(index, value);
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder addAggregationResults(
        com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder builderForValue) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(builderForValue.build());
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder addAggregationResults(
        int index, com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder builderForValue) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder addAllAggregationResults(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.AggregationResult>
            values) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregationResults_);
        onChanged();
      } else {
        aggregationResultsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder clearAggregationResults() {
      if (aggregationResultsBuilder_ == null) {
        aggregationResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        aggregationResultsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public Builder removeAggregationResults(int index) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.remove(index);
        onChanged();
      } else {
        aggregationResultsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder
        getAggregationResultsBuilder(int index) {
      return getAggregationResultsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder
        getAggregationResultsOrBuilder(int index) {
      if (aggregationResultsBuilder_ == null) {
        return aggregationResults_.get(index);
      } else {
        return aggregationResultsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder>
        getAggregationResultsOrBuilderList() {
      if (aggregationResultsBuilder_ != null) {
        return aggregationResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregationResults_);
      }
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder
        addAggregationResultsBuilder() {
      return getAggregationResultsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.AggregationResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder
        addAggregationResultsBuilder(int index) {
      return getAggregationResultsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1beta1.AggregationResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * One AggregationResult per metric.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1beta1.AggregationResult aggregation_results = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder>
        getAggregationResultsBuilderList() {
      return getAggregationResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.AggregationResult,
            com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder,
            com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder>
        getAggregationResultsFieldBuilder() {
      if (aggregationResultsBuilder_ == null) {
        aggregationResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.AggregationResult,
                com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder,
                com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder>(
                aggregationResults_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        aggregationResults_ = null;
      }
      return aggregationResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AggregationOutput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AggregationOutput)
  private static final com.google.cloud.aiplatform.v1beta1.AggregationOutput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AggregationOutput();
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationOutput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregationOutput> PARSER =
      new com.google.protobuf.AbstractParser<AggregationOutput>() {
        @java.lang.Override
        public AggregationOutput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregationOutput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregationOutput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AggregationOutput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
