/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/evaluation_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The aggregation result for a single metric.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.AggregationResult}
 */
public final class AggregationResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AggregationResult)
    AggregationResultOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AggregationResult.newBuilder() to construct.
  private AggregationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregationResult() {
    aggregationMetric_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregationResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AggregationResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_AggregationResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.AggregationResult.class,
            com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder.class);
  }

  private int aggregationResultCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object aggregationResult_;

  public enum AggregationResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    POINTWISE_METRIC_RESULT(5),
    PAIRWISE_METRIC_RESULT(6),
    EXACT_MATCH_METRIC_VALUE(7),
    BLEU_METRIC_VALUE(8),
    ROUGE_METRIC_VALUE(9),
    AGGREGATIONRESULT_NOT_SET(0);
    private final int value;

    private AggregationResultCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AggregationResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static AggregationResultCase forNumber(int value) {
      switch (value) {
        case 5:
          return POINTWISE_METRIC_RESULT;
        case 6:
          return PAIRWISE_METRIC_RESULT;
        case 7:
          return EXACT_MATCH_METRIC_VALUE;
        case 8:
          return BLEU_METRIC_VALUE;
        case 9:
          return ROUGE_METRIC_VALUE;
        case 0:
          return AGGREGATIONRESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AggregationResultCase getAggregationResultCase() {
    return AggregationResultCase.forNumber(aggregationResultCase_);
  }

  public static final int POINTWISE_METRIC_RESULT_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Result for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
   * </code>
   *
   * @return Whether the pointwiseMetricResult field is set.
   */
  @java.lang.Override
  public boolean hasPointwiseMetricResult() {
    return aggregationResultCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Result for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
   * </code>
   *
   * @return The pointwiseMetricResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult getPointwiseMetricResult() {
    if (aggregationResultCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Result for pointwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PointwiseMetricResultOrBuilder
      getPointwiseMetricResultOrBuilder() {
    if (aggregationResultCase_ == 5) {
      return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance();
  }

  public static final int PAIRWISE_METRIC_RESULT_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Result for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;</code>
   *
   * @return Whether the pairwiseMetricResult field is set.
   */
  @java.lang.Override
  public boolean hasPairwiseMetricResult() {
    return aggregationResultCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Result for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;</code>
   *
   * @return The pairwiseMetricResult.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult getPairwiseMetricResult() {
    if (aggregationResultCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Result for pairwise metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PairwiseMetricResultOrBuilder
      getPairwiseMetricResultOrBuilder() {
    if (aggregationResultCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance();
  }

  public static final int EXACT_MATCH_METRIC_VALUE_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Results for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
   * </code>
   *
   * @return Whether the exactMatchMetricValue field is set.
   */
  @java.lang.Override
  public boolean hasExactMatchMetricValue() {
    return aggregationResultCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Results for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
   * </code>
   *
   * @return The exactMatchMetricValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue getExactMatchMetricValue() {
    if (aggregationResultCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Results for exact match metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValueOrBuilder
      getExactMatchMetricValueOrBuilder() {
    if (aggregationResultCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance();
  }

  public static final int BLEU_METRIC_VALUE_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * Results for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
   *
   * @return Whether the bleuMetricValue field is set.
   */
  @java.lang.Override
  public boolean hasBleuMetricValue() {
    return aggregationResultCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * Results for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
   *
   * @return The bleuMetricValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BleuMetricValue getBleuMetricValue() {
    if (aggregationResultCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Results for bleu metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.BleuMetricValueOrBuilder
      getBleuMetricValueOrBuilder() {
    if (aggregationResultCase_ == 8) {
      return (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance();
  }

  public static final int ROUGE_METRIC_VALUE_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * Results for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
   *
   * @return Whether the rougeMetricValue field is set.
   */
  @java.lang.Override
  public boolean hasRougeMetricValue() {
    return aggregationResultCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * Results for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
   *
   * @return The rougeMetricValue.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RougeMetricValue getRougeMetricValue() {
    if (aggregationResultCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Results for rouge metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RougeMetricValueOrBuilder
      getRougeMetricValueOrBuilder() {
    if (aggregationResultCase_ == 9) {
      return (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_;
    }
    return com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance();
  }

  public static final int AGGREGATION_METRIC_FIELD_NUMBER = 4;
  private int aggregationMetric_ = 0;

  /**
   *
   *
   * <pre>
   * Aggregation metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;</code>
   *
   * @return The enum numeric value on the wire for aggregationMetric.
   */
  @java.lang.Override
  public int getAggregationMetricValue() {
    return aggregationMetric_;
  }

  /**
   *
   *
   * <pre>
   * Aggregation metric.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;</code>
   *
   * @return The aggregationMetric.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric getAggregationMetric() {
    com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric result =
        com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric.forNumber(aggregationMetric_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (aggregationMetric_
        != com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric
            .AGGREGATION_METRIC_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, aggregationMetric_);
    }
    if (aggregationResultCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_);
    }
    if (aggregationResultCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_);
    }
    if (aggregationResultCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_);
    }
    if (aggregationResultCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_);
    }
    if (aggregationResultCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (aggregationMetric_
        != com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric
            .AGGREGATION_METRIC_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, aggregationMetric_);
    }
    if (aggregationResultCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_);
    }
    if (aggregationResultCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_);
    }
    if (aggregationResultCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_);
    }
    if (aggregationResultCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_);
    }
    if (aggregationResultCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AggregationResult)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.AggregationResult other =
        (com.google.cloud.aiplatform.v1beta1.AggregationResult) obj;

    if (aggregationMetric_ != other.aggregationMetric_) return false;
    if (!getAggregationResultCase().equals(other.getAggregationResultCase())) return false;
    switch (aggregationResultCase_) {
      case 5:
        if (!getPointwiseMetricResult().equals(other.getPointwiseMetricResult())) return false;
        break;
      case 6:
        if (!getPairwiseMetricResult().equals(other.getPairwiseMetricResult())) return false;
        break;
      case 7:
        if (!getExactMatchMetricValue().equals(other.getExactMatchMetricValue())) return false;
        break;
      case 8:
        if (!getBleuMetricValue().equals(other.getBleuMetricValue())) return false;
        break;
      case 9:
        if (!getRougeMetricValue().equals(other.getRougeMetricValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AGGREGATION_METRIC_FIELD_NUMBER;
    hash = (53 * hash) + aggregationMetric_;
    switch (aggregationResultCase_) {
      case 5:
        hash = (37 * hash) + POINTWISE_METRIC_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getPointwiseMetricResult().hashCode();
        break;
      case 6:
        hash = (37 * hash) + PAIRWISE_METRIC_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getPairwiseMetricResult().hashCode();
        break;
      case 7:
        hash = (37 * hash) + EXACT_MATCH_METRIC_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getExactMatchMetricValue().hashCode();
        break;
      case 8:
        hash = (37 * hash) + BLEU_METRIC_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getBleuMetricValue().hashCode();
        break;
      case 9:
        hash = (37 * hash) + ROUGE_METRIC_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getRougeMetricValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.AggregationResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The aggregation result for a single metric.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AggregationResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AggregationResult)
      com.google.cloud.aiplatform.v1beta1.AggregationResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AggregationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AggregationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AggregationResult.class,
              com.google.cloud.aiplatform.v1beta1.AggregationResult.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.AggregationResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (pointwiseMetricResultBuilder_ != null) {
        pointwiseMetricResultBuilder_.clear();
      }
      if (pairwiseMetricResultBuilder_ != null) {
        pairwiseMetricResultBuilder_.clear();
      }
      if (exactMatchMetricValueBuilder_ != null) {
        exactMatchMetricValueBuilder_.clear();
      }
      if (bleuMetricValueBuilder_ != null) {
        bleuMetricValueBuilder_.clear();
      }
      if (rougeMetricValueBuilder_ != null) {
        rougeMetricValueBuilder_.clear();
      }
      aggregationMetric_ = 0;
      aggregationResultCase_ = 0;
      aggregationResult_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.EvaluationServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_AggregationResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AggregationResult getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.AggregationResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AggregationResult build() {
      com.google.cloud.aiplatform.v1beta1.AggregationResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AggregationResult buildPartial() {
      com.google.cloud.aiplatform.v1beta1.AggregationResult result =
          new com.google.cloud.aiplatform.v1beta1.AggregationResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.AggregationResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.aggregationMetric_ = aggregationMetric_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.AggregationResult result) {
      result.aggregationResultCase_ = aggregationResultCase_;
      result.aggregationResult_ = this.aggregationResult_;
      if (aggregationResultCase_ == 5 && pointwiseMetricResultBuilder_ != null) {
        result.aggregationResult_ = pointwiseMetricResultBuilder_.build();
      }
      if (aggregationResultCase_ == 6 && pairwiseMetricResultBuilder_ != null) {
        result.aggregationResult_ = pairwiseMetricResultBuilder_.build();
      }
      if (aggregationResultCase_ == 7 && exactMatchMetricValueBuilder_ != null) {
        result.aggregationResult_ = exactMatchMetricValueBuilder_.build();
      }
      if (aggregationResultCase_ == 8 && bleuMetricValueBuilder_ != null) {
        result.aggregationResult_ = bleuMetricValueBuilder_.build();
      }
      if (aggregationResultCase_ == 9 && rougeMetricValueBuilder_ != null) {
        result.aggregationResult_ = rougeMetricValueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.AggregationResult) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.AggregationResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AggregationResult other) {
      if (other == com.google.cloud.aiplatform.v1beta1.AggregationResult.getDefaultInstance())
        return this;
      if (other.aggregationMetric_ != 0) {
        setAggregationMetricValue(other.getAggregationMetricValue());
      }
      switch (other.getAggregationResultCase()) {
        case POINTWISE_METRIC_RESULT:
          {
            mergePointwiseMetricResult(other.getPointwiseMetricResult());
            break;
          }
        case PAIRWISE_METRIC_RESULT:
          {
            mergePairwiseMetricResult(other.getPairwiseMetricResult());
            break;
          }
        case EXACT_MATCH_METRIC_VALUE:
          {
            mergeExactMatchMetricValue(other.getExactMatchMetricValue());
            break;
          }
        case BLEU_METRIC_VALUE:
          {
            mergeBleuMetricValue(other.getBleuMetricValue());
            break;
          }
        case ROUGE_METRIC_VALUE:
          {
            mergeRougeMetricValue(other.getRougeMetricValue());
            break;
          }
        case AGGREGATIONRESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 32:
              {
                aggregationMetric_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getPointwiseMetricResultFieldBuilder().getBuilder(), extensionRegistry);
                aggregationResultCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getPairwiseMetricResultFieldBuilder().getBuilder(), extensionRegistry);
                aggregationResultCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getExactMatchMetricValueFieldBuilder().getBuilder(), extensionRegistry);
                aggregationResultCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getBleuMetricValueFieldBuilder().getBuilder(), extensionRegistry);
                aggregationResultCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getRougeMetricValueFieldBuilder().getBuilder(), extensionRegistry);
                aggregationResultCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int aggregationResultCase_ = 0;
    private java.lang.Object aggregationResult_;

    public AggregationResultCase getAggregationResultCase() {
      return AggregationResultCase.forNumber(aggregationResultCase_);
    }

    public Builder clearAggregationResult() {
      aggregationResultCase_ = 0;
      aggregationResult_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricResultOrBuilder>
        pointwiseMetricResultBuilder_;

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     *
     * @return Whether the pointwiseMetricResult field is set.
     */
    @java.lang.Override
    public boolean hasPointwiseMetricResult() {
      return aggregationResultCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     *
     * @return The pointwiseMetricResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult getPointwiseMetricResult() {
      if (pointwiseMetricResultBuilder_ == null) {
        if (aggregationResultCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance();
      } else {
        if (aggregationResultCase_ == 5) {
          return pointwiseMetricResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    public Builder setPointwiseMetricResult(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult value) {
      if (pointwiseMetricResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationResult_ = value;
        onChanged();
      } else {
        pointwiseMetricResultBuilder_.setMessage(value);
      }
      aggregationResultCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    public Builder setPointwiseMetricResult(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.Builder builderForValue) {
      if (pointwiseMetricResultBuilder_ == null) {
        aggregationResult_ = builderForValue.build();
        onChanged();
      } else {
        pointwiseMetricResultBuilder_.setMessage(builderForValue.build());
      }
      aggregationResultCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    public Builder mergePointwiseMetricResult(
        com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult value) {
      if (pointwiseMetricResultBuilder_ == null) {
        if (aggregationResultCase_ == 5
            && aggregationResult_
                != com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance()) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult)
                          aggregationResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationResult_ = value;
        }
        onChanged();
      } else {
        if (aggregationResultCase_ == 5) {
          pointwiseMetricResultBuilder_.mergeFrom(value);
        } else {
          pointwiseMetricResultBuilder_.setMessage(value);
        }
      }
      aggregationResultCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    public Builder clearPointwiseMetricResult() {
      if (pointwiseMetricResultBuilder_ == null) {
        if (aggregationResultCase_ == 5) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
          onChanged();
        }
      } else {
        if (aggregationResultCase_ == 5) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
        }
        pointwiseMetricResultBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.Builder
        getPointwiseMetricResultBuilder() {
      return getPointwiseMetricResultFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PointwiseMetricResultOrBuilder
        getPointwiseMetricResultOrBuilder() {
      if ((aggregationResultCase_ == 5) && (pointwiseMetricResultBuilder_ != null)) {
        return pointwiseMetricResultBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationResultCase_ == 5) {
          return (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Result for pointwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PointwiseMetricResult pointwise_metric_result = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1beta1.PointwiseMetricResultOrBuilder>
        getPointwiseMetricResultFieldBuilder() {
      if (pointwiseMetricResultBuilder_ == null) {
        if (!(aggregationResultCase_ == 5)) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.getDefaultInstance();
        }
        pointwiseMetricResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult,
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult.Builder,
                com.google.cloud.aiplatform.v1beta1.PointwiseMetricResultOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PointwiseMetricResult) aggregationResult_,
                getParentForChildren(),
                isClean());
        aggregationResult_ = null;
      }
      aggregationResultCase_ = 5;
      onChanged();
      return pointwiseMetricResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricResultOrBuilder>
        pairwiseMetricResultBuilder_;

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     *
     * @return Whether the pairwiseMetricResult field is set.
     */
    @java.lang.Override
    public boolean hasPairwiseMetricResult() {
      return aggregationResultCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     *
     * @return The pairwiseMetricResult.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult getPairwiseMetricResult() {
      if (pairwiseMetricResultBuilder_ == null) {
        if (aggregationResultCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance();
      } else {
        if (aggregationResultCase_ == 6) {
          return pairwiseMetricResultBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    public Builder setPairwiseMetricResult(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult value) {
      if (pairwiseMetricResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationResult_ = value;
        onChanged();
      } else {
        pairwiseMetricResultBuilder_.setMessage(value);
      }
      aggregationResultCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    public Builder setPairwiseMetricResult(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.Builder builderForValue) {
      if (pairwiseMetricResultBuilder_ == null) {
        aggregationResult_ = builderForValue.build();
        onChanged();
      } else {
        pairwiseMetricResultBuilder_.setMessage(builderForValue.build());
      }
      aggregationResultCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    public Builder mergePairwiseMetricResult(
        com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult value) {
      if (pairwiseMetricResultBuilder_ == null) {
        if (aggregationResultCase_ == 6
            && aggregationResult_
                != com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance()) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationResult_ = value;
        }
        onChanged();
      } else {
        if (aggregationResultCase_ == 6) {
          pairwiseMetricResultBuilder_.mergeFrom(value);
        } else {
          pairwiseMetricResultBuilder_.setMessage(value);
        }
      }
      aggregationResultCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    public Builder clearPairwiseMetricResult() {
      if (pairwiseMetricResultBuilder_ == null) {
        if (aggregationResultCase_ == 6) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
          onChanged();
        }
      } else {
        if (aggregationResultCase_ == 6) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
        }
        pairwiseMetricResultBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.Builder
        getPairwiseMetricResultBuilder() {
      return getPairwiseMetricResultFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PairwiseMetricResultOrBuilder
        getPairwiseMetricResultOrBuilder() {
      if ((aggregationResultCase_ == 6) && (pairwiseMetricResultBuilder_ != null)) {
        return pairwiseMetricResultBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationResultCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Result for pairwise metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.PairwiseMetricResult pairwise_metric_result = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.Builder,
            com.google.cloud.aiplatform.v1beta1.PairwiseMetricResultOrBuilder>
        getPairwiseMetricResultFieldBuilder() {
      if (pairwiseMetricResultBuilder_ == null) {
        if (!(aggregationResultCase_ == 6)) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.getDefaultInstance();
        }
        pairwiseMetricResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult,
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult.Builder,
                com.google.cloud.aiplatform.v1beta1.PairwiseMetricResultOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.PairwiseMetricResult) aggregationResult_,
                getParentForChildren(),
                isClean());
        aggregationResult_ = null;
      }
      aggregationResultCase_ = 6;
      onChanged();
      return pairwiseMetricResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue,
            com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.Builder,
            com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValueOrBuilder>
        exactMatchMetricValueBuilder_;

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     *
     * @return Whether the exactMatchMetricValue field is set.
     */
    @java.lang.Override
    public boolean hasExactMatchMetricValue() {
      return aggregationResultCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     *
     * @return The exactMatchMetricValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue getExactMatchMetricValue() {
      if (exactMatchMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance();
      } else {
        if (aggregationResultCase_ == 7) {
          return exactMatchMetricValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    public Builder setExactMatchMetricValue(
        com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue value) {
      if (exactMatchMetricValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationResult_ = value;
        onChanged();
      } else {
        exactMatchMetricValueBuilder_.setMessage(value);
      }
      aggregationResultCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    public Builder setExactMatchMetricValue(
        com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.Builder builderForValue) {
      if (exactMatchMetricValueBuilder_ == null) {
        aggregationResult_ = builderForValue.build();
        onChanged();
      } else {
        exactMatchMetricValueBuilder_.setMessage(builderForValue.build());
      }
      aggregationResultCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    public Builder mergeExactMatchMetricValue(
        com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue value) {
      if (exactMatchMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 7
            && aggregationResult_
                != com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance()) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue)
                          aggregationResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationResult_ = value;
        }
        onChanged();
      } else {
        if (aggregationResultCase_ == 7) {
          exactMatchMetricValueBuilder_.mergeFrom(value);
        } else {
          exactMatchMetricValueBuilder_.setMessage(value);
        }
      }
      aggregationResultCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    public Builder clearExactMatchMetricValue() {
      if (exactMatchMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 7) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
          onChanged();
        }
      } else {
        if (aggregationResultCase_ == 7) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
        }
        exactMatchMetricValueBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.Builder
        getExactMatchMetricValueBuilder() {
      return getExactMatchMetricValueFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValueOrBuilder
        getExactMatchMetricValueOrBuilder() {
      if ((aggregationResultCase_ == 7) && (exactMatchMetricValueBuilder_ != null)) {
        return exactMatchMetricValueBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationResultCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Results for exact match metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue exact_match_metric_value = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue,
            com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.Builder,
            com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValueOrBuilder>
        getExactMatchMetricValueFieldBuilder() {
      if (exactMatchMetricValueBuilder_ == null) {
        if (!(aggregationResultCase_ == 7)) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.getDefaultInstance();
        }
        exactMatchMetricValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue,
                com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue.Builder,
                com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValueOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ExactMatchMetricValue) aggregationResult_,
                getParentForChildren(),
                isClean());
        aggregationResult_ = null;
      }
      aggregationResultCase_ = 7;
      onChanged();
      return exactMatchMetricValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BleuMetricValue,
            com.google.cloud.aiplatform.v1beta1.BleuMetricValue.Builder,
            com.google.cloud.aiplatform.v1beta1.BleuMetricValueOrBuilder>
        bleuMetricValueBuilder_;

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     *
     * @return Whether the bleuMetricValue field is set.
     */
    @java.lang.Override
    public boolean hasBleuMetricValue() {
      return aggregationResultCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     *
     * @return The bleuMetricValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BleuMetricValue getBleuMetricValue() {
      if (bleuMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance();
      } else {
        if (aggregationResultCase_ == 8) {
          return bleuMetricValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    public Builder setBleuMetricValue(com.google.cloud.aiplatform.v1beta1.BleuMetricValue value) {
      if (bleuMetricValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationResult_ = value;
        onChanged();
      } else {
        bleuMetricValueBuilder_.setMessage(value);
      }
      aggregationResultCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    public Builder setBleuMetricValue(
        com.google.cloud.aiplatform.v1beta1.BleuMetricValue.Builder builderForValue) {
      if (bleuMetricValueBuilder_ == null) {
        aggregationResult_ = builderForValue.build();
        onChanged();
      } else {
        bleuMetricValueBuilder_.setMessage(builderForValue.build());
      }
      aggregationResultCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    public Builder mergeBleuMetricValue(com.google.cloud.aiplatform.v1beta1.BleuMetricValue value) {
      if (bleuMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 8
            && aggregationResult_
                != com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance()) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.BleuMetricValue.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationResult_ = value;
        }
        onChanged();
      } else {
        if (aggregationResultCase_ == 8) {
          bleuMetricValueBuilder_.mergeFrom(value);
        } else {
          bleuMetricValueBuilder_.setMessage(value);
        }
      }
      aggregationResultCase_ = 8;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    public Builder clearBleuMetricValue() {
      if (bleuMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 8) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
          onChanged();
        }
      } else {
        if (aggregationResultCase_ == 8) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
        }
        bleuMetricValueBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.BleuMetricValue.Builder getBleuMetricValueBuilder() {
      return getBleuMetricValueFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.BleuMetricValueOrBuilder
        getBleuMetricValueOrBuilder() {
      if ((aggregationResultCase_ == 8) && (bleuMetricValueBuilder_ != null)) {
        return bleuMetricValueBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationResultCase_ == 8) {
          return (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Results for bleu metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.BleuMetricValue bleu_metric_value = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.BleuMetricValue,
            com.google.cloud.aiplatform.v1beta1.BleuMetricValue.Builder,
            com.google.cloud.aiplatform.v1beta1.BleuMetricValueOrBuilder>
        getBleuMetricValueFieldBuilder() {
      if (bleuMetricValueBuilder_ == null) {
        if (!(aggregationResultCase_ == 8)) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.BleuMetricValue.getDefaultInstance();
        }
        bleuMetricValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.BleuMetricValue,
                com.google.cloud.aiplatform.v1beta1.BleuMetricValue.Builder,
                com.google.cloud.aiplatform.v1beta1.BleuMetricValueOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.BleuMetricValue) aggregationResult_,
                getParentForChildren(),
                isClean());
        aggregationResult_ = null;
      }
      aggregationResultCase_ = 8;
      onChanged();
      return bleuMetricValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RougeMetricValue,
            com.google.cloud.aiplatform.v1beta1.RougeMetricValue.Builder,
            com.google.cloud.aiplatform.v1beta1.RougeMetricValueOrBuilder>
        rougeMetricValueBuilder_;

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     *
     * @return Whether the rougeMetricValue field is set.
     */
    @java.lang.Override
    public boolean hasRougeMetricValue() {
      return aggregationResultCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     *
     * @return The rougeMetricValue.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RougeMetricValue getRougeMetricValue() {
      if (rougeMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance();
      } else {
        if (aggregationResultCase_ == 9) {
          return rougeMetricValueBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    public Builder setRougeMetricValue(com.google.cloud.aiplatform.v1beta1.RougeMetricValue value) {
      if (rougeMetricValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationResult_ = value;
        onChanged();
      } else {
        rougeMetricValueBuilder_.setMessage(value);
      }
      aggregationResultCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    public Builder setRougeMetricValue(
        com.google.cloud.aiplatform.v1beta1.RougeMetricValue.Builder builderForValue) {
      if (rougeMetricValueBuilder_ == null) {
        aggregationResult_ = builderForValue.build();
        onChanged();
      } else {
        rougeMetricValueBuilder_.setMessage(builderForValue.build());
      }
      aggregationResultCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    public Builder mergeRougeMetricValue(
        com.google.cloud.aiplatform.v1beta1.RougeMetricValue value) {
      if (rougeMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 9
            && aggregationResult_
                != com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance()) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.RougeMetricValue.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationResult_ = value;
        }
        onChanged();
      } else {
        if (aggregationResultCase_ == 9) {
          rougeMetricValueBuilder_.mergeFrom(value);
        } else {
          rougeMetricValueBuilder_.setMessage(value);
        }
      }
      aggregationResultCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    public Builder clearRougeMetricValue() {
      if (rougeMetricValueBuilder_ == null) {
        if (aggregationResultCase_ == 9) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
          onChanged();
        }
      } else {
        if (aggregationResultCase_ == 9) {
          aggregationResultCase_ = 0;
          aggregationResult_ = null;
        }
        rougeMetricValueBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.RougeMetricValue.Builder
        getRougeMetricValueBuilder() {
      return getRougeMetricValueFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RougeMetricValueOrBuilder
        getRougeMetricValueOrBuilder() {
      if ((aggregationResultCase_ == 9) && (rougeMetricValueBuilder_ != null)) {
        return rougeMetricValueBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationResultCase_ == 9) {
          return (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_;
        }
        return com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Results for rouge metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.RougeMetricValue rouge_metric_value = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RougeMetricValue,
            com.google.cloud.aiplatform.v1beta1.RougeMetricValue.Builder,
            com.google.cloud.aiplatform.v1beta1.RougeMetricValueOrBuilder>
        getRougeMetricValueFieldBuilder() {
      if (rougeMetricValueBuilder_ == null) {
        if (!(aggregationResultCase_ == 9)) {
          aggregationResult_ =
              com.google.cloud.aiplatform.v1beta1.RougeMetricValue.getDefaultInstance();
        }
        rougeMetricValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RougeMetricValue,
                com.google.cloud.aiplatform.v1beta1.RougeMetricValue.Builder,
                com.google.cloud.aiplatform.v1beta1.RougeMetricValueOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.RougeMetricValue) aggregationResult_,
                getParentForChildren(),
                isClean());
        aggregationResult_ = null;
      }
      aggregationResultCase_ = 9;
      onChanged();
      return rougeMetricValueBuilder_;
    }

    private int aggregationMetric_ = 0;

    /**
     *
     *
     * <pre>
     * Aggregation metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for aggregationMetric.
     */
    @java.lang.Override
    public int getAggregationMetricValue() {
      return aggregationMetric_;
    }

    /**
     *
     *
     * <pre>
     * Aggregation metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for aggregationMetric to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationMetricValue(int value) {
      aggregationMetric_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregation metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;
     * </code>
     *
     * @return The aggregationMetric.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric getAggregationMetric() {
      com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric result =
          com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric.forNumber(
              aggregationMetric_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Aggregation metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;
     * </code>
     *
     * @param value The aggregationMetric to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationMetric(
        com.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      aggregationMetric_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregation metric.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Metric.AggregationMetric aggregation_metric = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAggregationMetric() {
      bitField0_ = (bitField0_ & ~0x00000020);
      aggregationMetric_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AggregationResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AggregationResult)
  private static final com.google.cloud.aiplatform.v1beta1.AggregationResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AggregationResult();
  }

  public static com.google.cloud.aiplatform.v1beta1.AggregationResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregationResult> PARSER =
      new com.google.protobuf.AbstractParser<AggregationResult>() {
        @java.lang.Override
        public AggregationResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregationResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregationResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AggregationResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
