/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/prediction_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for
 * [PredictionService.EmbedContent][google.cloud.aiplatform.v1beta1.PredictionService.EmbedContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.EmbedContentResponse}
 */
public final class EmbedContentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EmbedContentResponse)
    EmbedContentResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EmbedContentResponse.newBuilder() to construct.
  private EmbedContentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EmbedContentResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EmbedContentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.class,
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Builder.class);
  }

  public interface EmbeddingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Embedding vector values.
     * </pre>
     *
     * <code>repeated float values = 1;</code>
     *
     * @return A list containing the values.
     */
    java.util.List<java.lang.Float> getValuesList();

    /**
     *
     *
     * <pre>
     * Embedding vector values.
     * </pre>
     *
     * <code>repeated float values = 1;</code>
     *
     * @return The count of values.
     */
    int getValuesCount();

    /**
     *
     *
     * <pre>
     * Embedding vector values.
     * </pre>
     *
     * <code>repeated float values = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    float getValues(int index);
  }

  /**
   *
   *
   * <pre>
   * A list of floats representing an embedding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding}
   */
  public static final class Embedding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding)
      EmbeddingOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Embedding.newBuilder() to construct.
    private Embedding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Embedding() {
      values_ = emptyFloatList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Embedding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_Embedding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_Embedding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.class,
              com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder.class);
    }

    public static final int VALUES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.FloatList values_ = emptyFloatList();

    /**
     *
     *
     * <pre>
     * Embedding vector values.
     * </pre>
     *
     * <code>repeated float values = 1;</code>
     *
     * @return A list containing the values.
     */
    @java.lang.Override
    public java.util.List<java.lang.Float> getValuesList() {
      return values_;
    }

    /**
     *
     *
     * <pre>
     * Embedding vector values.
     * </pre>
     *
     * <code>repeated float values = 1;</code>
     *
     * @return The count of values.
     */
    public int getValuesCount() {
      return values_.size();
    }

    /**
     *
     *
     * <pre>
     * Embedding vector values.
     * </pre>
     *
     * <code>repeated float values = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The values at the given index.
     */
    public float getValues(int index) {
      return values_.getFloat(index);
    }

    private int valuesMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getValuesList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(valuesMemoizedSerializedSize);
      }
      for (int i = 0; i < values_.size(); i++) {
        output.writeFloatNoTag(values_.getFloat(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        dataSize = 4 * getValuesList().size();
        size += dataSize;
        if (!getValuesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        valuesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding other =
          (com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding) obj;

      if (!getValuesList().equals(other.getValuesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A list of floats representing an embedding.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding)
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.EmbeddingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_Embedding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_Embedding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.class,
                com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        values_ = emptyFloatList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_Embedding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding build() {
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding buildPartial() {
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding result =
            new com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          values_.makeImmutable();
          result.values_ = values_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
                .getDefaultInstance()) return this;
        if (!other.values_.isEmpty()) {
          if (values_.isEmpty()) {
            values_ = other.values_;
            values_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureValuesIsMutable();
            values_.addAll(other.values_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  float v = input.readFloat();
                  ensureValuesIsMutable();
                  values_.addFloat(v);
                  break;
                } // case 13
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  int alloc = length > 4096 ? 4096 : length;
                  ensureValuesIsMutable(alloc / 4);
                  while (input.getBytesUntilLimit() > 0) {
                    values_.addFloat(input.readFloat());
                  }
                  input.popLimit(limit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.FloatList values_ = emptyFloatList();

      private void ensureValuesIsMutable() {
        if (!values_.isModifiable()) {
          values_ = makeMutableCopy(values_);
        }
        bitField0_ |= 0x00000001;
      }

      private void ensureValuesIsMutable(int capacity) {
        if (!values_.isModifiable()) {
          values_ = makeMutableCopy(values_, capacity);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @return A list containing the values.
       */
      public java.util.List<java.lang.Float> getValuesList() {
        values_.makeImmutable();
        return values_;
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public float getValues(int index) {
        return values_.getFloat(index);
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The values to set.
       * @return This builder for chaining.
       */
      public Builder setValues(int index, float value) {

        ensureValuesIsMutable();
        values_.setFloat(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @param value The values to add.
       * @return This builder for chaining.
       */
      public Builder addValues(float value) {

        ensureValuesIsMutable();
        values_.addFloat(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @param values The values to add.
       * @return This builder for chaining.
       */
      public Builder addAllValues(java.lang.Iterable<? extends java.lang.Float> values) {
        ensureValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Embedding vector values.
       * </pre>
       *
       * <code>repeated float values = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValues() {
        values_ = emptyFloatList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding)
    private static final com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding();
    }

    public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Embedding> PARSER =
        new com.google.protobuf.AbstractParser<Embedding>() {
          @java.lang.Override
          public Embedding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Embedding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Embedding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int EMBEDDING_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding_;

  /**
   *
   *
   * <pre>
   * The embedding generated from the input content.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
   *
   * @return Whether the embedding field is set.
   */
  @java.lang.Override
  public boolean hasEmbedding() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The embedding generated from the input content.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
   *
   * @return The embedding.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding getEmbedding() {
    return embedding_ == null
        ? com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.getDefaultInstance()
        : embedding_;
  }

  /**
   *
   *
   * <pre>
   * The embedding generated from the input content.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.EmbeddingOrBuilder
      getEmbeddingOrBuilder() {
    return embedding_ == null
        ? com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.getDefaultInstance()
        : embedding_;
  }

  public static final int USAGE_METADATA_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1beta1.UsageMetadata usageMetadata_;

  /**
   *
   *
   * <pre>
   * Metadata about the response(s).
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
   *
   * @return Whether the usageMetadata field is set.
   */
  @java.lang.Override
  public boolean hasUsageMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Metadata about the response(s).
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
   *
   * @return The usageMetadata.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.UsageMetadata getUsageMetadata() {
    return usageMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.UsageMetadata.getDefaultInstance()
        : usageMetadata_;
  }

  /**
   *
   *
   * <pre>
   * Metadata about the response(s).
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.UsageMetadataOrBuilder getUsageMetadataOrBuilder() {
    return usageMetadata_ == null
        ? com.google.cloud.aiplatform.v1beta1.UsageMetadata.getDefaultInstance()
        : usageMetadata_;
  }

  public static final int TRUNCATED_FIELD_NUMBER = 4;
  private boolean truncated_ = false;

  /**
   *
   *
   * <pre>
   * Whether the input content was truncated before generating the embedding.
   * </pre>
   *
   * <code>bool truncated = 4;</code>
   *
   * @return The truncated.
   */
  @java.lang.Override
  public boolean getTruncated() {
    return truncated_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getEmbedding());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUsageMetadata());
    }
    if (truncated_ != false) {
      output.writeBool(4, truncated_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEmbedding());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUsageMetadata());
    }
    if (truncated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, truncated_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.EmbedContentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.EmbedContentResponse other =
        (com.google.cloud.aiplatform.v1beta1.EmbedContentResponse) obj;

    if (hasEmbedding() != other.hasEmbedding()) return false;
    if (hasEmbedding()) {
      if (!getEmbedding().equals(other.getEmbedding())) return false;
    }
    if (hasUsageMetadata() != other.hasUsageMetadata()) return false;
    if (hasUsageMetadata()) {
      if (!getUsageMetadata().equals(other.getUsageMetadata())) return false;
    }
    if (getTruncated() != other.getTruncated()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEmbedding()) {
      hash = (37 * hash) + EMBEDDING_FIELD_NUMBER;
      hash = (53 * hash) + getEmbedding().hashCode();
    }
    if (hasUsageMetadata()) {
      hash = (37 * hash) + USAGE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getUsageMetadata().hashCode();
    }
    hash = (37 * hash) + TRUNCATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTruncated());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.EmbedContentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for
   * [PredictionService.EmbedContent][google.cloud.aiplatform.v1beta1.PredictionService.EmbedContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.EmbedContentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.EmbedContentResponse)
      com.google.cloud.aiplatform.v1beta1.EmbedContentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.class,
              com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEmbeddingFieldBuilder();
        getUsageMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      embedding_ = null;
      if (embeddingBuilder_ != null) {
        embeddingBuilder_.dispose();
        embeddingBuilder_ = null;
      }
      usageMetadata_ = null;
      if (usageMetadataBuilder_ != null) {
        usageMetadataBuilder_.dispose();
        usageMetadataBuilder_ = null;
      }
      truncated_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PredictionServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_EmbedContentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse build() {
      com.google.cloud.aiplatform.v1beta1.EmbedContentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.EmbedContentResponse result =
          new com.google.cloud.aiplatform.v1beta1.EmbedContentResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.EmbedContentResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.embedding_ = embeddingBuilder_ == null ? embedding_ : embeddingBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.usageMetadata_ =
            usageMetadataBuilder_ == null ? usageMetadata_ : usageMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.truncated_ = truncated_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.EmbedContentResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.EmbedContentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.EmbedContentResponse other) {
      if (other == com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.getDefaultInstance())
        return this;
      if (other.hasEmbedding()) {
        mergeEmbedding(other.getEmbedding());
      }
      if (other.hasUsageMetadata()) {
        mergeUsageMetadata(other.getUsageMetadata());
      }
      if (other.getTruncated() != false) {
        setTruncated(other.getTruncated());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEmbeddingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUsageMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 32:
              {
                truncated_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding,
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder,
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.EmbeddingOrBuilder>
        embeddingBuilder_;

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     *
     * @return Whether the embedding field is set.
     */
    public boolean hasEmbedding() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     *
     * @return The embedding.
     */
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding getEmbedding() {
      if (embeddingBuilder_ == null) {
        return embedding_ == null
            ? com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
                .getDefaultInstance()
            : embedding_;
      } else {
        return embeddingBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    public Builder setEmbedding(
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding value) {
      if (embeddingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        embedding_ = value;
      } else {
        embeddingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    public Builder setEmbedding(
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder
            builderForValue) {
      if (embeddingBuilder_ == null) {
        embedding_ = builderForValue.build();
      } else {
        embeddingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    public Builder mergeEmbedding(
        com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding value) {
      if (embeddingBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && embedding_ != null
            && embedding_
                != com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
                    .getDefaultInstance()) {
          getEmbeddingBuilder().mergeFrom(value);
        } else {
          embedding_ = value;
        }
      } else {
        embeddingBuilder_.mergeFrom(value);
      }
      if (embedding_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    public Builder clearEmbedding() {
      bitField0_ = (bitField0_ & ~0x00000001);
      embedding_ = null;
      if (embeddingBuilder_ != null) {
        embeddingBuilder_.dispose();
        embeddingBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder
        getEmbeddingBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getEmbeddingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.EmbeddingOrBuilder
        getEmbeddingOrBuilder() {
      if (embeddingBuilder_ != null) {
        return embeddingBuilder_.getMessageOrBuilder();
      } else {
        return embedding_ == null
            ? com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding
                .getDefaultInstance()
            : embedding_;
      }
    }

    /**
     *
     *
     * <pre>
     * The embedding generated from the input content.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding embedding = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding,
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder,
            com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.EmbeddingOrBuilder>
        getEmbeddingFieldBuilder() {
      if (embeddingBuilder_ == null) {
        embeddingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding,
                com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.Embedding.Builder,
                com.google.cloud.aiplatform.v1beta1.EmbedContentResponse.EmbeddingOrBuilder>(
                getEmbedding(), getParentForChildren(), isClean());
        embedding_ = null;
      }
      return embeddingBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.UsageMetadata usageMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.UsageMetadata,
            com.google.cloud.aiplatform.v1beta1.UsageMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.UsageMetadataOrBuilder>
        usageMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     *
     * @return Whether the usageMetadata field is set.
     */
    public boolean hasUsageMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     *
     * @return The usageMetadata.
     */
    public com.google.cloud.aiplatform.v1beta1.UsageMetadata getUsageMetadata() {
      if (usageMetadataBuilder_ == null) {
        return usageMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.UsageMetadata.getDefaultInstance()
            : usageMetadata_;
      } else {
        return usageMetadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    public Builder setUsageMetadata(com.google.cloud.aiplatform.v1beta1.UsageMetadata value) {
      if (usageMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usageMetadata_ = value;
      } else {
        usageMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    public Builder setUsageMetadata(
        com.google.cloud.aiplatform.v1beta1.UsageMetadata.Builder builderForValue) {
      if (usageMetadataBuilder_ == null) {
        usageMetadata_ = builderForValue.build();
      } else {
        usageMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    public Builder mergeUsageMetadata(com.google.cloud.aiplatform.v1beta1.UsageMetadata value) {
      if (usageMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && usageMetadata_ != null
            && usageMetadata_
                != com.google.cloud.aiplatform.v1beta1.UsageMetadata.getDefaultInstance()) {
          getUsageMetadataBuilder().mergeFrom(value);
        } else {
          usageMetadata_ = value;
        }
      } else {
        usageMetadataBuilder_.mergeFrom(value);
      }
      if (usageMetadata_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    public Builder clearUsageMetadata() {
      bitField0_ = (bitField0_ & ~0x00000002);
      usageMetadata_ = null;
      if (usageMetadataBuilder_ != null) {
        usageMetadataBuilder_.dispose();
        usageMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.UsageMetadata.Builder getUsageMetadataBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUsageMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.UsageMetadataOrBuilder getUsageMetadataOrBuilder() {
      if (usageMetadataBuilder_ != null) {
        return usageMetadataBuilder_.getMessageOrBuilder();
      } else {
        return usageMetadata_ == null
            ? com.google.cloud.aiplatform.v1beta1.UsageMetadata.getDefaultInstance()
            : usageMetadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Metadata about the response(s).
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.UsageMetadata usage_metadata = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.UsageMetadata,
            com.google.cloud.aiplatform.v1beta1.UsageMetadata.Builder,
            com.google.cloud.aiplatform.v1beta1.UsageMetadataOrBuilder>
        getUsageMetadataFieldBuilder() {
      if (usageMetadataBuilder_ == null) {
        usageMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.UsageMetadata,
                com.google.cloud.aiplatform.v1beta1.UsageMetadata.Builder,
                com.google.cloud.aiplatform.v1beta1.UsageMetadataOrBuilder>(
                getUsageMetadata(), getParentForChildren(), isClean());
        usageMetadata_ = null;
      }
      return usageMetadataBuilder_;
    }

    private boolean truncated_;

    /**
     *
     *
     * <pre>
     * Whether the input content was truncated before generating the embedding.
     * </pre>
     *
     * <code>bool truncated = 4;</code>
     *
     * @return The truncated.
     */
    @java.lang.Override
    public boolean getTruncated() {
      return truncated_;
    }

    /**
     *
     *
     * <pre>
     * Whether the input content was truncated before generating the embedding.
     * </pre>
     *
     * <code>bool truncated = 4;</code>
     *
     * @param value The truncated to set.
     * @return This builder for chaining.
     */
    public Builder setTruncated(boolean value) {

      truncated_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the input content was truncated before generating the embedding.
     * </pre>
     *
     * <code>bool truncated = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTruncated() {
      bitField0_ = (bitField0_ & ~0x00000004);
      truncated_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.EmbedContentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.EmbedContentResponse)
  private static final com.google.cloud.aiplatform.v1beta1.EmbedContentResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.EmbedContentResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.EmbedContentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EmbedContentResponse> PARSER =
      new com.google.protobuf.AbstractParser<EmbedContentResponse>() {
        @java.lang.Override
        public EmbedContentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EmbedContentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EmbedContentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EmbedContentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
