/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

public interface ImportRagFilesConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ImportRagFilesConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  boolean hasGcsSource();

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return The gcsSource.
   */
  com.google.cloud.aiplatform.v1beta1.GcsSource getGcsSource();

  /**
   *
   *
   * <pre>
   * Google Cloud Storage location. Supports importing individual files as
   * well as entire Google Cloud Storage directories. Sample formats:
   * - `gs://bucket_name/my_directory/object_name/my_file.txt`
   * - `gs://bucket_name/my_directory`
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsSource gcs_source = 2;</code>
   */
  com.google.cloud.aiplatform.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   *
   * @return Whether the googleDriveSource field is set.
   */
  boolean hasGoogleDriveSource();

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   *
   * @return The googleDriveSource.
   */
  com.google.cloud.aiplatform.v1beta1.GoogleDriveSource getGoogleDriveSource();

  /**
   *
   *
   * <pre>
   * Google Drive location. Supports importing individual files as
   * well as Google Drive folders.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GoogleDriveSource google_drive_source = 3;</code>
   */
  com.google.cloud.aiplatform.v1beta1.GoogleDriveSourceOrBuilder getGoogleDriveSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   *
   * @return Whether the slackSource field is set.
   */
  boolean hasSlackSource();

  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   *
   * @return The slackSource.
   */
  com.google.cloud.aiplatform.v1beta1.SlackSource getSlackSource();

  /**
   *
   *
   * <pre>
   * Slack channels with their corresponding access tokens.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SlackSource slack_source = 6;</code>
   */
  com.google.cloud.aiplatform.v1beta1.SlackSourceOrBuilder getSlackSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   *
   * @return Whether the jiraSource field is set.
   */
  boolean hasJiraSource();

  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   *
   * @return The jiraSource.
   */
  com.google.cloud.aiplatform.v1beta1.JiraSource getJiraSource();

  /**
   *
   *
   * <pre>
   * Jira queries with their corresponding authentication.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.JiraSource jira_source = 7;</code>
   */
  com.google.cloud.aiplatform.v1beta1.JiraSourceOrBuilder getJiraSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * SharePoint sources.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
   *
   * @return Whether the sharePointSources field is set.
   */
  boolean hasSharePointSources();

  /**
   *
   *
   * <pre>
   * SharePoint sources.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
   *
   * @return The sharePointSources.
   */
  com.google.cloud.aiplatform.v1beta1.SharePointSources getSharePointSources();

  /**
   *
   *
   * <pre>
   * SharePoint sources.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.SharePointSources share_point_sources = 13;</code>
   */
  com.google.cloud.aiplatform.v1beta1.SharePointSourcesOrBuilder getSharePointSourcesOrBuilder();

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write partial failures to.
   * Deprecated. Prefer to use `import_result_gcs_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=710
   * @return Whether the partialFailureGcsSink field is set.
   */
  @java.lang.Deprecated
  boolean hasPartialFailureGcsSink();

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write partial failures to.
   * Deprecated. Prefer to use `import_result_gcs_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=710
   * @return The partialFailureGcsSink.
   */
  @java.lang.Deprecated
  com.google.cloud.aiplatform.v1beta1.GcsDestination getPartialFailureGcsSink();

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write partial failures to.
   * Deprecated. Prefer to use `import_result_gcs_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getPartialFailureGcsSinkOrBuilder();

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write partial failures to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * Deprecated. Prefer to use `import_result_bq_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink
   *     is deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=719
   * @return Whether the partialFailureBigquerySink field is set.
   */
  @java.lang.Deprecated
  boolean hasPartialFailureBigquerySink();

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write partial failures to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * Deprecated. Prefer to use `import_result_bq_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink
   *     is deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=719
   * @return The partialFailureBigquerySink.
   */
  @java.lang.Deprecated
  com.google.cloud.aiplatform.v1beta1.BigQueryDestination getPartialFailureBigquerySink();

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write partial failures to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * Deprecated. Prefer to use `import_result_bq_sink`.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
      getPartialFailureBigquerySinkOrBuilder();

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write import result to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
   *
   * @return Whether the importResultGcsSink field is set.
   */
  boolean hasImportResultGcsSink();

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write import result to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
   *
   * @return The importResultGcsSink.
   */
  com.google.cloud.aiplatform.v1beta1.GcsDestination getImportResultGcsSink();

  /**
   *
   *
   * <pre>
   * The Cloud Storage path to write import result to.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.GcsDestination import_result_gcs_sink = 14;</code>
   */
  com.google.cloud.aiplatform.v1beta1.GcsDestinationOrBuilder getImportResultGcsSinkOrBuilder();

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write import result to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
   * </code>
   *
   * @return Whether the importResultBigquerySink field is set.
   */
  boolean hasImportResultBigquerySink();

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write import result to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
   * </code>
   *
   * @return The importResultBigquerySink.
   */
  com.google.cloud.aiplatform.v1beta1.BigQueryDestination getImportResultBigquerySink();

  /**
   *
   *
   * <pre>
   * The BigQuery destination to write import result to. It should be a
   * bigquery table resource name (e.g.
   * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
   * table does not exist, it will be created with the expected schema. If the
   * table exists, the schema will be validated and data will be added to this
   * existing table.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.BigQueryDestination import_result_bigquery_sink = 15;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.BigQueryDestinationOrBuilder
      getImportResultBigquerySinkOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=738
   * @return Whether the ragFileChunkingConfig field is set.
   */
  @java.lang.Deprecated
  boolean hasRagFileChunkingConfig();

  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config is
   *     deprecated. See google/cloud/aiplatform/v1beta1/vertex_rag_data.proto;l=738
   * @return The ragFileChunkingConfig.
   */
  @java.lang.Deprecated
  com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfig getRagFileChunkingConfig();

  /**
   *
   *
   * <pre>
   * Specifies the size and overlap of chunks after importing RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileChunkingConfig rag_file_chunking_config = 4 [deprecated = true];
   * </code>
   */
  @java.lang.Deprecated
  com.google.cloud.aiplatform.v1beta1.RagFileChunkingConfigOrBuilder
      getRagFileChunkingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies the transformation config for RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
   * </code>
   *
   * @return Whether the ragFileTransformationConfig field is set.
   */
  boolean hasRagFileTransformationConfig();

  /**
   *
   *
   * <pre>
   * Specifies the transformation config for RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
   * </code>
   *
   * @return The ragFileTransformationConfig.
   */
  com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfig getRagFileTransformationConfig();

  /**
   *
   *
   * <pre>
   * Specifies the transformation config for RagFiles.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileTransformationConfig rag_file_transformation_config = 16;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.RagFileTransformationConfigOrBuilder
      getRagFileTransformationConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the parsing config for RagFiles.
   * RAG will use the default parser if this field is not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ragFileParsingConfig field is set.
   */
  boolean hasRagFileParsingConfig();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the parsing config for RagFiles.
   * RAG will use the default parser if this field is not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ragFileParsingConfig.
   */
  com.google.cloud.aiplatform.v1beta1.RagFileParsingConfig getRagFileParsingConfig();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the parsing config for RagFiles.
   * RAG will use the default parser if this field is not set.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.RagFileParsingConfigOrBuilder
      getRagFileParsingConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies the metadata config for RagFiles.
   * Including paths for metadata schema and metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig rag_file_metadata_config = 17;
   * </code>
   *
   * @return Whether the ragFileMetadataConfig field is set.
   */
  boolean hasRagFileMetadataConfig();

  /**
   *
   *
   * <pre>
   * Specifies the metadata config for RagFiles.
   * Including paths for metadata schema and metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig rag_file_metadata_config = 17;
   * </code>
   *
   * @return The ragFileMetadataConfig.
   */
  com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig getRagFileMetadataConfig();

  /**
   *
   *
   * <pre>
   * Specifies the metadata config for RagFiles.
   * Including paths for metadata schema and metadata.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.RagFileMetadataConfig rag_file_metadata_config = 17;
   * </code>
   */
  com.google.cloud.aiplatform.v1beta1.RagFileMetadataConfigOrBuilder
      getRagFileMetadataConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The max number of queries per minute that this job is allowed to
   * make to the embedding model specified on the corpus. This value is specific
   * to this job and not shared across other import jobs. Consult the Quotas
   * page on the project to set an appropriate value here.
   * If unspecified, a default value of 1,000 QPM would be used.
   * </pre>
   *
   * <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The maxEmbeddingRequestsPerMin.
   */
  int getMaxEmbeddingRequestsPerMin();

  /**
   *
   *
   * <pre>
   * Optional. The max number of queries per minute that the indexing pipeline
   * job is allowed to make to the embedding model specified in the project.
   * Please follow the quota usage guideline of the embedding model you use to
   * set the value properly.If this value is not specified,
   * max_embedding_requests_per_min will be used by indexing pipeline job as the
   * global limit.
   * </pre>
   *
   * <code>
   * int32 global_max_embedding_requests_per_min = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The globalMaxEmbeddingRequestsPerMin.
   */
  int getGlobalMaxEmbeddingRequestsPerMin();

  /**
   *
   *
   * <pre>
   * Rebuilds the ANN index to optimize for recall on the imported data.
   * Only applicable for RagCorpora running on RagManagedDb with
   * `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
   * existing ANN config set on the RagCorpus. To change the ANN config, please
   * use the UpdateRagCorpus API.
   *
   * Default is false, i.e., index is not rebuilt.
   * </pre>
   *
   * <code>bool rebuild_ann_index = 19;</code>
   *
   * @return The rebuildAnnIndex.
   */
  boolean getRebuildAnnIndex();

  com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.ImportSourceCase getImportSourceCase();

  com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.PartialFailureSinkCase
      getPartialFailureSinkCase();

  com.google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.ImportResultSinkCase
      getImportResultSinkCase();
}
