/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REASONING_ENGINE_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reasoningEngine;
    private final String session;

    @Deprecated
    protected SessionName() {
        this.project = null;
        this.location = null;
        this.reasoningEngine = null;
        this.session = null;
    }

    private SessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reasoningEngine = (String)Preconditions.checkNotNull((Object)builder.getReasoningEngine());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReasoningEngine() {
        return this.reasoningEngine;
    }

    public String getSession() {
        return this.session;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionName of(String project, String location, String reasoningEngine, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setReasoningEngine(reasoningEngine).setSession(session).build();
    }

    public static String format(String project, String location, String reasoningEngine, String session) {
        return SessionName.newBuilder().setProject(project).setLocation(location).setReasoningEngine(reasoningEngine).setSession(session).build().toString();
    }

    public static SessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REASONING_ENGINE_SESSION.validatedMatch(formattedString, "SessionName.parse: formattedString not in valid format");
        return SessionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reasoning_engine"), (String)matchMap.get("session"));
    }

    public static List<SessionName> parseList(List<String> formattedStrings) {
        ArrayList<SessionName> list = new ArrayList<SessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REASONING_ENGINE_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionName sessionName = this;
            synchronized (sessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reasoningEngine != null) {
                        fieldMapBuilder.put((Object)"reasoning_engine", (Object)this.reasoningEngine);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REASONING_ENGINE_SESSION.instantiate(new String[]{"project", this.project, "location", this.location, "reasoning_engine", this.reasoningEngine, "session", this.session});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SessionName that = (SessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reasoningEngine, that.reasoningEngine) && Objects.equals(this.session, that.session);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.reasoningEngine);
        h *= 1000003;
        return h ^= Objects.hashCode(this.session);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reasoningEngine;
        private String session;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReasoningEngine() {
            return this.reasoningEngine;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReasoningEngine(String reasoningEngine) {
            this.reasoningEngine = reasoningEngine;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder(SessionName sessionName) {
            this.project = sessionName.project;
            this.location = sessionName.location;
            this.reasoningEngine = sessionName.reasoningEngine;
            this.session = sessionName.session;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }
}

