/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DockerImageName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_DOCKER_IMAGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/dockerImages/{docker_image}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String dockerImage;

    @Deprecated
    protected DockerImageName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.dockerImage = null;
    }

    private DockerImageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.dockerImage = (String)Preconditions.checkNotNull((Object)builder.getDockerImage());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DockerImageName of(String project, String location, String repository, String dockerImage) {
        return DockerImageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setDockerImage(dockerImage).build();
    }

    public static String format(String project, String location, String repository, String dockerImage) {
        return DockerImageName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setDockerImage(dockerImage).build().toString();
    }

    public static DockerImageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_DOCKER_IMAGE.validatedMatch(formattedString, "DockerImageName.parse: formattedString not in valid format");
        return DockerImageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("docker_image"));
    }

    public static List<DockerImageName> parseList(List<String> formattedStrings) {
        ArrayList<DockerImageName> list = new ArrayList<DockerImageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DockerImageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DockerImageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DockerImageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_DOCKER_IMAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DockerImageName dockerImageName = this;
            synchronized (dockerImageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.dockerImage != null) {
                        fieldMapBuilder.put((Object)"docker_image", (Object)this.dockerImage);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_DOCKER_IMAGE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "docker_image", this.dockerImage});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DockerImageName that = (DockerImageName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.dockerImage, that.dockerImage);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dockerImage);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String dockerImage;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getDockerImage() {
            return this.dockerImage;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setDockerImage(String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        private Builder(DockerImageName dockerImageName) {
            this.project = dockerImageName.project;
            this.location = dockerImageName.location;
            this.repository = dockerImageName.repository;
            this.dockerImage = dockerImageName.dockerImage;
        }

        public DockerImageName build() {
            return new DockerImageName(this);
        }
    }
}

