/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableSpecName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASET_TABLE_SPEC = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasets/{dataset}/tableSpecs/{table_spec}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String tableSpec;

    @Deprecated
    protected TableSpecName() {
        this.project = null;
        this.location = null;
        this.dataset = null;
        this.tableSpec = null;
    }

    private TableSpecName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.tableSpec = (String)Preconditions.checkNotNull((Object)builder.getTableSpec());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTableSpec() {
        return this.tableSpec;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TableSpecName of(String project, String location, String dataset, String tableSpec) {
        return TableSpecName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setTableSpec(tableSpec).build();
    }

    public static String format(String project, String location, String dataset, String tableSpec) {
        return TableSpecName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setTableSpec(tableSpec).build().toString();
    }

    public static TableSpecName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASET_TABLE_SPEC.validatedMatch(formattedString, "TableSpecName.parse: formattedString not in valid format");
        return TableSpecName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("table_spec"));
    }

    public static List<TableSpecName> parseList(List<String> formattedStrings) {
        ArrayList<TableSpecName> list = new ArrayList<TableSpecName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TableSpecName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TableSpecName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TableSpecName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASET_TABLE_SPEC.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TableSpecName tableSpecName = this;
            synchronized (tableSpecName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.tableSpec != null) {
                        fieldMapBuilder.put((Object)"table_spec", (Object)this.tableSpec);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASET_TABLE_SPEC.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "table_spec", this.tableSpec});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TableSpecName that = (TableSpecName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.tableSpec, that.tableSpec);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tableSpec);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String tableSpec;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getTableSpec() {
            return this.tableSpec;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTableSpec(String tableSpec) {
            this.tableSpec = tableSpec;
            return this;
        }

        private Builder(TableSpecName tableSpecName) {
            this.project = tableSpecName.project;
            this.location = tableSpecName.location;
            this.dataset = tableSpecName.dataset;
            this.tableSpec = tableSpecName.tableSpec;
        }

        public TableSpecName build() {
            return new TableSpecName(this);
        }
    }
}

