/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/batch.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * CreateResourceAllowance Request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.CreateResourceAllowanceRequest}
 */
public final class CreateResourceAllowanceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.CreateResourceAllowanceRequest)
    CreateResourceAllowanceRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateResourceAllowanceRequest.newBuilder() to construct.
  private CreateResourceAllowanceRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateResourceAllowanceRequest() {
    parent_ = "";
    resourceAllowanceId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateResourceAllowanceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.BatchProto
        .internal_static_google_cloud_batch_v1alpha_CreateResourceAllowanceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.BatchProto
        .internal_static_google_cloud_batch_v1alpha_CreateResourceAllowanceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.class,
            com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The parent resource name where the ResourceAllowance will be
   * created. Pattern: "projects/{project}/locations/{location}"
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The parent resource name where the ResourceAllowance will be
   * created. Pattern: "projects/{project}/locations/{location}"
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_ALLOWANCE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceAllowanceId_ = "";

  /**
   *
   *
   * <pre>
   * ID used to uniquely identify the ResourceAllowance within its parent scope.
   * This field should contain at most 63 characters and must start with
   * lowercase characters.
   * Only lowercase characters, numbers and '-' are accepted.
   * The '-' character cannot be the first or the last one.
   * A system generated ID will be used if the field is not set.
   *
   * The resource_allowance.name field in the request will be ignored and the
   * created resource name of the ResourceAllowance will be
   * "{parent}/resourceAllowances/{resource_allowance_id}".
   * </pre>
   *
   * <code>string resource_allowance_id = 2;</code>
   *
   * @return The resourceAllowanceId.
   */
  @java.lang.Override
  public java.lang.String getResourceAllowanceId() {
    java.lang.Object ref = resourceAllowanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceAllowanceId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * ID used to uniquely identify the ResourceAllowance within its parent scope.
   * This field should contain at most 63 characters and must start with
   * lowercase characters.
   * Only lowercase characters, numbers and '-' are accepted.
   * The '-' character cannot be the first or the last one.
   * A system generated ID will be used if the field is not set.
   *
   * The resource_allowance.name field in the request will be ignored and the
   * created resource name of the ResourceAllowance will be
   * "{parent}/resourceAllowances/{resource_allowance_id}".
   * </pre>
   *
   * <code>string resource_allowance_id = 2;</code>
   *
   * @return The bytes for resourceAllowanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceAllowanceIdBytes() {
    java.lang.Object ref = resourceAllowanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceAllowanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_ALLOWANCE_FIELD_NUMBER = 3;
  private com.google.cloud.batch.v1alpha.ResourceAllowance resourceAllowance_;

  /**
   *
   *
   * <pre>
   * Required. The ResourceAllowance to create.
   * </pre>
   *
   * <code>
   * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the resourceAllowance field is set.
   */
  @java.lang.Override
  public boolean hasResourceAllowance() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The ResourceAllowance to create.
   * </pre>
   *
   * <code>
   * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The resourceAllowance.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ResourceAllowance getResourceAllowance() {
    return resourceAllowance_ == null
        ? com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance()
        : resourceAllowance_;
  }

  /**
   *
   *
   * <pre>
   * Required. The ResourceAllowance to create.
   * </pre>
   *
   * <code>
   * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ResourceAllowanceOrBuilder getResourceAllowanceOrBuilder() {
    return resourceAllowance_ == null
        ? com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance()
        : resourceAllowance_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";

  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and
   * the request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>
   * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and
   * the request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>
   * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceAllowanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceAllowanceId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getResourceAllowance());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceAllowanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceAllowanceId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResourceAllowance());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest other =
        (com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getResourceAllowanceId().equals(other.getResourceAllowanceId())) return false;
    if (hasResourceAllowance() != other.hasResourceAllowance()) return false;
    if (hasResourceAllowance()) {
      if (!getResourceAllowance().equals(other.getResourceAllowance())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + RESOURCE_ALLOWANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResourceAllowanceId().hashCode();
    if (hasResourceAllowance()) {
      hash = (37 * hash) + RESOURCE_ALLOWANCE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceAllowance().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * CreateResourceAllowance Request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.CreateResourceAllowanceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.CreateResourceAllowanceRequest)
      com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.BatchProto
          .internal_static_google_cloud_batch_v1alpha_CreateResourceAllowanceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.BatchProto
          .internal_static_google_cloud_batch_v1alpha_CreateResourceAllowanceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.class,
              com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceAllowanceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      resourceAllowanceId_ = "";
      resourceAllowance_ = null;
      if (resourceAllowanceBuilder_ != null) {
        resourceAllowanceBuilder_.dispose();
        resourceAllowanceBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.BatchProto
          .internal_static_google_cloud_batch_v1alpha_CreateResourceAllowanceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest
        getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest build() {
      com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest buildPartial() {
      com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest result =
          new com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resourceAllowanceId_ = resourceAllowanceId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceAllowance_ =
            resourceAllowanceBuilder_ == null
                ? resourceAllowance_
                : resourceAllowanceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest) {
        return mergeFrom((com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest other) {
      if (other
          == com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getResourceAllowanceId().isEmpty()) {
        resourceAllowanceId_ = other.resourceAllowanceId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasResourceAllowance()) {
        mergeResourceAllowance(other.getResourceAllowance());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                resourceAllowanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getResourceAllowanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The parent resource name where the ResourceAllowance will be
     * created. Pattern: "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name where the ResourceAllowance will be
     * created. Pattern: "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name where the ResourceAllowance will be
     * created. Pattern: "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name where the ResourceAllowance will be
     * created. Pattern: "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource name where the ResourceAllowance will be
     * created. Pattern: "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object resourceAllowanceId_ = "";

    /**
     *
     *
     * <pre>
     * ID used to uniquely identify the ResourceAllowance within its parent scope.
     * This field should contain at most 63 characters and must start with
     * lowercase characters.
     * Only lowercase characters, numbers and '-' are accepted.
     * The '-' character cannot be the first or the last one.
     * A system generated ID will be used if the field is not set.
     *
     * The resource_allowance.name field in the request will be ignored and the
     * created resource name of the ResourceAllowance will be
     * "{parent}/resourceAllowances/{resource_allowance_id}".
     * </pre>
     *
     * <code>string resource_allowance_id = 2;</code>
     *
     * @return The resourceAllowanceId.
     */
    public java.lang.String getResourceAllowanceId() {
      java.lang.Object ref = resourceAllowanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceAllowanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID used to uniquely identify the ResourceAllowance within its parent scope.
     * This field should contain at most 63 characters and must start with
     * lowercase characters.
     * Only lowercase characters, numbers and '-' are accepted.
     * The '-' character cannot be the first or the last one.
     * A system generated ID will be used if the field is not set.
     *
     * The resource_allowance.name field in the request will be ignored and the
     * created resource name of the ResourceAllowance will be
     * "{parent}/resourceAllowances/{resource_allowance_id}".
     * </pre>
     *
     * <code>string resource_allowance_id = 2;</code>
     *
     * @return The bytes for resourceAllowanceId.
     */
    public com.google.protobuf.ByteString getResourceAllowanceIdBytes() {
      java.lang.Object ref = resourceAllowanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceAllowanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * ID used to uniquely identify the ResourceAllowance within its parent scope.
     * This field should contain at most 63 characters and must start with
     * lowercase characters.
     * Only lowercase characters, numbers and '-' are accepted.
     * The '-' character cannot be the first or the last one.
     * A system generated ID will be used if the field is not set.
     *
     * The resource_allowance.name field in the request will be ignored and the
     * created resource name of the ResourceAllowance will be
     * "{parent}/resourceAllowances/{resource_allowance_id}".
     * </pre>
     *
     * <code>string resource_allowance_id = 2;</code>
     *
     * @param value The resourceAllowanceId to set.
     * @return This builder for chaining.
     */
    public Builder setResourceAllowanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceAllowanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID used to uniquely identify the ResourceAllowance within its parent scope.
     * This field should contain at most 63 characters and must start with
     * lowercase characters.
     * Only lowercase characters, numbers and '-' are accepted.
     * The '-' character cannot be the first or the last one.
     * A system generated ID will be used if the field is not set.
     *
     * The resource_allowance.name field in the request will be ignored and the
     * created resource name of the ResourceAllowance will be
     * "{parent}/resourceAllowances/{resource_allowance_id}".
     * </pre>
     *
     * <code>string resource_allowance_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceAllowanceId() {
      resourceAllowanceId_ = getDefaultInstance().getResourceAllowanceId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * ID used to uniquely identify the ResourceAllowance within its parent scope.
     * This field should contain at most 63 characters and must start with
     * lowercase characters.
     * Only lowercase characters, numbers and '-' are accepted.
     * The '-' character cannot be the first or the last one.
     * A system generated ID will be used if the field is not set.
     *
     * The resource_allowance.name field in the request will be ignored and the
     * created resource name of the ResourceAllowance will be
     * "{parent}/resourceAllowances/{resource_allowance_id}".
     * </pre>
     *
     * <code>string resource_allowance_id = 2;</code>
     *
     * @param value The bytes for resourceAllowanceId to set.
     * @return This builder for chaining.
     */
    public Builder setResourceAllowanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceAllowanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.batch.v1alpha.ResourceAllowance resourceAllowance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.ResourceAllowance,
            com.google.cloud.batch.v1alpha.ResourceAllowance.Builder,
            com.google.cloud.batch.v1alpha.ResourceAllowanceOrBuilder>
        resourceAllowanceBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the resourceAllowance field is set.
     */
    public boolean hasResourceAllowance() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resourceAllowance.
     */
    public com.google.cloud.batch.v1alpha.ResourceAllowance getResourceAllowance() {
      if (resourceAllowanceBuilder_ == null) {
        return resourceAllowance_ == null
            ? com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance()
            : resourceAllowance_;
      } else {
        return resourceAllowanceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourceAllowance(com.google.cloud.batch.v1alpha.ResourceAllowance value) {
      if (resourceAllowanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceAllowance_ = value;
      } else {
        resourceAllowanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourceAllowance(
        com.google.cloud.batch.v1alpha.ResourceAllowance.Builder builderForValue) {
      if (resourceAllowanceBuilder_ == null) {
        resourceAllowance_ = builderForValue.build();
      } else {
        resourceAllowanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeResourceAllowance(com.google.cloud.batch.v1alpha.ResourceAllowance value) {
      if (resourceAllowanceBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && resourceAllowance_ != null
            && resourceAllowance_
                != com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance()) {
          getResourceAllowanceBuilder().mergeFrom(value);
        } else {
          resourceAllowance_ = value;
        }
      } else {
        resourceAllowanceBuilder_.mergeFrom(value);
      }
      if (resourceAllowance_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResourceAllowance() {
      bitField0_ = (bitField0_ & ~0x00000004);
      resourceAllowance_ = null;
      if (resourceAllowanceBuilder_ != null) {
        resourceAllowanceBuilder_.dispose();
        resourceAllowanceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.ResourceAllowance.Builder getResourceAllowanceBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResourceAllowanceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.ResourceAllowanceOrBuilder
        getResourceAllowanceOrBuilder() {
      if (resourceAllowanceBuilder_ != null) {
        return resourceAllowanceBuilder_.getMessageOrBuilder();
      } else {
        return resourceAllowance_ == null
            ? com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance()
            : resourceAllowance_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ResourceAllowance to create.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.ResourceAllowance resource_allowance = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.ResourceAllowance,
            com.google.cloud.batch.v1alpha.ResourceAllowance.Builder,
            com.google.cloud.batch.v1alpha.ResourceAllowanceOrBuilder>
        getResourceAllowanceFieldBuilder() {
      if (resourceAllowanceBuilder_ == null) {
        resourceAllowanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.ResourceAllowance,
                com.google.cloud.batch.v1alpha.ResourceAllowance.Builder,
                com.google.cloud.batch.v1alpha.ResourceAllowanceOrBuilder>(
                getResourceAllowance(), getParentForChildren(), isClean());
        resourceAllowance_ = null;
      }
      return resourceAllowanceBuilder_;
    }

    private java.lang.Object requestId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>
     * string request_id = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.CreateResourceAllowanceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.CreateResourceAllowanceRequest)
  private static final com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest();
  }

  public static com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateResourceAllowanceRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateResourceAllowanceRequest>() {
        @java.lang.Override
        public CreateResourceAllowanceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateResourceAllowanceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateResourceAllowanceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
