/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/resource_allowance.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * The Resource Allowance description for Cloud Batch.
 * Only one Resource Allowance is supported now under a specific location and
 * project.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.ResourceAllowance}
 */
public final class ResourceAllowance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.ResourceAllowance)
    ResourceAllowanceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ResourceAllowance.newBuilder() to construct.
  private ResourceAllowance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResourceAllowance() {
    name_ = "";
    uid_ = "";
    notifications_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResourceAllowance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.ResourceAllowanceProto
        .internal_static_google_cloud_batch_v1alpha_ResourceAllowance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.ResourceAllowanceProto
        .internal_static_google_cloud_batch_v1alpha_ResourceAllowance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.ResourceAllowance.class,
            com.google.cloud.batch.v1alpha.ResourceAllowance.Builder.class);
  }

  private int bitField0_;
  private int resourceAllowanceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object resourceAllowance_;

  public enum ResourceAllowanceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USAGE_RESOURCE_ALLOWANCE(4),
    RESOURCEALLOWANCE_NOT_SET(0);
    private final int value;

    private ResourceAllowanceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResourceAllowanceCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResourceAllowanceCase forNumber(int value) {
      switch (value) {
        case 4:
          return USAGE_RESOURCE_ALLOWANCE;
        case 0:
          return RESOURCEALLOWANCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResourceAllowanceCase getResourceAllowanceCase() {
    return ResourceAllowanceCase.forNumber(resourceAllowanceCase_);
  }

  public static final int USAGE_RESOURCE_ALLOWANCE_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * The detail of usage resource allowance.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
   *
   * @return Whether the usageResourceAllowance field is set.
   */
  @java.lang.Override
  public boolean hasUsageResourceAllowance() {
    return resourceAllowanceCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * The detail of usage resource allowance.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
   *
   * @return The usageResourceAllowance.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.UsageResourceAllowance getUsageResourceAllowance() {
    if (resourceAllowanceCase_ == 4) {
      return (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_;
    }
    return com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The detail of usage resource allowance.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.UsageResourceAllowanceOrBuilder
      getUsageResourceAllowanceOrBuilder() {
    if (resourceAllowanceCase_ == 4) {
      return (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_;
    }
    return com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. ResourceAllowance name.
   * For example:
   * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. ResourceAllowance name.
   * For example:
   * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A system generated unique ID (in UUID4 format) for the
   * ResourceAllowance.
   * </pre>
   *
   * <code>
   * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A system generated unique ID (in UUID4 format) for the
   * ResourceAllowance.
   * </pre>
   *
   * <code>
   * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when the ResourceAllowance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the ResourceAllowance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the ResourceAllowance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1alpha.ResourceAllowanceProto
                .internal_static_google_cloud_batch_v1alpha_ResourceAllowance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Batch. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Batch. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Batch. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Batch. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NOTIFICATIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1alpha.Notification> notifications_;

  /**
   *
   *
   * <pre>
   * Optional. Notification configurations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1alpha.Notification> getNotificationsList() {
    return notifications_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Notification configurations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1alpha.NotificationOrBuilder>
      getNotificationsOrBuilderList() {
    return notifications_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Notification configurations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getNotificationsCount() {
    return notifications_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Notification configurations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Notification getNotifications(int index) {
    return notifications_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Notification configurations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.NotificationOrBuilder getNotificationsOrBuilder(int index) {
    return notifications_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (resourceAllowanceCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    for (int i = 0; i < notifications_.size(); i++) {
      output.writeMessage(6, notifications_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (resourceAllowanceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    for (int i = 0; i < notifications_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, notifications_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.ResourceAllowance)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.ResourceAllowance other =
        (com.google.cloud.batch.v1alpha.ResourceAllowance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getNotificationsList().equals(other.getNotificationsList())) return false;
    if (!getResourceAllowanceCase().equals(other.getResourceAllowanceCase())) return false;
    switch (resourceAllowanceCase_) {
      case 4:
        if (!getUsageResourceAllowance().equals(other.getUsageResourceAllowance())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getNotificationsCount() > 0) {
      hash = (37 * hash) + NOTIFICATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationsList().hashCode();
    }
    switch (resourceAllowanceCase_) {
      case 4:
        hash = (37 * hash) + USAGE_RESOURCE_ALLOWANCE_FIELD_NUMBER;
        hash = (53 * hash) + getUsageResourceAllowance().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1alpha.ResourceAllowance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The Resource Allowance description for Cloud Batch.
   * Only one Resource Allowance is supported now under a specific location and
   * project.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.ResourceAllowance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.ResourceAllowance)
      com.google.cloud.batch.v1alpha.ResourceAllowanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.ResourceAllowanceProto
          .internal_static_google_cloud_batch_v1alpha_ResourceAllowance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.ResourceAllowanceProto
          .internal_static_google_cloud_batch_v1alpha_ResourceAllowance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.ResourceAllowance.class,
              com.google.cloud.batch.v1alpha.ResourceAllowance.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.ResourceAllowance.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getNotificationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (usageResourceAllowanceBuilder_ != null) {
        usageResourceAllowanceBuilder_.clear();
      }
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (notificationsBuilder_ == null) {
        notifications_ = java.util.Collections.emptyList();
      } else {
        notifications_ = null;
        notificationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      resourceAllowanceCase_ = 0;
      resourceAllowance_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.ResourceAllowanceProto
          .internal_static_google_cloud_batch_v1alpha_ResourceAllowance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.ResourceAllowance getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.ResourceAllowance build() {
      com.google.cloud.batch.v1alpha.ResourceAllowance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.ResourceAllowance buildPartial() {
      com.google.cloud.batch.v1alpha.ResourceAllowance result =
          new com.google.cloud.batch.v1alpha.ResourceAllowance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.batch.v1alpha.ResourceAllowance result) {
      if (notificationsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          notifications_ = java.util.Collections.unmodifiableList(notifications_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.notifications_ = notifications_;
      } else {
        result.notifications_ = notificationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.batch.v1alpha.ResourceAllowance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uid_ = uid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.batch.v1alpha.ResourceAllowance result) {
      result.resourceAllowanceCase_ = resourceAllowanceCase_;
      result.resourceAllowance_ = this.resourceAllowance_;
      if (resourceAllowanceCase_ == 4 && usageResourceAllowanceBuilder_ != null) {
        result.resourceAllowance_ = usageResourceAllowanceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.ResourceAllowance) {
        return mergeFrom((com.google.cloud.batch.v1alpha.ResourceAllowance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.ResourceAllowance other) {
      if (other == com.google.cloud.batch.v1alpha.ResourceAllowance.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (notificationsBuilder_ == null) {
        if (!other.notifications_.isEmpty()) {
          if (notifications_.isEmpty()) {
            notifications_ = other.notifications_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureNotificationsIsMutable();
            notifications_.addAll(other.notifications_);
          }
          onChanged();
        }
      } else {
        if (!other.notifications_.isEmpty()) {
          if (notificationsBuilder_.isEmpty()) {
            notificationsBuilder_.dispose();
            notificationsBuilder_ = null;
            notifications_ = other.notifications_;
            bitField0_ = (bitField0_ & ~0x00000020);
            notificationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNotificationsFieldBuilder()
                    : null;
          } else {
            notificationsBuilder_.addAllMessages(other.notifications_);
          }
        }
      }
      switch (other.getResourceAllowanceCase()) {
        case USAGE_RESOURCE_ALLOWANCE:
          {
            mergeUsageResourceAllowance(other.getUsageResourceAllowance());
            break;
          }
        case RESOURCEALLOWANCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getUsageResourceAllowanceFieldBuilder().getBuilder(), extensionRegistry);
                resourceAllowanceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.batch.v1alpha.Notification m =
                    input.readMessage(
                        com.google.cloud.batch.v1alpha.Notification.parser(), extensionRegistry);
                if (notificationsBuilder_ == null) {
                  ensureNotificationsIsMutable();
                  notifications_.add(m);
                } else {
                  notificationsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resourceAllowanceCase_ = 0;
    private java.lang.Object resourceAllowance_;

    public ResourceAllowanceCase getResourceAllowanceCase() {
      return ResourceAllowanceCase.forNumber(resourceAllowanceCase_);
    }

    public Builder clearResourceAllowance() {
      resourceAllowanceCase_ = 0;
      resourceAllowance_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.UsageResourceAllowance,
            com.google.cloud.batch.v1alpha.UsageResourceAllowance.Builder,
            com.google.cloud.batch.v1alpha.UsageResourceAllowanceOrBuilder>
        usageResourceAllowanceBuilder_;

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     *
     * @return Whether the usageResourceAllowance field is set.
     */
    @java.lang.Override
    public boolean hasUsageResourceAllowance() {
      return resourceAllowanceCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     *
     * @return The usageResourceAllowance.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.UsageResourceAllowance getUsageResourceAllowance() {
      if (usageResourceAllowanceBuilder_ == null) {
        if (resourceAllowanceCase_ == 4) {
          return (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_;
        }
        return com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance();
      } else {
        if (resourceAllowanceCase_ == 4) {
          return usageResourceAllowanceBuilder_.getMessage();
        }
        return com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    public Builder setUsageResourceAllowance(
        com.google.cloud.batch.v1alpha.UsageResourceAllowance value) {
      if (usageResourceAllowanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceAllowance_ = value;
        onChanged();
      } else {
        usageResourceAllowanceBuilder_.setMessage(value);
      }
      resourceAllowanceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    public Builder setUsageResourceAllowance(
        com.google.cloud.batch.v1alpha.UsageResourceAllowance.Builder builderForValue) {
      if (usageResourceAllowanceBuilder_ == null) {
        resourceAllowance_ = builderForValue.build();
        onChanged();
      } else {
        usageResourceAllowanceBuilder_.setMessage(builderForValue.build());
      }
      resourceAllowanceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    public Builder mergeUsageResourceAllowance(
        com.google.cloud.batch.v1alpha.UsageResourceAllowance value) {
      if (usageResourceAllowanceBuilder_ == null) {
        if (resourceAllowanceCase_ == 4
            && resourceAllowance_
                != com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance()) {
          resourceAllowance_ =
              com.google.cloud.batch.v1alpha.UsageResourceAllowance.newBuilder(
                      (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resourceAllowance_ = value;
        }
        onChanged();
      } else {
        if (resourceAllowanceCase_ == 4) {
          usageResourceAllowanceBuilder_.mergeFrom(value);
        } else {
          usageResourceAllowanceBuilder_.setMessage(value);
        }
      }
      resourceAllowanceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    public Builder clearUsageResourceAllowance() {
      if (usageResourceAllowanceBuilder_ == null) {
        if (resourceAllowanceCase_ == 4) {
          resourceAllowanceCase_ = 0;
          resourceAllowance_ = null;
          onChanged();
        }
      } else {
        if (resourceAllowanceCase_ == 4) {
          resourceAllowanceCase_ = 0;
          resourceAllowance_ = null;
        }
        usageResourceAllowanceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    public com.google.cloud.batch.v1alpha.UsageResourceAllowance.Builder
        getUsageResourceAllowanceBuilder() {
      return getUsageResourceAllowanceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.UsageResourceAllowanceOrBuilder
        getUsageResourceAllowanceOrBuilder() {
      if ((resourceAllowanceCase_ == 4) && (usageResourceAllowanceBuilder_ != null)) {
        return usageResourceAllowanceBuilder_.getMessageOrBuilder();
      } else {
        if (resourceAllowanceCase_ == 4) {
          return (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_;
        }
        return com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The detail of usage resource allowance.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.UsageResourceAllowance usage_resource_allowance = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.UsageResourceAllowance,
            com.google.cloud.batch.v1alpha.UsageResourceAllowance.Builder,
            com.google.cloud.batch.v1alpha.UsageResourceAllowanceOrBuilder>
        getUsageResourceAllowanceFieldBuilder() {
      if (usageResourceAllowanceBuilder_ == null) {
        if (!(resourceAllowanceCase_ == 4)) {
          resourceAllowance_ =
              com.google.cloud.batch.v1alpha.UsageResourceAllowance.getDefaultInstance();
        }
        usageResourceAllowanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.UsageResourceAllowance,
                com.google.cloud.batch.v1alpha.UsageResourceAllowance.Builder,
                com.google.cloud.batch.v1alpha.UsageResourceAllowanceOrBuilder>(
                (com.google.cloud.batch.v1alpha.UsageResourceAllowance) resourceAllowance_,
                getParentForChildren(),
                isClean());
        resourceAllowance_ = null;
      }
      resourceAllowanceCase_ = 4;
      onChanged();
      return usageResourceAllowanceBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. ResourceAllowance name.
     * For example:
     * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. ResourceAllowance name.
     * For example:
     * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. ResourceAllowance name.
     * For example:
     * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. ResourceAllowance name.
     * For example:
     * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. ResourceAllowance name.
     * For example:
     * "projects/123456/locations/us-central1/resourceAllowances/resource-allowance-1".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID (in UUID4 format) for the
     * ResourceAllowance.
     * </pre>
     *
     * <code>
     * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID (in UUID4 format) for the
     * ResourceAllowance.
     * </pre>
     *
     * <code>
     * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID (in UUID4 format) for the
     * ResourceAllowance.
     * </pre>
     *
     * <code>
     * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID (in UUID4 format) for the
     * ResourceAllowance.
     * </pre>
     *
     * <code>
     * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system generated unique ID (in UUID4 format) for the
     * ResourceAllowance.
     * </pre>
     *
     * <code>
     * string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = { ... }
     * </code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the ResourceAllowance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Batch. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.util.List<com.google.cloud.batch.v1alpha.Notification> notifications_ =
        java.util.Collections.emptyList();

    private void ensureNotificationsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        notifications_ =
            new java.util.ArrayList<com.google.cloud.batch.v1alpha.Notification>(notifications_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Notification,
            com.google.cloud.batch.v1alpha.Notification.Builder,
            com.google.cloud.batch.v1alpha.NotificationOrBuilder>
        notificationsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.batch.v1alpha.Notification> getNotificationsList() {
      if (notificationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(notifications_);
      } else {
        return notificationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getNotificationsCount() {
      if (notificationsBuilder_ == null) {
        return notifications_.size();
      } else {
        return notificationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.Notification getNotifications(int index) {
      if (notificationsBuilder_ == null) {
        return notifications_.get(index);
      } else {
        return notificationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNotifications(int index, com.google.cloud.batch.v1alpha.Notification value) {
      if (notificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationsIsMutable();
        notifications_.set(index, value);
        onChanged();
      } else {
        notificationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNotifications(
        int index, com.google.cloud.batch.v1alpha.Notification.Builder builderForValue) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.set(index, builderForValue.build());
        onChanged();
      } else {
        notificationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNotifications(com.google.cloud.batch.v1alpha.Notification value) {
      if (notificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationsIsMutable();
        notifications_.add(value);
        onChanged();
      } else {
        notificationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNotifications(int index, com.google.cloud.batch.v1alpha.Notification value) {
      if (notificationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNotificationsIsMutable();
        notifications_.add(index, value);
        onChanged();
      } else {
        notificationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNotifications(
        com.google.cloud.batch.v1alpha.Notification.Builder builderForValue) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.add(builderForValue.build());
        onChanged();
      } else {
        notificationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNotifications(
        int index, com.google.cloud.batch.v1alpha.Notification.Builder builderForValue) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.add(index, builderForValue.build());
        onChanged();
      } else {
        notificationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllNotifications(
        java.lang.Iterable<? extends com.google.cloud.batch.v1alpha.Notification> values) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, notifications_);
        onChanged();
      } else {
        notificationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNotifications() {
      if (notificationsBuilder_ == null) {
        notifications_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        notificationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeNotifications(int index) {
      if (notificationsBuilder_ == null) {
        ensureNotificationsIsMutable();
        notifications_.remove(index);
        onChanged();
      } else {
        notificationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.Notification.Builder getNotificationsBuilder(int index) {
      return getNotificationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.NotificationOrBuilder getNotificationsOrBuilder(
        int index) {
      if (notificationsBuilder_ == null) {
        return notifications_.get(index);
      } else {
        return notificationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1alpha.NotificationOrBuilder>
        getNotificationsOrBuilderList() {
      if (notificationsBuilder_ != null) {
        return notificationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(notifications_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.Notification.Builder addNotificationsBuilder() {
      return getNotificationsFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1alpha.Notification.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.batch.v1alpha.Notification.Builder addNotificationsBuilder(int index) {
      return getNotificationsFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1alpha.Notification.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Notification configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.Notification notifications = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.batch.v1alpha.Notification.Builder>
        getNotificationsBuilderList() {
      return getNotificationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Notification,
            com.google.cloud.batch.v1alpha.Notification.Builder,
            com.google.cloud.batch.v1alpha.NotificationOrBuilder>
        getNotificationsFieldBuilder() {
      if (notificationsBuilder_ == null) {
        notificationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1alpha.Notification,
                com.google.cloud.batch.v1alpha.Notification.Builder,
                com.google.cloud.batch.v1alpha.NotificationOrBuilder>(
                notifications_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        notifications_ = null;
      }
      return notificationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.ResourceAllowance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.ResourceAllowance)
  private static final com.google.cloud.batch.v1alpha.ResourceAllowance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.ResourceAllowance();
  }

  public static com.google.cloud.batch.v1alpha.ResourceAllowance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceAllowance> PARSER =
      new com.google.protobuf.AbstractParser<ResourceAllowance>() {
        @java.lang.Override
        public ResourceAllowance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResourceAllowance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceAllowance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ResourceAllowance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
