/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.beyondcorp.clientgateways.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClientGatewayName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLIENT_GATEWAY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clientGateways/{client_gateway}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String clientGateway;

    @Deprecated
    protected ClientGatewayName() {
        this.project = null;
        this.location = null;
        this.clientGateway = null;
    }

    private ClientGatewayName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.clientGateway = (String)Preconditions.checkNotNull((Object)builder.getClientGateway());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getClientGateway() {
        return this.clientGateway;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ClientGatewayName of(String project, String location, String clientGateway) {
        return ClientGatewayName.newBuilder().setProject(project).setLocation(location).setClientGateway(clientGateway).build();
    }

    public static String format(String project, String location, String clientGateway) {
        return ClientGatewayName.newBuilder().setProject(project).setLocation(location).setClientGateway(clientGateway).build().toString();
    }

    public static ClientGatewayName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLIENT_GATEWAY.validatedMatch(formattedString, "ClientGatewayName.parse: formattedString not in valid format");
        return ClientGatewayName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("client_gateway"));
    }

    public static List<ClientGatewayName> parseList(List<String> formattedStrings) {
        ArrayList<ClientGatewayName> list = new ArrayList<ClientGatewayName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClientGatewayName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClientGatewayName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClientGatewayName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLIENT_GATEWAY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClientGatewayName clientGatewayName = this;
            synchronized (clientGatewayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.clientGateway != null) {
                        fieldMapBuilder.put((Object)"client_gateway", (Object)this.clientGateway);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLIENT_GATEWAY.instantiate(new String[]{"project", this.project, "location", this.location, "client_gateway", this.clientGateway});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ClientGatewayName that = (ClientGatewayName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.clientGateway, that.clientGateway);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.clientGateway);
    }

    public static class Builder {
        private String project;
        private String location;
        private String clientGateway;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getClientGateway() {
            return this.clientGateway;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setClientGateway(String clientGateway) {
            this.clientGateway = clientGateway;
            return this;
        }

        private Builder(ClientGatewayName clientGatewayName) {
            this.project = clientGatewayName.project;
            this.location = clientGatewayName.location;
            this.clientGateway = clientGatewayName.clientGateway;
        }

        public ClientGatewayName build() {
            return new ClientGatewayName(this);
        }
    }
}

