/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_DATABASE_TABLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/databases/{database}/tables/{table}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String database;
    private final String table;

    @Deprecated
    protected TableName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.database = null;
        this.table = null;
    }

    private TableName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TableName of(String project, String location, String catalog, String database, String table) {
        return TableName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setDatabase(database).setTable(table).build();
    }

    public static String format(String project, String location, String catalog, String database, String table) {
        return TableName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setDatabase(database).setTable(table).build().toString();
    }

    public static TableName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_DATABASE_TABLE.validatedMatch(formattedString, "TableName.parse: formattedString not in valid format");
        return TableName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("database"), (String)matchMap.get("table"));
    }

    public static List<TableName> parseList(List<String> formattedStrings) {
        ArrayList<TableName> list = new ArrayList<TableName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TableName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TableName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TableName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_DATABASE_TABLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TableName tableName = this;
            synchronized (tableName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.table != null) {
                        fieldMapBuilder.put((Object)"table", (Object)this.table);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_DATABASE_TABLE.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "database", this.database, "table", this.table});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TableName that = (TableName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        return h ^= Objects.hashCode(this.table);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String database;
        private String table;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        private Builder(TableName tableName) {
            this.project = tableName.project;
            this.location = tableName.location;
            this.catalog = tableName.catalog;
            this.database = tableName.database;
            this.table = tableName.table;
        }

        public TableName build() {
            return new TableName(this);
        }
    }
}

