/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTRY_GROUP_ENTRY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entryGroup;
    private final String entry;

    @Deprecated
    protected EntryName() {
        this.project = null;
        this.location = null;
        this.entryGroup = null;
        this.entry = null;
    }

    private EntryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entryGroup = (String)Preconditions.checkNotNull((Object)builder.getEntryGroup());
        this.entry = (String)Preconditions.checkNotNull((Object)builder.getEntry());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntryGroup() {
        return this.entryGroup;
    }

    public String getEntry() {
        return this.entry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntryName of(String project, String location, String entryGroup, String entry) {
        return EntryName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).setEntry(entry).build();
    }

    public static String format(String project, String location, String entryGroup, String entry) {
        return EntryName.newBuilder().setProject(project).setLocation(location).setEntryGroup(entryGroup).setEntry(entry).build().toString();
    }

    public static EntryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENTRY_GROUP_ENTRY.validatedMatch(formattedString, "EntryName.parse: formattedString not in valid format");
        return EntryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entry_group"), (String)matchMap.get("entry"));
    }

    public static List<EntryName> parseList(List<String> formattedStrings) {
        ArrayList<EntryName> list = new ArrayList<EntryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTRY_GROUP_ENTRY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntryName entryName = this;
            synchronized (entryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entryGroup != null) {
                        fieldMapBuilder.put((Object)"entry_group", (Object)this.entryGroup);
                    }
                    if (this.entry != null) {
                        fieldMapBuilder.put((Object)"entry", (Object)this.entry);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENTRY_GROUP_ENTRY.instantiate(new String[]{"project", this.project, "location", this.location, "entry_group", this.entryGroup, "entry", this.entry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntryName that = (EntryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entryGroup, that.entryGroup) && Objects.equals(this.entry, that.entry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.entryGroup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entry);
    }

    public static class Builder {
        private String project;
        private String location;
        private String entryGroup;
        private String entry;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntryGroup() {
            return this.entryGroup;
        }

        public String getEntry() {
            return this.entry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntryGroup(String entryGroup) {
            this.entryGroup = entryGroup;
            return this;
        }

        public Builder setEntry(String entry) {
            this.entry = entry;
            return this;
        }

        private Builder(EntryName entryName) {
            this.project = entryName.project;
            this.location = entryName.location;
            this.entryGroup = entryName.entryGroup;
            this.entry = entryName.entry;
        }

        public EntryName build() {
            return new EntryName(this);
        }
    }
}

