/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagTemplateFieldName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TAG_TEMPLATE_FIELD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{field}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tagTemplate;
    private final String field;

    @Deprecated
    protected TagTemplateFieldName() {
        this.project = null;
        this.location = null;
        this.tagTemplate = null;
        this.field = null;
    }

    private TagTemplateFieldName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tagTemplate = (String)Preconditions.checkNotNull((Object)builder.getTagTemplate());
        this.field = (String)Preconditions.checkNotNull((Object)builder.getField());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTagTemplate() {
        return this.tagTemplate;
    }

    public String getField() {
        return this.field;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TagTemplateFieldName of(String project, String location, String tagTemplate, String field) {
        return TagTemplateFieldName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).setField(field).build();
    }

    public static String format(String project, String location, String tagTemplate, String field) {
        return TagTemplateFieldName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).setField(field).build().toString();
    }

    public static TagTemplateFieldName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TAG_TEMPLATE_FIELD.validatedMatch(formattedString, "TagTemplateFieldName.parse: formattedString not in valid format");
        return TagTemplateFieldName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tag_template"), (String)matchMap.get("field"));
    }

    public static List<TagTemplateFieldName> parseList(List<String> formattedStrings) {
        ArrayList<TagTemplateFieldName> list = new ArrayList<TagTemplateFieldName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagTemplateFieldName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagTemplateFieldName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagTemplateFieldName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TAG_TEMPLATE_FIELD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagTemplateFieldName tagTemplateFieldName = this;
            synchronized (tagTemplateFieldName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tagTemplate != null) {
                        fieldMapBuilder.put((Object)"tag_template", (Object)this.tagTemplate);
                    }
                    if (this.field != null) {
                        fieldMapBuilder.put((Object)"field", (Object)this.field);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TAG_TEMPLATE_FIELD.instantiate(new String[]{"project", this.project, "location", this.location, "tag_template", this.tagTemplate, "field", this.field});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TagTemplateFieldName that = (TagTemplateFieldName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tagTemplate, that.tagTemplate) && Objects.equals(this.field, that.field);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.tagTemplate);
        h *= 1000003;
        return h ^= Objects.hashCode(this.field);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tagTemplate;
        private String field;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTagTemplate() {
            return this.tagTemplate;
        }

        public String getField() {
            return this.field;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTagTemplate(String tagTemplate) {
            this.tagTemplate = tagTemplate;
            return this;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        private Builder(TagTemplateFieldName tagTemplateFieldName) {
            this.project = tagTemplateFieldName.project;
            this.location = tagTemplateFieldName.location;
            this.tagTemplate = tagTemplateFieldName.tagTemplate;
            this.field = tagTemplateFieldName.field;
        }

        public TagTemplateFieldName build() {
            return new TagTemplateFieldName(this);
        }
    }
}

