/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataform.v1alpha2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowInvocationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_WORKFLOW_INVOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/workflowInvocations/{workflow_invocation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String workflowInvocation;

    @Deprecated
    protected WorkflowInvocationName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.workflowInvocation = null;
    }

    private WorkflowInvocationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.workflowInvocation = (String)Preconditions.checkNotNull((Object)builder.getWorkflowInvocation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getWorkflowInvocation() {
        return this.workflowInvocation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkflowInvocationName of(String project, String location, String repository, String workflowInvocation) {
        return WorkflowInvocationName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setWorkflowInvocation(workflowInvocation).build();
    }

    public static String format(String project, String location, String repository, String workflowInvocation) {
        return WorkflowInvocationName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setWorkflowInvocation(workflowInvocation).build().toString();
    }

    public static WorkflowInvocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_WORKFLOW_INVOCATION.validatedMatch(formattedString, "WorkflowInvocationName.parse: formattedString not in valid format");
        return WorkflowInvocationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("workflow_invocation"));
    }

    public static List<WorkflowInvocationName> parseList(List<String> formattedStrings) {
        ArrayList<WorkflowInvocationName> list = new ArrayList<WorkflowInvocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkflowInvocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkflowInvocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkflowInvocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_WORKFLOW_INVOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkflowInvocationName workflowInvocationName = this;
            synchronized (workflowInvocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.workflowInvocation != null) {
                        fieldMapBuilder.put((Object)"workflow_invocation", (Object)this.workflowInvocation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_WORKFLOW_INVOCATION.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "workflow_invocation", this.workflowInvocation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkflowInvocationName that = (WorkflowInvocationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.workflowInvocation, that.workflowInvocation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workflowInvocation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String workflowInvocation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getWorkflowInvocation() {
            return this.workflowInvocation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setWorkflowInvocation(String workflowInvocation) {
            this.workflowInvocation = workflowInvocation;
            return this;
        }

        private Builder(WorkflowInvocationName workflowInvocationName) {
            this.project = workflowInvocationName.project;
            this.location = workflowInvocationName.location;
            this.repository = workflowInvocationName.repository;
            this.workflowInvocation = workflowInvocationName.workflowInvocation;
        }

        public WorkflowInvocationName build() {
            return new WorkflowInvocationName(this);
        }
    }
}

