/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataAttributeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATATAXONOMY_DATA_ATTRIBUTE_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataTaxonomy;
    private final String dataAttributeId;

    @Deprecated
    protected DataAttributeName() {
        this.project = null;
        this.location = null;
        this.dataTaxonomy = null;
        this.dataAttributeId = null;
    }

    private DataAttributeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataTaxonomy = (String)Preconditions.checkNotNull((Object)builder.getDataTaxonomy());
        this.dataAttributeId = (String)Preconditions.checkNotNull((Object)builder.getDataAttributeId());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataTaxonomy() {
        return this.dataTaxonomy;
    }

    public String getDataAttributeId() {
        return this.dataAttributeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataAttributeName of(String project, String location, String dataTaxonomy, String dataAttributeId) {
        return DataAttributeName.newBuilder().setProject(project).setLocation(location).setDataTaxonomy(dataTaxonomy).setDataAttributeId(dataAttributeId).build();
    }

    public static String format(String project, String location, String dataTaxonomy, String dataAttributeId) {
        return DataAttributeName.newBuilder().setProject(project).setLocation(location).setDataTaxonomy(dataTaxonomy).setDataAttributeId(dataAttributeId).build().toString();
    }

    public static DataAttributeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATATAXONOMY_DATA_ATTRIBUTE_ID.validatedMatch(formattedString, "DataAttributeName.parse: formattedString not in valid format");
        return DataAttributeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataTaxonomy"), (String)matchMap.get("data_attribute_id"));
    }

    public static List<DataAttributeName> parseList(List<String> formattedStrings) {
        ArrayList<DataAttributeName> list = new ArrayList<DataAttributeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataAttributeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataAttributeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataAttributeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATATAXONOMY_DATA_ATTRIBUTE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataAttributeName dataAttributeName = this;
            synchronized (dataAttributeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataTaxonomy != null) {
                        fieldMapBuilder.put((Object)"dataTaxonomy", (Object)this.dataTaxonomy);
                    }
                    if (this.dataAttributeId != null) {
                        fieldMapBuilder.put((Object)"data_attribute_id", (Object)this.dataAttributeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATATAXONOMY_DATA_ATTRIBUTE_ID.instantiate(new String[]{"project", this.project, "location", this.location, "dataTaxonomy", this.dataTaxonomy, "data_attribute_id", this.dataAttributeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataAttributeName that = (DataAttributeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataTaxonomy, that.dataTaxonomy) && Objects.equals(this.dataAttributeId, that.dataAttributeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataTaxonomy);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataAttributeId);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataTaxonomy;
        private String dataAttributeId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataTaxonomy() {
            return this.dataTaxonomy;
        }

        public String getDataAttributeId() {
            return this.dataAttributeId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataTaxonomy(String dataTaxonomy) {
            this.dataTaxonomy = dataTaxonomy;
            return this;
        }

        public Builder setDataAttributeId(String dataAttributeId) {
            this.dataAttributeId = dataAttributeId;
            return this;
        }

        private Builder(DataAttributeName dataAttributeName) {
            this.project = dataAttributeName.project;
            this.location = dataAttributeName.location;
            this.dataTaxonomy = dataAttributeName.dataTaxonomy;
            this.dataAttributeId = dataAttributeName.dataAttributeId;
        }

        public DataAttributeName build() {
            return new DataAttributeName(this);
        }
    }
}

