/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/document_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Response message for
 * [DocumentService.BatchGetDocumentsMetadata][google.cloud.discoveryengine.v1alpha.DocumentService.BatchGetDocumentsMetadata]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse}
 */
public final class BatchGetDocumentsMetadataResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse)
    BatchGetDocumentsMetadataResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchGetDocumentsMetadataResponse.newBuilder() to construct.
  private BatchGetDocumentsMetadataResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchGetDocumentsMetadataResponse() {
    documentsMetadata_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchGetDocumentsMetadataResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.class,
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * The state of the
   * [Document][google.cloud.discoveryengine.v1alpha.Document].
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should never be set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1alpha.Document] is indexed.
     * </pre>
     *
     * <code>INDEXED = 1;</code>
     */
    INDEXED(1),
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1alpha.Document] is not
     * indexed because its URI is not in the
     * [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
     * </pre>
     *
     * <code>NOT_IN_TARGET_SITE = 2;</code>
     */
    NOT_IN_TARGET_SITE(2),
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1alpha.Document] is not
     * indexed.
     * </pre>
     *
     * <code>NOT_IN_INDEX = 3;</code>
     */
    NOT_IN_INDEX(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should never be set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1alpha.Document] is indexed.
     * </pre>
     *
     * <code>INDEXED = 1;</code>
     */
    public static final int INDEXED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1alpha.Document] is not
     * indexed because its URI is not in the
     * [TargetSite][google.cloud.discoveryengine.v1alpha.TargetSite].
     * </pre>
     *
     * <code>NOT_IN_TARGET_SITE = 2;</code>
     */
    public static final int NOT_IN_TARGET_SITE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The [Document][google.cloud.discoveryengine.v1alpha.Document] is not
     * indexed.
     * </pre>
     *
     * <code>NOT_IN_INDEX = 3;</code>
     */
    public static final int NOT_IN_INDEX_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return INDEXED;
        case 2:
          return NOT_IN_TARGET_SITE;
        case 3:
          return NOT_IN_INDEX;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State)
  }

  public interface DocumentMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
     * </code>
     *
     * @return Whether the matcherValue field is set.
     */
    boolean hasMatcherValue();
    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
     * </code>
     *
     * @return The matcherValue.
     */
    com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            .MatcherValue
        getMatcherValue();
    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            .MatcherValueOrBuilder
        getMatcherValueOrBuilder();

    /**
     *
     *
     * <pre>
     * The state of the document.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * The state of the document.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State getState();

    /**
     *
     *
     * <pre>
     * The timestamp of the last time the
     * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
     * indexed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
     *
     * @return Whether the lastRefreshedTime field is set.
     */
    boolean hasLastRefreshedTime();
    /**
     *
     *
     * <pre>
     * The timestamp of the last time the
     * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
     * indexed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
     *
     * @return The lastRefreshedTime.
     */
    com.google.protobuf.Timestamp getLastRefreshedTime();
    /**
     *
     *
     * <pre>
     * The timestamp of the last time the
     * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
     * indexed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getLastRefreshedTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The metadata of a
   * [Document][google.cloud.discoveryengine.v1alpha.Document].
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata}
   */
  public static final class DocumentMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata)
      DocumentMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DocumentMetadata.newBuilder() to construct.
    private DocumentMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DocumentMetadata() {
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DocumentMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.class,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.Builder.class);
    }

    public interface MatcherValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * If match by URI, the URI of the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return Whether the uri field is set.
       */
      boolean hasUri();
      /**
       *
       *
       * <pre>
       * If match by URI, the URI of the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();
      /**
       *
       *
       * <pre>
       * If match by URI, the URI of the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();

      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
              .MatcherValue.MatcherValueCase
          getMatcherValueCase();
    }
    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue}
     */
    public static final class MatcherValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue)
        MatcherValueOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MatcherValue.newBuilder() to construct.
      private MatcherValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MatcherValue() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MatcherValue();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.MatcherValue.class,
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.MatcherValue.Builder.class);
      }

      private int matcherValueCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object matcherValue_;

      public enum MatcherValueCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        URI(1),
        MATCHERVALUE_NOT_SET(0);
        private final int value;

        private MatcherValueCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static MatcherValueCase valueOf(int value) {
          return forNumber(value);
        }

        public static MatcherValueCase forNumber(int value) {
          switch (value) {
            case 1:
              return URI;
            case 0:
              return MATCHERVALUE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public MatcherValueCase getMatcherValueCase() {
        return MatcherValueCase.forNumber(matcherValueCase_);
      }

      public static final int URI_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * If match by URI, the URI of the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return Whether the uri field is set.
       */
      public boolean hasUri() {
        return matcherValueCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * If match by URI, the URI of the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = "";
        if (matcherValueCase_ == 1) {
          ref = matcherValue_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (matcherValueCase_ == 1) {
            matcherValue_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * If match by URI, the URI of the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = "";
        if (matcherValueCase_ == 1) {
          ref = matcherValue_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (matcherValueCase_ == 1) {
            matcherValue_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (matcherValueCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, matcherValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (matcherValueCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, matcherValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.MatcherValue)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
                .MatcherValue
            other =
                (com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                        .DocumentMetadata.MatcherValue)
                    obj;

        if (!getMatcherValueCase().equals(other.getMatcherValueCase())) return false;
        switch (matcherValueCase_) {
          case 1:
            if (!getUri().equals(other.getUri())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (matcherValueCase_) {
          case 1:
            hash = (37 * hash) + URI_FIELD_NUMBER;
            hash = (53 * hash) + getUri().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue)
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValue.class,
                  com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValue.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          matcherValueCase_ = 0;
          matcherValue_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
              .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_MatcherValue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.MatcherValue
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.MatcherValue
            build() {
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.MatcherValue
            buildPartial() {
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue
              result =
                  new com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValue(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.MatcherValue
                result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.MatcherValue
                result) {
          result.matcherValueCase_ = matcherValueCase_;
          result.matcherValue_ = this.matcherValue_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                        .DocumentMetadata.MatcherValue)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.MatcherValue
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue.getDefaultInstance()) return this;
          switch (other.getMatcherValueCase()) {
            case URI:
              {
                matcherValueCase_ = 1;
                matcherValue_ = other.matcherValue_;
                onChanged();
                break;
              }
            case MATCHERVALUE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    matcherValueCase_ = 1;
                    matcherValue_ = s;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int matcherValueCase_ = 0;
        private java.lang.Object matcherValue_;

        public MatcherValueCase getMatcherValueCase() {
          return MatcherValueCase.forNumber(matcherValueCase_);
        }

        public Builder clearMatcherValue() {
          matcherValueCase_ = 0;
          matcherValue_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * If match by URI, the URI of the
         * [Document][google.cloud.discoveryengine.v1alpha.Document].
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return Whether the uri field is set.
         */
        @java.lang.Override
        public boolean hasUri() {
          return matcherValueCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * If match by URI, the URI of the
         * [Document][google.cloud.discoveryengine.v1alpha.Document].
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return The uri.
         */
        @java.lang.Override
        public java.lang.String getUri() {
          java.lang.Object ref = "";
          if (matcherValueCase_ == 1) {
            ref = matcherValue_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (matcherValueCase_ == 1) {
              matcherValue_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * If match by URI, the URI of the
         * [Document][google.cloud.discoveryengine.v1alpha.Document].
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return The bytes for uri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = "";
          if (matcherValueCase_ == 1) {
            ref = matcherValue_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (matcherValueCase_ == 1) {
              matcherValue_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * If match by URI, the URI of the
         * [Document][google.cloud.discoveryengine.v1alpha.Document].
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          matcherValueCase_ = 1;
          matcherValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If match by URI, the URI of the
         * [Document][google.cloud.discoveryengine.v1alpha.Document].
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          if (matcherValueCase_ == 1) {
            matcherValueCase_ = 0;
            matcherValue_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * If match by URI, the URI of the
         * [Document][google.cloud.discoveryengine.v1alpha.Document].
         * </pre>
         *
         * <code>string uri = 1;</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          matcherValueCase_ = 1;
          matcherValue_ = value;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue)
      private static final com.google.cloud.discoveryengine.v1alpha
              .BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.MatcherValue();
      }

      public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MatcherValue> PARSER =
          new com.google.protobuf.AbstractParser<MatcherValue>() {
            @java.lang.Override
            public MatcherValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MatcherValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MatcherValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int MATCHER_VALUE_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.MatcherValue
        matcherValue_;
    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
     * </code>
     *
     * @return Whether the matcherValue field is set.
     */
    @java.lang.Override
    public boolean hasMatcherValue() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
     * </code>
     *
     * @return The matcherValue.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.MatcherValue
        getMatcherValue() {
      return matcherValue_ == null
          ? com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue.getDefaultInstance()
          : matcherValue_;
    }
    /**
     *
     *
     * <pre>
     * The value of the matcher that was used to match the
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.MatcherValueOrBuilder
        getMatcherValueOrBuilder() {
      return matcherValue_ == null
          ? com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue.getDefaultInstance()
          : matcherValue_;
    }

    public static final int STATE_FIELD_NUMBER = 3;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the document.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the document.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
        getState() {
      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State result =
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
              .forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
              .UNRECOGNIZED
          : result;
    }

    public static final int LAST_REFRESHED_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp lastRefreshedTime_;
    /**
     *
     *
     * <pre>
     * The timestamp of the last time the
     * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
     * indexed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
     *
     * @return Whether the lastRefreshedTime field is set.
     */
    @java.lang.Override
    public boolean hasLastRefreshedTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp of the last time the
     * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
     * indexed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
     *
     * @return The lastRefreshedTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastRefreshedTime() {
      return lastRefreshedTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastRefreshedTime_;
    }
    /**
     *
     *
     * <pre>
     * The timestamp of the last time the
     * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
     * indexed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastRefreshedTimeOrBuilder() {
      return lastRefreshedTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastRefreshedTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getMatcherValue());
      }
      if (state_
          != com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, state_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getLastRefreshedTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMatcherValue());
      }
      if (state_
          != com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastRefreshedTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
          other =
              (com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata)
                  obj;

      if (hasMatcherValue() != other.hasMatcherValue()) return false;
      if (hasMatcherValue()) {
        if (!getMatcherValue().equals(other.getMatcherValue())) return false;
      }
      if (state_ != other.state_) return false;
      if (hasLastRefreshedTime() != other.hasLastRefreshedTime()) return false;
      if (hasLastRefreshedTime()) {
        if (!getLastRefreshedTime().equals(other.getLastRefreshedTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMatcherValue()) {
        hash = (37 * hash) + MATCHER_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getMatcherValue().hashCode();
      }
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (hasLastRefreshedTime()) {
        hash = (37 * hash) + LAST_REFRESHED_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastRefreshedTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The metadata of a
     * [Document][google.cloud.discoveryengine.v1alpha.Document].
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata)
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.class,
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMatcherValueFieldBuilder();
          getLastRefreshedTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        matcherValue_ = null;
        if (matcherValueBuilder_ != null) {
          matcherValueBuilder_.dispose();
          matcherValueBuilder_ = null;
        }
        state_ = 0;
        lastRefreshedTime_ = null;
        if (lastRefreshedTimeBuilder_ != null) {
          lastRefreshedTimeBuilder_.dispose();
          lastRefreshedTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
            .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_DocumentMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata
          build() {
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata
          buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            result =
                new com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.matcherValue_ =
              matcherValueBuilder_ == null ? matcherValue_ : matcherValueBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.lastRefreshedTime_ =
              lastRefreshedTimeBuilder_ == null
                  ? lastRefreshedTime_
                  : lastRefreshedTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.getDefaultInstance()) return this;
        if (other.hasMatcherValue()) {
          mergeMatcherValue(other.getMatcherValue());
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.hasLastRefreshedTime()) {
          mergeLastRefreshedTime(other.getLastRefreshedTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(getMatcherValueFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 24:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(
                      getLastRefreshedTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          matcherValue_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue.Builder,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValueOrBuilder>
          matcherValueBuilder_;
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       *
       * @return Whether the matcherValue field is set.
       */
      public boolean hasMatcherValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       *
       * @return The matcherValue.
       */
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue
          getMatcherValue() {
        if (matcherValueBuilder_ == null) {
          return matcherValue_ == null
              ? com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue.getDefaultInstance()
              : matcherValue_;
        } else {
          return matcherValueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      public Builder setMatcherValue(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue
              value) {
        if (matcherValueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          matcherValue_ = value;
        } else {
          matcherValueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      public Builder setMatcherValue(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue.Builder
              builderForValue) {
        if (matcherValueBuilder_ == null) {
          matcherValue_ = builderForValue.build();
        } else {
          matcherValueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      public Builder mergeMatcherValue(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue
              value) {
        if (matcherValueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && matcherValue_ != null
              && matcherValue_
                  != com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValue.getDefaultInstance()) {
            getMatcherValueBuilder().mergeFrom(value);
          } else {
            matcherValue_ = value;
          }
        } else {
          matcherValueBuilder_.mergeFrom(value);
        }
        if (matcherValue_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      public Builder clearMatcherValue() {
        bitField0_ = (bitField0_ & ~0x00000001);
        matcherValue_ = null;
        if (matcherValueBuilder_ != null) {
          matcherValueBuilder_.dispose();
          matcherValueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValue.Builder
          getMatcherValueBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMatcherValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata.MatcherValueOrBuilder
          getMatcherValueOrBuilder() {
        if (matcherValueBuilder_ != null) {
          return matcherValueBuilder_.getMessageOrBuilder();
        } else {
          return matcherValue_ == null
              ? com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue.getDefaultInstance()
              : matcherValue_;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the matcher that was used to match the
       * [Document][google.cloud.discoveryengine.v1alpha.Document].
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata.MatcherValue matcher_value = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValue.Builder,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.MatcherValueOrBuilder>
          getMatcherValueFieldBuilder() {
        if (matcherValueBuilder_ == null) {
          matcherValueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValue,
                  com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValue.Builder,
                  com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                      .DocumentMetadata.MatcherValueOrBuilder>(
                  getMatcherValue(), getParentForChildren(), isClean());
          matcherValue_ = null;
        }
        return matcherValueBuilder_;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * The state of the document.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * The state of the document.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The state of the document.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
          getState() {
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State result =
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
                .forNumber(state_);
        return result == null
            ? com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The state of the document.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The state of the document.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.State state = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp lastRefreshedTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastRefreshedTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       *
       * @return Whether the lastRefreshedTime field is set.
       */
      public boolean hasLastRefreshedTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       *
       * @return The lastRefreshedTime.
       */
      public com.google.protobuf.Timestamp getLastRefreshedTime() {
        if (lastRefreshedTimeBuilder_ == null) {
          return lastRefreshedTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastRefreshedTime_;
        } else {
          return lastRefreshedTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      public Builder setLastRefreshedTime(com.google.protobuf.Timestamp value) {
        if (lastRefreshedTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastRefreshedTime_ = value;
        } else {
          lastRefreshedTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      public Builder setLastRefreshedTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastRefreshedTimeBuilder_ == null) {
          lastRefreshedTime_ = builderForValue.build();
        } else {
          lastRefreshedTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      public Builder mergeLastRefreshedTime(com.google.protobuf.Timestamp value) {
        if (lastRefreshedTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && lastRefreshedTime_ != null
              && lastRefreshedTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getLastRefreshedTimeBuilder().mergeFrom(value);
          } else {
            lastRefreshedTime_ = value;
          }
        } else {
          lastRefreshedTimeBuilder_.mergeFrom(value);
        }
        if (lastRefreshedTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      public Builder clearLastRefreshedTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        lastRefreshedTime_ = null;
        if (lastRefreshedTimeBuilder_ != null) {
          lastRefreshedTimeBuilder_.dispose();
          lastRefreshedTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getLastRefreshedTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLastRefreshedTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastRefreshedTimeOrBuilder() {
        if (lastRefreshedTimeBuilder_ != null) {
          return lastRefreshedTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastRefreshedTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastRefreshedTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The timestamp of the last time the
       * [Document][google.cloud.discoveryengine.v1alpha.Document] was last
       * indexed.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_refreshed_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastRefreshedTimeFieldBuilder() {
        if (lastRefreshedTimeBuilder_ == null) {
          lastRefreshedTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastRefreshedTime(), getParentForChildren(), isClean());
          lastRefreshedTime_ = null;
        }
        return lastRefreshedTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata)
    private static final com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata();
    }

    public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DocumentMetadata> PARSER =
        new com.google.protobuf.AbstractParser<DocumentMetadata>() {
          @java.lang.Override
          public DocumentMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DocumentMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DocumentMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DOCUMENTS_METADATA_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata>
      documentsMetadata_;
  /**
   *
   *
   * <pre>
   * The metadata of the
   * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .DocumentMetadata>
      getDocumentsMetadataList() {
    return documentsMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata of the
   * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadataOrBuilder>
      getDocumentsMetadataOrBuilderList() {
    return documentsMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata of the
   * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
   * </code>
   */
  @java.lang.Override
  public int getDocumentsMetadataCount() {
    return documentsMetadata_.size();
  }
  /**
   *
   *
   * <pre>
   * The metadata of the
   * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
      getDocumentsMetadata(int index) {
    return documentsMetadata_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The metadata of the
   * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
          .DocumentMetadataOrBuilder
      getDocumentsMetadataOrBuilder(int index) {
    return documentsMetadata_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < documentsMetadata_.size(); i++) {
      output.writeMessage(1, documentsMetadata_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < documentsMetadata_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, documentsMetadata_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse other =
        (com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse) obj;

    if (!getDocumentsMetadataList().equals(other.getDocumentsMetadataList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDocumentsMetadataCount() > 0) {
      hash = (37 * hash) + DOCUMENTS_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentsMetadataList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [DocumentService.BatchGetDocumentsMetadata][google.cloud.discoveryengine.v1alpha.DocumentService.BatchGetDocumentsMetadata]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse)
      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.class,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (documentsMetadataBuilder_ == null) {
        documentsMetadata_ = java.util.Collections.emptyList();
      } else {
        documentsMetadata_ = null;
        documentsMetadataBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_BatchGetDocumentsMetadataResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse build() {
      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
        buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse result =
          new com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse result) {
      if (documentsMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          documentsMetadata_ = java.util.Collections.unmodifiableList(documentsMetadata_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.documentsMetadata_ = documentsMetadata_;
      } else {
        result.documentsMetadata_ = documentsMetadataBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
              .getDefaultInstance()) return this;
      if (documentsMetadataBuilder_ == null) {
        if (!other.documentsMetadata_.isEmpty()) {
          if (documentsMetadata_.isEmpty()) {
            documentsMetadata_ = other.documentsMetadata_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDocumentsMetadataIsMutable();
            documentsMetadata_.addAll(other.documentsMetadata_);
          }
          onChanged();
        }
      } else {
        if (!other.documentsMetadata_.isEmpty()) {
          if (documentsMetadataBuilder_.isEmpty()) {
            documentsMetadataBuilder_.dispose();
            documentsMetadataBuilder_ = null;
            documentsMetadata_ = other.documentsMetadata_;
            bitField0_ = (bitField0_ & ~0x00000001);
            documentsMetadataBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDocumentsMetadataFieldBuilder()
                    : null;
          } else {
            documentsMetadataBuilder_.addAllMessages(other.documentsMetadata_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                        .DocumentMetadata
                    m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1alpha
                                .BatchGetDocumentsMetadataResponse.DocumentMetadata.parser(),
                            extensionRegistry);
                if (documentsMetadataBuilder_ == null) {
                  ensureDocumentsMetadataIsMutable();
                  documentsMetadata_.add(m);
                } else {
                  documentsMetadataBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata>
        documentsMetadata_ = java.util.Collections.emptyList();

    private void ensureDocumentsMetadataIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        documentsMetadata_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata>(documentsMetadata_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata,
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.Builder,
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadataOrBuilder>
        documentsMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata>
        getDocumentsMetadataList() {
      if (documentsMetadataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(documentsMetadata_);
      } else {
        return documentsMetadataBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public int getDocumentsMetadataCount() {
      if (documentsMetadataBuilder_ == null) {
        return documentsMetadata_.size();
      } else {
        return documentsMetadataBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata
        getDocumentsMetadata(int index) {
      if (documentsMetadataBuilder_ == null) {
        return documentsMetadata_.get(index);
      } else {
        return documentsMetadataBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder setDocumentsMetadata(
        int index,
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            value) {
      if (documentsMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.set(index, value);
        onChanged();
      } else {
        documentsMetadataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder setDocumentsMetadata(
        int index,
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
                .Builder
            builderForValue) {
      if (documentsMetadataBuilder_ == null) {
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.set(index, builderForValue.build());
        onChanged();
      } else {
        documentsMetadataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder addDocumentsMetadata(
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            value) {
      if (documentsMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.add(value);
        onChanged();
      } else {
        documentsMetadataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder addDocumentsMetadata(
        int index,
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
            value) {
      if (documentsMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.add(index, value);
        onChanged();
      } else {
        documentsMetadataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder addDocumentsMetadata(
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
                .Builder
            builderForValue) {
      if (documentsMetadataBuilder_ == null) {
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.add(builderForValue.build());
        onChanged();
      } else {
        documentsMetadataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder addDocumentsMetadata(
        int index,
        com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata
                .Builder
            builderForValue) {
      if (documentsMetadataBuilder_ == null) {
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.add(index, builderForValue.build());
        onChanged();
      } else {
        documentsMetadataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder addAllDocumentsMetadata(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                        .DocumentMetadata>
            values) {
      if (documentsMetadataBuilder_ == null) {
        ensureDocumentsMetadataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documentsMetadata_);
        onChanged();
      } else {
        documentsMetadataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder clearDocumentsMetadata() {
      if (documentsMetadataBuilder_ == null) {
        documentsMetadata_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        documentsMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public Builder removeDocumentsMetadata(int index) {
      if (documentsMetadataBuilder_ == null) {
        ensureDocumentsMetadataIsMutable();
        documentsMetadata_.remove(index);
        onChanged();
      } else {
        documentsMetadataBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.Builder
        getDocumentsMetadataBuilder(int index) {
      return getDocumentsMetadataFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadataOrBuilder
        getDocumentsMetadataOrBuilder(int index) {
      if (documentsMetadataBuilder_ == null) {
        return documentsMetadata_.get(index);
      } else {
        return documentsMetadataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadataOrBuilder>
        getDocumentsMetadataOrBuilderList() {
      if (documentsMetadataBuilder_ != null) {
        return documentsMetadataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(documentsMetadata_);
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.Builder
        addDocumentsMetadataBuilder() {
      return getDocumentsMetadataFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
            .DocumentMetadata.Builder
        addDocumentsMetadataBuilder(int index) {
      return getDocumentsMetadataFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                  .DocumentMetadata.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The metadata of the
     * [Document][google.cloud.discoveryengine.v1alpha.Document]s.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse.DocumentMetadata documents_metadata = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.Builder>
        getDocumentsMetadataBuilderList() {
      return getDocumentsMetadataFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata,
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadata.Builder,
            com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                .DocumentMetadataOrBuilder>
        getDocumentsMetadataFieldBuilder() {
      if (documentsMetadataBuilder_ == null) {
        documentsMetadataBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata,
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadata.Builder,
                com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
                    .DocumentMetadataOrBuilder>(
                documentsMetadata_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        documentsMetadata_ = null;
      }
      return documentsMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse)
  private static final com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse();
  }

  public static com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchGetDocumentsMetadataResponse> PARSER =
      new com.google.protobuf.AbstractParser<BatchGetDocumentsMetadataResponse>() {
        @java.lang.Override
        public BatchGetDocumentsMetadataResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchGetDocumentsMetadataResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchGetDocumentsMetadataResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BatchGetDocumentsMetadataResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
