/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/project_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request for ReportConsentChange method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest}
 */
public final class ReportConsentChangeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest)
    ReportConsentChangeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReportConsentChangeRequest.newBuilder() to construct.
  private ReportConsentChangeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReportConsentChangeRequest() {
    consentChangeAction_ = 0;
    project_ = "";
    serviceTermId_ = "";
    serviceTermVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReportConsentChangeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.ProjectServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_ReportConsentChangeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.ProjectServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_ReportConsentChangeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.class,
            com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of consent acknowledgement (accept / reject).
   *
   * At this moment, only `ACCEPT` action is supported.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction}
   */
  public enum ConsentChangeAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Invalid action, user must specify accept/decline
     * </pre>
     *
     * <code>CONSENT_CHANGE_ACTION_UNSPECIFIED = 0;</code>
     */
    CONSENT_CHANGE_ACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * User accepts service terms.
     * </pre>
     *
     * <code>ACCEPT = 1;</code>
     */
    ACCEPT(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Invalid action, user must specify accept/decline
     * </pre>
     *
     * <code>CONSENT_CHANGE_ACTION_UNSPECIFIED = 0;</code>
     */
    public static final int CONSENT_CHANGE_ACTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * User accepts service terms.
     * </pre>
     *
     * <code>ACCEPT = 1;</code>
     */
    public static final int ACCEPT_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsentChangeAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConsentChangeAction forNumber(int value) {
      switch (value) {
        case 0:
          return CONSENT_CHANGE_ACTION_UNSPECIFIED;
        case 1:
          return ACCEPT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConsentChangeAction>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConsentChangeAction>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConsentChangeAction>() {
              public ConsentChangeAction findValueByNumber(int number) {
                return ConsentChangeAction.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ConsentChangeAction[] VALUES = values();

    public static ConsentChangeAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConsentChangeAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction)
  }

  public static final int CONSENT_CHANGE_ACTION_FIELD_NUMBER = 1;
  private int consentChangeAction_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Whether customer decides to accept or decline service term.
   *
   * At this moment, only accept action is supported.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for consentChangeAction.
   */
  @java.lang.Override
  public int getConsentChangeActionValue() {
    return consentChangeAction_;
  }
  /**
   *
   *
   * <pre>
   * Required. Whether customer decides to accept or decline service term.
   *
   * At this moment, only accept action is supported.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The consentChangeAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
      getConsentChangeAction() {
    com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction result =
        com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
            .forNumber(consentChangeAction_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
            .UNRECOGNIZED
        : result;
  }

  public static final int PROJECT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of a
   * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
   * `projects/{project_id_or_number}`.
   * </pre>
   *
   * <code>
   * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of a
   * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
   * `projects/{project_id_or_number}`.
   * </pre>
   *
   * <code>
   * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_TERM_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceTermId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the terms of service to update.
   * Available term ids:
   *
   * * `GA_DATA_USE_TERMS`: [Terms for data
   * use](https://cloud.google.com/retail/data-use-terms). When using this
   * service term id, the acceptable
   * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
   * to provide is `2022-11-23`.
   * </pre>
   *
   * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The serviceTermId.
   */
  @java.lang.Override
  public java.lang.String getServiceTermId() {
    java.lang.Object ref = serviceTermId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceTermId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the terms of service to update.
   * Available term ids:
   *
   * * `GA_DATA_USE_TERMS`: [Terms for data
   * use](https://cloud.google.com/retail/data-use-terms). When using this
   * service term id, the acceptable
   * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
   * to provide is `2022-11-23`.
   * </pre>
   *
   * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for serviceTermId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceTermIdBytes() {
    java.lang.Object ref = serviceTermId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceTermId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_TERM_VERSION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceTermVersion_ = "";
  /**
   *
   *
   * <pre>
   * Required. The version string of the terms of service to update.
   * </pre>
   *
   * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The serviceTermVersion.
   */
  @java.lang.Override
  public java.lang.String getServiceTermVersion() {
    java.lang.Object ref = serviceTermVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceTermVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The version string of the terms of service to update.
   * </pre>
   *
   * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for serviceTermVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceTermVersionBytes() {
    java.lang.Object ref = serviceTermVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceTermVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (consentChangeAction_
        != com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
            .CONSENT_CHANGE_ACTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, consentChangeAction_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceTermId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serviceTermId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceTermVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, serviceTermVersion_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (consentChangeAction_
        != com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
            .CONSENT_CHANGE_ACTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, consentChangeAction_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceTermId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serviceTermId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceTermVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, serviceTermVersion_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest other =
        (com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest) obj;

    if (consentChangeAction_ != other.consentChangeAction_) return false;
    if (!getProject().equals(other.getProject())) return false;
    if (!getServiceTermId().equals(other.getServiceTermId())) return false;
    if (!getServiceTermVersion().equals(other.getServiceTermVersion())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONSENT_CHANGE_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + consentChangeAction_;
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    hash = (37 * hash) + SERVICE_TERM_ID_FIELD_NUMBER;
    hash = (53 * hash) + getServiceTermId().hashCode();
    hash = (37 * hash) + SERVICE_TERM_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getServiceTermVersion().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for ReportConsentChange method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest)
      com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ProjectServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ReportConsentChangeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.ProjectServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ReportConsentChangeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.class,
              com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      consentChangeAction_ = 0;
      project_ = "";
      serviceTermId_ = "";
      serviceTermVersion_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.ProjectServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ReportConsentChangeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest build() {
      com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest result =
          new com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.consentChangeAction_ = consentChangeAction_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.serviceTermId_ = serviceTermId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceTermVersion_ = serviceTermVersion_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
              .getDefaultInstance()) return this;
      if (other.consentChangeAction_ != 0) {
        setConsentChangeActionValue(other.getConsentChangeActionValue());
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getServiceTermId().isEmpty()) {
        serviceTermId_ = other.serviceTermId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getServiceTermVersion().isEmpty()) {
        serviceTermVersion_ = other.serviceTermVersion_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                consentChangeAction_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                serviceTermId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                serviceTermVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int consentChangeAction_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Whether customer decides to accept or decline service term.
     *
     * At this moment, only accept action is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for consentChangeAction.
     */
    @java.lang.Override
    public int getConsentChangeActionValue() {
      return consentChangeAction_;
    }
    /**
     *
     *
     * <pre>
     * Required. Whether customer decides to accept or decline service term.
     *
     * At this moment, only accept action is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for consentChangeAction to set.
     * @return This builder for chaining.
     */
    public Builder setConsentChangeActionValue(int value) {
      consentChangeAction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Whether customer decides to accept or decline service term.
     *
     * At this moment, only accept action is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The consentChangeAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
        getConsentChangeAction() {
      com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
          result =
              com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
                  .ConsentChangeAction.forNumber(consentChangeAction_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Whether customer decides to accept or decline service term.
     *
     * At this moment, only accept action is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The consentChangeAction to set.
     * @return This builder for chaining.
     */
    public Builder setConsentChangeAction(
        com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      consentChangeAction_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Whether customer decides to accept or decline service term.
     *
     * At this moment, only accept action is supported.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.ConsentChangeAction consent_change_action = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConsentChangeAction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      consentChangeAction_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
     * `projects/{project_id_or_number}`.
     * </pre>
     *
     * <code>
     * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
     * `projects/{project_id_or_number}`.
     * </pre>
     *
     * <code>
     * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
     * `projects/{project_id_or_number}`.
     * </pre>
     *
     * <code>
     * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
     * `projects/{project_id_or_number}`.
     * </pre>
     *
     * <code>
     * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of a
     * [Project][google.cloud.discoveryengine.v1alpha.Project], such as
     * `projects/{project_id_or_number}`.
     * </pre>
     *
     * <code>
     * string project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object serviceTermId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the terms of service to update.
     * Available term ids:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this
     * service term id, the acceptable
     * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serviceTermId.
     */
    public java.lang.String getServiceTermId() {
      java.lang.Object ref = serviceTermId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceTermId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the terms of service to update.
     * Available term ids:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this
     * service term id, the acceptable
     * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serviceTermId.
     */
    public com.google.protobuf.ByteString getServiceTermIdBytes() {
      java.lang.Object ref = serviceTermId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceTermId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the terms of service to update.
     * Available term ids:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this
     * service term id, the acceptable
     * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The serviceTermId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceTermId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceTermId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the terms of service to update.
     * Available term ids:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this
     * service term id, the acceptable
     * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceTermId() {
      serviceTermId_ = getDefaultInstance().getServiceTermId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the terms of service to update.
     * Available term ids:
     *
     * * `GA_DATA_USE_TERMS`: [Terms for data
     * use](https://cloud.google.com/retail/data-use-terms). When using this
     * service term id, the acceptable
     * [service_term_version][google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest.service_term_version]
     * to provide is `2022-11-23`.
     * </pre>
     *
     * <code>string service_term_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for serviceTermId to set.
     * @return This builder for chaining.
     */
    public Builder setServiceTermIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceTermId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object serviceTermVersion_ = "";
    /**
     *
     *
     * <pre>
     * Required. The version string of the terms of service to update.
     * </pre>
     *
     * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serviceTermVersion.
     */
    public java.lang.String getServiceTermVersion() {
      java.lang.Object ref = serviceTermVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceTermVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The version string of the terms of service to update.
     * </pre>
     *
     * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serviceTermVersion.
     */
    public com.google.protobuf.ByteString getServiceTermVersionBytes() {
      java.lang.Object ref = serviceTermVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceTermVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The version string of the terms of service to update.
     * </pre>
     *
     * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The serviceTermVersion to set.
     * @return This builder for chaining.
     */
    public Builder setServiceTermVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceTermVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The version string of the terms of service to update.
     * </pre>
     *
     * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceTermVersion() {
      serviceTermVersion_ = getDefaultInstance().getServiceTermVersion();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The version string of the terms of service to update.
     * </pre>
     *
     * <code>string service_term_version = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for serviceTermVersion to set.
     * @return This builder for chaining.
     */
    public Builder setServiceTermVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceTermVersion_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReportConsentChangeRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReportConsentChangeRequest>() {
        @java.lang.Override
        public ReportConsentChangeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReportConsentChangeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReportConsentChangeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ReportConsentChangeRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
