/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.2
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Firestore.RunAggregationQuery][google.firestore.v1.Firestore.RunAggregationQuery].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.RunAggregationQueryRequest}
 */
public final class RunAggregationQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.RunAggregationQueryRequest)
    RunAggregationQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunAggregationQueryRequest.newBuilder() to construct.
  private RunAggregationQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunAggregationQueryRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunAggregationQueryRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_RunAggregationQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_RunAggregationQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.RunAggregationQueryRequest.class,
            com.google.firestore.v1.RunAggregationQueryRequest.Builder.class);
  }

  private int queryTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCTURED_AGGREGATION_QUERY(2),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return STRUCTURED_AGGREGATION_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  private int consistencySelectorCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object consistencySelector_;

  public enum ConsistencySelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION(4),
    NEW_TRANSACTION(5),
    READ_TIME(6),
    CONSISTENCYSELECTOR_NOT_SET(0);
    private final int value;

    private ConsistencySelectorCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsistencySelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConsistencySelectorCase forNumber(int value) {
      switch (value) {
        case 4:
          return TRANSACTION;
        case 5:
          return NEW_TRANSACTION;
        case 6:
          return READ_TIME;
        case 0:
          return CONSISTENCYSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConsistencySelectorCase getConsistencySelectorCase() {
    return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRUCTURED_AGGREGATION_QUERY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * An aggregation query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;</code>
   *
   * @return Whether the structuredAggregationQuery field is set.
   */
  @java.lang.Override
  public boolean hasStructuredAggregationQuery() {
    return queryTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * An aggregation query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;</code>
   *
   * @return The structuredAggregationQuery.
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredAggregationQuery getStructuredAggregationQuery() {
    if (queryTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredAggregationQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An aggregation query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredAggregationQueryOrBuilder
      getStructuredAggregationQueryOrBuilder() {
    if (queryTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredAggregationQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
  }

  public static final int TRANSACTION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Run the aggregation within an already active transaction.
   *
   * The value here is the opaque transaction ID to execute the query in.
   * </pre>
   *
   * <code>bytes transaction = 4;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return consistencySelectorCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Run the aggregation within an already active transaction.
   *
   * The value here is the opaque transaction ID to execute the query in.
   * </pre>
   *
   * <code>bytes transaction = 4;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (consistencySelectorCase_ == 4) {
      return (com.google.protobuf.ByteString) consistencySelector_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int NEW_TRANSACTION_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Starts a new transaction as part of the query, defaulting to read-only.
   *
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
   *
   * @return Whether the newTransaction field is set.
   */
  @java.lang.Override
  public boolean hasNewTransaction() {
    return consistencySelectorCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Starts a new transaction as part of the query, defaulting to read-only.
   *
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
   *
   * @return The newTransaction.
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions getNewTransaction() {
    if (consistencySelectorCase_ == 5) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Starts a new transaction as part of the query, defaulting to read-only.
   *
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
    if (consistencySelectorCase_ == 5) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }

  public static final int READ_TIME_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Executes the query at the given timestamp.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 6;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return consistencySelectorCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Executes the query at the given timestamp.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 6;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (consistencySelectorCase_ == 6) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Executes the query at the given timestamp.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (consistencySelectorCase_ == 6) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (queryTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.StructuredAggregationQuery) queryType_);
    }
    if (consistencySelectorCase_ == 4) {
      output.writeBytes(4, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 5) {
      output.writeMessage(5, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 6) {
      output.writeMessage(6, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (queryTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.StructuredAggregationQuery) queryType_);
    }
    if (consistencySelectorCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              4, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.RunAggregationQueryRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.RunAggregationQueryRequest other =
        (com.google.firestore.v1.RunAggregationQueryRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 2:
        if (!getStructuredAggregationQuery().equals(other.getStructuredAggregationQuery()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getConsistencySelectorCase().equals(other.getConsistencySelectorCase())) return false;
    switch (consistencySelectorCase_) {
      case 4:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 5:
        if (!getNewTransaction().equals(other.getNewTransaction())) return false;
        break;
      case 6:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (queryTypeCase_) {
      case 2:
        hash = (37 * hash) + STRUCTURED_AGGREGATION_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getStructuredAggregationQuery().hashCode();
        break;
      case 0:
      default:
    }
    switch (consistencySelectorCase_) {
      case 4:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 5:
        hash = (37 * hash) + NEW_TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getNewTransaction().hashCode();
        break;
      case 6:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.RunAggregationQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [Firestore.RunAggregationQuery][google.firestore.v1.Firestore.RunAggregationQuery].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.RunAggregationQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.RunAggregationQueryRequest)
      com.google.firestore.v1.RunAggregationQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunAggregationQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunAggregationQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.RunAggregationQueryRequest.class,
              com.google.firestore.v1.RunAggregationQueryRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.RunAggregationQueryRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (structuredAggregationQueryBuilder_ != null) {
        structuredAggregationQueryBuilder_.clear();
      }
      if (newTransactionBuilder_ != null) {
        newTransactionBuilder_.clear();
      }
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.clear();
      }
      queryTypeCase_ = 0;
      queryType_ = null;
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunAggregationQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.RunAggregationQueryRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.RunAggregationQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.RunAggregationQueryRequest build() {
      com.google.firestore.v1.RunAggregationQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.RunAggregationQueryRequest buildPartial() {
      com.google.firestore.v1.RunAggregationQueryRequest result =
          new com.google.firestore.v1.RunAggregationQueryRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.RunAggregationQueryRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
    }

    private void buildPartialOneofs(com.google.firestore.v1.RunAggregationQueryRequest result) {
      result.queryTypeCase_ = queryTypeCase_;
      result.queryType_ = this.queryType_;
      if (queryTypeCase_ == 2 && structuredAggregationQueryBuilder_ != null) {
        result.queryType_ = structuredAggregationQueryBuilder_.build();
      }
      result.consistencySelectorCase_ = consistencySelectorCase_;
      result.consistencySelector_ = this.consistencySelector_;
      if (consistencySelectorCase_ == 5 && newTransactionBuilder_ != null) {
        result.consistencySelector_ = newTransactionBuilder_.build();
      }
      if (consistencySelectorCase_ == 6 && readTimeBuilder_ != null) {
        result.consistencySelector_ = readTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.RunAggregationQueryRequest) {
        return mergeFrom((com.google.firestore.v1.RunAggregationQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.RunAggregationQueryRequest other) {
      if (other == com.google.firestore.v1.RunAggregationQueryRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getQueryTypeCase()) {
        case STRUCTURED_AGGREGATION_QUERY:
          {
            mergeStructuredAggregationQuery(other.getStructuredAggregationQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getConsistencySelectorCase()) {
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case NEW_TRANSACTION:
          {
            mergeNewTransaction(other.getNewTransaction());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case CONSISTENCYSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getStructuredAggregationQueryFieldBuilder().getBuilder(), extensionRegistry);
                queryTypeCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                consistencySelector_ = input.readBytes();
                consistencySelectorCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNewTransactionFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private int consistencySelectorCase_ = 0;
    private java.lang.Object consistencySelector_;

    public ConsistencySelectorCase getConsistencySelectorCase() {
      return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
    }

    public Builder clearConsistencySelector() {
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredAggregationQuery,
            com.google.firestore.v1.StructuredAggregationQuery.Builder,
            com.google.firestore.v1.StructuredAggregationQueryOrBuilder>
        structuredAggregationQueryBuilder_;
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     *
     * @return Whether the structuredAggregationQuery field is set.
     */
    @java.lang.Override
    public boolean hasStructuredAggregationQuery() {
      return queryTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     *
     * @return The structuredAggregationQuery.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery getStructuredAggregationQuery() {
      if (structuredAggregationQueryBuilder_ == null) {
        if (queryTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredAggregationQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 2) {
          return structuredAggregationQueryBuilder_.getMessage();
        }
        return com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    public Builder setStructuredAggregationQuery(
        com.google.firestore.v1.StructuredAggregationQuery value) {
      if (structuredAggregationQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        structuredAggregationQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    public Builder setStructuredAggregationQuery(
        com.google.firestore.v1.StructuredAggregationQuery.Builder builderForValue) {
      if (structuredAggregationQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        structuredAggregationQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    public Builder mergeStructuredAggregationQuery(
        com.google.firestore.v1.StructuredAggregationQuery value) {
      if (structuredAggregationQueryBuilder_ == null) {
        if (queryTypeCase_ == 2
            && queryType_
                != com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance()) {
          queryType_ =
              com.google.firestore.v1.StructuredAggregationQuery.newBuilder(
                      (com.google.firestore.v1.StructuredAggregationQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 2) {
          structuredAggregationQueryBuilder_.mergeFrom(value);
        } else {
          structuredAggregationQueryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    public Builder clearStructuredAggregationQuery() {
      if (structuredAggregationQueryBuilder_ == null) {
        if (queryTypeCase_ == 2) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 2) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        structuredAggregationQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    public com.google.firestore.v1.StructuredAggregationQuery.Builder
        getStructuredAggregationQueryBuilder() {
      return getStructuredAggregationQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQueryOrBuilder
        getStructuredAggregationQueryOrBuilder() {
      if ((queryTypeCase_ == 2) && (structuredAggregationQueryBuilder_ != null)) {
        return structuredAggregationQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredAggregationQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An aggregation query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery structured_aggregation_query = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredAggregationQuery,
            com.google.firestore.v1.StructuredAggregationQuery.Builder,
            com.google.firestore.v1.StructuredAggregationQueryOrBuilder>
        getStructuredAggregationQueryFieldBuilder() {
      if (structuredAggregationQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 2)) {
          queryType_ = com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
        }
        structuredAggregationQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.StructuredAggregationQuery,
                com.google.firestore.v1.StructuredAggregationQuery.Builder,
                com.google.firestore.v1.StructuredAggregationQueryOrBuilder>(
                (com.google.firestore.v1.StructuredAggregationQuery) queryType_,
                getParentForChildren(),
                isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 2;
      onChanged();
      return structuredAggregationQueryBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Run the aggregation within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return consistencySelectorCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Run the aggregation within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (consistencySelectorCase_ == 4) {
        return (com.google.protobuf.ByteString) consistencySelector_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Run the aggregation within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencySelectorCase_ = 4;
      consistencySelector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Run the aggregation within an already active transaction.
     *
     * The value here is the opaque transaction ID to execute the query in.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (consistencySelectorCase_ == 4) {
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        newTransactionBuilder_;
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     *
     * @return Whether the newTransaction field is set.
     */
    @java.lang.Override
    public boolean hasNewTransaction() {
      return consistencySelectorCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     *
     * @return The newTransaction.
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions getNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 5) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 5) {
          return newTransactionBuilder_.getMessage();
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder setNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder setNewTransaction(
        com.google.firestore.v1.TransactionOptions.Builder builderForValue) {
      if (newTransactionBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder mergeNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 5
            && consistencySelector_
                != com.google.firestore.v1.TransactionOptions.getDefaultInstance()) {
          consistencySelector_ =
              com.google.firestore.v1.TransactionOptions.newBuilder(
                      (com.google.firestore.v1.TransactionOptions) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 5) {
          newTransactionBuilder_.mergeFrom(value);
        } else {
          newTransactionBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder clearNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 5) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 5) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        newTransactionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public com.google.firestore.v1.TransactionOptions.Builder getNewTransactionBuilder() {
      return getNewTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
      if ((consistencySelectorCase_ == 5) && (newTransactionBuilder_ != null)) {
        return newTransactionBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 5) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction as part of the query, defaulting to read-only.
     *
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        getNewTransactionFieldBuilder() {
      if (newTransactionBuilder_ == null) {
        if (!(consistencySelectorCase_ == 5)) {
          consistencySelector_ = com.google.firestore.v1.TransactionOptions.getDefaultInstance();
        }
        newTransactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.TransactionOptions,
                com.google.firestore.v1.TransactionOptions.Builder,
                com.google.firestore.v1.TransactionOptionsOrBuilder>(
                (com.google.firestore.v1.TransactionOptions) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 5;
      onChanged();
      return newTransactionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencySelectorCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 6) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 6) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 6
            && consistencySelector_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          consistencySelector_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 6) {
          readTimeBuilder_.mergeFrom(value);
        } else {
          readTimeBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 6) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 6) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((consistencySelectorCase_ == 6) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 6) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Executes the query at the given timestamp.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(consistencySelectorCase_ == 6)) {
          consistencySelector_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 6;
      onChanged();
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.RunAggregationQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.RunAggregationQueryRequest)
  private static final com.google.firestore.v1.RunAggregationQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.RunAggregationQueryRequest();
  }

  public static com.google.firestore.v1.RunAggregationQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunAggregationQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunAggregationQueryRequest>() {
        @java.lang.Override
        public RunAggregationQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunAggregationQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunAggregationQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.RunAggregationQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
