/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

// Protobuf Java Version: 3.25.4
package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Metadata for CopyLogEntries long running operations.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.CopyLogEntriesMetadata}
 */
public final class CopyLogEntriesMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.CopyLogEntriesMetadata)
    CopyLogEntriesMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CopyLogEntriesMetadata.newBuilder() to construct.
  private CopyLogEntriesMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CopyLogEntriesMetadata() {
    state_ = 0;
    writerIdentity_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CopyLogEntriesMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_CopyLogEntriesMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_CopyLogEntriesMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.CopyLogEntriesMetadata.class,
            com.google.logging.v2.CopyLogEntriesMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The create time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The create time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The create time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The end time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The end time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The end time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * State of an operation.
   * </pre>
   *
   * <code>.google.logging.v2.OperationState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * State of an operation.
   * </pre>
   *
   * <code>.google.logging.v2.OperationState state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.logging.v2.OperationState getState() {
    com.google.logging.v2.OperationState result =
        com.google.logging.v2.OperationState.forNumber(state_);
    return result == null ? com.google.logging.v2.OperationState.UNRECOGNIZED : result;
  }

  public static final int CANCELLATION_REQUESTED_FIELD_NUMBER = 4;
  private boolean cancellationRequested_ = false;
  /**
   *
   *
   * <pre>
   * Identifies whether the user has requested cancellation of the operation.
   * </pre>
   *
   * <code>bool cancellation_requested = 4;</code>
   *
   * @return The cancellationRequested.
   */
  @java.lang.Override
  public boolean getCancellationRequested() {
    return cancellationRequested_;
  }

  public static final int REQUEST_FIELD_NUMBER = 5;
  private com.google.logging.v2.CopyLogEntriesRequest request_;
  /**
   *
   *
   * <pre>
   * CopyLogEntries RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * CopyLogEntries RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.logging.v2.CopyLogEntriesRequest getRequest() {
    return request_ == null
        ? com.google.logging.v2.CopyLogEntriesRequest.getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * CopyLogEntries RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.CopyLogEntriesRequestOrBuilder getRequestOrBuilder() {
    return request_ == null
        ? com.google.logging.v2.CopyLogEntriesRequest.getDefaultInstance()
        : request_;
  }

  public static final int PROGRESS_FIELD_NUMBER = 6;
  private int progress_ = 0;
  /**
   *
   *
   * <pre>
   * Estimated progress of the operation (0 - 100%).
   * </pre>
   *
   * <code>int32 progress = 6;</code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public int getProgress() {
    return progress_;
  }

  public static final int WRITER_IDENTITY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object writerIdentity_ = "";
  /**
   *
   *
   * <pre>
   * The IAM identity of a service account that must be granted access to the
   * destination.
   *
   * If the service account is not granted permission to the destination within
   * an hour, the operation will be cancelled.
   *
   * For example: `"serviceAccount:foo&#64;bar.com"`
   * </pre>
   *
   * <code>string writer_identity = 7;</code>
   *
   * @return The writerIdentity.
   */
  @java.lang.Override
  public java.lang.String getWriterIdentity() {
    java.lang.Object ref = writerIdentity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      writerIdentity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IAM identity of a service account that must be granted access to the
   * destination.
   *
   * If the service account is not granted permission to the destination within
   * an hour, the operation will be cancelled.
   *
   * For example: `"serviceAccount:foo&#64;bar.com"`
   * </pre>
   *
   * <code>string writer_identity = 7;</code>
   *
   * @return The bytes for writerIdentity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWriterIdentityBytes() {
    java.lang.Object ref = writerIdentity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      writerIdentity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (state_ != com.google.logging.v2.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (cancellationRequested_ != false) {
      output.writeBool(4, cancellationRequested_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getRequest());
    }
    if (progress_ != 0) {
      output.writeInt32(6, progress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(writerIdentity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, writerIdentity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (state_ != com.google.logging.v2.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (cancellationRequested_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, cancellationRequested_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRequest());
    }
    if (progress_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, progress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(writerIdentity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, writerIdentity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.CopyLogEntriesMetadata)) {
      return super.equals(obj);
    }
    com.google.logging.v2.CopyLogEntriesMetadata other =
        (com.google.logging.v2.CopyLogEntriesMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (getCancellationRequested() != other.getCancellationRequested()) return false;
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (getProgress() != other.getProgress()) return false;
    if (!getWriterIdentity().equals(other.getWriterIdentity())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + CANCELLATION_REQUESTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCancellationRequested());
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
    hash = (53 * hash) + getProgress();
    hash = (37 * hash) + WRITER_IDENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getWriterIdentity().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.CopyLogEntriesMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for CopyLogEntries long running operations.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.CopyLogEntriesMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.CopyLogEntriesMetadata)
      com.google.logging.v2.CopyLogEntriesMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_CopyLogEntriesMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_CopyLogEntriesMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.CopyLogEntriesMetadata.class,
              com.google.logging.v2.CopyLogEntriesMetadata.Builder.class);
    }

    // Construct using com.google.logging.v2.CopyLogEntriesMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getRequestFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      state_ = 0;
      cancellationRequested_ = false;
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      progress_ = 0;
      writerIdentity_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_CopyLogEntriesMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.CopyLogEntriesMetadata getDefaultInstanceForType() {
      return com.google.logging.v2.CopyLogEntriesMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.CopyLogEntriesMetadata build() {
      com.google.logging.v2.CopyLogEntriesMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.CopyLogEntriesMetadata buildPartial() {
      com.google.logging.v2.CopyLogEntriesMetadata result =
          new com.google.logging.v2.CopyLogEntriesMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.logging.v2.CopyLogEntriesMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.cancellationRequested_ = cancellationRequested_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.progress_ = progress_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.writerIdentity_ = writerIdentity_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.CopyLogEntriesMetadata) {
        return mergeFrom((com.google.logging.v2.CopyLogEntriesMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.CopyLogEntriesMetadata other) {
      if (other == com.google.logging.v2.CopyLogEntriesMetadata.getDefaultInstance()) return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getCancellationRequested() != false) {
        setCancellationRequested(other.getCancellationRequested());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (other.getProgress() != 0) {
        setProgress(other.getProgress());
      }
      if (!other.getWriterIdentity().isEmpty()) {
        writerIdentity_ = other.writerIdentity_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                cancellationRequested_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                progress_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                writerIdentity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.logging.v2.OperationState getState() {
      com.google.logging.v2.OperationState result =
          com.google.logging.v2.OperationState.forNumber(state_);
      return result == null ? com.google.logging.v2.OperationState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.logging.v2.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private boolean cancellationRequested_;
    /**
     *
     *
     * <pre>
     * Identifies whether the user has requested cancellation of the operation.
     * </pre>
     *
     * <code>bool cancellation_requested = 4;</code>
     *
     * @return The cancellationRequested.
     */
    @java.lang.Override
    public boolean getCancellationRequested() {
      return cancellationRequested_;
    }
    /**
     *
     *
     * <pre>
     * Identifies whether the user has requested cancellation of the operation.
     * </pre>
     *
     * <code>bool cancellation_requested = 4;</code>
     *
     * @param value The cancellationRequested to set.
     * @return This builder for chaining.
     */
    public Builder setCancellationRequested(boolean value) {

      cancellationRequested_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies whether the user has requested cancellation of the operation.
     * </pre>
     *
     * <code>bool cancellation_requested = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCancellationRequested() {
      bitField0_ = (bitField0_ & ~0x00000008);
      cancellationRequested_ = false;
      onChanged();
      return this;
    }

    private com.google.logging.v2.CopyLogEntriesRequest request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.CopyLogEntriesRequest,
            com.google.logging.v2.CopyLogEntriesRequest.Builder,
            com.google.logging.v2.CopyLogEntriesRequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     *
     * @return The request.
     */
    public com.google.logging.v2.CopyLogEntriesRequest getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.logging.v2.CopyLogEntriesRequest.getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    public Builder setRequest(com.google.logging.v2.CopyLogEntriesRequest value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    public Builder setRequest(com.google.logging.v2.CopyLogEntriesRequest.Builder builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    public Builder mergeRequest(com.google.logging.v2.CopyLogEntriesRequest value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && request_ != null
            && request_ != com.google.logging.v2.CopyLogEntriesRequest.getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      if (request_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000010);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    public com.google.logging.v2.CopyLogEntriesRequest.Builder getRequestBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    public com.google.logging.v2.CopyLogEntriesRequestOrBuilder getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.logging.v2.CopyLogEntriesRequest.getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * CopyLogEntries RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CopyLogEntriesRequest request = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.CopyLogEntriesRequest,
            com.google.logging.v2.CopyLogEntriesRequest.Builder,
            com.google.logging.v2.CopyLogEntriesRequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.CopyLogEntriesRequest,
                com.google.logging.v2.CopyLogEntriesRequest.Builder,
                com.google.logging.v2.CopyLogEntriesRequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private int progress_;
    /**
     *
     *
     * <pre>
     * Estimated progress of the operation (0 - 100%).
     * </pre>
     *
     * <code>int32 progress = 6;</code>
     *
     * @return The progress.
     */
    @java.lang.Override
    public int getProgress() {
      return progress_;
    }
    /**
     *
     *
     * <pre>
     * Estimated progress of the operation (0 - 100%).
     * </pre>
     *
     * <code>int32 progress = 6;</code>
     *
     * @param value The progress to set.
     * @return This builder for chaining.
     */
    public Builder setProgress(int value) {

      progress_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Estimated progress of the operation (0 - 100%).
     * </pre>
     *
     * <code>int32 progress = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgress() {
      bitField0_ = (bitField0_ & ~0x00000020);
      progress_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object writerIdentity_ = "";
    /**
     *
     *
     * <pre>
     * The IAM identity of a service account that must be granted access to the
     * destination.
     *
     * If the service account is not granted permission to the destination within
     * an hour, the operation will be cancelled.
     *
     * For example: `"serviceAccount:foo&#64;bar.com"`
     * </pre>
     *
     * <code>string writer_identity = 7;</code>
     *
     * @return The writerIdentity.
     */
    public java.lang.String getWriterIdentity() {
      java.lang.Object ref = writerIdentity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        writerIdentity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IAM identity of a service account that must be granted access to the
     * destination.
     *
     * If the service account is not granted permission to the destination within
     * an hour, the operation will be cancelled.
     *
     * For example: `"serviceAccount:foo&#64;bar.com"`
     * </pre>
     *
     * <code>string writer_identity = 7;</code>
     *
     * @return The bytes for writerIdentity.
     */
    public com.google.protobuf.ByteString getWriterIdentityBytes() {
      java.lang.Object ref = writerIdentity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        writerIdentity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IAM identity of a service account that must be granted access to the
     * destination.
     *
     * If the service account is not granted permission to the destination within
     * an hour, the operation will be cancelled.
     *
     * For example: `"serviceAccount:foo&#64;bar.com"`
     * </pre>
     *
     * <code>string writer_identity = 7;</code>
     *
     * @param value The writerIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setWriterIdentity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      writerIdentity_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM identity of a service account that must be granted access to the
     * destination.
     *
     * If the service account is not granted permission to the destination within
     * an hour, the operation will be cancelled.
     *
     * For example: `"serviceAccount:foo&#64;bar.com"`
     * </pre>
     *
     * <code>string writer_identity = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriterIdentity() {
      writerIdentity_ = getDefaultInstance().getWriterIdentity();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IAM identity of a service account that must be granted access to the
     * destination.
     *
     * If the service account is not granted permission to the destination within
     * an hour, the operation will be cancelled.
     *
     * For example: `"serviceAccount:foo&#64;bar.com"`
     * </pre>
     *
     * <code>string writer_identity = 7;</code>
     *
     * @param value The bytes for writerIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setWriterIdentityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      writerIdentity_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.CopyLogEntriesMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.CopyLogEntriesMetadata)
  private static final com.google.logging.v2.CopyLogEntriesMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.CopyLogEntriesMetadata();
  }

  public static com.google.logging.v2.CopyLogEntriesMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CopyLogEntriesMetadata> PARSER =
      new com.google.protobuf.AbstractParser<CopyLogEntriesMetadata>() {
        @java.lang.Override
        public CopyLogEntriesMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CopyLogEntriesMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CopyLogEntriesMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.CopyLogEntriesMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
