/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

// Protobuf Java Version: 3.25.8
package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Metadata for LongRunningUpdateBucket Operations.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.BucketMetadata}
 */
public final class BucketMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.BucketMetadata)
    BucketMetadataOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BucketMetadata.newBuilder() to construct.
  private BucketMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BucketMetadata() {
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BucketMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_BucketMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_BucketMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.BucketMetadata.class,
            com.google.logging.v2.BucketMetadata.Builder.class);
  }

  private int bitField0_;
  private int requestCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object request_;

  public enum RequestCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CREATE_BUCKET_REQUEST(4),
    UPDATE_BUCKET_REQUEST(5),
    REQUEST_NOT_SET(0);
    private final int value;

    private RequestCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestCase forNumber(int value) {
      switch (value) {
        case 4:
          return CREATE_BUCKET_REQUEST;
        case 5:
          return UPDATE_BUCKET_REQUEST;
        case 0:
          return REQUEST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestCase getRequestCase() {
    return RequestCase.forNumber(requestCase_);
  }

  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * The create time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The create time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * The create time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;

  /**
   *
   *
   * <pre>
   * The end time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The end time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  /**
   *
   *
   * <pre>
   * The end time of an operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * State of an operation.
   * </pre>
   *
   * <code>.google.logging.v2.OperationState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * State of an operation.
   * </pre>
   *
   * <code>.google.logging.v2.OperationState state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.logging.v2.OperationState getState() {
    com.google.logging.v2.OperationState result =
        com.google.logging.v2.OperationState.forNumber(state_);
    return result == null ? com.google.logging.v2.OperationState.UNRECOGNIZED : result;
  }

  public static final int CREATE_BUCKET_REQUEST_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * LongRunningCreateBucket RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
   *
   * @return Whether the createBucketRequest field is set.
   */
  @java.lang.Override
  public boolean hasCreateBucketRequest() {
    return requestCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * LongRunningCreateBucket RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
   *
   * @return The createBucketRequest.
   */
  @java.lang.Override
  public com.google.logging.v2.CreateBucketRequest getCreateBucketRequest() {
    if (requestCase_ == 4) {
      return (com.google.logging.v2.CreateBucketRequest) request_;
    }
    return com.google.logging.v2.CreateBucketRequest.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * LongRunningCreateBucket RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.CreateBucketRequestOrBuilder getCreateBucketRequestOrBuilder() {
    if (requestCase_ == 4) {
      return (com.google.logging.v2.CreateBucketRequest) request_;
    }
    return com.google.logging.v2.CreateBucketRequest.getDefaultInstance();
  }

  public static final int UPDATE_BUCKET_REQUEST_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * LongRunningUpdateBucket RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
   *
   * @return Whether the updateBucketRequest field is set.
   */
  @java.lang.Override
  public boolean hasUpdateBucketRequest() {
    return requestCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * LongRunningUpdateBucket RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
   *
   * @return The updateBucketRequest.
   */
  @java.lang.Override
  public com.google.logging.v2.UpdateBucketRequest getUpdateBucketRequest() {
    if (requestCase_ == 5) {
      return (com.google.logging.v2.UpdateBucketRequest) request_;
    }
    return com.google.logging.v2.UpdateBucketRequest.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * LongRunningUpdateBucket RPC request.
   * </pre>
   *
   * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.UpdateBucketRequestOrBuilder getUpdateBucketRequestOrBuilder() {
    if (requestCase_ == 5) {
      return (com.google.logging.v2.UpdateBucketRequest) request_;
    }
    return com.google.logging.v2.UpdateBucketRequest.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (state_ != com.google.logging.v2.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (requestCase_ == 4) {
      output.writeMessage(4, (com.google.logging.v2.CreateBucketRequest) request_);
    }
    if (requestCase_ == 5) {
      output.writeMessage(5, (com.google.logging.v2.UpdateBucketRequest) request_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (state_ != com.google.logging.v2.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (requestCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.logging.v2.CreateBucketRequest) request_);
    }
    if (requestCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.logging.v2.UpdateBucketRequest) request_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.BucketMetadata)) {
      return super.equals(obj);
    }
    com.google.logging.v2.BucketMetadata other = (com.google.logging.v2.BucketMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getRequestCase().equals(other.getRequestCase())) return false;
    switch (requestCase_) {
      case 4:
        if (!getCreateBucketRequest().equals(other.getCreateBucketRequest())) return false;
        break;
      case 5:
        if (!getUpdateBucketRequest().equals(other.getUpdateBucketRequest())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (requestCase_) {
      case 4:
        hash = (37 * hash) + CREATE_BUCKET_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getCreateBucketRequest().hashCode();
        break;
      case 5:
        hash = (37 * hash) + UPDATE_BUCKET_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateBucketRequest().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.BucketMetadata parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.BucketMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.BucketMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.BucketMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata for LongRunningUpdateBucket Operations.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.BucketMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.BucketMetadata)
      com.google.logging.v2.BucketMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_BucketMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_BucketMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.BucketMetadata.class,
              com.google.logging.v2.BucketMetadata.Builder.class);
    }

    // Construct using com.google.logging.v2.BucketMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      state_ = 0;
      if (createBucketRequestBuilder_ != null) {
        createBucketRequestBuilder_.clear();
      }
      if (updateBucketRequestBuilder_ != null) {
        updateBucketRequestBuilder_.clear();
      }
      requestCase_ = 0;
      request_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_BucketMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.BucketMetadata getDefaultInstanceForType() {
      return com.google.logging.v2.BucketMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.BucketMetadata build() {
      com.google.logging.v2.BucketMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.BucketMetadata buildPartial() {
      com.google.logging.v2.BucketMetadata result = new com.google.logging.v2.BucketMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.logging.v2.BucketMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.logging.v2.BucketMetadata result) {
      result.requestCase_ = requestCase_;
      result.request_ = this.request_;
      if (requestCase_ == 4 && createBucketRequestBuilder_ != null) {
        result.request_ = createBucketRequestBuilder_.build();
      }
      if (requestCase_ == 5 && updateBucketRequestBuilder_ != null) {
        result.request_ = updateBucketRequestBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.BucketMetadata) {
        return mergeFrom((com.google.logging.v2.BucketMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.BucketMetadata other) {
      if (other == com.google.logging.v2.BucketMetadata.getDefaultInstance()) return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getRequestCase()) {
        case CREATE_BUCKET_REQUEST:
          {
            mergeCreateBucketRequest(other.getCreateBucketRequest());
            break;
          }
        case UPDATE_BUCKET_REQUEST:
          {
            mergeUpdateBucketRequest(other.getUpdateBucketRequest());
            break;
          }
        case REQUEST_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getCreateBucketRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getUpdateBucketRequestFieldBuilder().getBuilder(), extensionRegistry);
                requestCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int requestCase_ = 0;
    private java.lang.Object request_;

    public RequestCase getRequestCase() {
      return RequestCase.forNumber(requestCase_);
    }

    public Builder clearRequest() {
      requestCase_ = 0;
      request_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The create time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The end time of an operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.logging.v2.OperationState getState() {
      com.google.logging.v2.OperationState result =
          com.google.logging.v2.OperationState.forNumber(state_);
      return result == null ? com.google.logging.v2.OperationState.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.logging.v2.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * State of an operation.
     * </pre>
     *
     * <code>.google.logging.v2.OperationState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.CreateBucketRequest,
            com.google.logging.v2.CreateBucketRequest.Builder,
            com.google.logging.v2.CreateBucketRequestOrBuilder>
        createBucketRequestBuilder_;

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     *
     * @return Whether the createBucketRequest field is set.
     */
    @java.lang.Override
    public boolean hasCreateBucketRequest() {
      return requestCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     *
     * @return The createBucketRequest.
     */
    @java.lang.Override
    public com.google.logging.v2.CreateBucketRequest getCreateBucketRequest() {
      if (createBucketRequestBuilder_ == null) {
        if (requestCase_ == 4) {
          return (com.google.logging.v2.CreateBucketRequest) request_;
        }
        return com.google.logging.v2.CreateBucketRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 4) {
          return createBucketRequestBuilder_.getMessage();
        }
        return com.google.logging.v2.CreateBucketRequest.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    public Builder setCreateBucketRequest(com.google.logging.v2.CreateBucketRequest value) {
      if (createBucketRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        createBucketRequestBuilder_.setMessage(value);
      }
      requestCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    public Builder setCreateBucketRequest(
        com.google.logging.v2.CreateBucketRequest.Builder builderForValue) {
      if (createBucketRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        createBucketRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    public Builder mergeCreateBucketRequest(com.google.logging.v2.CreateBucketRequest value) {
      if (createBucketRequestBuilder_ == null) {
        if (requestCase_ == 4
            && request_ != com.google.logging.v2.CreateBucketRequest.getDefaultInstance()) {
          request_ =
              com.google.logging.v2.CreateBucketRequest.newBuilder(
                      (com.google.logging.v2.CreateBucketRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 4) {
          createBucketRequestBuilder_.mergeFrom(value);
        } else {
          createBucketRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    public Builder clearCreateBucketRequest() {
      if (createBucketRequestBuilder_ == null) {
        if (requestCase_ == 4) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 4) {
          requestCase_ = 0;
          request_ = null;
        }
        createBucketRequestBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    public com.google.logging.v2.CreateBucketRequest.Builder getCreateBucketRequestBuilder() {
      return getCreateBucketRequestFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    @java.lang.Override
    public com.google.logging.v2.CreateBucketRequestOrBuilder getCreateBucketRequestOrBuilder() {
      if ((requestCase_ == 4) && (createBucketRequestBuilder_ != null)) {
        return createBucketRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 4) {
          return (com.google.logging.v2.CreateBucketRequest) request_;
        }
        return com.google.logging.v2.CreateBucketRequest.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * LongRunningCreateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.CreateBucketRequest create_bucket_request = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.CreateBucketRequest,
            com.google.logging.v2.CreateBucketRequest.Builder,
            com.google.logging.v2.CreateBucketRequestOrBuilder>
        getCreateBucketRequestFieldBuilder() {
      if (createBucketRequestBuilder_ == null) {
        if (!(requestCase_ == 4)) {
          request_ = com.google.logging.v2.CreateBucketRequest.getDefaultInstance();
        }
        createBucketRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.CreateBucketRequest,
                com.google.logging.v2.CreateBucketRequest.Builder,
                com.google.logging.v2.CreateBucketRequestOrBuilder>(
                (com.google.logging.v2.CreateBucketRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 4;
      onChanged();
      return createBucketRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.UpdateBucketRequest,
            com.google.logging.v2.UpdateBucketRequest.Builder,
            com.google.logging.v2.UpdateBucketRequestOrBuilder>
        updateBucketRequestBuilder_;

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     *
     * @return Whether the updateBucketRequest field is set.
     */
    @java.lang.Override
    public boolean hasUpdateBucketRequest() {
      return requestCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     *
     * @return The updateBucketRequest.
     */
    @java.lang.Override
    public com.google.logging.v2.UpdateBucketRequest getUpdateBucketRequest() {
      if (updateBucketRequestBuilder_ == null) {
        if (requestCase_ == 5) {
          return (com.google.logging.v2.UpdateBucketRequest) request_;
        }
        return com.google.logging.v2.UpdateBucketRequest.getDefaultInstance();
      } else {
        if (requestCase_ == 5) {
          return updateBucketRequestBuilder_.getMessage();
        }
        return com.google.logging.v2.UpdateBucketRequest.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    public Builder setUpdateBucketRequest(com.google.logging.v2.UpdateBucketRequest value) {
      if (updateBucketRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
        onChanged();
      } else {
        updateBucketRequestBuilder_.setMessage(value);
      }
      requestCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    public Builder setUpdateBucketRequest(
        com.google.logging.v2.UpdateBucketRequest.Builder builderForValue) {
      if (updateBucketRequestBuilder_ == null) {
        request_ = builderForValue.build();
        onChanged();
      } else {
        updateBucketRequestBuilder_.setMessage(builderForValue.build());
      }
      requestCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    public Builder mergeUpdateBucketRequest(com.google.logging.v2.UpdateBucketRequest value) {
      if (updateBucketRequestBuilder_ == null) {
        if (requestCase_ == 5
            && request_ != com.google.logging.v2.UpdateBucketRequest.getDefaultInstance()) {
          request_ =
              com.google.logging.v2.UpdateBucketRequest.newBuilder(
                      (com.google.logging.v2.UpdateBucketRequest) request_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          request_ = value;
        }
        onChanged();
      } else {
        if (requestCase_ == 5) {
          updateBucketRequestBuilder_.mergeFrom(value);
        } else {
          updateBucketRequestBuilder_.setMessage(value);
        }
      }
      requestCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    public Builder clearUpdateBucketRequest() {
      if (updateBucketRequestBuilder_ == null) {
        if (requestCase_ == 5) {
          requestCase_ = 0;
          request_ = null;
          onChanged();
        }
      } else {
        if (requestCase_ == 5) {
          requestCase_ = 0;
          request_ = null;
        }
        updateBucketRequestBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    public com.google.logging.v2.UpdateBucketRequest.Builder getUpdateBucketRequestBuilder() {
      return getUpdateBucketRequestFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    @java.lang.Override
    public com.google.logging.v2.UpdateBucketRequestOrBuilder getUpdateBucketRequestOrBuilder() {
      if ((requestCase_ == 5) && (updateBucketRequestBuilder_ != null)) {
        return updateBucketRequestBuilder_.getMessageOrBuilder();
      } else {
        if (requestCase_ == 5) {
          return (com.google.logging.v2.UpdateBucketRequest) request_;
        }
        return com.google.logging.v2.UpdateBucketRequest.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * LongRunningUpdateBucket RPC request.
     * </pre>
     *
     * <code>.google.logging.v2.UpdateBucketRequest update_bucket_request = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.UpdateBucketRequest,
            com.google.logging.v2.UpdateBucketRequest.Builder,
            com.google.logging.v2.UpdateBucketRequestOrBuilder>
        getUpdateBucketRequestFieldBuilder() {
      if (updateBucketRequestBuilder_ == null) {
        if (!(requestCase_ == 5)) {
          request_ = com.google.logging.v2.UpdateBucketRequest.getDefaultInstance();
        }
        updateBucketRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.UpdateBucketRequest,
                com.google.logging.v2.UpdateBucketRequest.Builder,
                com.google.logging.v2.UpdateBucketRequestOrBuilder>(
                (com.google.logging.v2.UpdateBucketRequest) request_,
                getParentForChildren(),
                isClean());
        request_ = null;
      }
      requestCase_ = 5;
      onChanged();
      return updateBucketRequestBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.BucketMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.BucketMetadata)
  private static final com.google.logging.v2.BucketMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.BucketMetadata();
  }

  public static com.google.logging.v2.BucketMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BucketMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BucketMetadata>() {
        @java.lang.Override
        public BucketMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BucketMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BucketMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.BucketMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
