/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CmekSettingsName
implements ResourceName {
    private static final PathTemplate PROJECT_CMEK_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/cmekSettings");
    private static final PathTemplate ORGANIZATION_CMEK_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/cmekSettings");
    private static final PathTemplate FOLDER_CMEK_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/cmekSettings");
    private static final PathTemplate BILLING_ACCOUNT_CMEK_SETTINGS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/cmekSettings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String organization;
    private String folder;
    private String billingAccount;

    @Deprecated
    protected CmekSettingsName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    private CmekSettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.pathTemplate = PROJECT_CMEK_SETTINGS_PATH_TEMPLATE;
    }

    private CmekSettingsName(OrganizationCmekSettingsBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.pathTemplate = ORGANIZATION_CMEK_SETTINGS_PATH_TEMPLATE;
    }

    private CmekSettingsName(FolderCmekSettingsBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.pathTemplate = FOLDER_CMEK_SETTINGS_PATH_TEMPLATE;
    }

    private CmekSettingsName(BillingAccountCmekSettingsBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.pathTemplate = BILLING_ACCOUNT_CMEK_SETTINGS_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectCmekSettingsBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationCmekSettingsBuilder newOrganizationCmekSettingsBuilder() {
        return new OrganizationCmekSettingsBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderCmekSettingsBuilder newFolderCmekSettingsBuilder() {
        return new FolderCmekSettingsBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountCmekSettingsBuilder newBillingAccountCmekSettingsBuilder() {
        return new BillingAccountCmekSettingsBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CmekSettingsName of(String project) {
        return CmekSettingsName.newProjectCmekSettingsBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CmekSettingsName ofProjectCmekSettingsName(String project) {
        return CmekSettingsName.newProjectCmekSettingsBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CmekSettingsName ofOrganizationCmekSettingsName(String organization) {
        return CmekSettingsName.newOrganizationCmekSettingsBuilder().setOrganization(organization).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CmekSettingsName ofFolderCmekSettingsName(String folder) {
        return CmekSettingsName.newFolderCmekSettingsBuilder().setFolder(folder).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static CmekSettingsName ofBillingAccountCmekSettingsName(String billingAccount) {
        return CmekSettingsName.newBillingAccountCmekSettingsBuilder().setBillingAccount(billingAccount).build();
    }

    public static String format(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectCmekSettingsName(String project) {
        return CmekSettingsName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationCmekSettingsName(String organization) {
        return CmekSettingsName.newOrganizationCmekSettingsBuilder().setOrganization(organization).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderCmekSettingsName(String folder) {
        return CmekSettingsName.newFolderCmekSettingsBuilder().setFolder(folder).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountCmekSettingsName(String billingAccount) {
        return CmekSettingsName.newBillingAccountCmekSettingsBuilder().setBillingAccount(billingAccount).build().toString();
    }

    public static CmekSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_CMEK_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return CmekSettingsName.ofProjectCmekSettingsName((String)matchMap.get("project"));
        }
        if (ORGANIZATION_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CMEK_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return CmekSettingsName.ofOrganizationCmekSettingsName((String)matchMap.get("organization"));
        }
        if (FOLDER_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_CMEK_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return CmekSettingsName.ofFolderCmekSettingsName((String)matchMap.get("folder"));
        }
        if (BILLING_ACCOUNT_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_CMEK_SETTINGS_PATH_TEMPLATE.match(formattedString);
            return CmekSettingsName.ofBillingAccountCmekSettingsName((String)matchMap.get("billing_account"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<CmekSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<CmekSettingsName> list = new ArrayList<CmekSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CmekSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CmekSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CmekSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString) || FOLDER_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString) || BILLING_ACCOUNT_CMEK_SETTINGS_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CmekSettingsName cmekSettingsName = this;
            synchronized (cmekSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CmekSettingsName that = (CmekSettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountCmekSettingsBuilder {
        private String billingAccount;

        private BillingAccountCmekSettingsBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public BillingAccountCmekSettingsBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderCmekSettingsBuilder {
        private String folder;

        private FolderCmekSettingsBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderCmekSettingsBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationCmekSettingsBuilder {
        private String organization;

        private OrganizationCmekSettingsBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public OrganizationCmekSettingsBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(CmekSettingsName cmekSettingsName) {
            Preconditions.checkArgument((cmekSettingsName.pathTemplate == PROJECT_CMEK_SETTINGS_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when CmekSettingsName has the pattern of projects/{project}/cmekSettings.");
            this.project = cmekSettingsName.project;
        }

        public CmekSettingsName build() {
            return new CmekSettingsName(this);
        }
    }
}

