/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/snooze.proto

// Protobuf Java Version: 3.25.5
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A `Snooze` will prevent any alerts from being opened, and close any that
 * are already open. The `Snooze` will work on alerts that match the
 * criteria defined in the `Snooze`. The `Snooze` will be active from
 * `interval.start_time` through `interval.end_time`.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.Snooze}
 */
public final class Snooze extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.Snooze)
    SnoozeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Snooze.newBuilder() to construct.
  private Snooze(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Snooze() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Snooze();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.SnoozeProto
        .internal_static_google_monitoring_v3_Snooze_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.SnoozeProto
        .internal_static_google_monitoring_v3_Snooze_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.Snooze.class, com.google.monitoring.v3.Snooze.Builder.class);
  }

  public interface CriteriaOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.Snooze.Criteria)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the policies.
     */
    java.util.List<java.lang.String> getPoliciesList();
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of policies.
     */
    int getPoliciesCount();
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The policies at the given index.
     */
    java.lang.String getPolicies(int index);
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the policies at the given index.
     */
    com.google.protobuf.ByteString getPoliciesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Criteria specific to the `AlertPolicy`s that this `Snooze` applies to. The
   * `Snooze` will suppress alerts that come from one of the `AlertPolicy`s
   * whose names are supplied.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Snooze.Criteria}
   */
  public static final class Criteria extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.Snooze.Criteria)
      CriteriaOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Criteria.newBuilder() to construct.
    private Criteria(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Criteria() {
      policies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Criteria();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.SnoozeProto
          .internal_static_google_monitoring_v3_Snooze_Criteria_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.SnoozeProto
          .internal_static_google_monitoring_v3_Snooze_Criteria_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Snooze.Criteria.class,
              com.google.monitoring.v3.Snooze.Criteria.Builder.class);
    }

    public static final int POLICIES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList policies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the policies.
     */
    public com.google.protobuf.ProtocolStringList getPoliciesList() {
      return policies_;
    }
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of policies.
     */
    public int getPoliciesCount() {
      return policies_.size();
    }
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The policies at the given index.
     */
    public java.lang.String getPolicies(int index) {
      return policies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The specific `AlertPolicy` names for the alert that should be snoozed.
     * The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
     *
     * There is a limit of 16 policies per snooze. This limit is checked during
     * snooze creation.
     * </pre>
     *
     * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the policies at the given index.
     */
    public com.google.protobuf.ByteString getPoliciesBytes(int index) {
      return policies_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < policies_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, policies_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < policies_.size(); i++) {
          dataSize += computeStringSizeNoTag(policies_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPoliciesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.Snooze.Criteria)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.Snooze.Criteria other =
          (com.google.monitoring.v3.Snooze.Criteria) obj;

      if (!getPoliciesList().equals(other.getPoliciesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPoliciesCount() > 0) {
        hash = (37 * hash) + POLICIES_FIELD_NUMBER;
        hash = (53 * hash) + getPoliciesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.Snooze.Criteria parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.monitoring.v3.Snooze.Criteria prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Criteria specific to the `AlertPolicy`s that this `Snooze` applies to. The
     * `Snooze` will suppress alerts that come from one of the `AlertPolicy`s
     * whose names are supplied.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.Snooze.Criteria}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Snooze.Criteria)
        com.google.monitoring.v3.Snooze.CriteriaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.SnoozeProto
            .internal_static_google_monitoring_v3_Snooze_Criteria_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.SnoozeProto
            .internal_static_google_monitoring_v3_Snooze_Criteria_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.Snooze.Criteria.class,
                com.google.monitoring.v3.Snooze.Criteria.Builder.class);
      }

      // Construct using com.google.monitoring.v3.Snooze.Criteria.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        policies_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.SnoozeProto
            .internal_static_google_monitoring_v3_Snooze_Criteria_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Snooze.Criteria getDefaultInstanceForType() {
        return com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.Snooze.Criteria build() {
        com.google.monitoring.v3.Snooze.Criteria result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.Snooze.Criteria buildPartial() {
        com.google.monitoring.v3.Snooze.Criteria result =
            new com.google.monitoring.v3.Snooze.Criteria(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.Snooze.Criteria result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          policies_.makeImmutable();
          result.policies_ = policies_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.Snooze.Criteria) {
          return mergeFrom((com.google.monitoring.v3.Snooze.Criteria) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.Snooze.Criteria other) {
        if (other == com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance()) return this;
        if (!other.policies_.isEmpty()) {
          if (policies_.isEmpty()) {
            policies_ = other.policies_;
            bitField0_ |= 0x00000001;
          } else {
            ensurePoliciesIsMutable();
            policies_.addAll(other.policies_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePoliciesIsMutable();
                  policies_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList policies_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePoliciesIsMutable() {
        if (!policies_.isModifiable()) {
          policies_ = new com.google.protobuf.LazyStringArrayList(policies_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return A list containing the policies.
       */
      public com.google.protobuf.ProtocolStringList getPoliciesList() {
        policies_.makeImmutable();
        return policies_;
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The count of policies.
       */
      public int getPoliciesCount() {
        return policies_.size();
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index of the element to return.
       * @return The policies at the given index.
       */
      public java.lang.String getPolicies(int index) {
        return policies_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the policies at the given index.
       */
      public com.google.protobuf.ByteString getPoliciesBytes(int index) {
        return policies_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param index The index to set the value at.
       * @param value The policies to set.
       * @return This builder for chaining.
       */
      public Builder setPolicies(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePoliciesIsMutable();
        policies_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The policies to add.
       * @return This builder for chaining.
       */
      public Builder addPolicies(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePoliciesIsMutable();
        policies_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param values The policies to add.
       * @return This builder for chaining.
       */
      public Builder addAllPolicies(java.lang.Iterable<java.lang.String> values) {
        ensurePoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, policies_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPolicies() {
        policies_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The specific `AlertPolicy` names for the alert that should be snoozed.
       * The format is:
       *
       *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]
       *
       * There is a limit of 16 policies per snooze. This limit is checked during
       * snooze creation.
       * </pre>
       *
       * <code>repeated string policies = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes of the policies to add.
       * @return This builder for chaining.
       */
      public Builder addPoliciesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePoliciesIsMutable();
        policies_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Snooze.Criteria)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.Snooze.Criteria)
    private static final com.google.monitoring.v3.Snooze.Criteria DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.Snooze.Criteria();
    }

    public static com.google.monitoring.v3.Snooze.Criteria getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Criteria> PARSER =
        new com.google.protobuf.AbstractParser<Criteria>() {
          @java.lang.Override
          public Criteria parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Criteria> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Criteria> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Snooze.Criteria getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the `Snooze`. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
   *
   * The ID of the `Snooze` will be generated by the system.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the `Snooze`. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
   *
   * The ID of the `Snooze` will be generated by the system.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CRITERIA_FIELD_NUMBER = 3;
  private com.google.monitoring.v3.Snooze.Criteria criteria_;
  /**
   *
   *
   * <pre>
   * Required. This defines the criteria for applying the `Snooze`. See
   * `Criteria` for more information.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the criteria field is set.
   */
  @java.lang.Override
  public boolean hasCriteria() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. This defines the criteria for applying the `Snooze`. See
   * `Criteria` for more information.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The criteria.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Snooze.Criteria getCriteria() {
    return criteria_ == null
        ? com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance()
        : criteria_;
  }
  /**
   *
   *
   * <pre>
   * Required. This defines the criteria for applying the `Snooze`. See
   * `Criteria` for more information.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Snooze.CriteriaOrBuilder getCriteriaOrBuilder() {
    return criteria_ == null
        ? com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance()
        : criteria_;
  }

  public static final int INTERVAL_FIELD_NUMBER = 4;
  private com.google.monitoring.v3.TimeInterval interval_;
  /**
   *
   *
   * <pre>
   * Required. The `Snooze` will be active from `interval.start_time` through
   * `interval.end_time`.
   * `interval.start_time` cannot be in the past. There is a 15 second clock
   * skew to account for the time it takes for a request to reach the API from
   * the UI.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the interval field is set.
   */
  @java.lang.Override
  public boolean hasInterval() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The `Snooze` will be active from `interval.start_time` through
   * `interval.end_time`.
   * `interval.start_time` cannot be in the past. There is a 15 second clock
   * skew to account for the time it takes for a request to reach the API from
   * the UI.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The interval.
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeInterval getInterval() {
    return interval_ == null
        ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
        : interval_;
  }
  /**
   *
   *
   * <pre>
   * Required. The `Snooze` will be active from `interval.start_time` through
   * `interval.end_time`.
   * `interval.start_time` cannot be in the past. There is a 15 second clock
   * skew to account for the time it takes for a request to reach the API from
   * the UI.
   * </pre>
   *
   * <code>
   * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.TimeIntervalOrBuilder getIntervalOrBuilder() {
    return interval_ == null
        ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
        : interval_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. A display name for the `Snooze`. This can be, at most, 512
   * unicode characters.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A display name for the `Snooze`. This can be, at most, 512
   * unicode characters.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCriteria());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getInterval());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCriteria());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInterval());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.Snooze)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.Snooze other = (com.google.monitoring.v3.Snooze) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCriteria() != other.hasCriteria()) return false;
    if (hasCriteria()) {
      if (!getCriteria().equals(other.getCriteria())) return false;
    }
    if (hasInterval() != other.hasInterval()) return false;
    if (hasInterval()) {
      if (!getInterval().equals(other.getInterval())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCriteria()) {
      hash = (37 * hash) + CRITERIA_FIELD_NUMBER;
      hash = (53 * hash) + getCriteria().hashCode();
    }
    if (hasInterval()) {
      hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getInterval().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.Snooze parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Snooze parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Snooze parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Snooze parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.Snooze prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `Snooze` will prevent any alerts from being opened, and close any that
   * are already open. The `Snooze` will work on alerts that match the
   * criteria defined in the `Snooze`. The `Snooze` will be active from
   * `interval.start_time` through `interval.end_time`.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Snooze}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Snooze)
      com.google.monitoring.v3.SnoozeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.SnoozeProto
          .internal_static_google_monitoring_v3_Snooze_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.SnoozeProto
          .internal_static_google_monitoring_v3_Snooze_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Snooze.class, com.google.monitoring.v3.Snooze.Builder.class);
    }

    // Construct using com.google.monitoring.v3.Snooze.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCriteriaFieldBuilder();
        getIntervalFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      criteria_ = null;
      if (criteriaBuilder_ != null) {
        criteriaBuilder_.dispose();
        criteriaBuilder_ = null;
      }
      interval_ = null;
      if (intervalBuilder_ != null) {
        intervalBuilder_.dispose();
        intervalBuilder_ = null;
      }
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.SnoozeProto
          .internal_static_google_monitoring_v3_Snooze_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Snooze getDefaultInstanceForType() {
      return com.google.monitoring.v3.Snooze.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.Snooze build() {
      com.google.monitoring.v3.Snooze result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Snooze buildPartial() {
      com.google.monitoring.v3.Snooze result = new com.google.monitoring.v3.Snooze(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.Snooze result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.criteria_ = criteriaBuilder_ == null ? criteria_ : criteriaBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.interval_ = intervalBuilder_ == null ? interval_ : intervalBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.Snooze) {
        return mergeFrom((com.google.monitoring.v3.Snooze) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.Snooze other) {
      if (other == com.google.monitoring.v3.Snooze.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCriteria()) {
        mergeCriteria(other.getCriteria());
      }
      if (other.hasInterval()) {
        mergeInterval(other.getInterval());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getCriteriaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the `Snooze`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
     *
     * The ID of the `Snooze` will be generated by the system.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Snooze`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
     *
     * The ID of the `Snooze` will be generated by the system.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Snooze`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
     *
     * The ID of the `Snooze` will be generated by the system.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Snooze`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
     *
     * The ID of the `Snooze` will be generated by the system.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Snooze`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
     *
     * The ID of the `Snooze` will be generated by the system.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.monitoring.v3.Snooze.Criteria criteria_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Snooze.Criteria,
            com.google.monitoring.v3.Snooze.Criteria.Builder,
            com.google.monitoring.v3.Snooze.CriteriaOrBuilder>
        criteriaBuilder_;
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the criteria field is set.
     */
    public boolean hasCriteria() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The criteria.
     */
    public com.google.monitoring.v3.Snooze.Criteria getCriteria() {
      if (criteriaBuilder_ == null) {
        return criteria_ == null
            ? com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance()
            : criteria_;
      } else {
        return criteriaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCriteria(com.google.monitoring.v3.Snooze.Criteria value) {
      if (criteriaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        criteria_ = value;
      } else {
        criteriaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCriteria(com.google.monitoring.v3.Snooze.Criteria.Builder builderForValue) {
      if (criteriaBuilder_ == null) {
        criteria_ = builderForValue.build();
      } else {
        criteriaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeCriteria(com.google.monitoring.v3.Snooze.Criteria value) {
      if (criteriaBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && criteria_ != null
            && criteria_ != com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance()) {
          getCriteriaBuilder().mergeFrom(value);
        } else {
          criteria_ = value;
        }
      } else {
        criteriaBuilder_.mergeFrom(value);
      }
      if (criteria_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearCriteria() {
      bitField0_ = (bitField0_ & ~0x00000002);
      criteria_ = null;
      if (criteriaBuilder_ != null) {
        criteriaBuilder_.dispose();
        criteriaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.Snooze.Criteria.Builder getCriteriaBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCriteriaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.Snooze.CriteriaOrBuilder getCriteriaOrBuilder() {
      if (criteriaBuilder_ != null) {
        return criteriaBuilder_.getMessageOrBuilder();
      } else {
        return criteria_ == null
            ? com.google.monitoring.v3.Snooze.Criteria.getDefaultInstance()
            : criteria_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. This defines the criteria for applying the `Snooze`. See
     * `Criteria` for more information.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.Snooze.Criteria criteria = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Snooze.Criteria,
            com.google.monitoring.v3.Snooze.Criteria.Builder,
            com.google.monitoring.v3.Snooze.CriteriaOrBuilder>
        getCriteriaFieldBuilder() {
      if (criteriaBuilder_ == null) {
        criteriaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Snooze.Criteria,
                com.google.monitoring.v3.Snooze.Criteria.Builder,
                com.google.monitoring.v3.Snooze.CriteriaOrBuilder>(
                getCriteria(), getParentForChildren(), isClean());
        criteria_ = null;
      }
      return criteriaBuilder_;
    }

    private com.google.monitoring.v3.TimeInterval interval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TimeInterval,
            com.google.monitoring.v3.TimeInterval.Builder,
            com.google.monitoring.v3.TimeIntervalOrBuilder>
        intervalBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the interval field is set.
     */
    public boolean hasInterval() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The interval.
     */
    public com.google.monitoring.v3.TimeInterval getInterval() {
      if (intervalBuilder_ == null) {
        return interval_ == null
            ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
            : interval_;
      } else {
        return intervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInterval(com.google.monitoring.v3.TimeInterval value) {
      if (intervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        interval_ = value;
      } else {
        intervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInterval(com.google.monitoring.v3.TimeInterval.Builder builderForValue) {
      if (intervalBuilder_ == null) {
        interval_ = builderForValue.build();
      } else {
        intervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInterval(com.google.monitoring.v3.TimeInterval value) {
      if (intervalBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && interval_ != null
            && interval_ != com.google.monitoring.v3.TimeInterval.getDefaultInstance()) {
          getIntervalBuilder().mergeFrom(value);
        } else {
          interval_ = value;
        }
      } else {
        intervalBuilder_.mergeFrom(value);
      }
      if (interval_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInterval() {
      bitField0_ = (bitField0_ & ~0x00000004);
      interval_ = null;
      if (intervalBuilder_ != null) {
        intervalBuilder_.dispose();
        intervalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeInterval.Builder getIntervalBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.TimeIntervalOrBuilder getIntervalOrBuilder() {
      if (intervalBuilder_ != null) {
        return intervalBuilder_.getMessageOrBuilder();
      } else {
        return interval_ == null
            ? com.google.monitoring.v3.TimeInterval.getDefaultInstance()
            : interval_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` will be active from `interval.start_time` through
     * `interval.end_time`.
     * `interval.start_time` cannot be in the past. There is a 15 second clock
     * skew to account for the time it takes for a request to reach the API from
     * the UI.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.TimeInterval interval = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.TimeInterval,
            com.google.monitoring.v3.TimeInterval.Builder,
            com.google.monitoring.v3.TimeIntervalOrBuilder>
        getIntervalFieldBuilder() {
      if (intervalBuilder_ == null) {
        intervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.TimeInterval,
                com.google.monitoring.v3.TimeInterval.Builder,
                com.google.monitoring.v3.TimeIntervalOrBuilder>(
                getInterval(), getParentForChildren(), isClean());
        interval_ = null;
      }
      return intervalBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. A display name for the `Snooze`. This can be, at most, 512
     * unicode characters.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A display name for the `Snooze`. This can be, at most, 512
     * unicode characters.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A display name for the `Snooze`. This can be, at most, 512
     * unicode characters.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A display name for the `Snooze`. This can be, at most, 512
     * unicode characters.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A display name for the `Snooze`. This can be, at most, 512
     * unicode characters.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Snooze)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.Snooze)
  private static final com.google.monitoring.v3.Snooze DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.Snooze();
  }

  public static com.google.monitoring.v3.Snooze getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Snooze> PARSER =
      new com.google.protobuf.AbstractParser<Snooze>() {
        @java.lang.Override
        public Snooze parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Snooze> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Snooze> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.Snooze getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
