/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/metric.proto

// Protobuf Java Version: 3.25.5
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A collection of data points that describes the time-varying values
 * of a metric. A time series is identified by a combination of a
 * fully-specified monitored resource and a fully-specified metric.
 * This type is used for both listing and creating time series.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.TimeSeries}
 */
public final class TimeSeries extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.TimeSeries)
    TimeSeriesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TimeSeries.newBuilder() to construct.
  private TimeSeries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TimeSeries() {
    metricKind_ = 0;
    valueType_ = 0;
    points_ = java.util.Collections.emptyList();
    unit_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TimeSeries();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TimeSeries_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.MetricProto
        .internal_static_google_monitoring_v3_TimeSeries_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.TimeSeries.class,
            com.google.monitoring.v3.TimeSeries.Builder.class);
  }

  private int bitField0_;
  public static final int METRIC_FIELD_NUMBER = 1;
  private com.google.api.Metric metric_;
  /**
   *
   *
   * <pre>
   * The associated metric. A fully-specified metric used to identify the time
   * series.
   * </pre>
   *
   * <code>.google.api.Metric metric = 1;</code>
   *
   * @return Whether the metric field is set.
   */
  @java.lang.Override
  public boolean hasMetric() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The associated metric. A fully-specified metric used to identify the time
   * series.
   * </pre>
   *
   * <code>.google.api.Metric metric = 1;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public com.google.api.Metric getMetric() {
    return metric_ == null ? com.google.api.Metric.getDefaultInstance() : metric_;
  }
  /**
   *
   *
   * <pre>
   * The associated metric. A fully-specified metric used to identify the time
   * series.
   * </pre>
   *
   * <code>.google.api.Metric metric = 1;</code>
   */
  @java.lang.Override
  public com.google.api.MetricOrBuilder getMetricOrBuilder() {
    return metric_ == null ? com.google.api.Metric.getDefaultInstance() : metric_;
  }

  public static final int RESOURCE_FIELD_NUMBER = 2;
  private com.google.api.MonitoredResource resource_;
  /**
   *
   *
   * <pre>
   * The associated monitored resource.  Custom metrics can use only certain
   * monitored resource types in their time series data. For more information,
   * see [Monitored resources for custom
   * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 2;</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The associated monitored resource.  Custom metrics can use only certain
   * monitored resource types in their time series data. For more information,
   * see [Monitored resources for custom
   * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 2;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.api.MonitoredResource getResource() {
    return resource_ == null ? com.google.api.MonitoredResource.getDefaultInstance() : resource_;
  }
  /**
   *
   *
   * <pre>
   * The associated monitored resource.  Custom metrics can use only certain
   * monitored resource types in their time series data. For more information,
   * see [Monitored resources for custom
   * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 2;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceOrBuilder getResourceOrBuilder() {
    return resource_ == null ? com.google.api.MonitoredResource.getDefaultInstance() : resource_;
  }

  public static final int METADATA_FIELD_NUMBER = 7;
  private com.google.api.MonitoredResourceMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Output only. The associated monitored resource metadata. When reading a
   * time series, this field will include metadata labels that are explicitly
   * named in the reduction. When creating a time series, this field is ignored.
   * </pre>
   *
   * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The associated monitored resource metadata. When reading a
   * time series, this field will include metadata labels that are explicitly
   * named in the reduction. When creating a time series, this field is ignored.
   * </pre>
   *
   * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceMetadata getMetadata() {
    return metadata_ == null
        ? com.google.api.MonitoredResourceMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The associated monitored resource metadata. When reading a
   * time series, this field will include metadata labels that are explicitly
   * named in the reduction. When creating a time series, this field is ignored.
   * </pre>
   *
   * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.api.MonitoredResourceMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int METRIC_KIND_FIELD_NUMBER = 3;
  private int metricKind_ = 0;
  /**
   *
   *
   * <pre>
   * The metric kind of the time series. When listing time series, this metric
   * kind might be different from the metric kind of the associated metric if
   * this time series is an alignment or reduction of other time series.
   *
   * When creating a time series, this field is optional. If present, it must be
   * the same as the metric kind of the associated metric. If the associated
   * metric's descriptor must be auto-created, then this field specifies the
   * metric kind of the new descriptor and must be either `GAUGE` (the default)
   * or `CUMULATIVE`.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
   *
   * @return The enum numeric value on the wire for metricKind.
   */
  @java.lang.Override
  public int getMetricKindValue() {
    return metricKind_;
  }
  /**
   *
   *
   * <pre>
   * The metric kind of the time series. When listing time series, this metric
   * kind might be different from the metric kind of the associated metric if
   * this time series is an alignment or reduction of other time series.
   *
   * When creating a time series, this field is optional. If present, it must be
   * the same as the metric kind of the associated metric. If the associated
   * metric's descriptor must be auto-created, then this field specifies the
   * metric kind of the new descriptor and must be either `GAUGE` (the default)
   * or `CUMULATIVE`.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
   *
   * @return The metricKind.
   */
  @java.lang.Override
  public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
    com.google.api.MetricDescriptor.MetricKind result =
        com.google.api.MetricDescriptor.MetricKind.forNumber(metricKind_);
    return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
  }

  public static final int VALUE_TYPE_FIELD_NUMBER = 4;
  private int valueType_ = 0;
  /**
   *
   *
   * <pre>
   * The value type of the time series. When listing time series, this value
   * type might be different from the value type of the associated metric if
   * this time series is an alignment or reduction of other time series.
   *
   * When creating a time series, this field is optional. If present, it must be
   * the same as the type of the data in the `points` field.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
   *
   * @return The enum numeric value on the wire for valueType.
   */
  @java.lang.Override
  public int getValueTypeValue() {
    return valueType_;
  }
  /**
   *
   *
   * <pre>
   * The value type of the time series. When listing time series, this value
   * type might be different from the value type of the associated metric if
   * this time series is an alignment or reduction of other time series.
   *
   * When creating a time series, this field is optional. If present, it must be
   * the same as the type of the data in the `points` field.
   * </pre>
   *
   * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
   *
   * @return The valueType.
   */
  @java.lang.Override
  public com.google.api.MetricDescriptor.ValueType getValueType() {
    com.google.api.MetricDescriptor.ValueType result =
        com.google.api.MetricDescriptor.ValueType.forNumber(valueType_);
    return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
  }

  public static final int POINTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.Point> points_;
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.Point> getPointsList() {
    return points_;
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.monitoring.v3.PointOrBuilder>
      getPointsOrBuilderList() {
    return points_;
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  @java.lang.Override
  public int getPointsCount() {
    return points_.size();
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.Point getPoints(int index) {
    return points_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The data points of this time series. When listing time series, points are
   * returned in reverse time order.
   *
   * When creating a time series, this field must contain exactly one point and
   * the point's type must be the same as the value type of the associated
   * metric. If the associated metric's descriptor must be auto-created, then
   * the value type of the descriptor is determined by the point's type, which
   * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.Point points = 5;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.PointOrBuilder getPointsOrBuilder(int index) {
    return points_.get(index);
  }

  public static final int UNIT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object unit_ = "";
  /**
   *
   *
   * <pre>
   * The units in which the metric value is reported. It is only applicable
   * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
   * defines the representation of the stored metric values.
   * </pre>
   *
   * <code>string unit = 8;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The units in which the metric value is reported. It is only applicable
   * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
   * defines the representation of the stored metric values.
   * </pre>
   *
   * <code>string unit = 8;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getMetric());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getResource());
    }
    if (metricKind_
        != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, metricKind_);
    }
    if (valueType_
        != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, valueType_);
    }
    for (int i = 0; i < points_.size(); i++) {
      output.writeMessage(5, points_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, unit_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetric());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResource());
    }
    if (metricKind_
        != com.google.api.MetricDescriptor.MetricKind.METRIC_KIND_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, metricKind_);
    }
    if (valueType_
        != com.google.api.MetricDescriptor.ValueType.VALUE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, valueType_);
    }
    for (int i = 0; i < points_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, points_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, unit_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.TimeSeries)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.TimeSeries other = (com.google.monitoring.v3.TimeSeries) obj;

    if (hasMetric() != other.hasMetric()) return false;
    if (hasMetric()) {
      if (!getMetric().equals(other.getMetric())) return false;
    }
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (metricKind_ != other.metricKind_) return false;
    if (valueType_ != other.valueType_) return false;
    if (!getPointsList().equals(other.getPointsList())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMetric()) {
      hash = (37 * hash) + METRIC_FIELD_NUMBER;
      hash = (53 * hash) + getMetric().hashCode();
    }
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (37 * hash) + METRIC_KIND_FIELD_NUMBER;
    hash = (53 * hash) + metricKind_;
    hash = (37 * hash) + VALUE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + valueType_;
    if (getPointsCount() > 0) {
      hash = (37 * hash) + POINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPointsList().hashCode();
    }
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeries parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeries parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.TimeSeries parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.TimeSeries prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A collection of data points that describes the time-varying values
   * of a metric. A time series is identified by a combination of a
   * fully-specified monitored resource and a fully-specified metric.
   * This type is used for both listing and creating time series.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.TimeSeries}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.TimeSeries)
      com.google.monitoring.v3.TimeSeriesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeries_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeries_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.TimeSeries.class,
              com.google.monitoring.v3.TimeSeries.Builder.class);
    }

    // Construct using com.google.monitoring.v3.TimeSeries.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetricFieldBuilder();
        getResourceFieldBuilder();
        getMetadataFieldBuilder();
        getPointsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      metric_ = null;
      if (metricBuilder_ != null) {
        metricBuilder_.dispose();
        metricBuilder_ = null;
      }
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      metricKind_ = 0;
      valueType_ = 0;
      if (pointsBuilder_ == null) {
        points_ = java.util.Collections.emptyList();
      } else {
        points_ = null;
        pointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      unit_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.MetricProto
          .internal_static_google_monitoring_v3_TimeSeries_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeries getDefaultInstanceForType() {
      return com.google.monitoring.v3.TimeSeries.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeries build() {
      com.google.monitoring.v3.TimeSeries result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.TimeSeries buildPartial() {
      com.google.monitoring.v3.TimeSeries result = new com.google.monitoring.v3.TimeSeries(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.monitoring.v3.TimeSeries result) {
      if (pointsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          points_ = java.util.Collections.unmodifiableList(points_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.points_ = points_;
      } else {
        result.points_ = pointsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.TimeSeries result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.metric_ = metricBuilder_ == null ? metric_ : metricBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metricKind_ = metricKind_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.valueType_ = valueType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.unit_ = unit_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.TimeSeries) {
        return mergeFrom((com.google.monitoring.v3.TimeSeries) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.TimeSeries other) {
      if (other == com.google.monitoring.v3.TimeSeries.getDefaultInstance()) return this;
      if (other.hasMetric()) {
        mergeMetric(other.getMetric());
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.metricKind_ != 0) {
        setMetricKindValue(other.getMetricKindValue());
      }
      if (other.valueType_ != 0) {
        setValueTypeValue(other.getValueTypeValue());
      }
      if (pointsBuilder_ == null) {
        if (!other.points_.isEmpty()) {
          if (points_.isEmpty()) {
            points_ = other.points_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensurePointsIsMutable();
            points_.addAll(other.points_);
          }
          onChanged();
        }
      } else {
        if (!other.points_.isEmpty()) {
          if (pointsBuilder_.isEmpty()) {
            pointsBuilder_.dispose();
            pointsBuilder_ = null;
            points_ = other.points_;
            bitField0_ = (bitField0_ & ~0x00000020);
            pointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPointsFieldBuilder()
                    : null;
          } else {
            pointsBuilder_.addAllMessages(other.points_);
          }
        }
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMetricFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                metricKind_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 32:
              {
                valueType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                com.google.monitoring.v3.Point m =
                    input.readMessage(com.google.monitoring.v3.Point.parser(), extensionRegistry);
                if (pointsBuilder_ == null) {
                  ensurePointsIsMutable();
                  points_.add(m);
                } else {
                  pointsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            case 66:
              {
                unit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.api.Metric metric_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Metric, com.google.api.Metric.Builder, com.google.api.MetricOrBuilder>
        metricBuilder_;
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     *
     * @return Whether the metric field is set.
     */
    public boolean hasMetric() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     *
     * @return The metric.
     */
    public com.google.api.Metric getMetric() {
      if (metricBuilder_ == null) {
        return metric_ == null ? com.google.api.Metric.getDefaultInstance() : metric_;
      } else {
        return metricBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder setMetric(com.google.api.Metric value) {
      if (metricBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metric_ = value;
      } else {
        metricBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder setMetric(com.google.api.Metric.Builder builderForValue) {
      if (metricBuilder_ == null) {
        metric_ = builderForValue.build();
      } else {
        metricBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder mergeMetric(com.google.api.Metric value) {
      if (metricBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && metric_ != null
            && metric_ != com.google.api.Metric.getDefaultInstance()) {
          getMetricBuilder().mergeFrom(value);
        } else {
          metric_ = value;
        }
      } else {
        metricBuilder_.mergeFrom(value);
      }
      if (metric_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public Builder clearMetric() {
      bitField0_ = (bitField0_ & ~0x00000001);
      metric_ = null;
      if (metricBuilder_ != null) {
        metricBuilder_.dispose();
        metricBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public com.google.api.Metric.Builder getMetricBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getMetricFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    public com.google.api.MetricOrBuilder getMetricOrBuilder() {
      if (metricBuilder_ != null) {
        return metricBuilder_.getMessageOrBuilder();
      } else {
        return metric_ == null ? com.google.api.Metric.getDefaultInstance() : metric_;
      }
    }
    /**
     *
     *
     * <pre>
     * The associated metric. A fully-specified metric used to identify the time
     * series.
     * </pre>
     *
     * <code>.google.api.Metric metric = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Metric, com.google.api.Metric.Builder, com.google.api.MetricOrBuilder>
        getMetricFieldBuilder() {
      if (metricBuilder_ == null) {
        metricBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Metric,
                com.google.api.Metric.Builder,
                com.google.api.MetricOrBuilder>(getMetric(), getParentForChildren(), isClean());
        metric_ = null;
      }
      return metricBuilder_;
    }

    private com.google.api.MonitoredResource resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        resourceBuilder_;
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     *
     * @return The resource.
     */
    public com.google.api.MonitoredResource getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null
            ? com.google.api.MonitoredResource.getDefaultInstance()
            : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder setResource(com.google.api.MonitoredResource value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder setResource(com.google.api.MonitoredResource.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder mergeResource(com.google.api.MonitoredResource value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && resource_ != null
            && resource_ != com.google.api.MonitoredResource.getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      if (resource_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public com.google.api.MonitoredResource.Builder getResourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    public com.google.api.MonitoredResourceOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null
            ? com.google.api.MonitoredResource.getDefaultInstance()
            : resource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The associated monitored resource.  Custom metrics can use only certain
     * monitored resource types in their time series data. For more information,
     * see [Monitored resources for custom
     * metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MonitoredResource,
                com.google.api.MonitoredResource.Builder,
                com.google.api.MonitoredResourceOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private com.google.api.MonitoredResourceMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResourceMetadata,
            com.google.api.MonitoredResourceMetadata.Builder,
            com.google.api.MonitoredResourceMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     *
     * @return The metadata.
     */
    public com.google.api.MonitoredResourceMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.api.MonitoredResourceMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    public Builder setMetadata(com.google.api.MonitoredResourceMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    public Builder setMetadata(com.google.api.MonitoredResourceMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    public Builder mergeMetadata(com.google.api.MonitoredResourceMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && metadata_ != null
            && metadata_ != com.google.api.MonitoredResourceMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    public com.google.api.MonitoredResourceMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    public com.google.api.MonitoredResourceMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.api.MonitoredResourceMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The associated monitored resource metadata. When reading a
     * time series, this field will include metadata labels that are explicitly
     * named in the reduction. When creating a time series, this field is ignored.
     * </pre>
     *
     * <code>.google.api.MonitoredResourceMetadata metadata = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResourceMetadata,
            com.google.api.MonitoredResourceMetadata.Builder,
            com.google.api.MonitoredResourceMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MonitoredResourceMetadata,
                com.google.api.MonitoredResourceMetadata.Builder,
                com.google.api.MonitoredResourceMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private int metricKind_ = 0;
    /**
     *
     *
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The enum numeric value on the wire for metricKind.
     */
    @java.lang.Override
    public int getMetricKindValue() {
      return metricKind_;
    }
    /**
     *
     *
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @param value The enum numeric value on the wire for metricKind to set.
     * @return This builder for chaining.
     */
    public Builder setMetricKindValue(int value) {
      metricKind_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return The metricKind.
     */
    @java.lang.Override
    public com.google.api.MetricDescriptor.MetricKind getMetricKind() {
      com.google.api.MetricDescriptor.MetricKind result =
          com.google.api.MetricDescriptor.MetricKind.forNumber(metricKind_);
      return result == null ? com.google.api.MetricDescriptor.MetricKind.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @param value The metricKind to set.
     * @return This builder for chaining.
     */
    public Builder setMetricKind(com.google.api.MetricDescriptor.MetricKind value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      metricKind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metric kind of the time series. When listing time series, this metric
     * kind might be different from the metric kind of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the metric kind of the associated metric. If the associated
     * metric's descriptor must be auto-created, then this field specifies the
     * metric kind of the new descriptor and must be either `GAUGE` (the default)
     * or `CUMULATIVE`.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricKind() {
      bitField0_ = (bitField0_ & ~0x00000008);
      metricKind_ = 0;
      onChanged();
      return this;
    }

    private int valueType_ = 0;
    /**
     *
     *
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @return The enum numeric value on the wire for valueType.
     */
    @java.lang.Override
    public int getValueTypeValue() {
      return valueType_;
    }
    /**
     *
     *
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueTypeValue(int value) {
      valueType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @return The valueType.
     */
    @java.lang.Override
    public com.google.api.MetricDescriptor.ValueType getValueType() {
      com.google.api.MetricDescriptor.ValueType result =
          com.google.api.MetricDescriptor.ValueType.forNumber(valueType_);
      return result == null ? com.google.api.MetricDescriptor.ValueType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @param value The valueType to set.
     * @return This builder for chaining.
     */
    public Builder setValueType(com.google.api.MetricDescriptor.ValueType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      valueType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value type of the time series. When listing time series, this value
     * type might be different from the value type of the associated metric if
     * this time series is an alignment or reduction of other time series.
     *
     * When creating a time series, this field is optional. If present, it must be
     * the same as the type of the data in the `points` field.
     * </pre>
     *
     * <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      valueType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.monitoring.v3.Point> points_ =
        java.util.Collections.emptyList();

    private void ensurePointsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        points_ = new java.util.ArrayList<com.google.monitoring.v3.Point>(points_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.Point,
            com.google.monitoring.v3.Point.Builder,
            com.google.monitoring.v3.PointOrBuilder>
        pointsBuilder_;

    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public java.util.List<com.google.monitoring.v3.Point> getPointsList() {
      if (pointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(points_);
      } else {
        return pointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public int getPointsCount() {
      if (pointsBuilder_ == null) {
        return points_.size();
      } else {
        return pointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point getPoints(int index) {
      if (pointsBuilder_ == null) {
        return points_.get(index);
      } else {
        return pointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder setPoints(int index, com.google.monitoring.v3.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.set(index, value);
        onChanged();
      } else {
        pointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder setPoints(int index, com.google.monitoring.v3.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.set(index, builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(com.google.monitoring.v3.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.add(value);
        onChanged();
      } else {
        pointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(int index, com.google.monitoring.v3.Point value) {
      if (pointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePointsIsMutable();
        points_.add(index, value);
        onChanged();
      } else {
        pointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(com.google.monitoring.v3.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.add(builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addPoints(int index, com.google.monitoring.v3.Point.Builder builderForValue) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.add(index, builderForValue.build());
        onChanged();
      } else {
        pointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder addAllPoints(
        java.lang.Iterable<? extends com.google.monitoring.v3.Point> values) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, points_);
        onChanged();
      } else {
        pointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder clearPoints() {
      if (pointsBuilder_ == null) {
        points_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        pointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public Builder removePoints(int index) {
      if (pointsBuilder_ == null) {
        ensurePointsIsMutable();
        points_.remove(index);
        onChanged();
      } else {
        pointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point.Builder getPointsBuilder(int index) {
      return getPointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.PointOrBuilder getPointsOrBuilder(int index) {
      if (pointsBuilder_ == null) {
        return points_.get(index);
      } else {
        return pointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public java.util.List<? extends com.google.monitoring.v3.PointOrBuilder>
        getPointsOrBuilderList() {
      if (pointsBuilder_ != null) {
        return pointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(points_);
      }
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point.Builder addPointsBuilder() {
      return getPointsFieldBuilder()
          .addBuilder(com.google.monitoring.v3.Point.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public com.google.monitoring.v3.Point.Builder addPointsBuilder(int index) {
      return getPointsFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.Point.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The data points of this time series. When listing time series, points are
     * returned in reverse time order.
     *
     * When creating a time series, this field must contain exactly one point and
     * the point's type must be the same as the value type of the associated
     * metric. If the associated metric's descriptor must be auto-created, then
     * the value type of the descriptor is determined by the point's type, which
     * must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.Point points = 5;</code>
     */
    public java.util.List<com.google.monitoring.v3.Point.Builder> getPointsBuilderList() {
      return getPointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.Point,
            com.google.monitoring.v3.Point.Builder,
            com.google.monitoring.v3.PointOrBuilder>
        getPointsFieldBuilder() {
      if (pointsBuilder_ == null) {
        pointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.Point,
                com.google.monitoring.v3.Point.Builder,
                com.google.monitoring.v3.PointOrBuilder>(
                points_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        points_ = null;
      }
      return pointsBuilder_;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * </pre>
     *
     * <code>string unit = 8;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * </pre>
     *
     * <code>string unit = 8;</code>
     *
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * </pre>
     *
     * <code>string unit = 8;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      unit_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * </pre>
     *
     * <code>string unit = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {
      unit_ = getDefaultInstance().getUnit();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
     * defines the representation of the stored metric values.
     * </pre>
     *
     * <code>string unit = 8;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      unit_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.TimeSeries)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.TimeSeries)
  private static final com.google.monitoring.v3.TimeSeries DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.TimeSeries();
  }

  public static com.google.monitoring.v3.TimeSeries getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TimeSeries> PARSER =
      new com.google.protobuf.AbstractParser<TimeSeries>() {
        @java.lang.Override
        public TimeSeries parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TimeSeries> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TimeSeries> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.TimeSeries getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
