/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * A policy that specifies how Cloud Pub/Sub retries message delivery.
 * Retry delay will be exponential based on provided minimum and maximum
 * backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
 * RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded
 * events for a given message.
 * Retry Policy is implemented on a best effort basis. At times, the delay
 * between consecutive deliveries may not match the configuration. That is,
 * delay can be more or less than configured backoff.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.RetryPolicy}
 */
public final class RetryPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.RetryPolicy)
    RetryPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetryPolicy.newBuilder() to construct.
  private RetryPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryPolicy() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryPolicy();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto.internal_static_google_pubsub_v1_RetryPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_RetryPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.RetryPolicy.class, com.google.pubsub.v1.RetryPolicy.Builder.class);
  }

  public static final int MINIMUM_BACKOFF_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration minimumBackoff_;
  /**
   *
   *
   * <pre>
   * The minimum delay between consecutive deliveries of a given message.
   * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
   *
   * @return Whether the minimumBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMinimumBackoff() {
    return minimumBackoff_ != null;
  }
  /**
   *
   *
   * <pre>
   * The minimum delay between consecutive deliveries of a given message.
   * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
   *
   * @return The minimumBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMinimumBackoff() {
    return minimumBackoff_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : minimumBackoff_;
  }
  /**
   *
   *
   * <pre>
   * The minimum delay between consecutive deliveries of a given message.
   * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMinimumBackoffOrBuilder() {
    return getMinimumBackoff();
  }

  public static final int MAXIMUM_BACKOFF_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration maximumBackoff_;
  /**
   *
   *
   * <pre>
   * The maximum delay between consecutive deliveries of a given message.
   * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
   *
   * @return Whether the maximumBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMaximumBackoff() {
    return maximumBackoff_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum delay between consecutive deliveries of a given message.
   * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
   *
   * @return The maximumBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaximumBackoff() {
    return maximumBackoff_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maximumBackoff_;
  }
  /**
   *
   *
   * <pre>
   * The maximum delay between consecutive deliveries of a given message.
   * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaximumBackoffOrBuilder() {
    return getMaximumBackoff();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (minimumBackoff_ != null) {
      output.writeMessage(1, getMinimumBackoff());
    }
    if (maximumBackoff_ != null) {
      output.writeMessage(2, getMaximumBackoff());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (minimumBackoff_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMinimumBackoff());
    }
    if (maximumBackoff_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaximumBackoff());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.RetryPolicy)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.RetryPolicy other = (com.google.pubsub.v1.RetryPolicy) obj;

    if (hasMinimumBackoff() != other.hasMinimumBackoff()) return false;
    if (hasMinimumBackoff()) {
      if (!getMinimumBackoff().equals(other.getMinimumBackoff())) return false;
    }
    if (hasMaximumBackoff() != other.hasMaximumBackoff()) return false;
    if (hasMaximumBackoff()) {
      if (!getMaximumBackoff().equals(other.getMaximumBackoff())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMinimumBackoff()) {
      hash = (37 * hash) + MINIMUM_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMinimumBackoff().hashCode();
    }
    if (hasMaximumBackoff()) {
      hash = (37 * hash) + MAXIMUM_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMaximumBackoff().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.RetryPolicy parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.RetryPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.RetryPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.RetryPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies how Cloud Pub/Sub retries message delivery.
   * Retry delay will be exponential based on provided minimum and maximum
   * backoffs. https://en.wikipedia.org/wiki/Exponential_backoff.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline exceeded
   * events for a given message.
   * Retry Policy is implemented on a best effort basis. At times, the delay
   * between consecutive deliveries may not match the configuration. That is,
   * delay can be more or less than configured backoff.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.RetryPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.RetryPolicy)
      com.google.pubsub.v1.RetryPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_RetryPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_RetryPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.RetryPolicy.class,
              com.google.pubsub.v1.RetryPolicy.Builder.class);
    }

    // Construct using com.google.pubsub.v1.RetryPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (minimumBackoffBuilder_ == null) {
        minimumBackoff_ = null;
      } else {
        minimumBackoff_ = null;
        minimumBackoffBuilder_ = null;
      }
      if (maximumBackoffBuilder_ == null) {
        maximumBackoff_ = null;
      } else {
        maximumBackoff_ = null;
        maximumBackoffBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_RetryPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.RetryPolicy getDefaultInstanceForType() {
      return com.google.pubsub.v1.RetryPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.RetryPolicy build() {
      com.google.pubsub.v1.RetryPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.RetryPolicy buildPartial() {
      com.google.pubsub.v1.RetryPolicy result = new com.google.pubsub.v1.RetryPolicy(this);
      if (minimumBackoffBuilder_ == null) {
        result.minimumBackoff_ = minimumBackoff_;
      } else {
        result.minimumBackoff_ = minimumBackoffBuilder_.build();
      }
      if (maximumBackoffBuilder_ == null) {
        result.maximumBackoff_ = maximumBackoff_;
      } else {
        result.maximumBackoff_ = maximumBackoffBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.RetryPolicy) {
        return mergeFrom((com.google.pubsub.v1.RetryPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.RetryPolicy other) {
      if (other == com.google.pubsub.v1.RetryPolicy.getDefaultInstance()) return this;
      if (other.hasMinimumBackoff()) {
        mergeMinimumBackoff(other.getMinimumBackoff());
      }
      if (other.hasMaximumBackoff()) {
        mergeMaximumBackoff(other.getMaximumBackoff());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMinimumBackoffFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMaximumBackoffFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.protobuf.Duration minimumBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        minimumBackoffBuilder_;
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     *
     * @return Whether the minimumBackoff field is set.
     */
    public boolean hasMinimumBackoff() {
      return minimumBackoffBuilder_ != null || minimumBackoff_ != null;
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     *
     * @return The minimumBackoff.
     */
    public com.google.protobuf.Duration getMinimumBackoff() {
      if (minimumBackoffBuilder_ == null) {
        return minimumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minimumBackoff_;
      } else {
        return minimumBackoffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    public Builder setMinimumBackoff(com.google.protobuf.Duration value) {
      if (minimumBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minimumBackoff_ = value;
        onChanged();
      } else {
        minimumBackoffBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    public Builder setMinimumBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (minimumBackoffBuilder_ == null) {
        minimumBackoff_ = builderForValue.build();
        onChanged();
      } else {
        minimumBackoffBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    public Builder mergeMinimumBackoff(com.google.protobuf.Duration value) {
      if (minimumBackoffBuilder_ == null) {
        if (minimumBackoff_ != null) {
          minimumBackoff_ =
              com.google.protobuf.Duration.newBuilder(minimumBackoff_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          minimumBackoff_ = value;
        }
        onChanged();
      } else {
        minimumBackoffBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    public Builder clearMinimumBackoff() {
      if (minimumBackoffBuilder_ == null) {
        minimumBackoff_ = null;
        onChanged();
      } else {
        minimumBackoff_ = null;
        minimumBackoffBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    public com.google.protobuf.Duration.Builder getMinimumBackoffBuilder() {

      onChanged();
      return getMinimumBackoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMinimumBackoffOrBuilder() {
      if (minimumBackoffBuilder_ != null) {
        return minimumBackoffBuilder_.getMessageOrBuilder();
      } else {
        return minimumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minimumBackoff_;
      }
    }
    /**
     *
     *
     * <pre>
     * The minimum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 10 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration minimum_backoff = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMinimumBackoffFieldBuilder() {
      if (minimumBackoffBuilder_ == null) {
        minimumBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMinimumBackoff(), getParentForChildren(), isClean());
        minimumBackoff_ = null;
      }
      return minimumBackoffBuilder_;
    }

    private com.google.protobuf.Duration maximumBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maximumBackoffBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     *
     * @return Whether the maximumBackoff field is set.
     */
    public boolean hasMaximumBackoff() {
      return maximumBackoffBuilder_ != null || maximumBackoff_ != null;
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     *
     * @return The maximumBackoff.
     */
    public com.google.protobuf.Duration getMaximumBackoff() {
      if (maximumBackoffBuilder_ == null) {
        return maximumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maximumBackoff_;
      } else {
        return maximumBackoffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    public Builder setMaximumBackoff(com.google.protobuf.Duration value) {
      if (maximumBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maximumBackoff_ = value;
        onChanged();
      } else {
        maximumBackoffBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    public Builder setMaximumBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (maximumBackoffBuilder_ == null) {
        maximumBackoff_ = builderForValue.build();
        onChanged();
      } else {
        maximumBackoffBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    public Builder mergeMaximumBackoff(com.google.protobuf.Duration value) {
      if (maximumBackoffBuilder_ == null) {
        if (maximumBackoff_ != null) {
          maximumBackoff_ =
              com.google.protobuf.Duration.newBuilder(maximumBackoff_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          maximumBackoff_ = value;
        }
        onChanged();
      } else {
        maximumBackoffBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    public Builder clearMaximumBackoff() {
      if (maximumBackoffBuilder_ == null) {
        maximumBackoff_ = null;
        onChanged();
      } else {
        maximumBackoff_ = null;
        maximumBackoffBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getMaximumBackoffBuilder() {

      onChanged();
      return getMaximumBackoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaximumBackoffOrBuilder() {
      if (maximumBackoffBuilder_ != null) {
        return maximumBackoffBuilder_.getMessageOrBuilder();
      } else {
        return maximumBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maximumBackoff_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum delay between consecutive deliveries of a given message.
     * Value should be between 0 and 600 seconds. Defaults to 600 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration maximum_backoff = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaximumBackoffFieldBuilder() {
      if (maximumBackoffBuilder_ == null) {
        maximumBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaximumBackoff(), getParentForChildren(), isClean());
        maximumBackoff_ = null;
      }
      return maximumBackoffBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.RetryPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.RetryPolicy)
  private static final com.google.pubsub.v1.RetryPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.RetryPolicy();
  }

  public static com.google.pubsub.v1.RetryPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryPolicy> PARSER =
      new com.google.protobuf.AbstractParser<RetryPolicy>() {
        @java.lang.Override
        public RetryPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetryPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.RetryPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
