/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopicName
implements ResourceName {
    private static final PathTemplate PROJECT_TOPIC = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/topics/{topic}");
    private static final String DELETED_TOPIC = "_deleted-topic_";
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String topic;

    @Deprecated
    protected TopicName() {
        this.project = null;
        this.topic = null;
    }

    private TopicName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.topic = (String)Preconditions.checkNotNull((Object)builder.getTopic());
        this.pathTemplate = PROJECT_TOPIC;
    }

    private TopicName(String fixedValue) {
        this.fixedValue = fixedValue;
        this.fieldValuesMap = ImmutableMap.of((Object)"", (Object)fixedValue);
        this.project = null;
        this.topic = null;
    }

    public String getProject() {
        return this.project;
    }

    public String getTopic() {
        return this.topic;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectTopicBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TopicName of(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build();
    }

    public static TopicName ofProjectTopicName(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build();
    }

    public static TopicName ofDeletedTopicName() {
        return new TopicName(DELETED_TOPIC);
    }

    public static String format(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build().toString();
    }

    public static String formatProjectTopicName(String project, String topic) {
        return TopicName.newBuilder().setProject(project).setTopic(topic).build().toString();
    }

    public static String formatDeletedTopicName() {
        return DELETED_TOPIC;
    }

    public static TopicName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_TOPIC.matches(formattedString)) {
            Map matchMap = PROJECT_TOPIC.match(formattedString);
            return TopicName.ofProjectTopicName((String)matchMap.get("project"), (String)matchMap.get("topic"));
        }
        if (DELETED_TOPIC.equals(formattedString)) {
            return new TopicName(DELETED_TOPIC);
        }
        throw new ValidationException("TopicName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<TopicName> parseList(List<String> formattedStrings) {
        ArrayList<TopicName> list = new ArrayList<TopicName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TOPIC.matches(formattedString) || DELETED_TOPIC.equals(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicName topicName = this;
            synchronized (topicName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.topic != null) {
                        fieldMapBuilder.put((Object)"topic", (Object)this.topic);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TopicName that = (TopicName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.topic, that.topic);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.topic);
    }

    public static class Builder {
        private String project;
        private String topic;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        private Builder(TopicName topicName) {
            Preconditions.checkArgument((boolean)Objects.equals(topicName.pathTemplate, PROJECT_TOPIC), (Object)"toBuilder is only supported when TopicName has the pattern of projects/{project}/topics/{topic}");
            this.project = topicName.project;
            this.topic = topicName.topic;
        }

        public TopicName build() {
            return new TopicName(this);
        }
    }
}

