/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.8
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Settings for an ingestion data source on a topic.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings}
 */
public final class IngestionDataSourceSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings)
    IngestionDataSourceSettingsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use IngestionDataSourceSettings.newBuilder() to construct.
  private IngestionDataSourceSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IngestionDataSourceSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IngestionDataSourceSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionDataSourceSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.IngestionDataSourceSettings.class,
            com.google.pubsub.v1.IngestionDataSourceSettings.Builder.class);
  }

  public interface AwsKinesisOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamArn.
     */
    java.lang.String getStreamArn();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for streamArn.
     */
    com.google.protobuf.ByteString getStreamArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consumerArn.
     */
    java.lang.String getConsumerArn();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consumerArn.
     */
    com.google.protobuf.ByteString getConsumerArnBytes();

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    java.lang.String getAwsRoleArn();

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    com.google.protobuf.ByteString getAwsRoleArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    java.lang.String getGcpServiceAccount();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    com.google.protobuf.ByteString getGcpServiceAccountBytes();
  }

  /**
   *
   *
   * <pre>
   * Ingestion settings for Amazon Kinesis Data Streams.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis}
   */
  public static final class AwsKinesis extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
      AwsKinesisOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AwsKinesis.newBuilder() to construct.
    private AwsKinesis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsKinesis() {
      state_ = 0;
      streamArn_ = "";
      consumerArn_ = "";
      awsRoleArn_ = "";
      gcpServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsKinesis();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for ingestion from Amazon Kinesis Data Streams.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Kinesis.
       * This can happen if:
       *   - The provided `aws_role_arn` does not exist or does not have the
       *     appropriate permissions attached.
       *   - The provided `aws_role_arn` is not set up properly for Identity
       *     Federation using `gcp_service_account`.
       *   - The Pub/Sub SA is not granted the
       *     `iam.serviceAccounts.getOpenIdToken` permission on
       *     `gcp_service_account`.
       * </pre>
       *
       * <code>KINESIS_PERMISSION_DENIED = 2;</code>
       */
      KINESIS_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The Kinesis stream does not exist.
       * </pre>
       *
       * <code>STREAM_NOT_FOUND = 4;</code>
       */
      STREAM_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The Kinesis consumer does not exist.
       * </pre>
       *
       * <code>CONSUMER_NOT_FOUND = 5;</code>
       */
      CONSUMER_NOT_FOUND(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Kinesis.
       * This can happen if:
       *   - The provided `aws_role_arn` does not exist or does not have the
       *     appropriate permissions attached.
       *   - The provided `aws_role_arn` is not set up properly for Identity
       *     Federation using `gcp_service_account`.
       *   - The Pub/Sub SA is not granted the
       *     `iam.serviceAccounts.getOpenIdToken` permission on
       *     `gcp_service_account`.
       * </pre>
       *
       * <code>KINESIS_PERMISSION_DENIED = 2;</code>
       */
      public static final int KINESIS_PERMISSION_DENIED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The Kinesis stream does not exist.
       * </pre>
       *
       * <code>STREAM_NOT_FOUND = 4;</code>
       */
      public static final int STREAM_NOT_FOUND_VALUE = 4;

      /**
       *
       *
       * <pre>
       * The Kinesis consumer does not exist.
       * </pre>
       *
       * <code>CONSUMER_NOT_FOUND = 5;</code>
       */
      public static final int CONSUMER_NOT_FOUND_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return KINESIS_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return STREAM_NOT_FOUND;
          case 5:
            return CONSUMER_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.UNRECOGNIZED
          : result;
    }

    public static final int STREAM_ARN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object streamArn_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamArn.
     */
    @java.lang.Override
    public java.lang.String getStreamArn() {
      java.lang.Object ref = streamArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        streamArn_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for streamArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStreamArnBytes() {
      java.lang.Object ref = streamArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        streamArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONSUMER_ARN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object consumerArn_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consumerArn.
     */
    @java.lang.Override
    public java.lang.String getConsumerArn() {
      java.lang.Object ref = consumerArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consumerArn_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consumerArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConsumerArnBytes() {
      java.lang.Object ref = consumerArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        consumerArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AWS_ROLE_ARN_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object awsRoleArn_ = "";

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    @java.lang.Override
    public java.lang.String getAwsRoleArn() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        awsRoleArn_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAwsRoleArnBytes() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        awsRoleArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCP_SERVICE_ACCOUNT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcpServiceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getGcpServiceAccount() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccount_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(streamArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, streamArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consumerArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, consumerArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, gcpServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(streamArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, streamArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consumerArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, consumerArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, gcpServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) obj;

      if (state_ != other.state_) return false;
      if (!getStreamArn().equals(other.getStreamArn())) return false;
      if (!getConsumerArn().equals(other.getConsumerArn())) return false;
      if (!getAwsRoleArn().equals(other.getAwsRoleArn())) return false;
      if (!getGcpServiceAccount().equals(other.getGcpServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + STREAM_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getStreamArn().hashCode();
      hash = (37 * hash) + CONSUMER_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerArn().hashCode();
      hash = (37 * hash) + AWS_ROLE_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getAwsRoleArn().hashCode();
      hash = (37 * hash) + GCP_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGcpServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Ingestion settings for Amazon Kinesis Data Streams.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        streamArn_ = "";
        consumerArn_ = "";
        awsRoleArn_ = "";
        gcpServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.streamArn_ = streamArn_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.consumerArn_ = consumerArn_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.awsRoleArn_ = awsRoleArn_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.gcpServiceAccount_ = gcpServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getStreamArn().isEmpty()) {
          streamArn_ = other.streamArn_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getConsumerArn().isEmpty()) {
          consumerArn_ = other.consumerArn_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getAwsRoleArn().isEmpty()) {
          awsRoleArn_ = other.awsRoleArn_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getGcpServiceAccount().isEmpty()) {
          gcpServiceAccount_ = other.gcpServiceAccount_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  streamArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  consumerArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  awsRoleArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  gcpServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object streamArn_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The streamArn.
       */
      public java.lang.String getStreamArn() {
        java.lang.Object ref = streamArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          streamArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for streamArn.
       */
      public com.google.protobuf.ByteString getStreamArnBytes() {
        java.lang.Object ref = streamArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          streamArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The streamArn to set.
       * @return This builder for chaining.
       */
      public Builder setStreamArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStreamArn() {
        streamArn_ = getDefaultInstance().getStreamArn();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for streamArn to set.
       * @return This builder for chaining.
       */
      public Builder setStreamArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        streamArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object consumerArn_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The consumerArn.
       */
      public java.lang.String getConsumerArn() {
        java.lang.Object ref = consumerArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          consumerArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for consumerArn.
       */
      public com.google.protobuf.ByteString getConsumerArnBytes() {
        java.lang.Object ref = consumerArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          consumerArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The consumerArn to set.
       * @return This builder for chaining.
       */
      public Builder setConsumerArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        consumerArn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConsumerArn() {
        consumerArn_ = getDefaultInstance().getConsumerArn();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for consumerArn to set.
       * @return This builder for chaining.
       */
      public Builder setConsumerArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        consumerArn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object awsRoleArn_ = "";

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The awsRoleArn.
       */
      public java.lang.String getAwsRoleArn() {
        java.lang.Object ref = awsRoleArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          awsRoleArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for awsRoleArn.
       */
      public com.google.protobuf.ByteString getAwsRoleArnBytes() {
        java.lang.Object ref = awsRoleArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          awsRoleArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAwsRoleArn() {
        awsRoleArn_ = getDefaultInstance().getAwsRoleArn();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object gcpServiceAccount_ = "";

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcpServiceAccount.
       */
      public java.lang.String getGcpServiceAccount() {
        java.lang.Object ref = gcpServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcpServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcpServiceAccount.
       */
      public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
        java.lang.Object ref = gcpServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcpServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcpServiceAccount() {
        gcpServiceAccount_ = getDefaultInstance().getGcpServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsKinesis> PARSER =
        new com.google.protobuf.AbstractParser<AwsKinesis>() {
          @java.lang.Override
          public AwsKinesis parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsKinesis> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsKinesis> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CloudStorageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State getState();

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    java.lang.String getBucket();

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucket.
     */
    com.google.protobuf.ByteString getBucketBytes();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the textFormat field is set.
     */
    boolean hasTextFormat();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The textFormat.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat getTextFormat();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder
        getTextFormatOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroFormat field is set.
     */
    boolean hasAvroFormat();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroFormat.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat getAvroFormat();

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder
        getAvroFormatOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pubsubAvroFormat field is set.
     */
    boolean hasPubsubAvroFormat();

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pubsubAvroFormat.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
        getPubsubAvroFormat();

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder
        getPubsubAvroFormatOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the minimumObjectCreateTime field is set.
     */
    boolean hasMinimumObjectCreateTime();

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The minimumObjectCreateTime.
     */
    com.google.protobuf.Timestamp getMinimumObjectCreateTime();

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getMinimumObjectCreateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The matchGlob.
     */
    java.lang.String getMatchGlob();

    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for matchGlob.
     */
    com.google.protobuf.ByteString getMatchGlobBytes();

    com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.InputFormatCase
        getInputFormatCase();
  }

  /**
   *
   *
   * <pre>
   * Ingestion settings for Cloud Storage.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage}
   */
  public static final class CloudStorage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
      CloudStorageOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CloudStorage.newBuilder() to construct.
    private CloudStorage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudStorage() {
      state_ = 0;
      bucket_ = "";
      matchGlob_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudStorage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for ingestion from Cloud Storage.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while calling the Cloud Storage API. This
       * can happen if the Pub/Sub SA has not been granted the
       * [appropriate
       * permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions):
       * - storage.objects.list: to list the objects in a bucket.
       * - storage.objects.get: to read the objects in a bucket.
       * - storage.buckets.get: to verify the bucket exists.
       * </pre>
       *
       * <code>CLOUD_STORAGE_PERMISSION_DENIED = 2;</code>
       */
      CLOUD_STORAGE_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The provided Cloud Storage bucket doesn't exist.
       * </pre>
       *
       * <code>BUCKET_NOT_FOUND = 4;</code>
       */
      BUCKET_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The Cloud Storage bucket has too many objects, ingestion will be
       * paused.
       * </pre>
       *
       * <code>TOO_MANY_OBJECTS = 5;</code>
       */
      TOO_MANY_OBJECTS(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while calling the Cloud Storage API. This
       * can happen if the Pub/Sub SA has not been granted the
       * [appropriate
       * permissions](https://cloud.google.com/storage/docs/access-control/iam-permissions):
       * - storage.objects.list: to list the objects in a bucket.
       * - storage.objects.get: to read the objects in a bucket.
       * - storage.buckets.get: to verify the bucket exists.
       * </pre>
       *
       * <code>CLOUD_STORAGE_PERMISSION_DENIED = 2;</code>
       */
      public static final int CLOUD_STORAGE_PERMISSION_DENIED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The provided Cloud Storage bucket doesn't exist.
       * </pre>
       *
       * <code>BUCKET_NOT_FOUND = 4;</code>
       */
      public static final int BUCKET_NOT_FOUND_VALUE = 4;

      /**
       *
       *
       * <pre>
       * The Cloud Storage bucket has too many objects, ingestion will be
       * paused.
       * </pre>
       *
       * <code>TOO_MANY_OBJECTS = 5;</code>
       */
      public static final int TOO_MANY_OBJECTS_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return CLOUD_STORAGE_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return BUCKET_NOT_FOUND;
          case 5:
            return TOO_MANY_OBJECTS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State)
    }

    public interface TextFormatOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the delimiter field is set.
       */
      boolean hasDelimiter();

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The delimiter.
       */
      java.lang.String getDelimiter();

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for delimiter.
       */
      com.google.protobuf.ByteString getDelimiterBytes();
    }

    /**
     *
     *
     * <pre>
     * Configuration for reading Cloud Storage data in text format. Each line of
     * text as specified by the delimiter will be set to the `data` field of a
     * Pub/Sub message.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat}
     */
    public static final class TextFormat extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
        TextFormatOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use TextFormat.newBuilder() to construct.
      private TextFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TextFormat() {
        delimiter_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TextFormat();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
                    .class);
      }

      private int bitField0_;
      public static final int DELIMITER_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object delimiter_ = "";

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the delimiter field is set.
       */
      @java.lang.Override
      public boolean hasDelimiter() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The delimiter.
       */
      @java.lang.Override
      public java.lang.String getDelimiter() {
        java.lang.Object ref = delimiter_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          delimiter_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. When unset, '&#92;n' is used.
       * </pre>
       *
       * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for delimiter.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDelimiterBytes() {
        java.lang.Object ref = delimiter_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          delimiter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, delimiter_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, delimiter_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)) {
          return super.equals(obj);
        }
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat other =
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat) obj;

        if (hasDelimiter() != other.hasDelimiter()) return false;
        if (hasDelimiter()) {
          if (!getDelimiter().equals(other.getDelimiter())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDelimiter()) {
          hash = (37 * hash) + DELIMITER_FIELD_NUMBER;
          hash = (53 * hash) + getDelimiter().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configuration for reading Cloud Storage data in text format. Each line of
       * text as specified by the delimiter will be set to the `data` field of a
       * Pub/Sub message.
       * </pre>
       *
       * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.class,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
                      .class);
        }

        // Construct using
        // com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          delimiter_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_TextFormat_descriptor;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
            getDefaultInstanceForType() {
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat build() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
            buildPartial() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat result =
              new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.delimiter_ = delimiter_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat) {
            return mergeFrom(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat other) {
          if (other
              == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                  .getDefaultInstance()) return this;
          if (other.hasDelimiter()) {
            delimiter_ = other.delimiter_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    delimiter_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object delimiter_ = "";

        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return Whether the delimiter field is set.
         */
        public boolean hasDelimiter() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The delimiter.
         */
        public java.lang.String getDelimiter() {
          java.lang.Object ref = delimiter_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            delimiter_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for delimiter.
         */
        public com.google.protobuf.ByteString getDelimiterBytes() {
          java.lang.Object ref = delimiter_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            delimiter_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The delimiter to set.
         * @return This builder for chaining.
         */
        public Builder setDelimiter(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          delimiter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDelimiter() {
          delimiter_ = getDefaultInstance().getDelimiter();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. When unset, '&#92;n' is used.
         * </pre>
         *
         * <code>optional string delimiter = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for delimiter to set.
         * @return This builder for chaining.
         */
        public Builder setDelimiterBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          delimiter_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
      }

      // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
      private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat();
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TextFormat> PARSER =
          new com.google.protobuf.AbstractParser<TextFormat>() {
            @java.lang.Override
            public TextFormat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TextFormat> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TextFormat> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface AvroFormatOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Configuration for reading Cloud Storage data in Avro binary format. The
     * bytes of each object will be set to the `data` field of a Pub/Sub
     * message.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat}
     */
    public static final class AvroFormat extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
        AvroFormatOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use AvroFormat.newBuilder() to construct.
      private AvroFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AvroFormat() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AvroFormat();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
                    .class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)) {
          return super.equals(obj);
        }
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat other =
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configuration for reading Cloud Storage data in Avro binary format. The
       * bytes of each object will be set to the `data` field of a Pub/Sub
       * message.
       * </pre>
       *
       * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.class,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
                      .class);
        }

        // Construct using
        // com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_AvroFormat_descriptor;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
            getDefaultInstanceForType() {
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat build() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
            buildPartial() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat result =
              new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat) {
            return mergeFrom(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat other) {
          if (other
              == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
      }

      // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
      private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat();
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AvroFormat> PARSER =
          new com.google.protobuf.AbstractParser<AvroFormat>() {
            @java.lang.Override
            public AvroFormat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AvroFormat> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AvroFormat> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PubSubAvroFormatOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
        com.google.protobuf.MessageOrBuilder {}

    /**
     *
     *
     * <pre>
     * Configuration for reading Cloud Storage data written via [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage). The
     * data and attributes fields of the originally exported Pub/Sub message
     * will be restored when publishing.
     * </pre>
     *
     * Protobuf type {@code
     * google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat}
     */
    public static final class PubSubAvroFormat extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
        PubSubAvroFormatOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use PubSubAvroFormat.newBuilder() to construct.
      private PubSubAvroFormat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PubSubAvroFormat() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PubSubAvroFormat();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .Builder.class);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)) {
          return super.equals(obj);
        }
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat other =
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configuration for reading Cloud Storage data written via [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage). The
       * data and attributes fields of the originally exported Pub/Sub message
       * will be restored when publishing.
       * </pre>
       *
       * Protobuf type {@code
       * google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .class,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .Builder.class);
        }

        // Construct using
        // com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.pubsub.v1.PubsubProto
              .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_PubSubAvroFormat_descriptor;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
            getDefaultInstanceForType() {
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
            build() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
            buildPartial() {
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat result =
              new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat(
                  this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat) {
            return mergeFrom(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat other) {
          if (other
              == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                  .getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
      }

      // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
      private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
              .PubSubAvroFormat
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat();
      }

      public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PubSubAvroFormat> PARSER =
          new com.google.protobuf.AbstractParser<PubSubAvroFormat>() {
            @java.lang.Override
            public PubSubAvroFormat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PubSubAvroFormat> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PubSubAvroFormat> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int inputFormatCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object inputFormat_;

    public enum InputFormatCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT_FORMAT(3),
      AVRO_FORMAT(4),
      PUBSUB_AVRO_FORMAT(5),
      INPUTFORMAT_NOT_SET(0);
      private final int value;

      private InputFormatCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static InputFormatCase valueOf(int value) {
        return forNumber(value);
      }

      public static InputFormatCase forNumber(int value) {
        switch (value) {
          case 3:
            return TEXT_FORMAT;
          case 4:
            return AVRO_FORMAT;
          case 5:
            return PUBSUB_AVRO_FORMAT;
          case 0:
            return INPUTFORMAT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public InputFormatCase getInputFormatCase() {
      return InputFormatCase.forNumber(inputFormatCase_);
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Cloud
     * Storage ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.UNRECOGNIZED
          : result;
    }

    public static final int BUCKET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bucket_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucket.
     */
    @java.lang.Override
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage bucket. The bucket name must be without any
     * prefix like "gs://". See the [bucket naming requirements]
     * (https://cloud.google.com/storage/docs/buckets#naming).
     * </pre>
     *
     * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_FORMAT_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the textFormat field is set.
     */
    @java.lang.Override
    public boolean hasTextFormat() {
      return inputFormatCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The textFormat.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
        getTextFormat() {
      if (inputFormatCase_ == 3) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted as text.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder
        getTextFormatOrBuilder() {
      if (inputFormatCase_ == 3) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          .getDefaultInstance();
    }

    public static final int AVRO_FORMAT_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroFormat field is set.
     */
    @java.lang.Override
    public boolean hasAvroFormat() {
      return inputFormatCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroFormat.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
        getAvroFormat() {
      if (inputFormatCase_ == 4) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Optional. Data from Cloud Storage will be interpreted in Avro format.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder
        getAvroFormatOrBuilder() {
      if (inputFormatCase_ == 4) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          .getDefaultInstance();
    }

    public static final int PUBSUB_AVRO_FORMAT_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pubsubAvroFormat field is set.
     */
    @java.lang.Override
    public boolean hasPubsubAvroFormat() {
      return inputFormatCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pubsubAvroFormat.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
        getPubsubAvroFormat() {
      if (inputFormatCase_ == 5) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Optional. It will be assumed data from Cloud Storage was written via
     * [Cloud Storage
     * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder
        getPubsubAvroFormatOrBuilder() {
      if (inputFormatCase_ == 5) {
        return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
            inputFormat_;
      }
      return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          .getDefaultInstance();
    }

    public static final int MINIMUM_OBJECT_CREATE_TIME_FIELD_NUMBER = 6;
    private com.google.protobuf.Timestamp minimumObjectCreateTime_;

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the minimumObjectCreateTime field is set.
     */
    @java.lang.Override
    public boolean hasMinimumObjectCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The minimumObjectCreateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getMinimumObjectCreateTime() {
      return minimumObjectCreateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : minimumObjectCreateTime_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Only objects with a larger or equal creation timestamp will be
     * ingested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getMinimumObjectCreateTimeOrBuilder() {
      return minimumObjectCreateTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : minimumObjectCreateTime_;
    }

    public static final int MATCH_GLOB_FIELD_NUMBER = 9;

    @SuppressWarnings("serial")
    private volatile java.lang.Object matchGlob_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The matchGlob.
     */
    @java.lang.Override
    public java.lang.String getMatchGlob() {
      java.lang.Object ref = matchGlob_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        matchGlob_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Glob pattern used to match objects that will be ingested. If
     * unset, all objects will be ingested. See the [supported
     * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
     * </pre>
     *
     * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for matchGlob.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMatchGlobBytes() {
      java.lang.Object ref = matchGlob_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        matchGlob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bucket_);
      }
      if (inputFormatCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                inputFormat_);
      }
      if (inputFormatCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                inputFormat_);
      }
      if (inputFormatCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                inputFormat_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(6, getMinimumObjectCreateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchGlob_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, matchGlob_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bucket_);
      }
      if (inputFormatCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                    inputFormat_);
      }
      if (inputFormatCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                    inputFormat_);
      }
      if (inputFormatCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                    inputFormat_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, getMinimumObjectCreateTime());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(matchGlob_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, matchGlob_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) obj;

      if (state_ != other.state_) return false;
      if (!getBucket().equals(other.getBucket())) return false;
      if (hasMinimumObjectCreateTime() != other.hasMinimumObjectCreateTime()) return false;
      if (hasMinimumObjectCreateTime()) {
        if (!getMinimumObjectCreateTime().equals(other.getMinimumObjectCreateTime())) return false;
      }
      if (!getMatchGlob().equals(other.getMatchGlob())) return false;
      if (!getInputFormatCase().equals(other.getInputFormatCase())) return false;
      switch (inputFormatCase_) {
        case 3:
          if (!getTextFormat().equals(other.getTextFormat())) return false;
          break;
        case 4:
          if (!getAvroFormat().equals(other.getAvroFormat())) return false;
          break;
        case 5:
          if (!getPubsubAvroFormat().equals(other.getPubsubAvroFormat())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getBucket().hashCode();
      if (hasMinimumObjectCreateTime()) {
        hash = (37 * hash) + MINIMUM_OBJECT_CREATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getMinimumObjectCreateTime().hashCode();
      }
      hash = (37 * hash) + MATCH_GLOB_FIELD_NUMBER;
      hash = (53 * hash) + getMatchGlob().hashCode();
      switch (inputFormatCase_) {
        case 3:
          hash = (37 * hash) + TEXT_FORMAT_FIELD_NUMBER;
          hash = (53 * hash) + getTextFormat().hashCode();
          break;
        case 4:
          hash = (37 * hash) + AVRO_FORMAT_FIELD_NUMBER;
          hash = (53 * hash) + getAvroFormat().hashCode();
          break;
        case 5:
          hash = (37 * hash) + PUBSUB_AVRO_FORMAT_FIELD_NUMBER;
          hash = (53 * hash) + getPubsubAvroFormat().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Ingestion settings for Cloud Storage.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.CloudStorage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMinimumObjectCreateTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        bucket_ = "";
        if (textFormatBuilder_ != null) {
          textFormatBuilder_.clear();
        }
        if (avroFormatBuilder_ != null) {
          avroFormatBuilder_.clear();
        }
        if (pubsubAvroFormatBuilder_ != null) {
          pubsubAvroFormatBuilder_.clear();
        }
        minimumObjectCreateTime_ = null;
        if (minimumObjectCreateTimeBuilder_ != null) {
          minimumObjectCreateTimeBuilder_.dispose();
          minimumObjectCreateTimeBuilder_ = null;
        }
        matchGlob_ = "";
        inputFormatCase_ = 0;
        inputFormat_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_CloudStorage_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.bucket_ = bucket_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.minimumObjectCreateTime_ =
              minimumObjectCreateTimeBuilder_ == null
                  ? minimumObjectCreateTime_
                  : minimumObjectCreateTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.matchGlob_ = matchGlob_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage result) {
        result.inputFormatCase_ = inputFormatCase_;
        result.inputFormat_ = this.inputFormat_;
        if (inputFormatCase_ == 3 && textFormatBuilder_ != null) {
          result.inputFormat_ = textFormatBuilder_.build();
        }
        if (inputFormatCase_ == 4 && avroFormatBuilder_ != null) {
          result.inputFormat_ = avroFormatBuilder_.build();
        }
        if (inputFormatCase_ == 5 && pubsubAvroFormatBuilder_ != null) {
          result.inputFormat_ = pubsubAvroFormatBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getBucket().isEmpty()) {
          bucket_ = other.bucket_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasMinimumObjectCreateTime()) {
          mergeMinimumObjectCreateTime(other.getMinimumObjectCreateTime());
        }
        if (!other.getMatchGlob().isEmpty()) {
          matchGlob_ = other.matchGlob_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        switch (other.getInputFormatCase()) {
          case TEXT_FORMAT:
            {
              mergeTextFormat(other.getTextFormat());
              break;
            }
          case AVRO_FORMAT:
            {
              mergeAvroFormat(other.getAvroFormat());
              break;
            }
          case PUBSUB_AVRO_FORMAT:
            {
              mergePubsubAvroFormat(other.getPubsubAvroFormat());
              break;
            }
          case INPUTFORMAT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  bucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTextFormatFieldBuilder().getBuilder(), extensionRegistry);
                  inputFormatCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getAvroFormatFieldBuilder().getBuilder(), extensionRegistry);
                  inputFormatCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getPubsubAvroFormatFieldBuilder().getBuilder(), extensionRegistry);
                  inputFormatCase_ = 5;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getMinimumObjectCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 74:
                {
                  matchGlob_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int inputFormatCase_ = 0;
      private java.lang.Object inputFormat_;

      public InputFormatCase getInputFormatCase() {
        return InputFormatCase.forNumber(inputFormatCase_);
      }

      public Builder clearInputFormat() {
        inputFormatCase_ = 0;
        inputFormat_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Cloud
       * Storage ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object bucket_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bucket.
       */
      public java.lang.String getBucket() {
        java.lang.Object ref = bucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for bucket.
       */
      public com.google.protobuf.ByteString getBucketBytes() {
        java.lang.Object ref = bucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucket_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucket() {
        bucket_ = getDefaultInstance().getBucket();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Cloud Storage bucket. The bucket name must be without any
       * prefix like "gs://". See the [bucket naming requirements]
       * (https://cloud.google.com/storage/docs/buckets#naming).
       * </pre>
       *
       * <code>string bucket = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bucket_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder>
          textFormatBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the textFormat field is set.
       */
      @java.lang.Override
      public boolean hasTextFormat() {
        return inputFormatCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The textFormat.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
          getTextFormat() {
        if (textFormatBuilder_ == null) {
          if (inputFormatCase_ == 3) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        } else {
          if (inputFormatCase_ == 3) {
            return textFormatBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTextFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat value) {
        if (textFormatBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputFormat_ = value;
          onChanged();
        } else {
          textFormatBuilder_.setMessage(value);
        }
        inputFormatCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setTextFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
              builderForValue) {
        if (textFormatBuilder_ == null) {
          inputFormat_ = builderForValue.build();
          onChanged();
        } else {
          textFormatBuilder_.setMessage(builderForValue.build());
        }
        inputFormatCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeTextFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat value) {
        if (textFormatBuilder_ == null) {
          if (inputFormatCase_ == 3
              && inputFormat_
                  != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                      .getDefaultInstance()) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.newBuilder(
                        (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                            inputFormat_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputFormat_ = value;
          }
          onChanged();
        } else {
          if (inputFormatCase_ == 3) {
            textFormatBuilder_.mergeFrom(value);
          } else {
            textFormatBuilder_.setMessage(value);
          }
        }
        inputFormatCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearTextFormat() {
        if (textFormatBuilder_ == null) {
          if (inputFormatCase_ == 3) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
            onChanged();
          }
        } else {
          if (inputFormatCase_ == 3) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
          }
          textFormatBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder
          getTextFormatBuilder() {
        return getTextFormatFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder
          getTextFormatOrBuilder() {
        if ((inputFormatCase_ == 3) && (textFormatBuilder_ != null)) {
          return textFormatBuilder_.getMessageOrBuilder();
        } else {
          if (inputFormatCase_ == 3) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted as text.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat text_format = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormatOrBuilder>
          getTextFormatFieldBuilder() {
        if (textFormatBuilder_ == null) {
          if (!(inputFormatCase_ == 3)) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat
                    .getDefaultInstance();
          }
          textFormatBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat.Builder,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                      .TextFormatOrBuilder>(
                  (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.TextFormat)
                      inputFormat_,
                  getParentForChildren(),
                  isClean());
          inputFormat_ = null;
        }
        inputFormatCase_ = 3;
        onChanged();
        return textFormatBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder>
          avroFormatBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the avroFormat field is set.
       */
      @java.lang.Override
      public boolean hasAvroFormat() {
        return inputFormatCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The avroFormat.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
          getAvroFormat() {
        if (avroFormatBuilder_ == null) {
          if (inputFormatCase_ == 4) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        } else {
          if (inputFormatCase_ == 4) {
            return avroFormatBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat value) {
        if (avroFormatBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputFormat_ = value;
          onChanged();
        } else {
          avroFormatBuilder_.setMessage(value);
        }
        inputFormatCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
              builderForValue) {
        if (avroFormatBuilder_ == null) {
          inputFormat_ = builderForValue.build();
          onChanged();
        } else {
          avroFormatBuilder_.setMessage(builderForValue.build());
        }
        inputFormatCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat value) {
        if (avroFormatBuilder_ == null) {
          if (inputFormatCase_ == 4
              && inputFormat_
                  != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                      .getDefaultInstance()) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.newBuilder(
                        (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                            inputFormat_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputFormat_ = value;
          }
          onChanged();
        } else {
          if (inputFormatCase_ == 4) {
            avroFormatBuilder_.mergeFrom(value);
          } else {
            avroFormatBuilder_.setMessage(value);
          }
        }
        inputFormatCase_ = 4;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAvroFormat() {
        if (avroFormatBuilder_ == null) {
          if (inputFormatCase_ == 4) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
            onChanged();
          }
        } else {
          if (inputFormatCase_ == 4) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
          }
          avroFormatBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder
          getAvroFormatBuilder() {
        return getAvroFormatFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder
          getAvroFormatOrBuilder() {
        if ((inputFormatCase_ == 4) && (avroFormatBuilder_ != null)) {
          return avroFormatBuilder_.getMessageOrBuilder();
        } else {
          if (inputFormatCase_ == 4) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Data from Cloud Storage will be interpreted in Avro format.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat avro_format = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormatOrBuilder>
          getAvroFormatFieldBuilder() {
        if (avroFormatBuilder_ == null) {
          if (!(inputFormatCase_ == 4)) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat
                    .getDefaultInstance();
          }
          avroFormatBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat.Builder,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                      .AvroFormatOrBuilder>(
                  (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.AvroFormat)
                      inputFormat_,
                  getParentForChildren(),
                  isClean());
          inputFormat_ = null;
        }
        inputFormatCase_ = 4;
        onChanged();
        return avroFormatBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                  .Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                  .PubSubAvroFormatOrBuilder>
          pubsubAvroFormatBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the pubsubAvroFormat field is set.
       */
      @java.lang.Override
      public boolean hasPubsubAvroFormat() {
        return inputFormatCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The pubsubAvroFormat.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
          getPubsubAvroFormat() {
        if (pubsubAvroFormatBuilder_ == null) {
          if (inputFormatCase_ == 5) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        } else {
          if (inputFormatCase_ == 5) {
            return pubsubAvroFormatBuilder_.getMessage();
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPubsubAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat value) {
        if (pubsubAvroFormatBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          inputFormat_ = value;
          onChanged();
        } else {
          pubsubAvroFormatBuilder_.setMessage(value);
        }
        inputFormatCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPubsubAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.Builder
              builderForValue) {
        if (pubsubAvroFormatBuilder_ == null) {
          inputFormat_ = builderForValue.build();
          onChanged();
        } else {
          pubsubAvroFormatBuilder_.setMessage(builderForValue.build());
        }
        inputFormatCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePubsubAvroFormat(
          com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat value) {
        if (pubsubAvroFormatBuilder_ == null) {
          if (inputFormatCase_ == 5
              && inputFormat_
                  != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .getDefaultInstance()) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .newBuilder(
                        (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                                .PubSubAvroFormat)
                            inputFormat_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            inputFormat_ = value;
          }
          onChanged();
        } else {
          if (inputFormatCase_ == 5) {
            pubsubAvroFormatBuilder_.mergeFrom(value);
          } else {
            pubsubAvroFormatBuilder_.setMessage(value);
          }
        }
        inputFormatCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPubsubAvroFormat() {
        if (pubsubAvroFormatBuilder_ == null) {
          if (inputFormatCase_ == 5) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
            onChanged();
          }
        } else {
          if (inputFormatCase_ == 5) {
            inputFormatCase_ = 0;
            inputFormat_ = null;
          }
          pubsubAvroFormatBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat.Builder
          getPubsubAvroFormatBuilder() {
        return getPubsubAvroFormatFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormatOrBuilder
          getPubsubAvroFormatOrBuilder() {
        if ((inputFormatCase_ == 5) && (pubsubAvroFormatBuilder_ != null)) {
          return pubsubAvroFormatBuilder_.getMessageOrBuilder();
        } else {
          if (inputFormatCase_ == 5) {
            return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                inputFormat_;
          }
          return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. It will be assumed data from Cloud Storage was written via
       * [Cloud Storage
       * subscriptions](https://cloud.google.com/pubsub/docs/cloudstorage).
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat pubsub_avro_format = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                  .Builder,
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                  .PubSubAvroFormatOrBuilder>
          getPubsubAvroFormatFieldBuilder() {
        if (pubsubAvroFormatBuilder_ == null) {
          if (!(inputFormatCase_ == 5)) {
            inputFormat_ =
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                    .getDefaultInstance();
          }
          pubsubAvroFormatBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat
                      .Builder,
                  com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                      .PubSubAvroFormatOrBuilder>(
                  (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.PubSubAvroFormat)
                      inputFormat_,
                  getParentForChildren(),
                  isClean());
          inputFormat_ = null;
        }
        inputFormatCase_ = 5;
        onChanged();
        return pubsubAvroFormatBuilder_;
      }

      private com.google.protobuf.Timestamp minimumObjectCreateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          minimumObjectCreateTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the minimumObjectCreateTime field is set.
       */
      public boolean hasMinimumObjectCreateTime() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The minimumObjectCreateTime.
       */
      public com.google.protobuf.Timestamp getMinimumObjectCreateTime() {
        if (minimumObjectCreateTimeBuilder_ == null) {
          return minimumObjectCreateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : minimumObjectCreateTime_;
        } else {
          return minimumObjectCreateTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMinimumObjectCreateTime(com.google.protobuf.Timestamp value) {
        if (minimumObjectCreateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minimumObjectCreateTime_ = value;
        } else {
          minimumObjectCreateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setMinimumObjectCreateTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (minimumObjectCreateTimeBuilder_ == null) {
          minimumObjectCreateTime_ = builderForValue.build();
        } else {
          minimumObjectCreateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeMinimumObjectCreateTime(com.google.protobuf.Timestamp value) {
        if (minimumObjectCreateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && minimumObjectCreateTime_ != null
              && minimumObjectCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getMinimumObjectCreateTimeBuilder().mergeFrom(value);
          } else {
            minimumObjectCreateTime_ = value;
          }
        } else {
          minimumObjectCreateTimeBuilder_.mergeFrom(value);
        }
        if (minimumObjectCreateTime_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearMinimumObjectCreateTime() {
        bitField0_ = (bitField0_ & ~0x00000020);
        minimumObjectCreateTime_ = null;
        if (minimumObjectCreateTimeBuilder_ != null) {
          minimumObjectCreateTimeBuilder_.dispose();
          minimumObjectCreateTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getMinimumObjectCreateTimeBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getMinimumObjectCreateTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getMinimumObjectCreateTimeOrBuilder() {
        if (minimumObjectCreateTimeBuilder_ != null) {
          return minimumObjectCreateTimeBuilder_.getMessageOrBuilder();
        } else {
          return minimumObjectCreateTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : minimumObjectCreateTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Only objects with a larger or equal creation timestamp will be
       * ingested.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp minimum_object_create_time = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getMinimumObjectCreateTimeFieldBuilder() {
        if (minimumObjectCreateTimeBuilder_ == null) {
          minimumObjectCreateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getMinimumObjectCreateTime(), getParentForChildren(), isClean());
          minimumObjectCreateTime_ = null;
        }
        return minimumObjectCreateTimeBuilder_;
      }

      private java.lang.Object matchGlob_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The matchGlob.
       */
      public java.lang.String getMatchGlob() {
        java.lang.Object ref = matchGlob_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          matchGlob_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for matchGlob.
       */
      public com.google.protobuf.ByteString getMatchGlobBytes() {
        java.lang.Object ref = matchGlob_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          matchGlob_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The matchGlob to set.
       * @return This builder for chaining.
       */
      public Builder setMatchGlob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        matchGlob_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatchGlob() {
        matchGlob_ = getDefaultInstance().getMatchGlob();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Glob pattern used to match objects that will be ingested. If
       * unset, all objects will be ingested. See the [supported
       * patterns](https://cloud.google.com/storage/docs/json_api/v1/objects/list#list-objects-and-prefixes-using-glob).
       * </pre>
       *
       * <code>string match_glob = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for matchGlob to set.
       * @return This builder for chaining.
       */
      public Builder setMatchGlobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        matchGlob_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.CloudStorage)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudStorage> PARSER =
        new com.google.protobuf.AbstractParser<CloudStorage>() {
          @java.lang.Override
          public CloudStorage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudStorage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudStorage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AzureEventHubsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Event
     * Hubs ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Event
     * Hubs ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State getState();

    /**
     *
     *
     * <pre>
     * Optional. Name of the resource group within the azure subscription.
     * </pre>
     *
     * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The resourceGroup.
     */
    java.lang.String getResourceGroup();

    /**
     *
     *
     * <pre>
     * Optional. Name of the resource group within the azure subscription.
     * </pre>
     *
     * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for resourceGroup.
     */
    com.google.protobuf.ByteString getResourceGroupBytes();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hubs namespace.
     * </pre>
     *
     * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The namespace.
     */
    java.lang.String getNamespace();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hubs namespace.
     * </pre>
     *
     * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for namespace.
     */
    com.google.protobuf.ByteString getNamespaceBytes();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hub.
     * </pre>
     *
     * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The eventHub.
     */
    java.lang.String getEventHub();

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hub.
     * </pre>
     *
     * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for eventHub.
     */
    com.google.protobuf.ByteString getEventHubBytes();

    /**
     *
     *
     * <pre>
     * Optional. The client id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The clientId.
     */
    java.lang.String getClientId();

    /**
     *
     *
     * <pre>
     * Optional. The client id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for clientId.
     */
    com.google.protobuf.ByteString getClientIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The tenant id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tenantId.
     */
    java.lang.String getTenantId();

    /**
     *
     *
     * <pre>
     * Optional. The tenant id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tenantId.
     */
    com.google.protobuf.ByteString getTenantIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Azure subscription id.
     * </pre>
     *
     * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subscriptionId.
     */
    java.lang.String getSubscriptionId();

    /**
     *
     *
     * <pre>
     * Optional. The Azure subscription id.
     * </pre>
     *
     * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subscriptionId.
     */
    com.google.protobuf.ByteString getSubscriptionIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The GCP service account to be used for Federated Identity
     * authentication.
     * </pre>
     *
     * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The gcpServiceAccount.
     */
    java.lang.String getGcpServiceAccount();

    /**
     *
     *
     * <pre>
     * Optional. The GCP service account to be used for Federated Identity
     * authentication.
     * </pre>
     *
     * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    com.google.protobuf.ByteString getGcpServiceAccountBytes();
  }

  /**
   *
   *
   * <pre>
   * Ingestion settings for Azure Event Hubs.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs}
   */
  public static final class AzureEventHubs extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)
      AzureEventHubsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AzureEventHubs.newBuilder() to construct.
    private AzureEventHubs(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AzureEventHubs() {
      state_ = 0;
      resourceGroup_ = "";
      namespace_ = "";
      eventHub_ = "";
      clientId_ = "";
      tenantId_ = "";
      subscriptionId_ = "";
      gcpServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AzureEventHubs();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AzureEventHubs_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AzureEventHubs_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for managed ingestion from Event Hubs.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Event Hubs.
       * This can happen when `client_id`, or `tenant_id` are invalid. Or the
       * right permissions haven't been granted.
       * </pre>
       *
       * <code>EVENT_HUBS_PERMISSION_DENIED = 2;</code>
       */
      EVENT_HUBS_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic.
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The provided Event Hubs namespace couldn't be found.
       * </pre>
       *
       * <code>NAMESPACE_NOT_FOUND = 4;</code>
       */
      NAMESPACE_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The provided Event Hub couldn't be found.
       * </pre>
       *
       * <code>EVENT_HUB_NOT_FOUND = 5;</code>
       */
      EVENT_HUB_NOT_FOUND(5),
      /**
       *
       *
       * <pre>
       * The provided Event Hubs subscription couldn't be found.
       * </pre>
       *
       * <code>SUBSCRIPTION_NOT_FOUND = 6;</code>
       */
      SUBSCRIPTION_NOT_FOUND(6),
      /**
       *
       *
       * <pre>
       * The provided Event Hubs resource group couldn't be found.
       * </pre>
       *
       * <code>RESOURCE_GROUP_NOT_FOUND = 7;</code>
       */
      RESOURCE_GROUP_NOT_FOUND(7),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Event Hubs.
       * This can happen when `client_id`, or `tenant_id` are invalid. Or the
       * right permissions haven't been granted.
       * </pre>
       *
       * <code>EVENT_HUBS_PERMISSION_DENIED = 2;</code>
       */
      public static final int EVENT_HUBS_PERMISSION_DENIED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic.
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The provided Event Hubs namespace couldn't be found.
       * </pre>
       *
       * <code>NAMESPACE_NOT_FOUND = 4;</code>
       */
      public static final int NAMESPACE_NOT_FOUND_VALUE = 4;

      /**
       *
       *
       * <pre>
       * The provided Event Hub couldn't be found.
       * </pre>
       *
       * <code>EVENT_HUB_NOT_FOUND = 5;</code>
       */
      public static final int EVENT_HUB_NOT_FOUND_VALUE = 5;

      /**
       *
       *
       * <pre>
       * The provided Event Hubs subscription couldn't be found.
       * </pre>
       *
       * <code>SUBSCRIPTION_NOT_FOUND = 6;</code>
       */
      public static final int SUBSCRIPTION_NOT_FOUND_VALUE = 6;

      /**
       *
       *
       * <pre>
       * The provided Event Hubs resource group couldn't be found.
       * </pre>
       *
       * <code>RESOURCE_GROUP_NOT_FOUND = 7;</code>
       */
      public static final int RESOURCE_GROUP_NOT_FOUND_VALUE = 7;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return EVENT_HUBS_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return NAMESPACE_NOT_FOUND;
          case 5:
            return EVENT_HUB_NOT_FOUND;
          case 6:
            return SUBSCRIPTION_NOT_FOUND;
          case 7:
            return RESOURCE_GROUP_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Event
     * Hubs ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Event
     * Hubs ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State.UNRECOGNIZED
          : result;
    }

    public static final int RESOURCE_GROUP_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object resourceGroup_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Name of the resource group within the azure subscription.
     * </pre>
     *
     * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The resourceGroup.
     */
    @java.lang.Override
    public java.lang.String getResourceGroup() {
      java.lang.Object ref = resourceGroup_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceGroup_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Name of the resource group within the azure subscription.
     * </pre>
     *
     * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for resourceGroup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getResourceGroupBytes() {
      java.lang.Object ref = resourceGroup_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAMESPACE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object namespace_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hubs namespace.
     * </pre>
     *
     * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The namespace.
     */
    @java.lang.Override
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        namespace_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hubs namespace.
     * </pre>
     *
     * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for namespace.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EVENT_HUB_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object eventHub_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hub.
     * </pre>
     *
     * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The eventHub.
     */
    @java.lang.Override
    public java.lang.String getEventHub() {
      java.lang.Object ref = eventHub_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventHub_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the Event Hub.
     * </pre>
     *
     * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for eventHub.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEventHubBytes() {
      java.lang.Object ref = eventHub_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventHub_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLIENT_ID_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clientId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The client id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The clientId.
     */
    @java.lang.Override
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The client id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for clientId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TENANT_ID_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tenantId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The tenant id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The tenantId.
     */
    @java.lang.Override
    public java.lang.String getTenantId() {
      java.lang.Object ref = tenantId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tenantId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The tenant id of the Azure application that is being used to
     * authenticate Pub/Sub.
     * </pre>
     *
     * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for tenantId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTenantIdBytes() {
      java.lang.Object ref = tenantId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tenantId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBSCRIPTION_ID_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subscriptionId_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Azure subscription id.
     * </pre>
     *
     * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The subscriptionId.
     */
    @java.lang.Override
    public java.lang.String getSubscriptionId() {
      java.lang.Object ref = subscriptionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subscriptionId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Azure subscription id.
     * </pre>
     *
     * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for subscriptionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubscriptionIdBytes() {
      java.lang.Object ref = subscriptionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subscriptionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCP_SERVICE_ACCOUNT_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcpServiceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The GCP service account to be used for Federated Identity
     * authentication.
     * </pre>
     *
     * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The gcpServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getGcpServiceAccount() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccount_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The GCP service account to be used for Federated Identity
     * authentication.
     * </pre>
     *
     * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceGroup_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, resourceGroup_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, namespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventHub_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, eventHub_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, clientId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenantId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, tenantId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscriptionId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, subscriptionId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, gcpServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceGroup_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, resourceGroup_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(namespace_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, namespace_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventHub_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, eventHub_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, clientId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenantId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, tenantId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subscriptionId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, subscriptionId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, gcpServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) obj;

      if (state_ != other.state_) return false;
      if (!getResourceGroup().equals(other.getResourceGroup())) return false;
      if (!getNamespace().equals(other.getNamespace())) return false;
      if (!getEventHub().equals(other.getEventHub())) return false;
      if (!getClientId().equals(other.getClientId())) return false;
      if (!getTenantId().equals(other.getTenantId())) return false;
      if (!getSubscriptionId().equals(other.getSubscriptionId())) return false;
      if (!getGcpServiceAccount().equals(other.getGcpServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + RESOURCE_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getResourceGroup().hashCode();
      hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
      hash = (53 * hash) + getNamespace().hashCode();
      hash = (37 * hash) + EVENT_HUB_FIELD_NUMBER;
      hash = (53 * hash) + getEventHub().hashCode();
      hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getClientId().hashCode();
      hash = (37 * hash) + TENANT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getTenantId().hashCode();
      hash = (37 * hash) + SUBSCRIPTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSubscriptionId().hashCode();
      hash = (37 * hash) + GCP_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGcpServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Ingestion settings for Azure Event Hubs.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AzureEventHubs_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AzureEventHubs_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder.class);
      }

      // Construct using
      // com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        resourceGroup_ = "";
        namespace_ = "";
        eventHub_ = "";
        clientId_ = "";
        tenantId_ = "";
        subscriptionId_ = "";
        gcpServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AzureEventHubs_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceGroup_ = resourceGroup_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.namespace_ = namespace_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.eventHub_ = eventHub_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.clientId_ = clientId_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.tenantId_ = tenantId_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.subscriptionId_ = subscriptionId_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.gcpServiceAccount_ = gcpServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getResourceGroup().isEmpty()) {
          resourceGroup_ = other.resourceGroup_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getNamespace().isEmpty()) {
          namespace_ = other.namespace_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getEventHub().isEmpty()) {
          eventHub_ = other.eventHub_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getClientId().isEmpty()) {
          clientId_ = other.clientId_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getTenantId().isEmpty()) {
          tenantId_ = other.tenantId_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (!other.getSubscriptionId().isEmpty()) {
          subscriptionId_ = other.subscriptionId_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (!other.getGcpServiceAccount().isEmpty()) {
          gcpServiceAccount_ = other.gcpServiceAccount_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  resourceGroup_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  namespace_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  eventHub_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  clientId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  tenantId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  subscriptionId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  gcpServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Event
       * Hubs ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Event
       * Hubs ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Event
       * Hubs ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Event
       * Hubs ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Event
       * Hubs ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object resourceGroup_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Name of the resource group within the azure subscription.
       * </pre>
       *
       * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The resourceGroup.
       */
      public java.lang.String getResourceGroup() {
        java.lang.Object ref = resourceGroup_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          resourceGroup_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Name of the resource group within the azure subscription.
       * </pre>
       *
       * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for resourceGroup.
       */
      public com.google.protobuf.ByteString getResourceGroupBytes() {
        java.lang.Object ref = resourceGroup_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          resourceGroup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Name of the resource group within the azure subscription.
       * </pre>
       *
       * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The resourceGroup to set.
       * @return This builder for chaining.
       */
      public Builder setResourceGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceGroup_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Name of the resource group within the azure subscription.
       * </pre>
       *
       * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceGroup() {
        resourceGroup_ = getDefaultInstance().getResourceGroup();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Name of the resource group within the azure subscription.
       * </pre>
       *
       * <code>string resource_group = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for resourceGroup to set.
       * @return This builder for chaining.
       */
      public Builder setResourceGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        resourceGroup_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object namespace_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hubs namespace.
       * </pre>
       *
       * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The namespace.
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          namespace_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hubs namespace.
       * </pre>
       *
       * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for namespace.
       */
      public com.google.protobuf.ByteString getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hubs namespace.
       * </pre>
       *
       * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        namespace_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hubs namespace.
       * </pre>
       *
       * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNamespace() {
        namespace_ = getDefaultInstance().getNamespace();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hubs namespace.
       * </pre>
       *
       * <code>string namespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for namespace to set.
       * @return This builder for chaining.
       */
      public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        namespace_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object eventHub_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hub.
       * </pre>
       *
       * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The eventHub.
       */
      public java.lang.String getEventHub() {
        java.lang.Object ref = eventHub_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          eventHub_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hub.
       * </pre>
       *
       * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for eventHub.
       */
      public com.google.protobuf.ByteString getEventHubBytes() {
        java.lang.Object ref = eventHub_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          eventHub_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hub.
       * </pre>
       *
       * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The eventHub to set.
       * @return This builder for chaining.
       */
      public Builder setEventHub(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventHub_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hub.
       * </pre>
       *
       * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEventHub() {
        eventHub_ = getDefaultInstance().getEventHub();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the Event Hub.
       * </pre>
       *
       * <code>string event_hub = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for eventHub to set.
       * @return This builder for chaining.
       */
      public Builder setEventHubBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        eventHub_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object clientId_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The client id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The clientId.
       */
      public java.lang.String getClientId() {
        java.lang.Object ref = clientId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clientId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The client id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for clientId.
       */
      public com.google.protobuf.ByteString getClientIdBytes() {
        java.lang.Object ref = clientId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clientId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The client id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The clientId to set.
       * @return This builder for chaining.
       */
      public Builder setClientId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The client id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClientId() {
        clientId_ = getDefaultInstance().getClientId();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The client id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string client_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for clientId to set.
       * @return This builder for chaining.
       */
      public Builder setClientIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clientId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object tenantId_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The tenant id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The tenantId.
       */
      public java.lang.String getTenantId() {
        java.lang.Object ref = tenantId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tenantId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The tenant id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for tenantId.
       */
      public com.google.protobuf.ByteString getTenantIdBytes() {
        java.lang.Object ref = tenantId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tenantId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The tenant id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The tenantId to set.
       * @return This builder for chaining.
       */
      public Builder setTenantId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tenantId_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The tenant id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTenantId() {
        tenantId_ = getDefaultInstance().getTenantId();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The tenant id of the Azure application that is being used to
       * authenticate Pub/Sub.
       * </pre>
       *
       * <code>string tenant_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for tenantId to set.
       * @return This builder for chaining.
       */
      public Builder setTenantIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tenantId_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private java.lang.Object subscriptionId_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Azure subscription id.
       * </pre>
       *
       * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The subscriptionId.
       */
      public java.lang.String getSubscriptionId() {
        java.lang.Object ref = subscriptionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subscriptionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Azure subscription id.
       * </pre>
       *
       * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for subscriptionId.
       */
      public com.google.protobuf.ByteString getSubscriptionIdBytes() {
        java.lang.Object ref = subscriptionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subscriptionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Azure subscription id.
       * </pre>
       *
       * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The subscriptionId to set.
       * @return This builder for chaining.
       */
      public Builder setSubscriptionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subscriptionId_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Azure subscription id.
       * </pre>
       *
       * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubscriptionId() {
        subscriptionId_ = getDefaultInstance().getSubscriptionId();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Azure subscription id.
       * </pre>
       *
       * <code>string subscription_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for subscriptionId to set.
       * @return This builder for chaining.
       */
      public Builder setSubscriptionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subscriptionId_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private java.lang.Object gcpServiceAccount_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The GCP service account to be used for Federated Identity
       * authentication.
       * </pre>
       *
       * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The gcpServiceAccount.
       */
      public java.lang.String getGcpServiceAccount() {
        java.lang.Object ref = gcpServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcpServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The GCP service account to be used for Federated Identity
       * authentication.
       * </pre>
       *
       * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for gcpServiceAccount.
       */
      public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
        java.lang.Object ref = gcpServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcpServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The GCP service account to be used for Federated Identity
       * authentication.
       * </pre>
       *
       * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The GCP service account to be used for Federated Identity
       * authentication.
       * </pre>
       *
       * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcpServiceAccount() {
        gcpServiceAccount_ = getDefaultInstance().getGcpServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The GCP service account to be used for Federated Identity
       * authentication.
       * </pre>
       *
       * <code>string gcp_service_account = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AzureEventHubs> PARSER =
        new com.google.protobuf.AbstractParser<AzureEventHubs>() {
          @java.lang.Override
          public AzureEventHubs parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AzureEventHubs> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AzureEventHubs> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AwsMskOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Amazon
     * MSK ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Amazon
     * MSK ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State getState();

    /**
     *
     *
     * <pre>
     * Required. The Amazon Resource Name (ARN) that uniquely identifies the
     * cluster.
     * </pre>
     *
     * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterArn.
     */
    java.lang.String getClusterArn();

    /**
     *
     *
     * <pre>
     * Required. The Amazon Resource Name (ARN) that uniquely identifies the
     * cluster.
     * </pre>
     *
     * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterArn.
     */
    com.google.protobuf.ByteString getClusterArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
     * will import from.
     * </pre>
     *
     * <code>
     * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
     * will import from.
     * </pre>
     *
     * <code>
     * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
     * the required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    java.lang.String getAwsRoleArn();

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
     * the required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    com.google.protobuf.ByteString getAwsRoleArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
     * for the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    java.lang.String getGcpServiceAccount();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
     * for the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    com.google.protobuf.ByteString getGcpServiceAccountBytes();
  }

  /**
   *
   *
   * <pre>
   * Ingestion settings for Amazon MSK.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsMsk}
   */
  public static final class AwsMsk extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)
      AwsMskOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AwsMsk.newBuilder() to construct.
    private AwsMsk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsMsk() {
      state_ = 0;
      clusterArn_ = "";
      topic_ = "";
      awsRoleArn_ = "";
      gcpServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsMsk();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsMsk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsMsk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for managed ingestion from Amazon MSK.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Amazon MSK.
       * </pre>
       *
       * <code>MSK_PERMISSION_DENIED = 2;</code>
       */
      MSK_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic.
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The provided MSK cluster wasn't found.
       * </pre>
       *
       * <code>CLUSTER_NOT_FOUND = 4;</code>
       */
      CLUSTER_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The provided topic wasn't found.
       * </pre>
       *
       * <code>TOPIC_NOT_FOUND = 5;</code>
       */
      TOPIC_NOT_FOUND(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Amazon MSK.
       * </pre>
       *
       * <code>MSK_PERMISSION_DENIED = 2;</code>
       */
      public static final int MSK_PERMISSION_DENIED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic.
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The provided MSK cluster wasn't found.
       * </pre>
       *
       * <code>CLUSTER_NOT_FOUND = 4;</code>
       */
      public static final int CLUSTER_NOT_FOUND_VALUE = 4;

      /**
       *
       *
       * <pre>
       * The provided topic wasn't found.
       * </pre>
       *
       * <code>TOPIC_NOT_FOUND = 5;</code>
       */
      public static final int TOPIC_NOT_FOUND_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return MSK_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return CLUSTER_NOT_FOUND;
          case 5:
            return TOPIC_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Amazon
     * MSK ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Amazon
     * MSK ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State.UNRECOGNIZED
          : result;
    }

    public static final int CLUSTER_ARN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clusterArn_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Amazon Resource Name (ARN) that uniquely identifies the
     * cluster.
     * </pre>
     *
     * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterArn.
     */
    @java.lang.Override
    public java.lang.String getClusterArn() {
      java.lang.Object ref = clusterArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterArn_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Amazon Resource Name (ARN) that uniquely identifies the
     * cluster.
     * </pre>
     *
     * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClusterArnBytes() {
      java.lang.Object ref = clusterArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOPIC_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topic_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
     * will import from.
     * </pre>
     *
     * <code>
     * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
     * will import from.
     * </pre>
     *
     * <code>
     * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AWS_ROLE_ARN_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object awsRoleArn_ = "";

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
     * the required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    @java.lang.Override
    public java.lang.String getAwsRoleArn() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        awsRoleArn_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
     * the required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAwsRoleArnBytes() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        awsRoleArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCP_SERVICE_ACCOUNT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcpServiceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
     * for the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getGcpServiceAccount() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccount_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
     * for the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, topic_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, gcpServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, topic_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, gcpServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) obj;

      if (state_ != other.state_) return false;
      if (!getClusterArn().equals(other.getClusterArn())) return false;
      if (!getTopic().equals(other.getTopic())) return false;
      if (!getAwsRoleArn().equals(other.getAwsRoleArn())) return false;
      if (!getGcpServiceAccount().equals(other.getGcpServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + CLUSTER_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getClusterArn().hashCode();
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      hash = (37 * hash) + AWS_ROLE_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getAwsRoleArn().hashCode();
      hash = (37 * hash) + GCP_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGcpServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Ingestion settings for Amazon MSK.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsMsk}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsMskOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsMsk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsMsk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        clusterArn_ = "";
        topic_ = "";
        awsRoleArn_ = "";
        gcpServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsMsk_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.clusterArn_ = clusterArn_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.topic_ = topic_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.awsRoleArn_ = awsRoleArn_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.gcpServiceAccount_ = gcpServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk other) {
        if (other == com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getClusterArn().isEmpty()) {
          clusterArn_ = other.clusterArn_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getAwsRoleArn().isEmpty()) {
          awsRoleArn_ = other.awsRoleArn_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getGcpServiceAccount().isEmpty()) {
          gcpServiceAccount_ = other.gcpServiceAccount_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  clusterArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  topic_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  awsRoleArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  gcpServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Amazon
       * MSK ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Amazon
       * MSK ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Amazon
       * MSK ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Amazon
       * MSK ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Amazon
       * MSK ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object clusterArn_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Amazon Resource Name (ARN) that uniquely identifies the
       * cluster.
       * </pre>
       *
       * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The clusterArn.
       */
      public java.lang.String getClusterArn() {
        java.lang.Object ref = clusterArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clusterArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Amazon Resource Name (ARN) that uniquely identifies the
       * cluster.
       * </pre>
       *
       * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for clusterArn.
       */
      public com.google.protobuf.ByteString getClusterArnBytes() {
        java.lang.Object ref = clusterArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clusterArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Amazon Resource Name (ARN) that uniquely identifies the
       * cluster.
       * </pre>
       *
       * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The clusterArn to set.
       * @return This builder for chaining.
       */
      public Builder setClusterArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clusterArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Amazon Resource Name (ARN) that uniquely identifies the
       * cluster.
       * </pre>
       *
       * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterArn() {
        clusterArn_ = getDefaultInstance().getClusterArn();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Amazon Resource Name (ARN) that uniquely identifies the
       * cluster.
       * </pre>
       *
       * <code>string cluster_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for clusterArn to set.
       * @return This builder for chaining.
       */
      public Builder setClusterArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clusterArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object topic_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
       * will import from.
       * </pre>
       *
       * <code>
       * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
       * will import from.
       * </pre>
       *
       * <code>
       * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
       * will import from.
       * </pre>
       *
       * <code>
       * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topic_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
       * will import from.
       * </pre>
       *
       * <code>
       * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {
        topic_ = getDefaultInstance().getTopic();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Amazon MSK cluster that Pub/Sub
       * will import from.
       * </pre>
       *
       * <code>
       * string topic = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topic_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object awsRoleArn_ = "";

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
       * the required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The awsRoleArn.
       */
      public java.lang.String getAwsRoleArn() {
        java.lang.Object ref = awsRoleArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          awsRoleArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
       * the required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for awsRoleArn.
       */
      public com.google.protobuf.ByteString getAwsRoleArnBytes() {
        java.lang.Object ref = awsRoleArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          awsRoleArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
       * the required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
       * the required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAwsRoleArn() {
        awsRoleArn_ = getDefaultInstance().getAwsRoleArn();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Amazon MSK. Check the Pub/Sub docs for how to set up this role and
       * the required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object gcpServiceAccount_ = "";

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
       * for the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcpServiceAccount.
       */
      public java.lang.String getGcpServiceAccount() {
        java.lang.Object ref = gcpServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcpServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
       * for the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcpServiceAccount.
       */
      public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
        java.lang.Object ref = gcpServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcpServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
       * for the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
       * for the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcpServiceAccount() {
        gcpServiceAccount_ = getDefaultInstance().getGcpServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Amazon MSK (via a `AssumeRoleWithWebIdentity` call
       * for the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsMsk)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsMsk> PARSER =
        new com.google.protobuf.AbstractParser<AwsMsk>() {
          @java.lang.Override
          public AwsMsk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsMsk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsMsk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConfluentCloudOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the
     * Confluent Cloud ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the
     * Confluent Cloud ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State getState();

    /**
     *
     *
     * <pre>
     * Required. The address of the bootstrap server. The format is url:port.
     * </pre>
     *
     * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bootstrapServer.
     */
    java.lang.String getBootstrapServer();

    /**
     *
     *
     * <pre>
     * Required. The address of the bootstrap server. The format is url:port.
     * </pre>
     *
     * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bootstrapServer.
     */
    com.google.protobuf.ByteString getBootstrapServerBytes();

    /**
     *
     *
     * <pre>
     * Required. The id of the cluster.
     * </pre>
     *
     * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterId.
     */
    java.lang.String getClusterId();

    /**
     *
     *
     * <pre>
     * Required. The id of the cluster.
     * </pre>
     *
     * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterId.
     */
    com.google.protobuf.ByteString getClusterIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Confluent Cloud cluster that
     * Pub/Sub will import from.
     * </pre>
     *
     * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Confluent Cloud cluster that
     * Pub/Sub will import from.
     * </pre>
     *
     * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();

    /**
     *
     *
     * <pre>
     * Required. The id of the identity pool to be used for Federated Identity
     * authentication with Confluent Cloud. See
     * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
     * </pre>
     *
     * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The identityPoolId.
     */
    java.lang.String getIdentityPoolId();

    /**
     *
     *
     * <pre>
     * Required. The id of the identity pool to be used for Federated Identity
     * authentication with Confluent Cloud. See
     * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
     * </pre>
     *
     * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for identityPoolId.
     */
    com.google.protobuf.ByteString getIdentityPoolIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with `identity_pool_id`.
     * </pre>
     *
     * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    java.lang.String getGcpServiceAccount();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with `identity_pool_id`.
     * </pre>
     *
     * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    com.google.protobuf.ByteString getGcpServiceAccountBytes();
  }

  /**
   *
   *
   * <pre>
   * Ingestion settings for Confluent Cloud.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud}
   */
  public static final class ConfluentCloud extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)
      ConfluentCloudOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ConfluentCloud.newBuilder() to construct.
    private ConfluentCloud(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConfluentCloud() {
      state_ = 0;
      bootstrapServer_ = "";
      clusterId_ = "";
      topic_ = "";
      identityPoolId_ = "";
      gcpServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConfluentCloud();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_ConfluentCloud_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_ConfluentCloud_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for managed ingestion from Confluent Cloud.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Confluent
       * Cloud.
       * </pre>
       *
       * <code>CONFLUENT_CLOUD_PERMISSION_DENIED = 2;</code>
       */
      CONFLUENT_CLOUD_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic.
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The provided bootstrap server address is unreachable.
       * </pre>
       *
       * <code>UNREACHABLE_BOOTSTRAP_SERVER = 4;</code>
       */
      UNREACHABLE_BOOTSTRAP_SERVER(4),
      /**
       *
       *
       * <pre>
       * The provided cluster wasn't found.
       * </pre>
       *
       * <code>CLUSTER_NOT_FOUND = 5;</code>
       */
      CLUSTER_NOT_FOUND(5),
      /**
       *
       *
       * <pre>
       * The provided topic wasn't found.
       * </pre>
       *
       * <code>TOPIC_NOT_FOUND = 6;</code>
       */
      TOPIC_NOT_FOUND(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Confluent
       * Cloud.
       * </pre>
       *
       * <code>CONFLUENT_CLOUD_PERMISSION_DENIED = 2;</code>
       */
      public static final int CONFLUENT_CLOUD_PERMISSION_DENIED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic.
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;

      /**
       *
       *
       * <pre>
       * The provided bootstrap server address is unreachable.
       * </pre>
       *
       * <code>UNREACHABLE_BOOTSTRAP_SERVER = 4;</code>
       */
      public static final int UNREACHABLE_BOOTSTRAP_SERVER_VALUE = 4;

      /**
       *
       *
       * <pre>
       * The provided cluster wasn't found.
       * </pre>
       *
       * <code>CLUSTER_NOT_FOUND = 5;</code>
       */
      public static final int CLUSTER_NOT_FOUND_VALUE = 5;

      /**
       *
       *
       * <pre>
       * The provided topic wasn't found.
       * </pre>
       *
       * <code>TOPIC_NOT_FOUND = 6;</code>
       */
      public static final int TOPIC_NOT_FOUND_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return CONFLUENT_CLOUD_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return UNREACHABLE_BOOTSTRAP_SERVER;
          case 5:
            return CLUSTER_NOT_FOUND;
          case 6:
            return TOPIC_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the
     * Confluent Cloud ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the
     * Confluent Cloud ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State.UNRECOGNIZED
          : result;
    }

    public static final int BOOTSTRAP_SERVER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bootstrapServer_ = "";

    /**
     *
     *
     * <pre>
     * Required. The address of the bootstrap server. The format is url:port.
     * </pre>
     *
     * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bootstrapServer.
     */
    @java.lang.Override
    public java.lang.String getBootstrapServer() {
      java.lang.Object ref = bootstrapServer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bootstrapServer_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The address of the bootstrap server. The format is url:port.
     * </pre>
     *
     * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bootstrapServer.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBootstrapServerBytes() {
      java.lang.Object ref = bootstrapServer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bootstrapServer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLUSTER_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clusterId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The id of the cluster.
     * </pre>
     *
     * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The clusterId.
     */
    @java.lang.Override
    public java.lang.String getClusterId() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The id of the cluster.
     * </pre>
     *
     * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for clusterId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClusterIdBytes() {
      java.lang.Object ref = clusterId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOPIC_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object topic_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Confluent Cloud cluster that
     * Pub/Sub will import from.
     * </pre>
     *
     * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the topic in the Confluent Cloud cluster that
     * Pub/Sub will import from.
     * </pre>
     *
     * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IDENTITY_POOL_ID_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object identityPoolId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The id of the identity pool to be used for Federated Identity
     * authentication with Confluent Cloud. See
     * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
     * </pre>
     *
     * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The identityPoolId.
     */
    @java.lang.Override
    public java.lang.String getIdentityPoolId() {
      java.lang.Object ref = identityPoolId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identityPoolId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The id of the identity pool to be used for Federated Identity
     * authentication with Confluent Cloud. See
     * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
     * </pre>
     *
     * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for identityPoolId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdentityPoolIdBytes() {
      java.lang.Object ref = identityPoolId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        identityPoolId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCP_SERVICE_ACCOUNT_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcpServiceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with `identity_pool_id`.
     * </pre>
     *
     * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getGcpServiceAccount() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccount_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with `identity_pool_id`.
     * </pre>
     *
     * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootstrapServer_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bootstrapServer_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, clusterId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, topic_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityPoolId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, identityPoolId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, gcpServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bootstrapServer_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bootstrapServer_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, clusterId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, topic_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityPoolId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, identityPoolId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, gcpServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) obj;

      if (state_ != other.state_) return false;
      if (!getBootstrapServer().equals(other.getBootstrapServer())) return false;
      if (!getClusterId().equals(other.getClusterId())) return false;
      if (!getTopic().equals(other.getTopic())) return false;
      if (!getIdentityPoolId().equals(other.getIdentityPoolId())) return false;
      if (!getGcpServiceAccount().equals(other.getGcpServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + BOOTSTRAP_SERVER_FIELD_NUMBER;
      hash = (53 * hash) + getBootstrapServer().hashCode();
      hash = (37 * hash) + CLUSTER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getClusterId().hashCode();
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      hash = (37 * hash) + IDENTITY_POOL_ID_FIELD_NUMBER;
      hash = (53 * hash) + getIdentityPoolId().hashCode();
      hash = (37 * hash) + GCP_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGcpServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Ingestion settings for Confluent Cloud.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloudOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_ConfluentCloud_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_ConfluentCloud_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder.class);
      }

      // Construct using
      // com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        bootstrapServer_ = "";
        clusterId_ = "";
        topic_ = "";
        identityPoolId_ = "";
        gcpServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_ConfluentCloud_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.bootstrapServer_ = bootstrapServer_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.clusterId_ = clusterId_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.topic_ = topic_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.identityPoolId_ = identityPoolId_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.gcpServiceAccount_ = gcpServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getBootstrapServer().isEmpty()) {
          bootstrapServer_ = other.bootstrapServer_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getClusterId().isEmpty()) {
          clusterId_ = other.clusterId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getIdentityPoolId().isEmpty()) {
          identityPoolId_ = other.identityPoolId_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getGcpServiceAccount().isEmpty()) {
          gcpServiceAccount_ = other.gcpServiceAccount_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  bootstrapServer_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  clusterId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  topic_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  identityPoolId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  gcpServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the
       * Confluent Cloud ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the
       * Confluent Cloud ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the
       * Confluent Cloud ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the
       * Confluent Cloud ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the
       * Confluent Cloud ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object bootstrapServer_ = "";

      /**
       *
       *
       * <pre>
       * Required. The address of the bootstrap server. The format is url:port.
       * </pre>
       *
       * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bootstrapServer.
       */
      public java.lang.String getBootstrapServer() {
        java.lang.Object ref = bootstrapServer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bootstrapServer_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The address of the bootstrap server. The format is url:port.
       * </pre>
       *
       * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for bootstrapServer.
       */
      public com.google.protobuf.ByteString getBootstrapServerBytes() {
        java.lang.Object ref = bootstrapServer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bootstrapServer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The address of the bootstrap server. The format is url:port.
       * </pre>
       *
       * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bootstrapServer to set.
       * @return This builder for chaining.
       */
      public Builder setBootstrapServer(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bootstrapServer_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The address of the bootstrap server. The format is url:port.
       * </pre>
       *
       * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBootstrapServer() {
        bootstrapServer_ = getDefaultInstance().getBootstrapServer();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The address of the bootstrap server. The format is url:port.
       * </pre>
       *
       * <code>string bootstrap_server = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for bootstrapServer to set.
       * @return This builder for chaining.
       */
      public Builder setBootstrapServerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bootstrapServer_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object clusterId_ = "";

      /**
       *
       *
       * <pre>
       * Required. The id of the cluster.
       * </pre>
       *
       * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The clusterId.
       */
      public java.lang.String getClusterId() {
        java.lang.Object ref = clusterId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clusterId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the cluster.
       * </pre>
       *
       * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for clusterId.
       */
      public com.google.protobuf.ByteString getClusterIdBytes() {
        java.lang.Object ref = clusterId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clusterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the cluster.
       * </pre>
       *
       * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The clusterId to set.
       * @return This builder for chaining.
       */
      public Builder setClusterId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clusterId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the cluster.
       * </pre>
       *
       * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterId() {
        clusterId_ = getDefaultInstance().getClusterId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the cluster.
       * </pre>
       *
       * <code>string cluster_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for clusterId to set.
       * @return This builder for chaining.
       */
      public Builder setClusterIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clusterId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object topic_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Confluent Cloud cluster that
       * Pub/Sub will import from.
       * </pre>
       *
       * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Confluent Cloud cluster that
       * Pub/Sub will import from.
       * </pre>
       *
       * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Confluent Cloud cluster that
       * Pub/Sub will import from.
       * </pre>
       *
       * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        topic_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Confluent Cloud cluster that
       * Pub/Sub will import from.
       * </pre>
       *
       * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {
        topic_ = getDefaultInstance().getTopic();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the topic in the Confluent Cloud cluster that
       * Pub/Sub will import from.
       * </pre>
       *
       * <code>string topic = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        topic_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object identityPoolId_ = "";

      /**
       *
       *
       * <pre>
       * Required. The id of the identity pool to be used for Federated Identity
       * authentication with Confluent Cloud. See
       * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
       * </pre>
       *
       * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The identityPoolId.
       */
      public java.lang.String getIdentityPoolId() {
        java.lang.Object ref = identityPoolId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          identityPoolId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the identity pool to be used for Federated Identity
       * authentication with Confluent Cloud. See
       * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
       * </pre>
       *
       * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for identityPoolId.
       */
      public com.google.protobuf.ByteString getIdentityPoolIdBytes() {
        java.lang.Object ref = identityPoolId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          identityPoolId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the identity pool to be used for Federated Identity
       * authentication with Confluent Cloud. See
       * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
       * </pre>
       *
       * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The identityPoolId to set.
       * @return This builder for chaining.
       */
      public Builder setIdentityPoolId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        identityPoolId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the identity pool to be used for Federated Identity
       * authentication with Confluent Cloud. See
       * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
       * </pre>
       *
       * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIdentityPoolId() {
        identityPoolId_ = getDefaultInstance().getIdentityPoolId();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The id of the identity pool to be used for Federated Identity
       * authentication with Confluent Cloud. See
       * https://docs.confluent.io/cloud/current/security/authenticate/workload-identities/identity-providers/oauth/identity-pools.html#add-oauth-identity-pools.
       * </pre>
       *
       * <code>string identity_pool_id = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for identityPoolId to set.
       * @return This builder for chaining.
       */
      public Builder setIdentityPoolIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        identityPoolId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object gcpServiceAccount_ = "";

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with `identity_pool_id`.
       * </pre>
       *
       * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcpServiceAccount.
       */
      public java.lang.String getGcpServiceAccount() {
        java.lang.Object ref = gcpServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcpServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with `identity_pool_id`.
       * </pre>
       *
       * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcpServiceAccount.
       */
      public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
        java.lang.Object ref = gcpServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcpServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with `identity_pool_id`.
       * </pre>
       *
       * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with `identity_pool_id`.
       * </pre>
       *
       * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcpServiceAccount() {
        gcpServiceAccount_ = getDefaultInstance().getGcpServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with `identity_pool_id`.
       * </pre>
       *
       * <code>string gcp_service_account = 6 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConfluentCloud> PARSER =
        new com.google.protobuf.AbstractParser<ConfluentCloud>() {
          @java.lang.Override
          public ConfluentCloud parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConfluentCloud> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConfluentCloud> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AWS_KINESIS(1),
    CLOUD_STORAGE(2),
    AZURE_EVENT_HUBS(3),
    AWS_MSK(5),
    CONFLUENT_CLOUD(6),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return AWS_KINESIS;
        case 2:
          return CLOUD_STORAGE;
        case 3:
          return AZURE_EVENT_HUBS;
        case 5:
          return AWS_MSK;
        case 6:
          return CONFLUENT_CLOUD;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int AWS_KINESIS_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the awsKinesis field is set.
   */
  @java.lang.Override
  public boolean hasAwsKinesis() {
    return sourceCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The awsKinesis.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getAwsKinesis() {
    if (sourceCase_ == 1) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder
      getAwsKinesisOrBuilder() {
    if (sourceCase_ == 1) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
  }

  public static final int CLOUD_STORAGE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cloudStorage field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorage() {
    return sourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudStorage.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage getCloudStorage() {
    if (sourceCase_ == 2) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Cloud Storage.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder
      getCloudStorageOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
  }

  public static final int AZURE_EVENT_HUBS_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Optional. Azure Event Hubs.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the azureEventHubs field is set.
   */
  @java.lang.Override
  public boolean hasAzureEventHubs() {
    return sourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Optional. Azure Event Hubs.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The azureEventHubs.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs getAzureEventHubs() {
    if (sourceCase_ == 3) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Azure Event Hubs.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubsOrBuilder
      getAzureEventHubsOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
  }

  public static final int AWS_MSK_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Optional. Amazon MSK.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the awsMsk field is set.
   */
  @java.lang.Override
  public boolean hasAwsMsk() {
    return sourceCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Optional. Amazon MSK.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The awsMsk.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk getAwsMsk() {
    if (sourceCase_ == 5) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Amazon MSK.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMskOrBuilder getAwsMskOrBuilder() {
    if (sourceCase_ == 5) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
  }

  public static final int CONFLUENT_CLOUD_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Optional. Confluent Cloud.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the confluentCloud field is set.
   */
  @java.lang.Override
  public boolean hasConfluentCloud() {
    return sourceCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Optional. Confluent Cloud.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The confluentCloud.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud getConfluentCloud() {
    if (sourceCase_ == 6) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Confluent Cloud.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloudOrBuilder
      getConfluentCloudOrBuilder() {
    if (sourceCase_ == 6) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
  }

  public static final int PLATFORM_LOGS_SETTINGS_FIELD_NUMBER = 4;
  private com.google.pubsub.v1.PlatformLogsSettings platformLogsSettings_;

  /**
   *
   *
   * <pre>
   * Optional. Platform Logs settings. If unset, no Platform Logs will be
   * generated.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the platformLogsSettings field is set.
   */
  @java.lang.Override
  public boolean hasPlatformLogsSettings() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Platform Logs settings. If unset, no Platform Logs will be
   * generated.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The platformLogsSettings.
   */
  @java.lang.Override
  public com.google.pubsub.v1.PlatformLogsSettings getPlatformLogsSettings() {
    return platformLogsSettings_ == null
        ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
        : platformLogsSettings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Platform Logs settings. If unset, no Platform Logs will be
   * generated.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.PlatformLogsSettingsOrBuilder getPlatformLogsSettingsOrBuilder() {
    return platformLogsSettings_ == null
        ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
        : platformLogsSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeMessage(1, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2, (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(
          3, (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getPlatformLogsSettings());
    }
    if (sourceCase_ == 5) {
      output.writeMessage(5, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_);
    }
    if (sourceCase_ == 6) {
      output.writeMessage(
          6, (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPlatformLogsSettings());
    }
    if (sourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_);
    }
    if (sourceCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.IngestionDataSourceSettings other =
        (com.google.pubsub.v1.IngestionDataSourceSettings) obj;

    if (hasPlatformLogsSettings() != other.hasPlatformLogsSettings()) return false;
    if (hasPlatformLogsSettings()) {
      if (!getPlatformLogsSettings().equals(other.getPlatformLogsSettings())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getAwsKinesis().equals(other.getAwsKinesis())) return false;
        break;
      case 2:
        if (!getCloudStorage().equals(other.getCloudStorage())) return false;
        break;
      case 3:
        if (!getAzureEventHubs().equals(other.getAzureEventHubs())) return false;
        break;
      case 5:
        if (!getAwsMsk().equals(other.getAwsMsk())) return false;
        break;
      case 6:
        if (!getConfluentCloud().equals(other.getConfluentCloud())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPlatformLogsSettings()) {
      hash = (37 * hash) + PLATFORM_LOGS_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPlatformLogsSettings().hashCode();
    }
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + AWS_KINESIS_FIELD_NUMBER;
        hash = (53 * hash) + getAwsKinesis().hashCode();
        break;
      case 2:
        hash = (37 * hash) + CLOUD_STORAGE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudStorage().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AZURE_EVENT_HUBS_FIELD_NUMBER;
        hash = (53 * hash) + getAzureEventHubs().hashCode();
        break;
      case 5:
        hash = (37 * hash) + AWS_MSK_FIELD_NUMBER;
        hash = (53 * hash) + getAwsMsk().hashCode();
        break;
      case 6:
        hash = (37 * hash) + CONFLUENT_CLOUD_FIELD_NUMBER;
        hash = (53 * hash) + getConfluentCloud().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.IngestionDataSourceSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Settings for an ingestion data source on a topic.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings)
      com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.Builder.class);
    }

    // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPlatformLogsSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (awsKinesisBuilder_ != null) {
        awsKinesisBuilder_.clear();
      }
      if (cloudStorageBuilder_ != null) {
        cloudStorageBuilder_.clear();
      }
      if (azureEventHubsBuilder_ != null) {
        azureEventHubsBuilder_.clear();
      }
      if (awsMskBuilder_ != null) {
        awsMskBuilder_.clear();
      }
      if (confluentCloudBuilder_ != null) {
        confluentCloudBuilder_.clear();
      }
      platformLogsSettings_ = null;
      if (platformLogsSettingsBuilder_ != null) {
        platformLogsSettingsBuilder_.dispose();
        platformLogsSettingsBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstanceForType() {
      return com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings build() {
      com.google.pubsub.v1.IngestionDataSourceSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings buildPartial() {
      com.google.pubsub.v1.IngestionDataSourceSettings result =
          new com.google.pubsub.v1.IngestionDataSourceSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.IngestionDataSourceSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.platformLogsSettings_ =
            platformLogsSettingsBuilder_ == null
                ? platformLogsSettings_
                : platformLogsSettingsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.pubsub.v1.IngestionDataSourceSettings result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 1 && awsKinesisBuilder_ != null) {
        result.source_ = awsKinesisBuilder_.build();
      }
      if (sourceCase_ == 2 && cloudStorageBuilder_ != null) {
        result.source_ = cloudStorageBuilder_.build();
      }
      if (sourceCase_ == 3 && azureEventHubsBuilder_ != null) {
        result.source_ = azureEventHubsBuilder_.build();
      }
      if (sourceCase_ == 5 && awsMskBuilder_ != null) {
        result.source_ = awsMskBuilder_.build();
      }
      if (sourceCase_ == 6 && confluentCloudBuilder_ != null) {
        result.source_ = confluentCloudBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings) {
        return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings other) {
      if (other == com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance())
        return this;
      if (other.hasPlatformLogsSettings()) {
        mergePlatformLogsSettings(other.getPlatformLogsSettings());
      }
      switch (other.getSourceCase()) {
        case AWS_KINESIS:
          {
            mergeAwsKinesis(other.getAwsKinesis());
            break;
          }
        case CLOUD_STORAGE:
          {
            mergeCloudStorage(other.getCloudStorage());
            break;
          }
        case AZURE_EVENT_HUBS:
          {
            mergeAzureEventHubs(other.getAzureEventHubs());
            break;
          }
        case AWS_MSK:
          {
            mergeAwsMsk(other.getAwsMsk());
            break;
          }
        case CONFLUENT_CLOUD:
          {
            mergeConfluentCloud(other.getConfluentCloud());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAwsKinesisFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCloudStorageFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAzureEventHubsFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getPlatformLogsSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAwsMskFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getConfluentCloudFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>
        awsKinesisBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the awsKinesis field is set.
     */
    @java.lang.Override
    public boolean hasAwsKinesis() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The awsKinesis.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getAwsKinesis() {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      } else {
        if (sourceCase_ == 1) {
          return awsKinesisBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis value) {
      if (awsKinesisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        awsKinesisBuilder_.setMessage(value);
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder builderForValue) {
      if (awsKinesisBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        awsKinesisBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis value) {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 1) {
          awsKinesisBuilder_.mergeFrom(value);
        } else {
          awsKinesisBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAwsKinesis() {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
        }
        awsKinesisBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder
        getAwsKinesisBuilder() {
      return getAwsKinesisFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder
        getAwsKinesisOrBuilder() {
      if ((sourceCase_ == 1) && (awsKinesisBuilder_ != null)) {
        return awsKinesisBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 1) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>
        getAwsKinesisFieldBuilder() {
      if (awsKinesisBuilder_ == null) {
        if (!(sourceCase_ == 1)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
        }
        awsKinesisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 1;
      onChanged();
      return awsKinesisBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder>
        cloudStorageBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the cloudStorage field is set.
     */
    @java.lang.Override
    public boolean hasCloudStorage() {
      return sourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The cloudStorage.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage getCloudStorage() {
      if (cloudStorageBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return cloudStorageBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorage(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage value) {
      if (cloudStorageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        cloudStorageBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCloudStorage(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder builderForValue) {
      if (cloudStorageBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        cloudStorageBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCloudStorage(
        com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage value) {
      if (cloudStorageBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          cloudStorageBuilder_.mergeFrom(value);
        } else {
          cloudStorageBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCloudStorage() {
      if (cloudStorageBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        cloudStorageBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder
        getCloudStorageBuilder() {
      return getCloudStorageFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder
        getCloudStorageOrBuilder() {
      if ((sourceCase_ == 2) && (cloudStorageBuilder_ != null)) {
        return cloudStorageBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.CloudStorage cloud_storage = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder>
        getCloudStorageFieldBuilder() {
      if (cloudStorageBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.getDefaultInstance();
        }
        cloudStorageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorageOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.CloudStorage) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return cloudStorageBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs,
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubsOrBuilder>
        azureEventHubsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the azureEventHubs field is set.
     */
    @java.lang.Override
    public boolean hasAzureEventHubs() {
      return sourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The azureEventHubs.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs getAzureEventHubs() {
      if (azureEventHubsBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return azureEventHubsBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAzureEventHubs(
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs value) {
      if (azureEventHubsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        azureEventHubsBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAzureEventHubs(
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder builderForValue) {
      if (azureEventHubsBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        azureEventHubsBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAzureEventHubs(
        com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs value) {
      if (azureEventHubsBuilder_ == null) {
        if (sourceCase_ == 3
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          azureEventHubsBuilder_.mergeFrom(value);
        } else {
          azureEventHubsBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAzureEventHubs() {
      if (azureEventHubsBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        azureEventHubsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder
        getAzureEventHubsBuilder() {
      return getAzureEventHubsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubsOrBuilder
        getAzureEventHubsOrBuilder() {
      if ((sourceCase_ == 3) && (azureEventHubsBuilder_ != null)) {
        return azureEventHubsBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Azure Event Hubs.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs azure_event_hubs = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs,
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubsOrBuilder>
        getAzureEventHubsFieldBuilder() {
      if (azureEventHubsBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.getDefaultInstance();
        }
        azureEventHubsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs,
                com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubsOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.AzureEventHubs) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return azureEventHubsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMskOrBuilder>
        awsMskBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the awsMsk field is set.
     */
    @java.lang.Override
    public boolean hasAwsMsk() {
      return sourceCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The awsMsk.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk getAwsMsk() {
      if (awsMskBuilder_ == null) {
        if (sourceCase_ == 5) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
      } else {
        if (sourceCase_ == 5) {
          return awsMskBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsMsk(com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk value) {
      if (awsMskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        awsMskBuilder_.setMessage(value);
      }
      sourceCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsMsk(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder builderForValue) {
      if (awsMskBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        awsMskBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAwsMsk(com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk value) {
      if (awsMskBuilder_ == null) {
        if (sourceCase_ == 5
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 5) {
          awsMskBuilder_.mergeFrom(value);
        } else {
          awsMskBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAwsMsk() {
      if (awsMskBuilder_ == null) {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
        }
        awsMskBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder getAwsMskBuilder() {
      return getAwsMskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsMskOrBuilder getAwsMskOrBuilder() {
      if ((sourceCase_ == 5) && (awsMskBuilder_ != null)) {
        return awsMskBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 5) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Amazon MSK.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsMsk aws_msk = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsMskOrBuilder>
        getAwsMskFieldBuilder() {
      if (awsMskBuilder_ == null) {
        if (!(sourceCase_ == 5)) {
          source_ = com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.getDefaultInstance();
        }
        awsMskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsMskOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.AwsMsk) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 5;
      onChanged();
      return awsMskBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud,
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloudOrBuilder>
        confluentCloudBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the confluentCloud field is set.
     */
    @java.lang.Override
    public boolean hasConfluentCloud() {
      return sourceCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The confluentCloud.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud getConfluentCloud() {
      if (confluentCloudBuilder_ == null) {
        if (sourceCase_ == 6) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
      } else {
        if (sourceCase_ == 6) {
          return confluentCloudBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfluentCloud(
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud value) {
      if (confluentCloudBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        confluentCloudBuilder_.setMessage(value);
      }
      sourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConfluentCloud(
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder builderForValue) {
      if (confluentCloudBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        confluentCloudBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConfluentCloud(
        com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud value) {
      if (confluentCloudBuilder_ == null) {
        if (sourceCase_ == 6
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 6) {
          confluentCloudBuilder_.mergeFrom(value);
        } else {
          confluentCloudBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConfluentCloud() {
      if (confluentCloudBuilder_ == null) {
        if (sourceCase_ == 6) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 6) {
          sourceCase_ = 0;
          source_ = null;
        }
        confluentCloudBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder
        getConfluentCloudBuilder() {
      return getConfluentCloudFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloudOrBuilder
        getConfluentCloudOrBuilder() {
      if ((sourceCase_ == 6) && (confluentCloudBuilder_ != null)) {
        return confluentCloudBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 6) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Confluent Cloud.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud confluent_cloud = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud,
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloudOrBuilder>
        getConfluentCloudFieldBuilder() {
      if (confluentCloudBuilder_ == null) {
        if (!(sourceCase_ == 6)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.getDefaultInstance();
        }
        confluentCloudBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud,
                com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloudOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.ConfluentCloud) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 6;
      onChanged();
      return confluentCloudBuilder_;
    }

    private com.google.pubsub.v1.PlatformLogsSettings platformLogsSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PlatformLogsSettings,
            com.google.pubsub.v1.PlatformLogsSettings.Builder,
            com.google.pubsub.v1.PlatformLogsSettingsOrBuilder>
        platformLogsSettingsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the platformLogsSettings field is set.
     */
    public boolean hasPlatformLogsSettings() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The platformLogsSettings.
     */
    public com.google.pubsub.v1.PlatformLogsSettings getPlatformLogsSettings() {
      if (platformLogsSettingsBuilder_ == null) {
        return platformLogsSettings_ == null
            ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
            : platformLogsSettings_;
      } else {
        return platformLogsSettingsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlatformLogsSettings(com.google.pubsub.v1.PlatformLogsSettings value) {
      if (platformLogsSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformLogsSettings_ = value;
      } else {
        platformLogsSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPlatformLogsSettings(
        com.google.pubsub.v1.PlatformLogsSettings.Builder builderForValue) {
      if (platformLogsSettingsBuilder_ == null) {
        platformLogsSettings_ = builderForValue.build();
      } else {
        platformLogsSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePlatformLogsSettings(com.google.pubsub.v1.PlatformLogsSettings value) {
      if (platformLogsSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && platformLogsSettings_ != null
            && platformLogsSettings_
                != com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()) {
          getPlatformLogsSettingsBuilder().mergeFrom(value);
        } else {
          platformLogsSettings_ = value;
        }
      } else {
        platformLogsSettingsBuilder_.mergeFrom(value);
      }
      if (platformLogsSettings_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPlatformLogsSettings() {
      bitField0_ = (bitField0_ & ~0x00000020);
      platformLogsSettings_ = null;
      if (platformLogsSettingsBuilder_ != null) {
        platformLogsSettingsBuilder_.dispose();
        platformLogsSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PlatformLogsSettings.Builder getPlatformLogsSettingsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPlatformLogsSettingsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PlatformLogsSettingsOrBuilder getPlatformLogsSettingsOrBuilder() {
      if (platformLogsSettingsBuilder_ != null) {
        return platformLogsSettingsBuilder_.getMessageOrBuilder();
      } else {
        return platformLogsSettings_ == null
            ? com.google.pubsub.v1.PlatformLogsSettings.getDefaultInstance()
            : platformLogsSettings_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Platform Logs settings. If unset, no Platform Logs will be
     * generated.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PlatformLogsSettings platform_logs_settings = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PlatformLogsSettings,
            com.google.pubsub.v1.PlatformLogsSettings.Builder,
            com.google.pubsub.v1.PlatformLogsSettingsOrBuilder>
        getPlatformLogsSettingsFieldBuilder() {
      if (platformLogsSettingsBuilder_ == null) {
        platformLogsSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.PlatformLogsSettings,
                com.google.pubsub.v1.PlatformLogsSettings.Builder,
                com.google.pubsub.v1.PlatformLogsSettingsOrBuilder>(
                getPlatformLogsSettings(), getParentForChildren(), isClean());
        platformLogsSettings_ = null;
      }
      return platformLogsSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings)
  private static final com.google.pubsub.v1.IngestionDataSourceSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings();
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IngestionDataSourceSettings> PARSER =
      new com.google.protobuf.AbstractParser<IngestionDataSourceSettings>() {
        @java.lang.Override
        public IngestionDataSourceSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IngestionDataSourceSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IngestionDataSourceSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
