/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagKeyName
implements ResourceName {
    private static final PathTemplate TAG_KEY = PathTemplate.createWithoutUrlEncoding((String)"tagKeys/{tag_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String tagKey;

    @Deprecated
    protected TagKeyName() {
        this.tagKey = null;
    }

    private TagKeyName(Builder builder) {
        this.tagKey = (String)Preconditions.checkNotNull((Object)builder.getTagKey());
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TagKeyName of(String tagKey) {
        return TagKeyName.newBuilder().setTagKey(tagKey).build();
    }

    public static String format(String tagKey) {
        return TagKeyName.newBuilder().setTagKey(tagKey).build().toString();
    }

    public static TagKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TAG_KEY.validatedMatch(formattedString, "TagKeyName.parse: formattedString not in valid format");
        return TagKeyName.of((String)matchMap.get("tag_key"));
    }

    public static List<TagKeyName> parseList(List<String> formattedStrings) {
        ArrayList<TagKeyName> list = new ArrayList<TagKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TAG_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagKeyName tagKeyName = this;
            synchronized (tagKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.tagKey != null) {
                        fieldMapBuilder.put((Object)"tag_key", (Object)this.tagKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TAG_KEY.instantiate(new String[]{"tag_key", this.tagKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TagKeyName that = (TagKeyName)o;
            return Objects.equals(this.tagKey, that.tagKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.tagKey);
    }

    public static class Builder {
        private String tagKey;

        protected Builder() {
        }

        public String getTagKey() {
            return this.tagKey;
        }

        public Builder setTagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        private Builder(TagKeyName tagKeyName) {
            this.tagKey = tagKeyName.tagKey;
        }

        public TagKeyName build() {
            return new TagKeyName(this);
        }
    }
}

