/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Probe describes a health check to be performed against a container to
 * determine whether it is alive or ready to receive traffic.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Probe}
 */
public final class Probe extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Probe)
    ProbeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Probe.newBuilder() to construct.
  private Probe(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Probe() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Probe();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto.internal_static_google_cloud_run_v2_Probe_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_Probe_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Probe.class, com.google.cloud.run.v2.Probe.Builder.class);
  }

  private int probeTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object probeType_;

  public enum ProbeTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HTTP_GET(5),
    TCP_SOCKET(6),
    GRPC(7),
    PROBETYPE_NOT_SET(0);
    private final int value;

    private ProbeTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProbeTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProbeTypeCase forNumber(int value) {
      switch (value) {
        case 5:
          return HTTP_GET;
        case 6:
          return TCP_SOCKET;
        case 7:
          return GRPC;
        case 0:
          return PROBETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ProbeTypeCase getProbeTypeCase() {
    return ProbeTypeCase.forNumber(probeTypeCase_);
  }

  public static final int INITIAL_DELAY_SECONDS_FIELD_NUMBER = 1;
  private int initialDelaySeconds_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds after the container has started before the
   * probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum
   * value for liveness probe is 3600. Maximum value for startup probe is 240.
   * </pre>
   *
   * <code>int32 initial_delay_seconds = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The initialDelaySeconds.
   */
  @java.lang.Override
  public int getInitialDelaySeconds() {
    return initialDelaySeconds_;
  }

  public static final int TIMEOUT_SECONDS_FIELD_NUMBER = 2;
  private int timeoutSeconds_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds after which the probe times out.
   * Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
   * Must be smaller than period_seconds.
   * </pre>
   *
   * <code>int32 timeout_seconds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The timeoutSeconds.
   */
  @java.lang.Override
  public int getTimeoutSeconds() {
    return timeoutSeconds_;
  }

  public static final int PERIOD_SECONDS_FIELD_NUMBER = 3;
  private int periodSeconds_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. How often (in seconds) to perform the probe.
   * Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
   * is 3600. Maximum value for startup probe is 240.
   * Must be greater or equal than timeout_seconds.
   * </pre>
   *
   * <code>int32 period_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The periodSeconds.
   */
  @java.lang.Override
  public int getPeriodSeconds() {
    return periodSeconds_;
  }

  public static final int FAILURE_THRESHOLD_FIELD_NUMBER = 4;
  private int failureThreshold_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Minimum consecutive failures for the probe to be considered
   * failed after having succeeded. Defaults to 3. Minimum value is 1.
   * </pre>
   *
   * <code>int32 failure_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The failureThreshold.
   */
  @java.lang.Override
  public int getFailureThreshold() {
    return failureThreshold_;
  }

  public static final int HTTP_GET_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Optional. HTTPGet specifies the http request to perform.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the httpGet field is set.
   */
  @java.lang.Override
  public boolean hasHttpGet() {
    return probeTypeCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Optional. HTTPGet specifies the http request to perform.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The httpGet.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.HTTPGetAction getHttpGet() {
    if (probeTypeCase_ == 5) {
      return (com.google.cloud.run.v2.HTTPGetAction) probeType_;
    }
    return com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. HTTPGet specifies the http request to perform.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.HTTPGetActionOrBuilder getHttpGetOrBuilder() {
    if (probeTypeCase_ == 5) {
      return (com.google.cloud.run.v2.HTTPGetAction) probeType_;
    }
    return com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance();
  }

  public static final int TCP_SOCKET_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Optional. TCPSocket specifies an action involving a TCP port.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the tcpSocket field is set.
   */
  @java.lang.Override
  public boolean hasTcpSocket() {
    return probeTypeCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Optional. TCPSocket specifies an action involving a TCP port.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tcpSocket.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TCPSocketAction getTcpSocket() {
    if (probeTypeCase_ == 6) {
      return (com.google.cloud.run.v2.TCPSocketAction) probeType_;
    }
    return com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. TCPSocket specifies an action involving a TCP port.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.TCPSocketActionOrBuilder getTcpSocketOrBuilder() {
    if (probeTypeCase_ == 6) {
      return (com.google.cloud.run.v2.TCPSocketAction) probeType_;
    }
    return com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance();
  }

  public static final int GRPC_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Optional. GRPC specifies an action involving a gRPC port.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the grpc field is set.
   */
  @java.lang.Override
  public boolean hasGrpc() {
    return probeTypeCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Optional. GRPC specifies an action involving a gRPC port.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The grpc.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.GRPCAction getGrpc() {
    if (probeTypeCase_ == 7) {
      return (com.google.cloud.run.v2.GRPCAction) probeType_;
    }
    return com.google.cloud.run.v2.GRPCAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. GRPC specifies an action involving a gRPC port.
   * Exactly one of httpGet, tcpSocket, or grpc must be specified.
   * </pre>
   *
   * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.GRPCActionOrBuilder getGrpcOrBuilder() {
    if (probeTypeCase_ == 7) {
      return (com.google.cloud.run.v2.GRPCAction) probeType_;
    }
    return com.google.cloud.run.v2.GRPCAction.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (initialDelaySeconds_ != 0) {
      output.writeInt32(1, initialDelaySeconds_);
    }
    if (timeoutSeconds_ != 0) {
      output.writeInt32(2, timeoutSeconds_);
    }
    if (periodSeconds_ != 0) {
      output.writeInt32(3, periodSeconds_);
    }
    if (failureThreshold_ != 0) {
      output.writeInt32(4, failureThreshold_);
    }
    if (probeTypeCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.run.v2.HTTPGetAction) probeType_);
    }
    if (probeTypeCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.run.v2.TCPSocketAction) probeType_);
    }
    if (probeTypeCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.run.v2.GRPCAction) probeType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (initialDelaySeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, initialDelaySeconds_);
    }
    if (timeoutSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, timeoutSeconds_);
    }
    if (periodSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, periodSeconds_);
    }
    if (failureThreshold_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, failureThreshold_);
    }
    if (probeTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.run.v2.HTTPGetAction) probeType_);
    }
    if (probeTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.run.v2.TCPSocketAction) probeType_);
    }
    if (probeTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.run.v2.GRPCAction) probeType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Probe)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Probe other = (com.google.cloud.run.v2.Probe) obj;

    if (getInitialDelaySeconds() != other.getInitialDelaySeconds()) return false;
    if (getTimeoutSeconds() != other.getTimeoutSeconds()) return false;
    if (getPeriodSeconds() != other.getPeriodSeconds()) return false;
    if (getFailureThreshold() != other.getFailureThreshold()) return false;
    if (!getProbeTypeCase().equals(other.getProbeTypeCase())) return false;
    switch (probeTypeCase_) {
      case 5:
        if (!getHttpGet().equals(other.getHttpGet())) return false;
        break;
      case 6:
        if (!getTcpSocket().equals(other.getTcpSocket())) return false;
        break;
      case 7:
        if (!getGrpc().equals(other.getGrpc())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INITIAL_DELAY_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getInitialDelaySeconds();
    hash = (37 * hash) + TIMEOUT_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getTimeoutSeconds();
    hash = (37 * hash) + PERIOD_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getPeriodSeconds();
    hash = (37 * hash) + FAILURE_THRESHOLD_FIELD_NUMBER;
    hash = (53 * hash) + getFailureThreshold();
    switch (probeTypeCase_) {
      case 5:
        hash = (37 * hash) + HTTP_GET_FIELD_NUMBER;
        hash = (53 * hash) + getHttpGet().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TCP_SOCKET_FIELD_NUMBER;
        hash = (53 * hash) + getTcpSocket().hashCode();
        break;
      case 7:
        hash = (37 * hash) + GRPC_FIELD_NUMBER;
        hash = (53 * hash) + getGrpc().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Probe parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Probe parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Probe parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Probe parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Probe prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Probe describes a health check to be performed against a container to
   * determine whether it is alive or ready to receive traffic.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Probe}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Probe)
      com.google.cloud.run.v2.ProbeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Probe_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Probe_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Probe.class, com.google.cloud.run.v2.Probe.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Probe.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      initialDelaySeconds_ = 0;
      timeoutSeconds_ = 0;
      periodSeconds_ = 0;
      failureThreshold_ = 0;
      if (httpGetBuilder_ != null) {
        httpGetBuilder_.clear();
      }
      if (tcpSocketBuilder_ != null) {
        tcpSocketBuilder_.clear();
      }
      if (grpcBuilder_ != null) {
        grpcBuilder_.clear();
      }
      probeTypeCase_ = 0;
      probeType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Probe_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Probe getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Probe.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Probe build() {
      com.google.cloud.run.v2.Probe result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Probe buildPartial() {
      com.google.cloud.run.v2.Probe result = new com.google.cloud.run.v2.Probe(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.Probe result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.initialDelaySeconds_ = initialDelaySeconds_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.timeoutSeconds_ = timeoutSeconds_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.periodSeconds_ = periodSeconds_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.failureThreshold_ = failureThreshold_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.Probe result) {
      result.probeTypeCase_ = probeTypeCase_;
      result.probeType_ = this.probeType_;
      if (probeTypeCase_ == 5 && httpGetBuilder_ != null) {
        result.probeType_ = httpGetBuilder_.build();
      }
      if (probeTypeCase_ == 6 && tcpSocketBuilder_ != null) {
        result.probeType_ = tcpSocketBuilder_.build();
      }
      if (probeTypeCase_ == 7 && grpcBuilder_ != null) {
        result.probeType_ = grpcBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Probe) {
        return mergeFrom((com.google.cloud.run.v2.Probe) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Probe other) {
      if (other == com.google.cloud.run.v2.Probe.getDefaultInstance()) return this;
      if (other.getInitialDelaySeconds() != 0) {
        setInitialDelaySeconds(other.getInitialDelaySeconds());
      }
      if (other.getTimeoutSeconds() != 0) {
        setTimeoutSeconds(other.getTimeoutSeconds());
      }
      if (other.getPeriodSeconds() != 0) {
        setPeriodSeconds(other.getPeriodSeconds());
      }
      if (other.getFailureThreshold() != 0) {
        setFailureThreshold(other.getFailureThreshold());
      }
      switch (other.getProbeTypeCase()) {
        case HTTP_GET:
          {
            mergeHttpGet(other.getHttpGet());
            break;
          }
        case TCP_SOCKET:
          {
            mergeTcpSocket(other.getTcpSocket());
            break;
          }
        case GRPC:
          {
            mergeGrpc(other.getGrpc());
            break;
          }
        case PROBETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                initialDelaySeconds_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                timeoutSeconds_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                periodSeconds_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                failureThreshold_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getHttpGetFieldBuilder().getBuilder(), extensionRegistry);
                probeTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTcpSocketFieldBuilder().getBuilder(), extensionRegistry);
                probeTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getGrpcFieldBuilder().getBuilder(), extensionRegistry);
                probeTypeCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int probeTypeCase_ = 0;
    private java.lang.Object probeType_;

    public ProbeTypeCase getProbeTypeCase() {
      return ProbeTypeCase.forNumber(probeTypeCase_);
    }

    public Builder clearProbeType() {
      probeTypeCase_ = 0;
      probeType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int initialDelaySeconds_;

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds after the container has started before the
     * probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum
     * value for liveness probe is 3600. Maximum value for startup probe is 240.
     * </pre>
     *
     * <code>int32 initial_delay_seconds = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The initialDelaySeconds.
     */
    @java.lang.Override
    public int getInitialDelaySeconds() {
      return initialDelaySeconds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds after the container has started before the
     * probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum
     * value for liveness probe is 3600. Maximum value for startup probe is 240.
     * </pre>
     *
     * <code>int32 initial_delay_seconds = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The initialDelaySeconds to set.
     * @return This builder for chaining.
     */
    public Builder setInitialDelaySeconds(int value) {

      initialDelaySeconds_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds after the container has started before the
     * probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum
     * value for liveness probe is 3600. Maximum value for startup probe is 240.
     * </pre>
     *
     * <code>int32 initial_delay_seconds = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInitialDelaySeconds() {
      bitField0_ = (bitField0_ & ~0x00000001);
      initialDelaySeconds_ = 0;
      onChanged();
      return this;
    }

    private int timeoutSeconds_;

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds after which the probe times out.
     * Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
     * Must be smaller than period_seconds.
     * </pre>
     *
     * <code>int32 timeout_seconds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The timeoutSeconds.
     */
    @java.lang.Override
    public int getTimeoutSeconds() {
      return timeoutSeconds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds after which the probe times out.
     * Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
     * Must be smaller than period_seconds.
     * </pre>
     *
     * <code>int32 timeout_seconds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The timeoutSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setTimeoutSeconds(int value) {

      timeoutSeconds_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds after which the probe times out.
     * Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
     * Must be smaller than period_seconds.
     * </pre>
     *
     * <code>int32 timeout_seconds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeoutSeconds() {
      bitField0_ = (bitField0_ & ~0x00000002);
      timeoutSeconds_ = 0;
      onChanged();
      return this;
    }

    private int periodSeconds_;

    /**
     *
     *
     * <pre>
     * Optional. How often (in seconds) to perform the probe.
     * Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
     * is 3600. Maximum value for startup probe is 240.
     * Must be greater or equal than timeout_seconds.
     * </pre>
     *
     * <code>int32 period_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The periodSeconds.
     */
    @java.lang.Override
    public int getPeriodSeconds() {
      return periodSeconds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. How often (in seconds) to perform the probe.
     * Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
     * is 3600. Maximum value for startup probe is 240.
     * Must be greater or equal than timeout_seconds.
     * </pre>
     *
     * <code>int32 period_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The periodSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setPeriodSeconds(int value) {

      periodSeconds_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. How often (in seconds) to perform the probe.
     * Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
     * is 3600. Maximum value for startup probe is 240.
     * Must be greater or equal than timeout_seconds.
     * </pre>
     *
     * <code>int32 period_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeriodSeconds() {
      bitField0_ = (bitField0_ & ~0x00000004);
      periodSeconds_ = 0;
      onChanged();
      return this;
    }

    private int failureThreshold_;

    /**
     *
     *
     * <pre>
     * Optional. Minimum consecutive failures for the probe to be considered
     * failed after having succeeded. Defaults to 3. Minimum value is 1.
     * </pre>
     *
     * <code>int32 failure_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The failureThreshold.
     */
    @java.lang.Override
    public int getFailureThreshold() {
      return failureThreshold_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Minimum consecutive failures for the probe to be considered
     * failed after having succeeded. Defaults to 3. Minimum value is 1.
     * </pre>
     *
     * <code>int32 failure_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The failureThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setFailureThreshold(int value) {

      failureThreshold_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Minimum consecutive failures for the probe to be considered
     * failed after having succeeded. Defaults to 3. Minimum value is 1.
     * </pre>
     *
     * <code>int32 failure_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureThreshold() {
      bitField0_ = (bitField0_ & ~0x00000008);
      failureThreshold_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.HTTPGetAction,
            com.google.cloud.run.v2.HTTPGetAction.Builder,
            com.google.cloud.run.v2.HTTPGetActionOrBuilder>
        httpGetBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the httpGet field is set.
     */
    @java.lang.Override
    public boolean hasHttpGet() {
      return probeTypeCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The httpGet.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.HTTPGetAction getHttpGet() {
      if (httpGetBuilder_ == null) {
        if (probeTypeCase_ == 5) {
          return (com.google.cloud.run.v2.HTTPGetAction) probeType_;
        }
        return com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance();
      } else {
        if (probeTypeCase_ == 5) {
          return httpGetBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHttpGet(com.google.cloud.run.v2.HTTPGetAction value) {
      if (httpGetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        probeType_ = value;
        onChanged();
      } else {
        httpGetBuilder_.setMessage(value);
      }
      probeTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHttpGet(com.google.cloud.run.v2.HTTPGetAction.Builder builderForValue) {
      if (httpGetBuilder_ == null) {
        probeType_ = builderForValue.build();
        onChanged();
      } else {
        httpGetBuilder_.setMessage(builderForValue.build());
      }
      probeTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHttpGet(com.google.cloud.run.v2.HTTPGetAction value) {
      if (httpGetBuilder_ == null) {
        if (probeTypeCase_ == 5
            && probeType_ != com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance()) {
          probeType_ =
              com.google.cloud.run.v2.HTTPGetAction.newBuilder(
                      (com.google.cloud.run.v2.HTTPGetAction) probeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          probeType_ = value;
        }
        onChanged();
      } else {
        if (probeTypeCase_ == 5) {
          httpGetBuilder_.mergeFrom(value);
        } else {
          httpGetBuilder_.setMessage(value);
        }
      }
      probeTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHttpGet() {
      if (httpGetBuilder_ == null) {
        if (probeTypeCase_ == 5) {
          probeTypeCase_ = 0;
          probeType_ = null;
          onChanged();
        }
      } else {
        if (probeTypeCase_ == 5) {
          probeTypeCase_ = 0;
          probeType_ = null;
        }
        httpGetBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.HTTPGetAction.Builder getHttpGetBuilder() {
      return getHttpGetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.HTTPGetActionOrBuilder getHttpGetOrBuilder() {
      if ((probeTypeCase_ == 5) && (httpGetBuilder_ != null)) {
        return httpGetBuilder_.getMessageOrBuilder();
      } else {
        if (probeTypeCase_ == 5) {
          return (com.google.cloud.run.v2.HTTPGetAction) probeType_;
        }
        return com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. HTTPGet specifies the http request to perform.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.HTTPGetAction http_get = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.HTTPGetAction,
            com.google.cloud.run.v2.HTTPGetAction.Builder,
            com.google.cloud.run.v2.HTTPGetActionOrBuilder>
        getHttpGetFieldBuilder() {
      if (httpGetBuilder_ == null) {
        if (!(probeTypeCase_ == 5)) {
          probeType_ = com.google.cloud.run.v2.HTTPGetAction.getDefaultInstance();
        }
        httpGetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.HTTPGetAction,
                com.google.cloud.run.v2.HTTPGetAction.Builder,
                com.google.cloud.run.v2.HTTPGetActionOrBuilder>(
                (com.google.cloud.run.v2.HTTPGetAction) probeType_,
                getParentForChildren(),
                isClean());
        probeType_ = null;
      }
      probeTypeCase_ = 5;
      onChanged();
      return httpGetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TCPSocketAction,
            com.google.cloud.run.v2.TCPSocketAction.Builder,
            com.google.cloud.run.v2.TCPSocketActionOrBuilder>
        tcpSocketBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tcpSocket field is set.
     */
    @java.lang.Override
    public boolean hasTcpSocket() {
      return probeTypeCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tcpSocket.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.TCPSocketAction getTcpSocket() {
      if (tcpSocketBuilder_ == null) {
        if (probeTypeCase_ == 6) {
          return (com.google.cloud.run.v2.TCPSocketAction) probeType_;
        }
        return com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance();
      } else {
        if (probeTypeCase_ == 6) {
          return tcpSocketBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTcpSocket(com.google.cloud.run.v2.TCPSocketAction value) {
      if (tcpSocketBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        probeType_ = value;
        onChanged();
      } else {
        tcpSocketBuilder_.setMessage(value);
      }
      probeTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTcpSocket(com.google.cloud.run.v2.TCPSocketAction.Builder builderForValue) {
      if (tcpSocketBuilder_ == null) {
        probeType_ = builderForValue.build();
        onChanged();
      } else {
        tcpSocketBuilder_.setMessage(builderForValue.build());
      }
      probeTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTcpSocket(com.google.cloud.run.v2.TCPSocketAction value) {
      if (tcpSocketBuilder_ == null) {
        if (probeTypeCase_ == 6
            && probeType_ != com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance()) {
          probeType_ =
              com.google.cloud.run.v2.TCPSocketAction.newBuilder(
                      (com.google.cloud.run.v2.TCPSocketAction) probeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          probeType_ = value;
        }
        onChanged();
      } else {
        if (probeTypeCase_ == 6) {
          tcpSocketBuilder_.mergeFrom(value);
        } else {
          tcpSocketBuilder_.setMessage(value);
        }
      }
      probeTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTcpSocket() {
      if (tcpSocketBuilder_ == null) {
        if (probeTypeCase_ == 6) {
          probeTypeCase_ = 0;
          probeType_ = null;
          onChanged();
        }
      } else {
        if (probeTypeCase_ == 6) {
          probeTypeCase_ = 0;
          probeType_ = null;
        }
        tcpSocketBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.TCPSocketAction.Builder getTcpSocketBuilder() {
      return getTcpSocketFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.TCPSocketActionOrBuilder getTcpSocketOrBuilder() {
      if ((probeTypeCase_ == 6) && (tcpSocketBuilder_ != null)) {
        return tcpSocketBuilder_.getMessageOrBuilder();
      } else {
        if (probeTypeCase_ == 6) {
          return (com.google.cloud.run.v2.TCPSocketAction) probeType_;
        }
        return com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. TCPSocket specifies an action involving a TCP port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.TCPSocketAction tcp_socket = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.TCPSocketAction,
            com.google.cloud.run.v2.TCPSocketAction.Builder,
            com.google.cloud.run.v2.TCPSocketActionOrBuilder>
        getTcpSocketFieldBuilder() {
      if (tcpSocketBuilder_ == null) {
        if (!(probeTypeCase_ == 6)) {
          probeType_ = com.google.cloud.run.v2.TCPSocketAction.getDefaultInstance();
        }
        tcpSocketBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.TCPSocketAction,
                com.google.cloud.run.v2.TCPSocketAction.Builder,
                com.google.cloud.run.v2.TCPSocketActionOrBuilder>(
                (com.google.cloud.run.v2.TCPSocketAction) probeType_,
                getParentForChildren(),
                isClean());
        probeType_ = null;
      }
      probeTypeCase_ = 6;
      onChanged();
      return tcpSocketBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.GRPCAction,
            com.google.cloud.run.v2.GRPCAction.Builder,
            com.google.cloud.run.v2.GRPCActionOrBuilder>
        grpcBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the grpc field is set.
     */
    @java.lang.Override
    public boolean hasGrpc() {
      return probeTypeCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The grpc.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.GRPCAction getGrpc() {
      if (grpcBuilder_ == null) {
        if (probeTypeCase_ == 7) {
          return (com.google.cloud.run.v2.GRPCAction) probeType_;
        }
        return com.google.cloud.run.v2.GRPCAction.getDefaultInstance();
      } else {
        if (probeTypeCase_ == 7) {
          return grpcBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.GRPCAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGrpc(com.google.cloud.run.v2.GRPCAction value) {
      if (grpcBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        probeType_ = value;
        onChanged();
      } else {
        grpcBuilder_.setMessage(value);
      }
      probeTypeCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGrpc(com.google.cloud.run.v2.GRPCAction.Builder builderForValue) {
      if (grpcBuilder_ == null) {
        probeType_ = builderForValue.build();
        onChanged();
      } else {
        grpcBuilder_.setMessage(builderForValue.build());
      }
      probeTypeCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGrpc(com.google.cloud.run.v2.GRPCAction value) {
      if (grpcBuilder_ == null) {
        if (probeTypeCase_ == 7
            && probeType_ != com.google.cloud.run.v2.GRPCAction.getDefaultInstance()) {
          probeType_ =
              com.google.cloud.run.v2.GRPCAction.newBuilder(
                      (com.google.cloud.run.v2.GRPCAction) probeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          probeType_ = value;
        }
        onChanged();
      } else {
        if (probeTypeCase_ == 7) {
          grpcBuilder_.mergeFrom(value);
        } else {
          grpcBuilder_.setMessage(value);
        }
      }
      probeTypeCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGrpc() {
      if (grpcBuilder_ == null) {
        if (probeTypeCase_ == 7) {
          probeTypeCase_ = 0;
          probeType_ = null;
          onChanged();
        }
      } else {
        if (probeTypeCase_ == 7) {
          probeTypeCase_ = 0;
          probeType_ = null;
        }
        grpcBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.GRPCAction.Builder getGrpcBuilder() {
      return getGrpcFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.GRPCActionOrBuilder getGrpcOrBuilder() {
      if ((probeTypeCase_ == 7) && (grpcBuilder_ != null)) {
        return grpcBuilder_.getMessageOrBuilder();
      } else {
        if (probeTypeCase_ == 7) {
          return (com.google.cloud.run.v2.GRPCAction) probeType_;
        }
        return com.google.cloud.run.v2.GRPCAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. GRPC specifies an action involving a gRPC port.
     * Exactly one of httpGet, tcpSocket, or grpc must be specified.
     * </pre>
     *
     * <code>.google.cloud.run.v2.GRPCAction grpc = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.GRPCAction,
            com.google.cloud.run.v2.GRPCAction.Builder,
            com.google.cloud.run.v2.GRPCActionOrBuilder>
        getGrpcFieldBuilder() {
      if (grpcBuilder_ == null) {
        if (!(probeTypeCase_ == 7)) {
          probeType_ = com.google.cloud.run.v2.GRPCAction.getDefaultInstance();
        }
        grpcBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.GRPCAction,
                com.google.cloud.run.v2.GRPCAction.Builder,
                com.google.cloud.run.v2.GRPCActionOrBuilder>(
                (com.google.cloud.run.v2.GRPCAction) probeType_, getParentForChildren(), isClean());
        probeType_ = null;
      }
      probeTypeCase_ = 7;
      onChanged();
      return grpcBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Probe)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Probe)
  private static final com.google.cloud.run.v2.Probe DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Probe();
  }

  public static com.google.cloud.run.v2.Probe getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Probe> PARSER =
      new com.google.protobuf.AbstractParser<Probe>() {
        @java.lang.Override
        public Probe parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Probe> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Probe> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Probe getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
