/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for ComposeObject.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.ComposeObjectRequest}
 */
public final class ComposeObjectRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.ComposeObjectRequest)
    ComposeObjectRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ComposeObjectRequest.newBuilder() to construct.
  private ComposeObjectRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComposeObjectRequest() {
    sourceObjects_ = java.util.Collections.emptyList();
    destinationPredefinedAcl_ = "";
    kmsKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComposeObjectRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ComposeObjectRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_ComposeObjectRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.ComposeObjectRequest.class,
            com.google.storage.v2.ComposeObjectRequest.Builder.class);
  }

  public interface SourceObjectOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.ComposeObjectRequest.SourceObject)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The source object's name. All source objects must reside in the
     * same bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The source object's name. All source objects must reside in the
     * same bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The generation of this object to use as the source.
     * </pre>
     *
     * <code>int64 generation = 2;</code>
     *
     * @return The generation.
     */
    long getGeneration();

    /**
     *
     *
     * <pre>
     * Conditions that must be met for this operation to execute.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
     * </code>
     *
     * @return Whether the objectPreconditions field is set.
     */
    boolean hasObjectPreconditions();
    /**
     *
     *
     * <pre>
     * Conditions that must be met for this operation to execute.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
     * </code>
     *
     * @return The objectPreconditions.
     */
    com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
        getObjectPreconditions();
    /**
     *
     *
     * <pre>
     * Conditions that must be met for this operation to execute.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
     * </code>
     */
    com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditionsOrBuilder
        getObjectPreconditionsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Description of a source object for a composition request.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ComposeObjectRequest.SourceObject}
   */
  public static final class SourceObject extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.ComposeObjectRequest.SourceObject)
      SourceObjectOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SourceObject.newBuilder() to construct.
    private SourceObject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SourceObject() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SourceObject();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ComposeObjectRequest.SourceObject.class,
              com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder.class);
    }

    public interface ObjectPreconditionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Only perform the composition if the generation of the source object
       * that would be used matches this value.  If this value and a generation
       * are both specified, they must be the same value or the call will fail.
       * </pre>
       *
       * <code>optional int64 if_generation_match = 1;</code>
       *
       * @return Whether the ifGenerationMatch field is set.
       */
      boolean hasIfGenerationMatch();
      /**
       *
       *
       * <pre>
       * Only perform the composition if the generation of the source object
       * that would be used matches this value.  If this value and a generation
       * are both specified, they must be the same value or the call will fail.
       * </pre>
       *
       * <code>optional int64 if_generation_match = 1;</code>
       *
       * @return The ifGenerationMatch.
       */
      long getIfGenerationMatch();
    }
    /**
     *
     *
     * <pre>
     * Preconditions for a source object of a composition request.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions}
     */
    public static final class ObjectPreconditions extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)
        ObjectPreconditionsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ObjectPreconditions.newBuilder() to construct.
      private ObjectPreconditions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ObjectPreconditions() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ObjectPreconditions();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_ObjectPreconditions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_ObjectPreconditions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.class,
                com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.Builder
                    .class);
      }

      private int bitField0_;
      public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 1;
      private long ifGenerationMatch_ = 0L;
      /**
       *
       *
       * <pre>
       * Only perform the composition if the generation of the source object
       * that would be used matches this value.  If this value and a generation
       * are both specified, they must be the same value or the call will fail.
       * </pre>
       *
       * <code>optional int64 if_generation_match = 1;</code>
       *
       * @return Whether the ifGenerationMatch field is set.
       */
      @java.lang.Override
      public boolean hasIfGenerationMatch() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Only perform the composition if the generation of the source object
       * that would be used matches this value.  If this value and a generation
       * are both specified, they must be the same value or the call will fail.
       * </pre>
       *
       * <code>optional int64 if_generation_match = 1;</code>
       *
       * @return The ifGenerationMatch.
       */
      @java.lang.Override
      public long getIfGenerationMatch() {
        return ifGenerationMatch_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(1, ifGenerationMatch_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, ifGenerationMatch_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)) {
          return super.equals(obj);
        }
        com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions other =
            (com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions) obj;

        if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
        if (hasIfGenerationMatch()) {
          if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasIfGenerationMatch()) {
          hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Preconditions for a source object of a composition request.
       * </pre>
       *
       * Protobuf type {@code
       * google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_ObjectPreconditions_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_ObjectPreconditions_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.class,
                  com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
                      .Builder.class);
        }

        // Construct using
        // com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          ifGenerationMatch_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storage.v2.StorageProto
              .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_ObjectPreconditions_descriptor;
        }

        @java.lang.Override
        public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
            getDefaultInstanceForType() {
          return com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions build() {
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
            buildPartial() {
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions result =
              new com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.ifGenerationMatch_ = ifGenerationMatch_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions) {
            return mergeFrom(
                (com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions other) {
          if (other
              == com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
                  .getDefaultInstance()) return this;
          if (other.hasIfGenerationMatch()) {
            setIfGenerationMatch(other.getIfGenerationMatch());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    ifGenerationMatch_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long ifGenerationMatch_;
        /**
         *
         *
         * <pre>
         * Only perform the composition if the generation of the source object
         * that would be used matches this value.  If this value and a generation
         * are both specified, they must be the same value or the call will fail.
         * </pre>
         *
         * <code>optional int64 if_generation_match = 1;</code>
         *
         * @return Whether the ifGenerationMatch field is set.
         */
        @java.lang.Override
        public boolean hasIfGenerationMatch() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Only perform the composition if the generation of the source object
         * that would be used matches this value.  If this value and a generation
         * are both specified, they must be the same value or the call will fail.
         * </pre>
         *
         * <code>optional int64 if_generation_match = 1;</code>
         *
         * @return The ifGenerationMatch.
         */
        @java.lang.Override
        public long getIfGenerationMatch() {
          return ifGenerationMatch_;
        }
        /**
         *
         *
         * <pre>
         * Only perform the composition if the generation of the source object
         * that would be used matches this value.  If this value and a generation
         * are both specified, they must be the same value or the call will fail.
         * </pre>
         *
         * <code>optional int64 if_generation_match = 1;</code>
         *
         * @param value The ifGenerationMatch to set.
         * @return This builder for chaining.
         */
        public Builder setIfGenerationMatch(long value) {

          ifGenerationMatch_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Only perform the composition if the generation of the source object
         * that would be used matches this value.  If this value and a generation
         * are both specified, they must be the same value or the call will fail.
         * </pre>
         *
         * <code>optional int64 if_generation_match = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIfGenerationMatch() {
          bitField0_ = (bitField0_ & ~0x00000001);
          ifGenerationMatch_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)
      }

      // @@protoc_insertion_point(class_scope:google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions)
      private static final com.google.storage.v2.ComposeObjectRequest.SourceObject
              .ObjectPreconditions
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions();
      }

      public static com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ObjectPreconditions> PARSER =
          new com.google.protobuf.AbstractParser<ObjectPreconditions>() {
            @java.lang.Override
            public ObjectPreconditions parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ObjectPreconditions> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ObjectPreconditions> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The source object's name. All source objects must reside in the
     * same bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The source object's name. All source objects must reside in the
     * same bucket.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERATION_FIELD_NUMBER = 2;
    private long generation_ = 0L;
    /**
     *
     *
     * <pre>
     * The generation of this object to use as the source.
     * </pre>
     *
     * <code>int64 generation = 2;</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }

    public static final int OBJECT_PRECONDITIONS_FIELD_NUMBER = 3;
    private com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
        objectPreconditions_;
    /**
     *
     *
     * <pre>
     * Conditions that must be met for this operation to execute.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
     * </code>
     *
     * @return Whether the objectPreconditions field is set.
     */
    @java.lang.Override
    public boolean hasObjectPreconditions() {
      return objectPreconditions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Conditions that must be met for this operation to execute.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
     * </code>
     *
     * @return The objectPreconditions.
     */
    @java.lang.Override
    public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
        getObjectPreconditions() {
      return objectPreconditions_ == null
          ? com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
              .getDefaultInstance()
          : objectPreconditions_;
    }
    /**
     *
     *
     * <pre>
     * Conditions that must be met for this operation to execute.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditionsOrBuilder
        getObjectPreconditionsOrBuilder() {
      return objectPreconditions_ == null
          ? com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
              .getDefaultInstance()
          : objectPreconditions_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (generation_ != 0L) {
        output.writeInt64(2, generation_);
      }
      if (objectPreconditions_ != null) {
        output.writeMessage(3, getObjectPreconditions());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (generation_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, generation_);
      }
      if (objectPreconditions_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getObjectPreconditions());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.ComposeObjectRequest.SourceObject)) {
        return super.equals(obj);
      }
      com.google.storage.v2.ComposeObjectRequest.SourceObject other =
          (com.google.storage.v2.ComposeObjectRequest.SourceObject) obj;

      if (!getName().equals(other.getName())) return false;
      if (getGeneration() != other.getGeneration()) return false;
      if (hasObjectPreconditions() != other.hasObjectPreconditions()) return false;
      if (hasObjectPreconditions()) {
        if (!getObjectPreconditions().equals(other.getObjectPreconditions())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + GENERATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
      if (hasObjectPreconditions()) {
        hash = (37 * hash) + OBJECT_PRECONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getObjectPreconditions().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storage.v2.ComposeObjectRequest.SourceObject prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Description of a source object for a composition request.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.ComposeObjectRequest.SourceObject}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.ComposeObjectRequest.SourceObject)
        com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.ComposeObjectRequest.SourceObject.class,
                com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder.class);
      }

      // Construct using com.google.storage.v2.ComposeObjectRequest.SourceObject.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        generation_ = 0L;
        objectPreconditions_ = null;
        if (objectPreconditionsBuilder_ != null) {
          objectPreconditionsBuilder_.dispose();
          objectPreconditionsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_ComposeObjectRequest_SourceObject_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.ComposeObjectRequest.SourceObject getDefaultInstanceForType() {
        return com.google.storage.v2.ComposeObjectRequest.SourceObject.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.ComposeObjectRequest.SourceObject build() {
        com.google.storage.v2.ComposeObjectRequest.SourceObject result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.ComposeObjectRequest.SourceObject buildPartial() {
        com.google.storage.v2.ComposeObjectRequest.SourceObject result =
            new com.google.storage.v2.ComposeObjectRequest.SourceObject(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.ComposeObjectRequest.SourceObject result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.generation_ = generation_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.objectPreconditions_ =
              objectPreconditionsBuilder_ == null
                  ? objectPreconditions_
                  : objectPreconditionsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.ComposeObjectRequest.SourceObject) {
          return mergeFrom((com.google.storage.v2.ComposeObjectRequest.SourceObject) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.ComposeObjectRequest.SourceObject other) {
        if (other == com.google.storage.v2.ComposeObjectRequest.SourceObject.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getGeneration() != 0L) {
          setGeneration(other.getGeneration());
        }
        if (other.hasObjectPreconditions()) {
          mergeObjectPreconditions(other.getObjectPreconditions());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  generation_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getObjectPreconditionsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The source object's name. All source objects must reside in the
       * same bucket.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The source object's name. All source objects must reside in the
       * same bucket.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The source object's name. All source objects must reside in the
       * same bucket.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The source object's name. All source objects must reside in the
       * same bucket.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The source object's name. All source objects must reside in the
       * same bucket.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long generation_;
      /**
       *
       *
       * <pre>
       * The generation of this object to use as the source.
       * </pre>
       *
       * <code>int64 generation = 2;</code>
       *
       * @return The generation.
       */
      @java.lang.Override
      public long getGeneration() {
        return generation_;
      }
      /**
       *
       *
       * <pre>
       * The generation of this object to use as the source.
       * </pre>
       *
       * <code>int64 generation = 2;</code>
       *
       * @param value The generation to set.
       * @return This builder for chaining.
       */
      public Builder setGeneration(long value) {

        generation_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The generation of this object to use as the source.
       * </pre>
       *
       * <code>int64 generation = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGeneration() {
        bitField0_ = (bitField0_ & ~0x00000002);
        generation_ = 0L;
        onChanged();
        return this;
      }

      private com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          objectPreconditions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions,
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.Builder,
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditionsOrBuilder>
          objectPreconditionsBuilder_;
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       *
       * @return Whether the objectPreconditions field is set.
       */
      public boolean hasObjectPreconditions() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       *
       * @return The objectPreconditions.
       */
      public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
          getObjectPreconditions() {
        if (objectPreconditionsBuilder_ == null) {
          return objectPreconditions_ == null
              ? com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
                  .getDefaultInstance()
              : objectPreconditions_;
        } else {
          return objectPreconditionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      public Builder setObjectPreconditions(
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions value) {
        if (objectPreconditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          objectPreconditions_ = value;
        } else {
          objectPreconditionsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      public Builder setObjectPreconditions(
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.Builder
              builderForValue) {
        if (objectPreconditionsBuilder_ == null) {
          objectPreconditions_ = builderForValue.build();
        } else {
          objectPreconditionsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      public Builder mergeObjectPreconditions(
          com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions value) {
        if (objectPreconditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && objectPreconditions_ != null
              && objectPreconditions_
                  != com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
                      .getDefaultInstance()) {
            getObjectPreconditionsBuilder().mergeFrom(value);
          } else {
            objectPreconditions_ = value;
          }
        } else {
          objectPreconditionsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      public Builder clearObjectPreconditions() {
        bitField0_ = (bitField0_ & ~0x00000004);
        objectPreconditions_ = null;
        if (objectPreconditionsBuilder_ != null) {
          objectPreconditionsBuilder_.dispose();
          objectPreconditionsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.Builder
          getObjectPreconditionsBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getObjectPreconditionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      public com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditionsOrBuilder
          getObjectPreconditionsOrBuilder() {
        if (objectPreconditionsBuilder_ != null) {
          return objectPreconditionsBuilder_.getMessageOrBuilder();
        } else {
          return objectPreconditions_ == null
              ? com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
                  .getDefaultInstance()
              : objectPreconditions_;
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions that must be met for this operation to execute.
       * </pre>
       *
       * <code>
       * .google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions object_preconditions = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions,
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions.Builder,
              com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditionsOrBuilder>
          getObjectPreconditionsFieldBuilder() {
        if (objectPreconditionsBuilder_ == null) {
          objectPreconditionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions,
                  com.google.storage.v2.ComposeObjectRequest.SourceObject.ObjectPreconditions
                      .Builder,
                  com.google.storage.v2.ComposeObjectRequest.SourceObject
                      .ObjectPreconditionsOrBuilder>(
                  getObjectPreconditions(), getParentForChildren(), isClean());
          objectPreconditions_ = null;
        }
        return objectPreconditionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.ComposeObjectRequest.SourceObject)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.ComposeObjectRequest.SourceObject)
    private static final com.google.storage.v2.ComposeObjectRequest.SourceObject DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.ComposeObjectRequest.SourceObject();
    }

    public static com.google.storage.v2.ComposeObjectRequest.SourceObject getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SourceObject> PARSER =
        new com.google.protobuf.AbstractParser<SourceObject>() {
          @java.lang.Override
          public SourceObject parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SourceObject> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SourceObject> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.ComposeObjectRequest.SourceObject getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DESTINATION_FIELD_NUMBER = 1;
  private com.google.storage.v2.Object destination_;
  /**
   *
   *
   * <pre>
   * Required. Properties of the resulting object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return destination_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Properties of the resulting object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getDestination() {
    return destination_ == null ? com.google.storage.v2.Object.getDefaultInstance() : destination_;
  }
  /**
   *
   *
   * <pre>
   * Required. Properties of the resulting object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getDestinationOrBuilder() {
    return destination_ == null ? com.google.storage.v2.Object.getDefaultInstance() : destination_;
  }

  public static final int SOURCE_OBJECTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.ComposeObjectRequest.SourceObject> sourceObjects_;
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.ComposeObjectRequest.SourceObject>
      getSourceObjectsList() {
    return sourceObjects_;
  }
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder>
      getSourceObjectsOrBuilderList() {
    return sourceObjects_;
  }
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  @java.lang.Override
  public int getSourceObjectsCount() {
    return sourceObjects_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ComposeObjectRequest.SourceObject getSourceObjects(int index) {
    return sourceObjects_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder getSourceObjectsOrBuilder(
      int index) {
    return sourceObjects_.get(index);
  }

  public static final int DESTINATION_PREDEFINED_ACL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationPredefinedAcl_ = "";
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to the destination object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string destination_predefined_acl = 9;</code>
   *
   * @return The destinationPredefinedAcl.
   */
  @java.lang.Override
  public java.lang.String getDestinationPredefinedAcl() {
    java.lang.Object ref = destinationPredefinedAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationPredefinedAcl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to the destination object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string destination_predefined_acl = 9;</code>
   *
   * @return The bytes for destinationPredefinedAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationPredefinedAclBytes() {
    java.lang.Object ref = destinationPredefinedAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationPredefinedAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 4;
  private long ifGenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 5;
  private long ifMetagenerationMatch_ = 0L;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 5;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 5;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int KMS_KEY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the Cloud KMS key, of the form
   * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
   * that will be used to encrypt the object. Overrides the object
   * metadata's `kms_key_name` value, if any.
   * </pre>
   *
   * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the Cloud KMS key, of the form
   * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
   * that will be used to encrypt the object. Overrides the object
   * metadata's `kms_key_name` value, if any.
   * </pre>
   *
   * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER = 7;
  private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  @java.lang.Override
  public boolean hasCommonObjectRequestParams() {
    return commonObjectRequestParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
   *
   * @return The commonObjectRequestParams.
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
      getCommonObjectRequestParamsOrBuilder() {
    return commonObjectRequestParams_ == null
        ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
        : commonObjectRequestParams_;
  }

  public static final int OBJECT_CHECKSUMS_FIELD_NUMBER = 10;
  private com.google.storage.v2.ObjectChecksums objectChecksums_;
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be validated against the
   * combined checksums of the component objects.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
   *
   * @return Whether the objectChecksums field is set.
   */
  @java.lang.Override
  public boolean hasObjectChecksums() {
    return objectChecksums_ != null;
  }
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be validated against the
   * combined checksums of the component objects.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
   *
   * @return The objectChecksums.
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be validated against the
   * combined checksums of the component objects.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
    return objectChecksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : objectChecksums_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destination_ != null) {
      output.writeMessage(1, getDestination());
    }
    for (int i = 0; i < sourceObjects_.size(); i++) {
      output.writeMessage(2, sourceObjects_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(4, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(5, ifMetagenerationMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, kmsKey_);
    }
    if (commonObjectRequestParams_ != null) {
      output.writeMessage(7, getCommonObjectRequestParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPredefinedAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, destinationPredefinedAcl_);
    }
    if (objectChecksums_ != null) {
      output.writeMessage(10, getObjectChecksums());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destination_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDestination());
    }
    for (int i = 0; i < sourceObjects_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, sourceObjects_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, ifMetagenerationMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, kmsKey_);
    }
    if (commonObjectRequestParams_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getCommonObjectRequestParams());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPredefinedAcl_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(9, destinationPredefinedAcl_);
    }
    if (objectChecksums_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getObjectChecksums());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.ComposeObjectRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.ComposeObjectRequest other =
        (com.google.storage.v2.ComposeObjectRequest) obj;

    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (!getSourceObjectsList().equals(other.getSourceObjectsList())) return false;
    if (!getDestinationPredefinedAcl().equals(other.getDestinationPredefinedAcl())) return false;
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (hasCommonObjectRequestParams() != other.hasCommonObjectRequestParams()) return false;
    if (hasCommonObjectRequestParams()) {
      if (!getCommonObjectRequestParams().equals(other.getCommonObjectRequestParams()))
        return false;
    }
    if (hasObjectChecksums() != other.hasObjectChecksums()) return false;
    if (hasObjectChecksums()) {
      if (!getObjectChecksums().equals(other.getObjectChecksums())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (getSourceObjectsCount() > 0) {
      hash = (37 * hash) + SOURCE_OBJECTS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceObjectsList().hashCode();
    }
    hash = (37 * hash) + DESTINATION_PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationPredefinedAcl().hashCode();
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    if (hasCommonObjectRequestParams()) {
      hash = (37 * hash) + COMMON_OBJECT_REQUEST_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getCommonObjectRequestParams().hashCode();
    }
    if (hasObjectChecksums()) {
      hash = (37 * hash) + OBJECT_CHECKSUMS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectChecksums().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.ComposeObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.ComposeObjectRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for ComposeObject.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.ComposeObjectRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.ComposeObjectRequest)
      com.google.storage.v2.ComposeObjectRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ComposeObjectRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ComposeObjectRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.ComposeObjectRequest.class,
              com.google.storage.v2.ComposeObjectRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.ComposeObjectRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      if (sourceObjectsBuilder_ == null) {
        sourceObjects_ = java.util.Collections.emptyList();
      } else {
        sourceObjects_ = null;
        sourceObjectsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      destinationPredefinedAcl_ = "";
      ifGenerationMatch_ = 0L;
      ifMetagenerationMatch_ = 0L;
      kmsKey_ = "";
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      objectChecksums_ = null;
      if (objectChecksumsBuilder_ != null) {
        objectChecksumsBuilder_.dispose();
        objectChecksumsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_ComposeObjectRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.ComposeObjectRequest getDefaultInstanceForType() {
      return com.google.storage.v2.ComposeObjectRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.ComposeObjectRequest build() {
      com.google.storage.v2.ComposeObjectRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.ComposeObjectRequest buildPartial() {
      com.google.storage.v2.ComposeObjectRequest result =
          new com.google.storage.v2.ComposeObjectRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.storage.v2.ComposeObjectRequest result) {
      if (sourceObjectsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          sourceObjects_ = java.util.Collections.unmodifiableList(sourceObjects_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sourceObjects_ = sourceObjects_;
      } else {
        result.sourceObjects_ = sourceObjectsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.storage.v2.ComposeObjectRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.destination_ =
            destinationBuilder_ == null ? destination_ : destinationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destinationPredefinedAcl_ = destinationPredefinedAcl_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.commonObjectRequestParams_ =
            commonObjectRequestParamsBuilder_ == null
                ? commonObjectRequestParams_
                : commonObjectRequestParamsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.objectChecksums_ =
            objectChecksumsBuilder_ == null ? objectChecksums_ : objectChecksumsBuilder_.build();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.ComposeObjectRequest) {
        return mergeFrom((com.google.storage.v2.ComposeObjectRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.ComposeObjectRequest other) {
      if (other == com.google.storage.v2.ComposeObjectRequest.getDefaultInstance()) return this;
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (sourceObjectsBuilder_ == null) {
        if (!other.sourceObjects_.isEmpty()) {
          if (sourceObjects_.isEmpty()) {
            sourceObjects_ = other.sourceObjects_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSourceObjectsIsMutable();
            sourceObjects_.addAll(other.sourceObjects_);
          }
          onChanged();
        }
      } else {
        if (!other.sourceObjects_.isEmpty()) {
          if (sourceObjectsBuilder_.isEmpty()) {
            sourceObjectsBuilder_.dispose();
            sourceObjectsBuilder_ = null;
            sourceObjects_ = other.sourceObjects_;
            bitField0_ = (bitField0_ & ~0x00000002);
            sourceObjectsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSourceObjectsFieldBuilder()
                    : null;
          } else {
            sourceObjectsBuilder_.addAllMessages(other.sourceObjects_);
          }
        }
      }
      if (!other.getDestinationPredefinedAcl().isEmpty()) {
        destinationPredefinedAcl_ = other.destinationPredefinedAcl_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCommonObjectRequestParams()) {
        mergeCommonObjectRequestParams(other.getCommonObjectRequestParams());
      }
      if (other.hasObjectChecksums()) {
        mergeObjectChecksums(other.getObjectChecksums());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.storage.v2.ComposeObjectRequest.SourceObject m =
                    input.readMessage(
                        com.google.storage.v2.ComposeObjectRequest.SourceObject.parser(),
                        extensionRegistry);
                if (sourceObjectsBuilder_ == null) {
                  ensureSourceObjectsIsMutable();
                  sourceObjects_.add(m);
                } else {
                  sourceObjectsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 32:
              {
                ifGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getCommonObjectRequestParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                destinationPredefinedAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getObjectChecksumsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.storage.v2.Object destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The destination.
     */
    public com.google.storage.v2.Object getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.storage.v2.Object.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.storage.v2.Object value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
      } else {
        destinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.storage.v2.Object.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDestination(com.google.storage.v2.Object value) {
      if (destinationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && destination_ != null
            && destination_ != com.google.storage.v2.Object.getDefaultInstance()) {
          getDestinationBuilder().mergeFrom(value);
        } else {
          destination_ = value;
        }
      } else {
        destinationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestination() {
      bitField0_ = (bitField0_ & ~0x00000001);
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.v2.Object.Builder getDestinationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.v2.ObjectOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.storage.v2.Object.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Properties of the resulting object.
     * </pre>
     *
     * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private java.util.List<com.google.storage.v2.ComposeObjectRequest.SourceObject> sourceObjects_ =
        java.util.Collections.emptyList();

    private void ensureSourceObjectsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        sourceObjects_ =
            new java.util.ArrayList<com.google.storage.v2.ComposeObjectRequest.SourceObject>(
                sourceObjects_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ComposeObjectRequest.SourceObject,
            com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder,
            com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder>
        sourceObjectsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public java.util.List<com.google.storage.v2.ComposeObjectRequest.SourceObject>
        getSourceObjectsList() {
      if (sourceObjectsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sourceObjects_);
      } else {
        return sourceObjectsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public int getSourceObjectsCount() {
      if (sourceObjectsBuilder_ == null) {
        return sourceObjects_.size();
      } else {
        return sourceObjectsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public com.google.storage.v2.ComposeObjectRequest.SourceObject getSourceObjects(int index) {
      if (sourceObjectsBuilder_ == null) {
        return sourceObjects_.get(index);
      } else {
        return sourceObjectsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder setSourceObjects(
        int index, com.google.storage.v2.ComposeObjectRequest.SourceObject value) {
      if (sourceObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceObjectsIsMutable();
        sourceObjects_.set(index, value);
        onChanged();
      } else {
        sourceObjectsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder setSourceObjects(
        int index,
        com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder builderForValue) {
      if (sourceObjectsBuilder_ == null) {
        ensureSourceObjectsIsMutable();
        sourceObjects_.set(index, builderForValue.build());
        onChanged();
      } else {
        sourceObjectsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder addSourceObjects(com.google.storage.v2.ComposeObjectRequest.SourceObject value) {
      if (sourceObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceObjectsIsMutable();
        sourceObjects_.add(value);
        onChanged();
      } else {
        sourceObjectsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder addSourceObjects(
        int index, com.google.storage.v2.ComposeObjectRequest.SourceObject value) {
      if (sourceObjectsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSourceObjectsIsMutable();
        sourceObjects_.add(index, value);
        onChanged();
      } else {
        sourceObjectsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder addSourceObjects(
        com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder builderForValue) {
      if (sourceObjectsBuilder_ == null) {
        ensureSourceObjectsIsMutable();
        sourceObjects_.add(builderForValue.build());
        onChanged();
      } else {
        sourceObjectsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder addSourceObjects(
        int index,
        com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder builderForValue) {
      if (sourceObjectsBuilder_ == null) {
        ensureSourceObjectsIsMutable();
        sourceObjects_.add(index, builderForValue.build());
        onChanged();
      } else {
        sourceObjectsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder addAllSourceObjects(
        java.lang.Iterable<? extends com.google.storage.v2.ComposeObjectRequest.SourceObject>
            values) {
      if (sourceObjectsBuilder_ == null) {
        ensureSourceObjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourceObjects_);
        onChanged();
      } else {
        sourceObjectsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder clearSourceObjects() {
      if (sourceObjectsBuilder_ == null) {
        sourceObjects_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        sourceObjectsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public Builder removeSourceObjects(int index) {
      if (sourceObjectsBuilder_ == null) {
        ensureSourceObjectsIsMutable();
        sourceObjects_.remove(index);
        onChanged();
      } else {
        sourceObjectsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder getSourceObjectsBuilder(
        int index) {
      return getSourceObjectsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder
        getSourceObjectsOrBuilder(int index) {
      if (sourceObjectsBuilder_ == null) {
        return sourceObjects_.get(index);
      } else {
        return sourceObjectsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder>
        getSourceObjectsOrBuilderList() {
      if (sourceObjectsBuilder_ != null) {
        return sourceObjectsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sourceObjects_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder
        addSourceObjectsBuilder() {
      return getSourceObjectsFieldBuilder()
          .addBuilder(com.google.storage.v2.ComposeObjectRequest.SourceObject.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder addSourceObjectsBuilder(
        int index) {
      return getSourceObjectsFieldBuilder()
          .addBuilder(
              index, com.google.storage.v2.ComposeObjectRequest.SourceObject.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of source objects that will be concatenated into a single object.
     * </pre>
     *
     * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;
     * </code>
     */
    public java.util.List<com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder>
        getSourceObjectsBuilderList() {
      return getSourceObjectsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ComposeObjectRequest.SourceObject,
            com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder,
            com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder>
        getSourceObjectsFieldBuilder() {
      if (sourceObjectsBuilder_ == null) {
        sourceObjectsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.ComposeObjectRequest.SourceObject,
                com.google.storage.v2.ComposeObjectRequest.SourceObject.Builder,
                com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder>(
                sourceObjects_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        sourceObjects_ = null;
      }
      return sourceObjectsBuilder_;
    }

    private java.lang.Object destinationPredefinedAcl_ = "";
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 9;</code>
     *
     * @return The destinationPredefinedAcl.
     */
    public java.lang.String getDestinationPredefinedAcl() {
      java.lang.Object ref = destinationPredefinedAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationPredefinedAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 9;</code>
     *
     * @return The bytes for destinationPredefinedAcl.
     */
    public com.google.protobuf.ByteString getDestinationPredefinedAclBytes() {
      java.lang.Object ref = destinationPredefinedAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationPredefinedAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 9;</code>
     *
     * @param value The destinationPredefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPredefinedAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationPredefinedAcl_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationPredefinedAcl() {
      destinationPredefinedAcl_ = getDefaultInstance().getDestinationPredefinedAcl();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to the destination object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string destination_predefined_acl = 9;</code>
     *
     * @param value The bytes for destinationPredefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationPredefinedAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationPredefinedAcl_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long ifGenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 4;</code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 4;</code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 4;</code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {

      ifGenerationMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current generation
     * matches the given value. Setting to 0 makes the operation succeed only if
     * there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the Cloud KMS key, of the form
     * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
     * that will be used to encrypt the object. Overrides the object
     * metadata's `kms_key_name` value, if any.
     * </pre>
     *
     * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Cloud KMS key, of the form
     * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
     * that will be used to encrypt the object. Overrides the object
     * metadata's `kms_key_name` value, if any.
     * </pre>
     *
     * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Cloud KMS key, of the form
     * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
     * that will be used to encrypt the object. Overrides the object
     * metadata's `kms_key_name` value, if any.
     * </pre>
     *
     * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Cloud KMS key, of the form
     * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
     * that will be used to encrypt the object. Overrides the object
     * metadata's `kms_key_name` value, if any.
     * </pre>
     *
     * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Cloud KMS key, of the form
     * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
     * that will be used to encrypt the object. Overrides the object
     * metadata's `kms_key_name` value, if any.
     * </pre>
     *
     * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.storage.v2.CommonObjectRequestParams commonObjectRequestParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        commonObjectRequestParamsBuilder_;
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     *
     * @return Whether the commonObjectRequestParams field is set.
     */
    public boolean hasCommonObjectRequestParams() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     *
     * @return The commonObjectRequestParams.
     */
    public com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams() {
      if (commonObjectRequestParamsBuilder_ == null) {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      } else {
        return commonObjectRequestParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonObjectRequestParams_ = value;
      } else {
        commonObjectRequestParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    public Builder setCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams.Builder builderForValue) {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParams_ = builderForValue.build();
      } else {
        commonObjectRequestParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    public Builder mergeCommonObjectRequestParams(
        com.google.storage.v2.CommonObjectRequestParams value) {
      if (commonObjectRequestParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && commonObjectRequestParams_ != null
            && commonObjectRequestParams_
                != com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()) {
          getCommonObjectRequestParamsBuilder().mergeFrom(value);
        } else {
          commonObjectRequestParams_ = value;
        }
      } else {
        commonObjectRequestParamsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    public Builder clearCommonObjectRequestParams() {
      bitField0_ = (bitField0_ & ~0x00000040);
      commonObjectRequestParams_ = null;
      if (commonObjectRequestParamsBuilder_ != null) {
        commonObjectRequestParamsBuilder_.dispose();
        commonObjectRequestParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    public com.google.storage.v2.CommonObjectRequestParams.Builder
        getCommonObjectRequestParamsBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCommonObjectRequestParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    public com.google.storage.v2.CommonObjectRequestParamsOrBuilder
        getCommonObjectRequestParamsOrBuilder() {
      if (commonObjectRequestParamsBuilder_ != null) {
        return commonObjectRequestParamsBuilder_.getMessageOrBuilder();
      } else {
        return commonObjectRequestParams_ == null
            ? com.google.storage.v2.CommonObjectRequestParams.getDefaultInstance()
            : commonObjectRequestParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * A set of parameters common to Storage API requests concerning an object.
     * </pre>
     *
     * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CommonObjectRequestParams,
            com.google.storage.v2.CommonObjectRequestParams.Builder,
            com.google.storage.v2.CommonObjectRequestParamsOrBuilder>
        getCommonObjectRequestParamsFieldBuilder() {
      if (commonObjectRequestParamsBuilder_ == null) {
        commonObjectRequestParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.CommonObjectRequestParams,
                com.google.storage.v2.CommonObjectRequestParams.Builder,
                com.google.storage.v2.CommonObjectRequestParamsOrBuilder>(
                getCommonObjectRequestParams(), getParentForChildren(), isClean());
        commonObjectRequestParams_ = null;
      }
      return commonObjectRequestParamsBuilder_;
    }

    private com.google.storage.v2.ObjectChecksums objectChecksums_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        objectChecksumsBuilder_;
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     *
     * @return Whether the objectChecksums field is set.
     */
    public boolean hasObjectChecksums() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     *
     * @return The objectChecksums.
     */
    public com.google.storage.v2.ObjectChecksums getObjectChecksums() {
      if (objectChecksumsBuilder_ == null) {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      } else {
        return objectChecksumsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    public Builder setObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectChecksums_ = value;
      } else {
        objectChecksumsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    public Builder setObjectChecksums(
        com.google.storage.v2.ObjectChecksums.Builder builderForValue) {
      if (objectChecksumsBuilder_ == null) {
        objectChecksums_ = builderForValue.build();
      } else {
        objectChecksumsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    public Builder mergeObjectChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (objectChecksumsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && objectChecksums_ != null
            && objectChecksums_ != com.google.storage.v2.ObjectChecksums.getDefaultInstance()) {
          getObjectChecksumsBuilder().mergeFrom(value);
        } else {
          objectChecksums_ = value;
        }
      } else {
        objectChecksumsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    public Builder clearObjectChecksums() {
      bitField0_ = (bitField0_ & ~0x00000080);
      objectChecksums_ = null;
      if (objectChecksumsBuilder_ != null) {
        objectChecksumsBuilder_.dispose();
        objectChecksumsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    public com.google.storage.v2.ObjectChecksums.Builder getObjectChecksumsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getObjectChecksumsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    public com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder() {
      if (objectChecksumsBuilder_ != null) {
        return objectChecksumsBuilder_.getMessageOrBuilder();
      } else {
        return objectChecksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : objectChecksums_;
      }
    }
    /**
     *
     *
     * <pre>
     * The checksums of the complete object. This will be validated against the
     * combined checksums of the component objects.
     * </pre>
     *
     * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        getObjectChecksumsFieldBuilder() {
      if (objectChecksumsBuilder_ == null) {
        objectChecksumsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ObjectChecksums,
                com.google.storage.v2.ObjectChecksums.Builder,
                com.google.storage.v2.ObjectChecksumsOrBuilder>(
                getObjectChecksums(), getParentForChildren(), isClean());
        objectChecksums_ = null;
      }
      return objectChecksumsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.ComposeObjectRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.ComposeObjectRequest)
  private static final com.google.storage.v2.ComposeObjectRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.ComposeObjectRequest();
  }

  public static com.google.storage.v2.ComposeObjectRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComposeObjectRequest> PARSER =
      new com.google.protobuf.AbstractParser<ComposeObjectRequest>() {
        @java.lang.Override
        public ComposeObjectRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComposeObjectRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComposeObjectRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.ComposeObjectRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
