/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.4
package com.google.storage.v2;

public interface ComposeObjectRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.ComposeObjectRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Properties of the resulting object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destination field is set.
   */
  boolean hasDestination();
  /**
   *
   *
   * <pre>
   * Required. Properties of the resulting object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destination.
   */
  com.google.storage.v2.Object getDestination();
  /**
   *
   *
   * <pre>
   * Required. Properties of the resulting object.
   * </pre>
   *
   * <code>.google.storage.v2.Object destination = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.storage.v2.ObjectOrBuilder getDestinationOrBuilder();

  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  java.util.List<com.google.storage.v2.ComposeObjectRequest.SourceObject> getSourceObjectsList();
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  com.google.storage.v2.ComposeObjectRequest.SourceObject getSourceObjects(int index);
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  int getSourceObjectsCount();
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  java.util.List<? extends com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder>
      getSourceObjectsOrBuilderList();
  /**
   *
   *
   * <pre>
   * The list of source objects that will be concatenated into a single object.
   * </pre>
   *
   * <code>repeated .google.storage.v2.ComposeObjectRequest.SourceObject source_objects = 2;</code>
   */
  com.google.storage.v2.ComposeObjectRequest.SourceObjectOrBuilder getSourceObjectsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to the destination object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string destination_predefined_acl = 9;</code>
   *
   * @return The destinationPredefinedAcl.
   */
  java.lang.String getDestinationPredefinedAcl();
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to the destination object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string destination_predefined_acl = 9;</code>
   *
   * @return The bytes for destinationPredefinedAcl.
   */
  com.google.protobuf.ByteString getDestinationPredefinedAclBytes();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  boolean hasIfGenerationMatch();
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current generation
   * matches the given value. Setting to 0 makes the operation succeed only if
   * there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 4;</code>
   *
   * @return The ifGenerationMatch.
   */
  long getIfGenerationMatch();

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 5;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  boolean hasIfMetagenerationMatch();
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 5;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  long getIfMetagenerationMatch();

  /**
   *
   *
   * <pre>
   * Resource name of the Cloud KMS key, of the form
   * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
   * that will be used to encrypt the object. Overrides the object
   * metadata's `kms_key_name` value, if any.
   * </pre>
   *
   * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKey.
   */
  java.lang.String getKmsKey();
  /**
   *
   *
   * <pre>
   * Resource name of the Cloud KMS key, of the form
   * `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
   * that will be used to encrypt the object. Overrides the object
   * metadata's `kms_key_name` value, if any.
   * </pre>
   *
   * <code>string kms_key = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKey.
   */
  com.google.protobuf.ByteString getKmsKeyBytes();

  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
   *
   * @return Whether the commonObjectRequestParams field is set.
   */
  boolean hasCommonObjectRequestParams();
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
   *
   * @return The commonObjectRequestParams.
   */
  com.google.storage.v2.CommonObjectRequestParams getCommonObjectRequestParams();
  /**
   *
   *
   * <pre>
   * A set of parameters common to Storage API requests concerning an object.
   * </pre>
   *
   * <code>.google.storage.v2.CommonObjectRequestParams common_object_request_params = 7;</code>
   */
  com.google.storage.v2.CommonObjectRequestParamsOrBuilder getCommonObjectRequestParamsOrBuilder();

  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be validated against the
   * combined checksums of the component objects.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
   *
   * @return Whether the objectChecksums field is set.
   */
  boolean hasObjectChecksums();
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be validated against the
   * combined checksums of the component objects.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
   *
   * @return The objectChecksums.
   */
  com.google.storage.v2.ObjectChecksums getObjectChecksums();
  /**
   *
   *
   * <pre>
   * The checksums of the complete object. This will be validated against the
   * combined checksums of the component objects.
   * </pre>
   *
   * <code>.google.storage.v2.ObjectChecksums object_checksums = 10;</code>
   */
  com.google.storage.v2.ObjectChecksumsOrBuilder getObjectChecksumsOrBuilder();
}
