/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workstations/v1/workstations.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.workstations.v1;

/**
 *
 *
 * <pre>
 * A single instance of a developer workstation with its own persistent storage.
 * </pre>
 *
 * Protobuf type {@code google.cloud.workstations.v1.Workstation}
 */
public final class Workstation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.Workstation)
    WorkstationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Workstation.newBuilder() to construct.
  private Workstation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Workstation() {
    name_ = "";
    displayName_ = "";
    uid_ = "";
    etag_ = "";
    state_ = 0;
    host_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Workstation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_Workstation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetAnnotations();
      case 13:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_Workstation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workstations.v1.Workstation.class,
            com.google.cloud.workstations.v1.Workstation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Whether a workstation is running and ready to receive user requests.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.workstations.v1.Workstation.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Do not use.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The workstation is not yet ready to accept requests from users but will
     * be soon.
     * </pre>
     *
     * <code>STATE_STARTING = 1;</code>
     */
    STATE_STARTING(1),
    /**
     *
     *
     * <pre>
     * The workstation is ready to accept requests from users.
     * </pre>
     *
     * <code>STATE_RUNNING = 2;</code>
     */
    STATE_RUNNING(2),
    /**
     *
     *
     * <pre>
     * The workstation is being stopped.
     * </pre>
     *
     * <code>STATE_STOPPING = 3;</code>
     */
    STATE_STOPPING(3),
    /**
     *
     *
     * <pre>
     * The workstation is stopped and will not be able to receive requests until
     * it is started.
     * </pre>
     *
     * <code>STATE_STOPPED = 4;</code>
     */
    STATE_STOPPED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Do not use.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The workstation is not yet ready to accept requests from users but will
     * be soon.
     * </pre>
     *
     * <code>STATE_STARTING = 1;</code>
     */
    public static final int STATE_STARTING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The workstation is ready to accept requests from users.
     * </pre>
     *
     * <code>STATE_RUNNING = 2;</code>
     */
    public static final int STATE_RUNNING_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The workstation is being stopped.
     * </pre>
     *
     * <code>STATE_STOPPING = 3;</code>
     */
    public static final int STATE_STOPPING_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The workstation is stopped and will not be able to receive requests until
     * it is started.
     * </pre>
     *
     * <code>STATE_STOPPED = 4;</code>
     */
    public static final int STATE_STOPPED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STATE_STARTING;
        case 2:
          return STATE_RUNNING;
        case 3:
          return STATE_STOPPING;
        case 4:
          return STATE_STOPPED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.workstations.v1.Workstation.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.workstations.v1.Workstation.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Full name of this workstation.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Full name of this workstation.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Human-readable name for this workstation.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Human-readable name for this workstation.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A system-assigned unique identifier for this workstation.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A system-assigned unique identifier for this workstation.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECONCILING_FIELD_NUMBER = 4;
  private boolean reconciling_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this workstation is currently being updated
   * to match its intended state.
   * </pre>
   *
   * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_Workstation_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 13;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_Workstation_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was most recently successfully
   * started, regardless of the workstation's initial state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was most recently successfully
   * started, regardless of the workstation's initial state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was most recently successfully
   * started, regardless of the workstation's initial state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Checksum computed by the server. May be sent on update and delete
   * requests to make sure that the client has an up-to-date value before
   * proceeding.
   * </pre>
   *
   * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Checksum computed by the server. May be sent on update and delete
   * requests to make sure that the client has an up-to-date value before
   * proceeding.
   * </pre>
   *
   * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 10;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Current state of the workstation.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Current state of the workstation.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.Workstation.State getState() {
    com.google.cloud.workstations.v1.Workstation.State result =
        com.google.cloud.workstations.v1.Workstation.State.forNumber(state_);
    return result == null
        ? com.google.cloud.workstations.v1.Workstation.State.UNRECOGNIZED
        : result;
  }

  public static final int HOST_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Host to which clients can send HTTPS traffic that will be
   * received by the workstation. Authorized traffic will be received to the
   * workstation as HTTP on port 80. To send traffic to a different port,
   * clients may prefix the host with the destination port in the format
   * `{port}-{host}`.
   * </pre>
   *
   * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Host to which clients can send HTTPS traffic that will be
   * received by the workstation. Authorized traffic will be received to the
   * workstation as HTTP on port 80. To send traffic to a different port,
   * clients may prefix the host with the destination port in the format
   * `{port}-{host}`.
   * </pre>
   *
   * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uid_);
    }
    if (reconciling_ != false) {
      output.writeBool(4, reconciling_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, etag_);
    }
    if (state_
        != com.google.cloud.workstations.v1.Workstation.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, host_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 13);
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(14, getStartTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uid_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, reconciling_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, etag_);
    }
    if (state_
        != com.google.cloud.workstations.v1.Workstation.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, host_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, labels__);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getStartTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workstations.v1.Workstation)) {
      return super.equals(obj);
    }
    com.google.cloud.workstations.v1.Workstation other =
        (com.google.cloud.workstations.v1.Workstation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (state_ != other.state_) return false;
    if (!getHost().equals(other.getHost())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.Workstation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.Workstation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.Workstation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.workstations.v1.Workstation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A single instance of a developer workstation with its own persistent storage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.Workstation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.Workstation)
      com.google.cloud.workstations.v1.WorkstationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_Workstation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetAnnotations();
        case 13:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableAnnotations();
        case 13:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_Workstation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.Workstation.class,
              com.google.cloud.workstations.v1.Workstation.Builder.class);
    }

    // Construct using com.google.cloud.workstations.v1.Workstation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      uid_ = "";
      reconciling_ = false;
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      etag_ = "";
      state_ = 0;
      host_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_Workstation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.Workstation getDefaultInstanceForType() {
      return com.google.cloud.workstations.v1.Workstation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.Workstation build() {
      com.google.cloud.workstations.v1.Workstation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.Workstation buildPartial() {
      com.google.cloud.workstations.v1.Workstation result =
          new com.google.cloud.workstations.v1.Workstation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.workstations.v1.Workstation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.host_ = host_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workstations.v1.Workstation) {
        return mergeFrom((com.google.cloud.workstations.v1.Workstation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.workstations.v1.Workstation other) {
      if (other == com.google.cloud.workstations.v1.Workstation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 80:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 80
            case 90:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 106:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Full name of this workstation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean reconciling_;

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation is currently being updated
     * to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation is currently being updated
     * to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation is currently being updated
     * to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000008);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was most recently successfully
     * started, regardless of the workstation's initial state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Current state of the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.workstations.v1.Workstation.State getState() {
      com.google.cloud.workstations.v1.Workstation.State result =
          com.google.cloud.workstations.v1.Workstation.State.forNumber(state_);
      return result == null
          ? com.google.cloud.workstations.v1.Workstation.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.workstations.v1.Workstation.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Current state of the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.Workstation.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000800);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object host_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Host to which clients can send HTTPS traffic that will be
     * received by the workstation. Authorized traffic will be received to the
     * workstation as HTTP on port 80. To send traffic to a different port,
     * clients may prefix the host with the destination port in the format
     * `{port}-{host}`.
     * </pre>
     *
     * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Host to which clients can send HTTPS traffic that will be
     * received by the workstation. Authorized traffic will be received to the
     * workstation as HTTP on port 80. To send traffic to a different port,
     * clients may prefix the host with the destination port in the format
     * `{port}-{host}`.
     * </pre>
     *
     * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Host to which clients can send HTTPS traffic that will be
     * received by the workstation. Authorized traffic will be received to the
     * workstation as HTTP on port 80. To send traffic to a different port,
     * clients may prefix the host with the destination port in the format
     * `{port}-{host}`.
     * </pre>
     *
     * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Host to which clients can send HTTPS traffic that will be
     * received by the workstation. Authorized traffic will be received to the
     * workstation as HTTP on port 80. To send traffic to a different port,
     * clients may prefix the host with the destination port in the format
     * `{port}-{host}`.
     * </pre>
     *
     * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Host to which clients can send HTTPS traffic that will be
     * received by the workstation. Authorized traffic will be received to the
     * workstation as HTTP on port 80. To send traffic to a different port,
     * clients may prefix the host with the destination port in the format
     * `{port}-{host}`.
     * </pre>
     *
     * <code>string host = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.Workstation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.Workstation)
  private static final com.google.cloud.workstations.v1.Workstation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.Workstation();
  }

  public static com.google.cloud.workstations.v1.Workstation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Workstation> PARSER =
      new com.google.protobuf.AbstractParser<Workstation>() {
        @java.lang.Override
        public Workstation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Workstation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Workstation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workstations.v1.Workstation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
