/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workstations/v1/workstations.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.workstations.v1;

/**
 *
 *
 * <pre>
 * A workstation cluster resource in the Cloud Workstations API.
 *
 * Defines a group of workstations in a particular region and the
 * VPC network they're attached to.
 * </pre>
 *
 * Protobuf type {@code google.cloud.workstations.v1.WorkstationCluster}
 */
public final class WorkstationCluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationCluster)
    WorkstationClusterOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WorkstationCluster.newBuilder() to construct.
  private WorkstationCluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkstationCluster() {
    name_ = "";
    displayName_ = "";
    uid_ = "";
    etag_ = "";
    network_ = "";
    subnetwork_ = "";
    controlPlaneIp_ = "";
    conditions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkstationCluster();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_WorkstationCluster_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetAnnotations();
      case 15:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_WorkstationCluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workstations.v1.WorkstationCluster.class,
            com.google.cloud.workstations.v1.WorkstationCluster.Builder.class);
  }

  public interface PrivateClusterConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. Whether Workstations endpoint is private.
     * </pre>
     *
     * <code>bool enable_private_endpoint = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The enablePrivateEndpoint.
     */
    boolean getEnablePrivateEndpoint();

    /**
     *
     *
     * <pre>
     * Output only. Hostname for the workstation cluster. This field will be
     * populated only when private endpoint is enabled. To access workstations
     * in the workstation cluster, create a new DNS zone mapping this domain
     * name to an internal IP address and a forwarding rule mapping that address
     * to the service attachment.
     * </pre>
     *
     * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterHostname.
     */
    java.lang.String getClusterHostname();

    /**
     *
     *
     * <pre>
     * Output only. Hostname for the workstation cluster. This field will be
     * populated only when private endpoint is enabled. To access workstations
     * in the workstation cluster, create a new DNS zone mapping this domain
     * name to an internal IP address and a forwarding rule mapping that address
     * to the service attachment.
     * </pre>
     *
     * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterHostname.
     */
    com.google.protobuf.ByteString getClusterHostnameBytes();

    /**
     *
     *
     * <pre>
     * Output only. Service attachment URI for the workstation cluster. The
     * service attachemnt is created when private endpoint is enabled. To access
     * workstations in the workstation cluster, configure access to the managed
     * service using [Private Service
     * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
     * </pre>
     *
     * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAttachmentUri.
     */
    java.lang.String getServiceAttachmentUri();

    /**
     *
     *
     * <pre>
     * Output only. Service attachment URI for the workstation cluster. The
     * service attachemnt is created when private endpoint is enabled. To access
     * workstations in the workstation cluster, configure access to the managed
     * service using [Private Service
     * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
     * </pre>
     *
     * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAttachmentUri.
     */
    com.google.protobuf.ByteString getServiceAttachmentUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowedProjects.
     */
    java.util.List<java.lang.String> getAllowedProjectsList();

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowedProjects.
     */
    int getAllowedProjectsCount();

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowedProjects at the given index.
     */
    java.lang.String getAllowedProjects(int index);

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedProjects at the given index.
     */
    com.google.protobuf.ByteString getAllowedProjectsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Configuration options for private workstation clusters.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig}
   */
  public static final class PrivateClusterConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig)
      PrivateClusterConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PrivateClusterConfig.newBuilder() to construct.
    private PrivateClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PrivateClusterConfig() {
      clusterHostname_ = "";
      serviceAttachmentUri_ = "";
      allowedProjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PrivateClusterConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationCluster_PrivateClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationCluster_PrivateClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.class,
              com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder
                  .class);
    }

    public static final int ENABLE_PRIVATE_ENDPOINT_FIELD_NUMBER = 1;
    private boolean enablePrivateEndpoint_ = false;

    /**
     *
     *
     * <pre>
     * Immutable. Whether Workstations endpoint is private.
     * </pre>
     *
     * <code>bool enable_private_endpoint = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The enablePrivateEndpoint.
     */
    @java.lang.Override
    public boolean getEnablePrivateEndpoint() {
      return enablePrivateEndpoint_;
    }

    public static final int CLUSTER_HOSTNAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object clusterHostname_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Hostname for the workstation cluster. This field will be
     * populated only when private endpoint is enabled. To access workstations
     * in the workstation cluster, create a new DNS zone mapping this domain
     * name to an internal IP address and a forwarding rule mapping that address
     * to the service attachment.
     * </pre>
     *
     * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The clusterHostname.
     */
    @java.lang.Override
    public java.lang.String getClusterHostname() {
      java.lang.Object ref = clusterHostname_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clusterHostname_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Hostname for the workstation cluster. This field will be
     * populated only when private endpoint is enabled. To access workstations
     * in the workstation cluster, create a new DNS zone mapping this domain
     * name to an internal IP address and a forwarding rule mapping that address
     * to the service attachment.
     * </pre>
     *
     * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for clusterHostname.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getClusterHostnameBytes() {
      java.lang.Object ref = clusterHostname_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clusterHostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_ATTACHMENT_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceAttachmentUri_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Service attachment URI for the workstation cluster. The
     * service attachemnt is created when private endpoint is enabled. To access
     * workstations in the workstation cluster, configure access to the managed
     * service using [Private Service
     * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
     * </pre>
     *
     * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAttachmentUri.
     */
    @java.lang.Override
    public java.lang.String getServiceAttachmentUri() {
      java.lang.Object ref = serviceAttachmentUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAttachmentUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Service attachment URI for the workstation cluster. The
     * service attachemnt is created when private endpoint is enabled. To access
     * workstations in the workstation cluster, configure access to the managed
     * service using [Private Service
     * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
     * </pre>
     *
     * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAttachmentUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAttachmentUriBytes() {
      java.lang.Object ref = serviceAttachmentUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAttachmentUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOWED_PROJECTS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowedProjects_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowedProjects.
     */
    public com.google.protobuf.ProtocolStringList getAllowedProjectsList() {
      return allowedProjects_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowedProjects.
     */
    public int getAllowedProjectsCount() {
      return allowedProjects_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowedProjects at the given index.
     */
    public java.lang.String getAllowedProjects(int index) {
      return allowedProjects_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Additional projects that are allowed to attach to the
     * workstation cluster's service attachment. By default, the workstation
     * cluster's project and the VPC host project (if different) are allowed.
     * </pre>
     *
     * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedProjects at the given index.
     */
    public com.google.protobuf.ByteString getAllowedProjectsBytes(int index) {
      return allowedProjects_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enablePrivateEndpoint_ != false) {
        output.writeBool(1, enablePrivateEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterHostname_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, clusterHostname_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAttachmentUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serviceAttachmentUri_);
      }
      for (int i = 0; i < allowedProjects_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, allowedProjects_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enablePrivateEndpoint_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enablePrivateEndpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clusterHostname_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, clusterHostname_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAttachmentUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serviceAttachmentUri_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedProjects_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedProjects_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedProjectsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig other =
          (com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig) obj;

      if (getEnablePrivateEndpoint() != other.getEnablePrivateEndpoint()) return false;
      if (!getClusterHostname().equals(other.getClusterHostname())) return false;
      if (!getServiceAttachmentUri().equals(other.getServiceAttachmentUri())) return false;
      if (!getAllowedProjectsList().equals(other.getAllowedProjectsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_PRIVATE_ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnablePrivateEndpoint());
      hash = (37 * hash) + CLUSTER_HOSTNAME_FIELD_NUMBER;
      hash = (53 * hash) + getClusterHostname().hashCode();
      hash = (37 * hash) + SERVICE_ATTACHMENT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAttachmentUri().hashCode();
      if (getAllowedProjectsCount() > 0) {
        hash = (37 * hash) + ALLOWED_PROJECTS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedProjectsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration options for private workstation clusters.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig)
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationCluster_PrivateClusterConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationCluster_PrivateClusterConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.class,
                com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enablePrivateEndpoint_ = false;
        clusterHostname_ = "";
        serviceAttachmentUri_ = "";
        allowedProjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationCluster_PrivateClusterConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
          getDefaultInstanceForType() {
        return com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig build() {
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
          buildPartial() {
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig result =
            new com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enablePrivateEndpoint_ = enablePrivateEndpoint_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.clusterHostname_ = clusterHostname_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.serviceAttachmentUri_ = serviceAttachmentUri_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          allowedProjects_.makeImmutable();
          result.allowedProjects_ = allowedProjects_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig) {
          return mergeFrom(
              (com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig other) {
        if (other
            == com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
                .getDefaultInstance()) return this;
        if (other.getEnablePrivateEndpoint() != false) {
          setEnablePrivateEndpoint(other.getEnablePrivateEndpoint());
        }
        if (!other.getClusterHostname().isEmpty()) {
          clusterHostname_ = other.clusterHostname_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getServiceAttachmentUri().isEmpty()) {
          serviceAttachmentUri_ = other.serviceAttachmentUri_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.allowedProjects_.isEmpty()) {
          if (allowedProjects_.isEmpty()) {
            allowedProjects_ = other.allowedProjects_;
            bitField0_ |= 0x00000008;
          } else {
            ensureAllowedProjectsIsMutable();
            allowedProjects_.addAll(other.allowedProjects_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  enablePrivateEndpoint_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  clusterHostname_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  serviceAttachmentUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowedProjectsIsMutable();
                  allowedProjects_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enablePrivateEndpoint_;

      /**
       *
       *
       * <pre>
       * Immutable. Whether Workstations endpoint is private.
       * </pre>
       *
       * <code>bool enable_private_endpoint = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The enablePrivateEndpoint.
       */
      @java.lang.Override
      public boolean getEnablePrivateEndpoint() {
        return enablePrivateEndpoint_;
      }

      /**
       *
       *
       * <pre>
       * Immutable. Whether Workstations endpoint is private.
       * </pre>
       *
       * <code>bool enable_private_endpoint = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The enablePrivateEndpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEnablePrivateEndpoint(boolean value) {

        enablePrivateEndpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Immutable. Whether Workstations endpoint is private.
       * </pre>
       *
       * <code>bool enable_private_endpoint = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnablePrivateEndpoint() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enablePrivateEndpoint_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object clusterHostname_ = "";

      /**
       *
       *
       * <pre>
       * Output only. Hostname for the workstation cluster. This field will be
       * populated only when private endpoint is enabled. To access workstations
       * in the workstation cluster, create a new DNS zone mapping this domain
       * name to an internal IP address and a forwarding rule mapping that address
       * to the service attachment.
       * </pre>
       *
       * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The clusterHostname.
       */
      public java.lang.String getClusterHostname() {
        java.lang.Object ref = clusterHostname_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clusterHostname_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Hostname for the workstation cluster. This field will be
       * populated only when private endpoint is enabled. To access workstations
       * in the workstation cluster, create a new DNS zone mapping this domain
       * name to an internal IP address and a forwarding rule mapping that address
       * to the service attachment.
       * </pre>
       *
       * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for clusterHostname.
       */
      public com.google.protobuf.ByteString getClusterHostnameBytes() {
        java.lang.Object ref = clusterHostname_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          clusterHostname_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Hostname for the workstation cluster. This field will be
       * populated only when private endpoint is enabled. To access workstations
       * in the workstation cluster, create a new DNS zone mapping this domain
       * name to an internal IP address and a forwarding rule mapping that address
       * to the service attachment.
       * </pre>
       *
       * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The clusterHostname to set.
       * @return This builder for chaining.
       */
      public Builder setClusterHostname(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        clusterHostname_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Hostname for the workstation cluster. This field will be
       * populated only when private endpoint is enabled. To access workstations
       * in the workstation cluster, create a new DNS zone mapping this domain
       * name to an internal IP address and a forwarding rule mapping that address
       * to the service attachment.
       * </pre>
       *
       * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearClusterHostname() {
        clusterHostname_ = getDefaultInstance().getClusterHostname();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Hostname for the workstation cluster. This field will be
       * populated only when private endpoint is enabled. To access workstations
       * in the workstation cluster, create a new DNS zone mapping this domain
       * name to an internal IP address and a forwarding rule mapping that address
       * to the service attachment.
       * </pre>
       *
       * <code>string cluster_hostname = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for clusterHostname to set.
       * @return This builder for chaining.
       */
      public Builder setClusterHostnameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        clusterHostname_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object serviceAttachmentUri_ = "";

      /**
       *
       *
       * <pre>
       * Output only. Service attachment URI for the workstation cluster. The
       * service attachemnt is created when private endpoint is enabled. To access
       * workstations in the workstation cluster, configure access to the managed
       * service using [Private Service
       * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
       * </pre>
       *
       * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The serviceAttachmentUri.
       */
      public java.lang.String getServiceAttachmentUri() {
        java.lang.Object ref = serviceAttachmentUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAttachmentUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Service attachment URI for the workstation cluster. The
       * service attachemnt is created when private endpoint is enabled. To access
       * workstations in the workstation cluster, configure access to the managed
       * service using [Private Service
       * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
       * </pre>
       *
       * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The bytes for serviceAttachmentUri.
       */
      public com.google.protobuf.ByteString getServiceAttachmentUriBytes() {
        java.lang.Object ref = serviceAttachmentUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAttachmentUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Service attachment URI for the workstation cluster. The
       * service attachemnt is created when private endpoint is enabled. To access
       * workstations in the workstation cluster, configure access to the managed
       * service using [Private Service
       * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
       * </pre>
       *
       * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The serviceAttachmentUri to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAttachmentUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAttachmentUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Service attachment URI for the workstation cluster. The
       * service attachemnt is created when private endpoint is enabled. To access
       * workstations in the workstation cluster, configure access to the managed
       * service using [Private Service
       * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
       * </pre>
       *
       * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAttachmentUri() {
        serviceAttachmentUri_ = getDefaultInstance().getServiceAttachmentUri();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Service attachment URI for the workstation cluster. The
       * service attachemnt is created when private endpoint is enabled. To access
       * workstations in the workstation cluster, configure access to the managed
       * service using [Private Service
       * Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
       * </pre>
       *
       * <code>string service_attachment_uri = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The bytes for serviceAttachmentUri to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAttachmentUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceAttachmentUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList allowedProjects_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowedProjectsIsMutable() {
        if (!allowedProjects_.isModifiable()) {
          allowedProjects_ = new com.google.protobuf.LazyStringArrayList(allowedProjects_);
        }
        bitField0_ |= 0x00000008;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the allowedProjects.
       */
      public com.google.protobuf.ProtocolStringList getAllowedProjectsList() {
        allowedProjects_.makeImmutable();
        return allowedProjects_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of allowedProjects.
       */
      public int getAllowedProjectsCount() {
        return allowedProjects_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The allowedProjects at the given index.
       */
      public java.lang.String getAllowedProjects(int index) {
        return allowedProjects_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedProjects at the given index.
       */
      public com.google.protobuf.ByteString getAllowedProjectsBytes(int index) {
        return allowedProjects_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The allowedProjects to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedProjects(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedProjectsIsMutable();
        allowedProjects_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The allowedProjects to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedProjects(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedProjectsIsMutable();
        allowedProjects_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The allowedProjects to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedProjects(java.lang.Iterable<java.lang.String> values) {
        ensureAllowedProjectsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedProjects_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedProjects() {
        allowedProjects_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional projects that are allowed to attach to the
       * workstation cluster's service attachment. By default, the workstation
       * cluster's project and the VPC host project (if different) are allowed.
       * </pre>
       *
       * <code>repeated string allowed_projects = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the allowedProjects to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedProjectsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowedProjectsIsMutable();
        allowedProjects_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig)
    private static final com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig();
    }

    public static com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrivateClusterConfig> PARSER =
        new com.google.protobuf.AbstractParser<PrivateClusterConfig>() {
          @java.lang.Override
          public PrivateClusterConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PrivateClusterConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrivateClusterConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Full name of this workstation cluster.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Full name of this workstation cluster.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Human-readable name for this workstation cluster.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Human-readable name for this workstation cluster.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A system-assigned unique identifier for this workstation
   * cluster.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A system-assigned unique identifier for this workstation
   * cluster.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECONCILING_FIELD_NUMBER = 4;
  private boolean reconciling_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this workstation cluster is currently being
   * updated to match its intended state.
   * </pre>
   *
   * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationCluster_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 15;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationCluster_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation cluster and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation cluster and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation cluster and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation cluster and that are also propagated to the
   * underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation cluster was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Checksum computed by the server. May be sent on update and delete
   * requests to make sure that the client has an up-to-date value before
   * proceeding.
   * </pre>
   *
   * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Checksum computed by the server. May be sent on update and delete
   * requests to make sure that the client has an up-to-date value before
   * proceeding.
   * </pre>
   *
   * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Name of the Compute Engine network in which instances associated
   * with this workstation cluster will be created.
   * </pre>
   *
   * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Name of the Compute Engine network in which instances associated
   * with this workstation cluster will be created.
   * </pre>
   *
   * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Name of the Compute Engine subnetwork in which instances
   * associated with this workstation cluster will be created. Must be part of
   * the subnetwork specified for this workstation cluster.
   * </pre>
   *
   * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Name of the Compute Engine subnetwork in which instances
   * associated with this workstation cluster will be created. Must be part of
   * the subnetwork specified for this workstation cluster.
   * </pre>
   *
   * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTROL_PLANE_IP_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object controlPlaneIp_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The private IP address of the control plane for this
   * workstation cluster. Workstation VMs need access to this IP address to work
   * with the service, so make sure that your firewall rules allow egress from
   * the workstation VMs to this address.
   * </pre>
   *
   * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The controlPlaneIp.
   */
  @java.lang.Override
  public java.lang.String getControlPlaneIp() {
    java.lang.Object ref = controlPlaneIp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      controlPlaneIp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The private IP address of the control plane for this
   * workstation cluster. Workstation VMs need access to this IP address to work
   * with the service, so make sure that your firewall rules allow egress from
   * the workstation VMs to this address.
   * </pre>
   *
   * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for controlPlaneIp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getControlPlaneIpBytes() {
    java.lang.Object ref = controlPlaneIp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      controlPlaneIp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
      privateClusterConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for private workstation cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privateClusterConfig field is set.
   */
  @java.lang.Override
  public boolean hasPrivateClusterConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for private workstation cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privateClusterConfig.
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
      getPrivateClusterConfig() {
    return privateClusterConfig_ == null
        ? com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
            .getDefaultInstance()
        : privateClusterConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for private workstation cluster.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfigOrBuilder
      getPrivateClusterConfigOrBuilder() {
    return privateClusterConfig_ == null
        ? com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
            .getDefaultInstance()
        : privateClusterConfig_;
  }

  public static final int DEGRADED_FIELD_NUMBER = 13;
  private boolean degraded_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Whether this workstation cluster is in degraded mode, in which
   * case it may require user action to restore full functionality. Details can
   * be found in
   * [conditions][google.cloud.workstations.v1.WorkstationCluster.conditions].
   * </pre>
   *
   * <code>bool degraded = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The degraded.
   */
  @java.lang.Override
  public boolean getDegraded() {
    return degraded_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> conditions_;

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the workstation cluster's current
   * state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getConditionsList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the workstation cluster's current
   * state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getConditionsOrBuilderList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the workstation cluster's current
   * state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the workstation cluster's current
   * state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getConditions(int index) {
    return conditions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the workstation cluster's current
   * state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uid_);
    }
    if (reconciling_ != false) {
      output.writeBool(4, reconciling_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, subnetwork_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(12, getPrivateClusterConfig());
    }
    if (degraded_ != false) {
      output.writeBool(13, degraded_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(14, conditions_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 15);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(controlPlaneIp_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, controlPlaneIp_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uid_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, reconciling_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, network_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, subnetwork_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getPrivateClusterConfig());
    }
    if (degraded_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, degraded_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, conditions_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(controlPlaneIp_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, controlPlaneIp_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workstations.v1.WorkstationCluster)) {
      return super.equals(obj);
    }
    com.google.cloud.workstations.v1.WorkstationCluster other =
        (com.google.cloud.workstations.v1.WorkstationCluster) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    if (!getControlPlaneIp().equals(other.getControlPlaneIp())) return false;
    if (hasPrivateClusterConfig() != other.hasPrivateClusterConfig()) return false;
    if (hasPrivateClusterConfig()) {
      if (!getPrivateClusterConfig().equals(other.getPrivateClusterConfig())) return false;
    }
    if (getDegraded() != other.getDegraded()) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getSubnetwork().hashCode();
    hash = (37 * hash) + CONTROL_PLANE_IP_FIELD_NUMBER;
    hash = (53 * hash) + getControlPlaneIp().hashCode();
    if (hasPrivateClusterConfig()) {
      hash = (37 * hash) + PRIVATE_CLUSTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateClusterConfig().hashCode();
    }
    hash = (37 * hash) + DEGRADED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDegraded());
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.workstations.v1.WorkstationCluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A workstation cluster resource in the Cloud Workstations API.
   *
   * Defines a group of workstations in a particular region and the
   * VPC network they're attached to.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationCluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationCluster)
      com.google.cloud.workstations.v1.WorkstationClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationCluster_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetAnnotations();
        case 15:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableAnnotations();
        case 15:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationCluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationCluster.class,
              com.google.cloud.workstations.v1.WorkstationCluster.Builder.class);
    }

    // Construct using com.google.cloud.workstations.v1.WorkstationCluster.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
        getPrivateClusterConfigFieldBuilder();
        getConditionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      uid_ = "";
      reconciling_ = false;
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      etag_ = "";
      network_ = "";
      subnetwork_ = "";
      controlPlaneIp_ = "";
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      degraded_ = false;
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00008000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationCluster_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationCluster getDefaultInstanceForType() {
      return com.google.cloud.workstations.v1.WorkstationCluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationCluster build() {
      com.google.cloud.workstations.v1.WorkstationCluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationCluster buildPartial() {
      com.google.cloud.workstations.v1.WorkstationCluster result =
          new com.google.cloud.workstations.v1.WorkstationCluster(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.workstations.v1.WorkstationCluster result) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00008000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.workstations.v1.WorkstationCluster result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.subnetwork_ = subnetwork_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.controlPlaneIp_ = controlPlaneIp_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.privateClusterConfig_ =
            privateClusterConfigBuilder_ == null
                ? privateClusterConfig_
                : privateClusterConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.degraded_ = degraded_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workstations.v1.WorkstationCluster) {
        return mergeFrom((com.google.cloud.workstations.v1.WorkstationCluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.workstations.v1.WorkstationCluster other) {
      if (other == com.google.cloud.workstations.v1.WorkstationCluster.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getSubnetwork().isEmpty()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getControlPlaneIp().isEmpty()) {
        controlPlaneIp_ = other.controlPlaneIp_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasPrivateClusterConfig()) {
        mergePrivateClusterConfig(other.getPrivateClusterConfig());
      }
      if (other.getDegraded() != false) {
        setDegraded(other.getDegraded());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00008000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00008000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getPrivateClusterConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 98
            case 104:
              {
                degraded_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 104
            case 114:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 122:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 122
            case 130:
              {
                controlPlaneIp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Full name of this workstation cluster.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation cluster.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation cluster.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation cluster.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation cluster.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation cluster.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation cluster.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation cluster.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation cluster.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation cluster.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * cluster.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * cluster.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * cluster.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * cluster.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * cluster.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean reconciling_;

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation cluster is currently being
     * updated to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation cluster is currently being
     * updated to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation cluster is currently being
     * updated to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000008);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation cluster and that are also propagated to the
     * underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation cluster was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine network in which instances associated
     * with this workstation cluster will be created.
     * </pre>
     *
     * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine network in which instances associated
     * with this workstation cluster will be created.
     * </pre>
     *
     * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine network in which instances associated
     * with this workstation cluster will be created.
     * </pre>
     *
     * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine network in which instances associated
     * with this workstation cluster will be created.
     * </pre>
     *
     * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine network in which instances associated
     * with this workstation cluster will be created.
     * </pre>
     *
     * <code>string network = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine subnetwork in which instances
     * associated with this workstation cluster will be created. Must be part of
     * the subnetwork specified for this workstation cluster.
     * </pre>
     *
     * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine subnetwork in which instances
     * associated with this workstation cluster will be created. Must be part of
     * the subnetwork specified for this workstation cluster.
     * </pre>
     *
     * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine subnetwork in which instances
     * associated with this workstation cluster will be created. Must be part of
     * the subnetwork specified for this workstation cluster.
     * </pre>
     *
     * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine subnetwork in which instances
     * associated with this workstation cluster will be created. Must be part of
     * the subnetwork specified for this workstation cluster.
     * </pre>
     *
     * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Name of the Compute Engine subnetwork in which instances
     * associated with this workstation cluster will be created. Must be part of
     * the subnetwork specified for this workstation cluster.
     * </pre>
     *
     * <code>string subnetwork = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object controlPlaneIp_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The private IP address of the control plane for this
     * workstation cluster. Workstation VMs need access to this IP address to work
     * with the service, so make sure that your firewall rules allow egress from
     * the workstation VMs to this address.
     * </pre>
     *
     * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The controlPlaneIp.
     */
    public java.lang.String getControlPlaneIp() {
      java.lang.Object ref = controlPlaneIp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        controlPlaneIp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The private IP address of the control plane for this
     * workstation cluster. Workstation VMs need access to this IP address to work
     * with the service, so make sure that your firewall rules allow egress from
     * the workstation VMs to this address.
     * </pre>
     *
     * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for controlPlaneIp.
     */
    public com.google.protobuf.ByteString getControlPlaneIpBytes() {
      java.lang.Object ref = controlPlaneIp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        controlPlaneIp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The private IP address of the control plane for this
     * workstation cluster. Workstation VMs need access to this IP address to work
     * with the service, so make sure that your firewall rules allow egress from
     * the workstation VMs to this address.
     * </pre>
     *
     * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The controlPlaneIp to set.
     * @return This builder for chaining.
     */
    public Builder setControlPlaneIp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      controlPlaneIp_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The private IP address of the control plane for this
     * workstation cluster. Workstation VMs need access to this IP address to work
     * with the service, so make sure that your firewall rules allow egress from
     * the workstation VMs to this address.
     * </pre>
     *
     * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearControlPlaneIp() {
      controlPlaneIp_ = getDefaultInstance().getControlPlaneIp();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The private IP address of the control plane for this
     * workstation cluster. Workstation VMs need access to this IP address to work
     * with the service, so make sure that your firewall rules allow egress from
     * the workstation VMs to this address.
     * </pre>
     *
     * <code>string control_plane_ip = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for controlPlaneIp to set.
     * @return This builder for chaining.
     */
    public Builder setControlPlaneIpBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      controlPlaneIp_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        privateClusterConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig,
            com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder,
            com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfigOrBuilder>
        privateClusterConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privateClusterConfig field is set.
     */
    public boolean hasPrivateClusterConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privateClusterConfig.
     */
    public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
        getPrivateClusterConfig() {
      if (privateClusterConfigBuilder_ == null) {
        return privateClusterConfig_ == null
            ? com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
                .getDefaultInstance()
            : privateClusterConfig_;
      } else {
        return privateClusterConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateClusterConfig(
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privateClusterConfig_ = value;
      } else {
        privateClusterConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivateClusterConfig(
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder
            builderForValue) {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfig_ = builderForValue.build();
      } else {
        privateClusterConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivateClusterConfig(
        com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig value) {
      if (privateClusterConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && privateClusterConfig_ != null
            && privateClusterConfig_
                != com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
                    .getDefaultInstance()) {
          getPrivateClusterConfigBuilder().mergeFrom(value);
        } else {
          privateClusterConfig_ = value;
        }
      } else {
        privateClusterConfigBuilder_.mergeFrom(value);
      }
      if (privateClusterConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivateClusterConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      privateClusterConfig_ = null;
      if (privateClusterConfigBuilder_ != null) {
        privateClusterConfigBuilder_.dispose();
        privateClusterConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder
        getPrivateClusterConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getPrivateClusterConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfigOrBuilder
        getPrivateClusterConfigOrBuilder() {
      if (privateClusterConfigBuilder_ != null) {
        return privateClusterConfigBuilder_.getMessageOrBuilder();
      } else {
        return privateClusterConfig_ == null
            ? com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig
                .getDefaultInstance()
            : privateClusterConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for private workstation cluster.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig private_cluster_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig,
            com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder,
            com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfigOrBuilder>
        getPrivateClusterConfigFieldBuilder() {
      if (privateClusterConfigBuilder_ == null) {
        privateClusterConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig,
                com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfig.Builder,
                com.google.cloud.workstations.v1.WorkstationCluster.PrivateClusterConfigOrBuilder>(
                getPrivateClusterConfig(), getParentForChildren(), isClean());
        privateClusterConfig_ = null;
      }
      return privateClusterConfigBuilder_;
    }

    private boolean degraded_;

    /**
     *
     *
     * <pre>
     * Output only. Whether this workstation cluster is in degraded mode, in which
     * case it may require user action to restore full functionality. Details can
     * be found in
     * [conditions][google.cloud.workstations.v1.WorkstationCluster.conditions].
     * </pre>
     *
     * <code>bool degraded = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The degraded.
     */
    @java.lang.Override
    public boolean getDegraded() {
      return degraded_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether this workstation cluster is in degraded mode, in which
     * case it may require user action to restore full functionality. Details can
     * be found in
     * [conditions][google.cloud.workstations.v1.WorkstationCluster.conditions].
     * </pre>
     *
     * <code>bool degraded = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The degraded to set.
     * @return This builder for chaining.
     */
    public Builder setDegraded(boolean value) {

      degraded_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether this workstation cluster is in degraded mode, in which
     * case it may require user action to restore full functionality. Details can
     * be found in
     * [conditions][google.cloud.workstations.v1.WorkstationCluster.conditions].
     * </pre>
     *
     * <code>bool degraded = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDegraded() {
      bitField0_ = (bitField0_ & ~0x00004000);
      degraded_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> conditions_ = java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.rpc.Status>(conditions_);
        bitField0_ |= 0x00008000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.rpc.Status value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.rpc.Status.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.rpc.Status value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.rpc.Status value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.rpc.Status.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.rpc.Status.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConditions(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00008000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the workstation cluster's current
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                conditions_, ((bitField0_ & 0x00008000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationCluster)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationCluster)
  private static final com.google.cloud.workstations.v1.WorkstationCluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.WorkstationCluster();
  }

  public static com.google.cloud.workstations.v1.WorkstationCluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkstationCluster> PARSER =
      new com.google.protobuf.AbstractParser<WorkstationCluster>() {
        @java.lang.Override
        public WorkstationCluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkstationCluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkstationCluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationCluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
