/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workstations/v1/workstations.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.workstations.v1;

/**
 *
 *
 * <pre>
 * A workstation configuration resource in the Cloud Workstations API.
 *
 * Workstation configurations act as templates for workstations. The workstation
 * configuration defines details such as the workstation virtual machine (VM)
 * instance type, persistent storage, container image defining environment,
 * which IDE or Code Editor to use, and more. Administrators and platform teams
 * can also use [Identity and Access Management
 * (IAM)](https://cloud.google.com/iam/docs/overview) rules to grant access to
 * teams or to individual developers.
 * </pre>
 *
 * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig}
 */
public final class WorkstationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig)
    WorkstationConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WorkstationConfig.newBuilder() to construct.
  private WorkstationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkstationConfig() {
    name_ = "";
    displayName_ = "";
    uid_ = "";
    etag_ = "";
    persistentDirectories_ = java.util.Collections.emptyList();
    readinessChecks_ = java.util.Collections.emptyList();
    replicaZones_ = com.google.protobuf.LazyStringArrayList.emptyList();
    conditions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkstationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_WorkstationConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetAnnotations();
      case 18:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workstations.v1.WorkstationsProto
        .internal_static_google_cloud_workstations_v1_WorkstationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workstations.v1.WorkstationConfig.class,
            com.google.cloud.workstations.v1.WorkstationConfig.Builder.class);
  }

  public interface HostOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.Host)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies a Compute Engine instance as the host.
     * </pre>
     *
     * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
     * </code>
     *
     * @return Whether the gceInstance field is set.
     */
    boolean hasGceInstance();

    /**
     *
     *
     * <pre>
     * Specifies a Compute Engine instance as the host.
     * </pre>
     *
     * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
     * </code>
     *
     * @return The gceInstance.
     */
    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance getGceInstance();

    /**
     *
     *
     * <pre>
     * Specifies a Compute Engine instance as the host.
     * </pre>
     *
     * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
     * </code>
     */
    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder
        getGceInstanceOrBuilder();

    com.google.cloud.workstations.v1.WorkstationConfig.Host.ConfigCase getConfigCase();
  }

  /**
   *
   *
   * <pre>
   * Runtime host for a workstation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.Host}
   */
  public static final class Host extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.Host)
      HostOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Host.newBuilder() to construct.
    private Host(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Host() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Host();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationConfig.Host.class,
              com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder.class);
    }

    public interface GceInstanceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The type of machine to use for VM instances—for example,
       * `"e2-standard-4"`. For more information about machine types that
       * Cloud Workstations supports, see the list of
       * [available machine
       * types](https://cloud.google.com/workstations/docs/available-machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The machineType.
       */
      java.lang.String getMachineType();

      /**
       *
       *
       * <pre>
       * Optional. The type of machine to use for VM instances—for example,
       * `"e2-standard-4"`. For more information about machine types that
       * Cloud Workstations supports, see the list of
       * [available machine
       * types](https://cloud.google.com/workstations/docs/available-machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for machineType.
       */
      com.google.protobuf.ByteString getMachineTypeBytes();

      /**
       *
       *
       * <pre>
       * Optional. The email address of the service account for Cloud
       * Workstations VMs created with this configuration. When specified, be
       * sure that the service account has `logginglogEntries.create` permission
       * on the project so it can write logs out to Cloud Logging. If using a
       * custom container image, the service account must have permissions to
       * pull the specified image.
       *
       * If you as the administrator want to be able to `ssh` into the
       * underlying VM, you need to set this value to a service account
       * for which you have the `iam.serviceAccounts.actAs` permission.
       * Conversely, if you don't want anyone to be able to `ssh` into the
       * underlying VM, use a service account where no one has that
       * permission.
       *
       * If not set, VMs run with a service account provided by the
       * Cloud Workstations service, and the image must be publicly
       * accessible.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The serviceAccount.
       */
      java.lang.String getServiceAccount();

      /**
       *
       *
       * <pre>
       * Optional. The email address of the service account for Cloud
       * Workstations VMs created with this configuration. When specified, be
       * sure that the service account has `logginglogEntries.create` permission
       * on the project so it can write logs out to Cloud Logging. If using a
       * custom container image, the service account must have permissions to
       * pull the specified image.
       *
       * If you as the administrator want to be able to `ssh` into the
       * underlying VM, you need to set this value to a service account
       * for which you have the `iam.serviceAccounts.actAs` permission.
       * Conversely, if you don't want anyone to be able to `ssh` into the
       * underlying VM, use a service account where no one has that
       * permission.
       *
       * If not set, VMs run with a service account provided by the
       * Cloud Workstations service, and the image must be publicly
       * accessible.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for serviceAccount.
       */
      com.google.protobuf.ByteString getServiceAccountBytes();

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the serviceAccountScopes.
       */
      java.util.List<java.lang.String> getServiceAccountScopesList();

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of serviceAccountScopes.
       */
      int getServiceAccountScopesCount();

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The serviceAccountScopes at the given index.
       */
      java.lang.String getServiceAccountScopes(int index);

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the serviceAccountScopes at the given index.
       */
      com.google.protobuf.ByteString getServiceAccountScopesBytes(int index);

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the tags.
       */
      java.util.List<java.lang.String> getTagsList();

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of tags.
       */
      int getTagsCount();

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      java.lang.String getTags(int index);

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      com.google.protobuf.ByteString getTagsBytes(int index);

      /**
       *
       *
       * <pre>
       * Optional. The number of VMs that the system should keep idle so that
       * new workstations can be started quickly for new users. Defaults to `0`
       * in the API.
       * </pre>
       *
       * <code>int32 pool_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The poolSize.
       */
      int getPoolSize();

      /**
       *
       *
       * <pre>
       * Output only. Number of instances currently available in the pool for
       * faster workstation startup.
       * </pre>
       *
       * <code>int32 pooled_instances = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The pooledInstances.
       */
      int getPooledInstances();

      /**
       *
       *
       * <pre>
       * Optional. When set to true, disables public IP addresses for VMs. If
       * you disable public IP addresses, you must set up Private Google Access
       * or Cloud NAT on your network. If you use Private Google Access and you
       * use `private.googleapis.com` or `restricted.googleapis.com` for
       * Container Registry and Artifact Registry, make sure that you set
       * up DNS records for domains `*.gcr.io` and `*.pkg.dev`.
       * Defaults to false (VMs have public IP addresses).
       * </pre>
       *
       * <code>bool disable_public_ip_addresses = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The disablePublicIpAddresses.
       */
      boolean getDisablePublicIpAddresses();

      /**
       *
       *
       * <pre>
       * Optional. Whether to enable nested virtualization on Cloud Workstations
       * VMs created under this workstation configuration.
       *
       * Nested virtualization lets you run virtual machine (VM) instances
       * inside your workstation. Before enabling nested virtualization,
       * consider the following important considerations. Cloud Workstations
       * instances are subject to the [same restrictions as Compute Engine
       * instances](https://cloud.google.com/compute/docs/instances/nested-virtualization/overview#restrictions):
       *
       * * **Organization policy**: projects, folders, or
       * organizations may be restricted from creating nested VMs if the
       * **Disable VM nested virtualization** constraint is enforced in
       * the organization policy. For more information, see the
       * Compute Engine section,
       * [Checking whether nested virtualization is
       * allowed](https://cloud.google.com/compute/docs/instances/nested-virtualization/managing-constraint#checking_whether_nested_virtualization_is_allowed).
       * * **Performance**: nested VMs might experience a 10% or greater
       * decrease in performance for workloads that are CPU-bound and
       * possibly greater than a 10% decrease for workloads that are
       * input/output bound.
       * * **Machine Type**: nested virtualization can only be enabled on
       * workstation configurations that specify a
       * [machine_type][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.machine_type]
       * in the N1 or N2 machine series.
       * * **GPUs**: nested virtualization may not be enabled on workstation
       * configurations with accelerators.
       * * **Operating System**: Because
       * [Container-Optimized
       * OS](https://cloud.google.com/compute/docs/images/os-details#container-optimized_os_cos)
       * does not support nested virtualization, when nested virtualization is
       * enabled, the underlying Compute Engine VM instances boot from an
       * [Ubuntu
       * LTS](https://cloud.google.com/compute/docs/images/os-details#ubuntu_lts)
       * image.
       * </pre>
       *
       * <code>bool enable_nested_virtualization = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enableNestedVirtualization.
       */
      boolean getEnableNestedVirtualization();

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the shieldedInstanceConfig field is set.
       */
      boolean hasShieldedInstanceConfig();

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The shieldedInstanceConfig.
       */
      com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig
          getShieldedInstanceConfig();

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceShieldedInstanceConfigOrBuilder
          getShieldedInstanceConfigOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the confidentialInstanceConfig field is set.
       */
      boolean hasConfidentialInstanceConfig();

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The confidentialInstanceConfig.
       */
      com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceConfidentialInstanceConfig
          getConfidentialInstanceConfig();

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceConfidentialInstanceConfigOrBuilder
          getConfidentialInstanceConfigOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. The size of the boot disk for the VM in gigabytes (GB).
       * The minimum boot disk size is `30` GB. Defaults to `50` GB.
       * </pre>
       *
       * <code>int32 boot_disk_size_gb = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bootDiskSizeGb.
       */
      int getBootDiskSizeGb();
    }

    /**
     *
     *
     * <pre>
     * A runtime using a Compute Engine instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance}
     */
    public static final class GceInstance extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)
        GceInstanceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use GceInstance.newBuilder() to construct.
      private GceInstance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GceInstance() {
        machineType_ = "";
        serviceAccount_ = "";
        serviceAccountScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GceInstance();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.class,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder.class);
      }

      public interface GceShieldedInstanceConfigOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has Secure Boot enabled.
         * </pre>
         *
         * <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The enableSecureBoot.
         */
        boolean getEnableSecureBoot();

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has the vTPM enabled.
         * </pre>
         *
         * <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The enableVtpm.
         */
        boolean getEnableVtpm();

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has integrity monitoring enabled.
         * </pre>
         *
         * <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enableIntegrityMonitoring.
         */
        boolean getEnableIntegrityMonitoring();
      }

      /**
       *
       *
       * <pre>
       * A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig}
       */
      public static final class GceShieldedInstanceConfig
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig)
          GceShieldedInstanceConfigOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use GceShieldedInstanceConfig.newBuilder() to construct.
        private GceShieldedInstanceConfig(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GceShieldedInstanceConfig() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GceShieldedInstanceConfig();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceShieldedInstanceConfig.class,
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceShieldedInstanceConfig.Builder.class);
        }

        public static final int ENABLE_SECURE_BOOT_FIELD_NUMBER = 1;
        private boolean enableSecureBoot_ = false;

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has Secure Boot enabled.
         * </pre>
         *
         * <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The enableSecureBoot.
         */
        @java.lang.Override
        public boolean getEnableSecureBoot() {
          return enableSecureBoot_;
        }

        public static final int ENABLE_VTPM_FIELD_NUMBER = 2;
        private boolean enableVtpm_ = false;

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has the vTPM enabled.
         * </pre>
         *
         * <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The enableVtpm.
         */
        @java.lang.Override
        public boolean getEnableVtpm() {
          return enableVtpm_;
        }

        public static final int ENABLE_INTEGRITY_MONITORING_FIELD_NUMBER = 3;
        private boolean enableIntegrityMonitoring_ = false;

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has integrity monitoring enabled.
         * </pre>
         *
         * <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enableIntegrityMonitoring.
         */
        @java.lang.Override
        public boolean getEnableIntegrityMonitoring() {
          return enableIntegrityMonitoring_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (enableSecureBoot_ != false) {
            output.writeBool(1, enableSecureBoot_);
          }
          if (enableVtpm_ != false) {
            output.writeBool(2, enableVtpm_);
          }
          if (enableIntegrityMonitoring_ != false) {
            output.writeBool(3, enableIntegrityMonitoring_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (enableSecureBoot_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enableSecureBoot_);
          }
          if (enableVtpm_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableVtpm_);
          }
          if (enableIntegrityMonitoring_ != false) {
            size +=
                com.google.protobuf.CodedOutputStream.computeBoolSize(
                    3, enableIntegrityMonitoring_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceShieldedInstanceConfig)) {
            return super.equals(obj);
          }
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceShieldedInstanceConfig
              other =
                  (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                          .GceShieldedInstanceConfig)
                      obj;

          if (getEnableSecureBoot() != other.getEnableSecureBoot()) return false;
          if (getEnableVtpm() != other.getEnableVtpm()) return false;
          if (getEnableIntegrityMonitoring() != other.getEnableIntegrityMonitoring()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ENABLE_SECURE_BOOT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSecureBoot());
          hash = (37 * hash) + ENABLE_VTPM_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableVtpm());
          hash = (37 * hash) + ENABLE_INTEGRITY_MONITORING_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashBoolean(getEnableIntegrityMonitoring());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig)
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfigOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfig.class,
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfig.Builder.class);
          }

          // Construct using
          // com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            enableSecureBoot_ = false;
            enableVtpm_ = false;
            enableIntegrityMonitoring_ = false;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceShieldedInstanceConfig_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceShieldedInstanceConfig
              getDefaultInstanceForType() {
            return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceShieldedInstanceConfig
              build() {
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceShieldedInstanceConfig
              buildPartial() {
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig
                result =
                    new com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfig(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceShieldedInstanceConfig
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.enableSecureBoot_ = enableSecureBoot_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.enableVtpm_ = enableVtpm_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.enableIntegrityMonitoring_ = enableIntegrityMonitoring_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig) {
              return mergeFrom(
                  (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                          .GceShieldedInstanceConfig)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceShieldedInstanceConfig
                  other) {
            if (other
                == com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig.getDefaultInstance()) return this;
            if (other.getEnableSecureBoot() != false) {
              setEnableSecureBoot(other.getEnableSecureBoot());
            }
            if (other.getEnableVtpm() != false) {
              setEnableVtpm(other.getEnableVtpm());
            }
            if (other.getEnableIntegrityMonitoring() != false) {
              setEnableIntegrityMonitoring(other.getEnableIntegrityMonitoring());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      enableSecureBoot_ = input.readBool();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 16:
                    {
                      enableVtpm_ = input.readBool();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  case 24:
                    {
                      enableIntegrityMonitoring_ = input.readBool();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private boolean enableSecureBoot_;

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has Secure Boot enabled.
           * </pre>
           *
           * <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The enableSecureBoot.
           */
          @java.lang.Override
          public boolean getEnableSecureBoot() {
            return enableSecureBoot_;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has Secure Boot enabled.
           * </pre>
           *
           * <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The enableSecureBoot to set.
           * @return This builder for chaining.
           */
          public Builder setEnableSecureBoot(boolean value) {

            enableSecureBoot_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has Secure Boot enabled.
           * </pre>
           *
           * <code>bool enable_secure_boot = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearEnableSecureBoot() {
            bitField0_ = (bitField0_ & ~0x00000001);
            enableSecureBoot_ = false;
            onChanged();
            return this;
          }

          private boolean enableVtpm_;

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has the vTPM enabled.
           * </pre>
           *
           * <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The enableVtpm.
           */
          @java.lang.Override
          public boolean getEnableVtpm() {
            return enableVtpm_;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has the vTPM enabled.
           * </pre>
           *
           * <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The enableVtpm to set.
           * @return This builder for chaining.
           */
          public Builder setEnableVtpm(boolean value) {

            enableVtpm_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has the vTPM enabled.
           * </pre>
           *
           * <code>bool enable_vtpm = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearEnableVtpm() {
            bitField0_ = (bitField0_ & ~0x00000002);
            enableVtpm_ = false;
            onChanged();
            return this;
          }

          private boolean enableIntegrityMonitoring_;

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has integrity monitoring enabled.
           * </pre>
           *
           * <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The enableIntegrityMonitoring.
           */
          @java.lang.Override
          public boolean getEnableIntegrityMonitoring() {
            return enableIntegrityMonitoring_;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has integrity monitoring enabled.
           * </pre>
           *
           * <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The enableIntegrityMonitoring to set.
           * @return This builder for chaining.
           */
          public Builder setEnableIntegrityMonitoring(boolean value) {

            enableIntegrityMonitoring_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has integrity monitoring enabled.
           * </pre>
           *
           * <code>bool enable_integrity_monitoring = 3 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearEnableIntegrityMonitoring() {
            bitField0_ = (bitField0_ & ~0x00000004);
            enableIntegrityMonitoring_ = false;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig)
        private static final com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceShieldedInstanceConfig();
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GceShieldedInstanceConfig> PARSER =
            new com.google.protobuf.AbstractParser<GceShieldedInstanceConfig>() {
              @java.lang.Override
              public GceShieldedInstanceConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GceShieldedInstanceConfig> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GceShieldedInstanceConfig> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface GceConfidentialInstanceConfigOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has confidential compute enabled.
         * </pre>
         *
         * <code>bool enable_confidential_compute = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enableConfidentialCompute.
         */
        boolean getEnableConfidentialCompute();
      }

      /**
       *
       *
       * <pre>
       * A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig}
       */
      public static final class GceConfidentialInstanceConfig
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig)
          GceConfidentialInstanceConfigOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use GceConfidentialInstanceConfig.newBuilder() to construct.
        private GceConfidentialInstanceConfig(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GceConfidentialInstanceConfig() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GceConfidentialInstanceConfig();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceConfidentialInstanceConfig.class,
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceConfidentialInstanceConfig.Builder.class);
        }

        public static final int ENABLE_CONFIDENTIAL_COMPUTE_FIELD_NUMBER = 1;
        private boolean enableConfidentialCompute_ = false;

        /**
         *
         *
         * <pre>
         * Optional. Whether the instance has confidential compute enabled.
         * </pre>
         *
         * <code>bool enable_confidential_compute = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enableConfidentialCompute.
         */
        @java.lang.Override
        public boolean getEnableConfidentialCompute() {
          return enableConfidentialCompute_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (enableConfidentialCompute_ != false) {
            output.writeBool(1, enableConfidentialCompute_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (enableConfidentialCompute_ != false) {
            size +=
                com.google.protobuf.CodedOutputStream.computeBoolSize(
                    1, enableConfidentialCompute_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceConfidentialInstanceConfig)) {
            return super.equals(obj);
          }
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceConfidentialInstanceConfig
              other =
                  (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                          .GceConfidentialInstanceConfig)
                      obj;

          if (getEnableConfidentialCompute() != other.getEnableConfidentialCompute()) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ENABLE_CONFIDENTIAL_COMPUTE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashBoolean(getEnableConfidentialCompute());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig)
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfigOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfig.class,
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfig.Builder.class);
          }

          // Construct using
          // com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            enableConfidentialCompute_ = false;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_GceConfidentialInstanceConfig_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceConfidentialInstanceConfig
              getDefaultInstanceForType() {
            return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceConfidentialInstanceConfig
              build() {
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceConfidentialInstanceConfig
              buildPartial() {
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig
                result =
                    new com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfig(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceConfidentialInstanceConfig
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.enableConfidentialCompute_ = enableConfidentialCompute_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig) {
              return mergeFrom(
                  (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                          .GceConfidentialInstanceConfig)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .GceConfidentialInstanceConfig
                  other) {
            if (other
                == com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig.getDefaultInstance()) return this;
            if (other.getEnableConfidentialCompute() != false) {
              setEnableConfidentialCompute(other.getEnableConfidentialCompute());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      enableConfidentialCompute_ = input.readBool();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private boolean enableConfidentialCompute_;

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has confidential compute enabled.
           * </pre>
           *
           * <code>bool enable_confidential_compute = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return The enableConfidentialCompute.
           */
          @java.lang.Override
          public boolean getEnableConfidentialCompute() {
            return enableConfidentialCompute_;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has confidential compute enabled.
           * </pre>
           *
           * <code>bool enable_confidential_compute = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @param value The enableConfidentialCompute to set.
           * @return This builder for chaining.
           */
          public Builder setEnableConfidentialCompute(boolean value) {

            enableConfidentialCompute_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Whether the instance has confidential compute enabled.
           * </pre>
           *
           * <code>bool enable_confidential_compute = 1 [(.google.api.field_behavior) = OPTIONAL];
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearEnableConfidentialCompute() {
            bitField0_ = (bitField0_ & ~0x00000001);
            enableConfidentialCompute_ = false;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig)
        private static final com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .GceConfidentialInstanceConfig();
        }

        public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GceConfidentialInstanceConfig> PARSER =
            new com.google.protobuf.AbstractParser<GceConfidentialInstanceConfig>() {
              @java.lang.Override
              public GceConfidentialInstanceConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GceConfidentialInstanceConfig> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GceConfidentialInstanceConfig> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object machineType_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The type of machine to use for VM instances—for example,
       * `"e2-standard-4"`. For more information about machine types that
       * Cloud Workstations supports, see the list of
       * [available machine
       * types](https://cloud.google.com/workstations/docs/available-machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The machineType.
       */
      @java.lang.Override
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The type of machine to use for VM instances—for example,
       * `"e2-standard-4"`. For more information about machine types that
       * Cloud Workstations supports, see the list of
       * [available machine
       * types](https://cloud.google.com/workstations/docs/available-machine-types).
       * </pre>
       *
       * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for machineType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object serviceAccount_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The email address of the service account for Cloud
       * Workstations VMs created with this configuration. When specified, be
       * sure that the service account has `logginglogEntries.create` permission
       * on the project so it can write logs out to Cloud Logging. If using a
       * custom container image, the service account must have permissions to
       * pull the specified image.
       *
       * If you as the administrator want to be able to `ssh` into the
       * underlying VM, you need to set this value to a service account
       * for which you have the `iam.serviceAccounts.actAs` permission.
       * Conversely, if you don't want anyone to be able to `ssh` into the
       * underlying VM, use a service account where no one has that
       * permission.
       *
       * If not set, VMs run with a service account provided by the
       * Cloud Workstations service, and the image must be publicly
       * accessible.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The serviceAccount.
       */
      @java.lang.Override
      public java.lang.String getServiceAccount() {
        java.lang.Object ref = serviceAccount_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAccount_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The email address of the service account for Cloud
       * Workstations VMs created with this configuration. When specified, be
       * sure that the service account has `logginglogEntries.create` permission
       * on the project so it can write logs out to Cloud Logging. If using a
       * custom container image, the service account must have permissions to
       * pull the specified image.
       *
       * If you as the administrator want to be able to `ssh` into the
       * underlying VM, you need to set this value to a service account
       * for which you have the `iam.serviceAccounts.actAs` permission.
       * Conversely, if you don't want anyone to be able to `ssh` into the
       * underlying VM, use a service account where no one has that
       * permission.
       *
       * If not set, VMs run with a service account provided by the
       * Cloud Workstations service, and the image must be publicly
       * accessible.
       * </pre>
       *
       * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for serviceAccount.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getServiceAccountBytes() {
        java.lang.Object ref = serviceAccount_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SERVICE_ACCOUNT_SCOPES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList serviceAccountScopes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the serviceAccountScopes.
       */
      public com.google.protobuf.ProtocolStringList getServiceAccountScopesList() {
        return serviceAccountScopes_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of serviceAccountScopes.
       */
      public int getServiceAccountScopesCount() {
        return serviceAccountScopes_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The serviceAccountScopes at the given index.
       */
      public java.lang.String getServiceAccountScopes(int index) {
        return serviceAccountScopes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Scopes to grant to the
       * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
       * Various scopes are automatically added based on feature usage. When
       * specified, users of workstations under this configuration must have
       * `iam.serviceAccounts.actAs` on the service account.
       * </pre>
       *
       * <code>repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the serviceAccountScopes at the given index.
       */
      public com.google.protobuf.ByteString getServiceAccountScopesBytes(int index) {
        return serviceAccountScopes_.getByteString(index);
      }

      public static final int TAGS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList tags_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the tags.
       */
      public com.google.protobuf.ProtocolStringList getTagsList() {
        return tags_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of tags.
       */
      public int getTagsCount() {
        return tags_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The tags at the given index.
       */
      public java.lang.String getTags(int index) {
        return tags_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Network tags to add to the Compute Engine VMs backing the
       * workstations. This option applies
       * [network
       * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
       * created with this configuration. These network tags enable the creation
       * of [firewall
       * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
       * </pre>
       *
       * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the tags at the given index.
       */
      public com.google.protobuf.ByteString getTagsBytes(int index) {
        return tags_.getByteString(index);
      }

      public static final int POOL_SIZE_FIELD_NUMBER = 5;
      private int poolSize_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. The number of VMs that the system should keep idle so that
       * new workstations can be started quickly for new users. Defaults to `0`
       * in the API.
       * </pre>
       *
       * <code>int32 pool_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The poolSize.
       */
      @java.lang.Override
      public int getPoolSize() {
        return poolSize_;
      }

      public static final int POOLED_INSTANCES_FIELD_NUMBER = 12;
      private int pooledInstances_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Number of instances currently available in the pool for
       * faster workstation startup.
       * </pre>
       *
       * <code>int32 pooled_instances = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The pooledInstances.
       */
      @java.lang.Override
      public int getPooledInstances() {
        return pooledInstances_;
      }

      public static final int DISABLE_PUBLIC_IP_ADDRESSES_FIELD_NUMBER = 6;
      private boolean disablePublicIpAddresses_ = false;

      /**
       *
       *
       * <pre>
       * Optional. When set to true, disables public IP addresses for VMs. If
       * you disable public IP addresses, you must set up Private Google Access
       * or Cloud NAT on your network. If you use Private Google Access and you
       * use `private.googleapis.com` or `restricted.googleapis.com` for
       * Container Registry and Artifact Registry, make sure that you set
       * up DNS records for domains `*.gcr.io` and `*.pkg.dev`.
       * Defaults to false (VMs have public IP addresses).
       * </pre>
       *
       * <code>bool disable_public_ip_addresses = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The disablePublicIpAddresses.
       */
      @java.lang.Override
      public boolean getDisablePublicIpAddresses() {
        return disablePublicIpAddresses_;
      }

      public static final int ENABLE_NESTED_VIRTUALIZATION_FIELD_NUMBER = 7;
      private boolean enableNestedVirtualization_ = false;

      /**
       *
       *
       * <pre>
       * Optional. Whether to enable nested virtualization on Cloud Workstations
       * VMs created under this workstation configuration.
       *
       * Nested virtualization lets you run virtual machine (VM) instances
       * inside your workstation. Before enabling nested virtualization,
       * consider the following important considerations. Cloud Workstations
       * instances are subject to the [same restrictions as Compute Engine
       * instances](https://cloud.google.com/compute/docs/instances/nested-virtualization/overview#restrictions):
       *
       * * **Organization policy**: projects, folders, or
       * organizations may be restricted from creating nested VMs if the
       * **Disable VM nested virtualization** constraint is enforced in
       * the organization policy. For more information, see the
       * Compute Engine section,
       * [Checking whether nested virtualization is
       * allowed](https://cloud.google.com/compute/docs/instances/nested-virtualization/managing-constraint#checking_whether_nested_virtualization_is_allowed).
       * * **Performance**: nested VMs might experience a 10% or greater
       * decrease in performance for workloads that are CPU-bound and
       * possibly greater than a 10% decrease for workloads that are
       * input/output bound.
       * * **Machine Type**: nested virtualization can only be enabled on
       * workstation configurations that specify a
       * [machine_type][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.machine_type]
       * in the N1 or N2 machine series.
       * * **GPUs**: nested virtualization may not be enabled on workstation
       * configurations with accelerators.
       * * **Operating System**: Because
       * [Container-Optimized
       * OS](https://cloud.google.com/compute/docs/images/os-details#container-optimized_os_cos)
       * does not support nested virtualization, when nested virtualization is
       * enabled, the underlying Compute Engine VM instances boot from an
       * [Ubuntu
       * LTS](https://cloud.google.com/compute/docs/images/os-details#ubuntu_lts)
       * image.
       * </pre>
       *
       * <code>bool enable_nested_virtualization = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enableNestedVirtualization.
       */
      @java.lang.Override
      public boolean getEnableNestedVirtualization() {
        return enableNestedVirtualization_;
      }

      public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 8;
      private com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceShieldedInstanceConfig
          shieldedInstanceConfig_;

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the shieldedInstanceConfig field is set.
       */
      @java.lang.Override
      public boolean hasShieldedInstanceConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The shieldedInstanceConfig.
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceShieldedInstanceConfig
          getShieldedInstanceConfig() {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Shielded instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceShieldedInstanceConfigOrBuilder
          getShieldedInstanceConfigOrBuilder() {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }

      public static final int CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER = 10;
      private com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceConfidentialInstanceConfig
          confidentialInstanceConfig_;

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the confidentialInstanceConfig field is set.
       */
      @java.lang.Override
      public boolean hasConfidentialInstanceConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The confidentialInstanceConfig.
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceConfidentialInstanceConfig
          getConfidentialInstanceConfig() {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      }

      /**
       *
       *
       * <pre>
       * Optional. A set of Compute Engine Confidential VM instance options.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .GceConfidentialInstanceConfigOrBuilder
          getConfidentialInstanceConfigOrBuilder() {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      }

      public static final int BOOT_DISK_SIZE_GB_FIELD_NUMBER = 9;
      private int bootDiskSizeGb_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. The size of the boot disk for the VM in gigabytes (GB).
       * The minimum boot disk size is `30` GB. Defaults to `50` GB.
       * </pre>
       *
       * <code>int32 boot_disk_size_gb = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bootDiskSizeGb.
       */
      @java.lang.Override
      public int getBootDiskSizeGb() {
        return bootDiskSizeGb_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, serviceAccount_);
        }
        for (int i = 0; i < serviceAccountScopes_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 3, serviceAccountScopes_.getRaw(i));
        }
        for (int i = 0; i < tags_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, tags_.getRaw(i));
        }
        if (poolSize_ != 0) {
          output.writeInt32(5, poolSize_);
        }
        if (disablePublicIpAddresses_ != false) {
          output.writeBool(6, disablePublicIpAddresses_);
        }
        if (enableNestedVirtualization_ != false) {
          output.writeBool(7, enableNestedVirtualization_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(8, getShieldedInstanceConfig());
        }
        if (bootDiskSizeGb_ != 0) {
          output.writeInt32(9, bootDiskSizeGb_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(10, getConfidentialInstanceConfig());
        }
        if (pooledInstances_ != 0) {
          output.writeInt32(12, pooledInstances_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, serviceAccount_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < serviceAccountScopes_.size(); i++) {
            dataSize += computeStringSizeNoTag(serviceAccountScopes_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getServiceAccountScopesList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < tags_.size(); i++) {
            dataSize += computeStringSizeNoTag(tags_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getTagsList().size();
        }
        if (poolSize_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, poolSize_);
        }
        if (disablePublicIpAddresses_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(6, disablePublicIpAddresses_);
        }
        if (enableNestedVirtualization_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(7, enableNestedVirtualization_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  8, getShieldedInstanceConfig());
        }
        if (bootDiskSizeGb_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, bootDiskSizeGb_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  10, getConfidentialInstanceConfig());
        }
        if (pooledInstances_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, pooledInstances_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)) {
          return super.equals(obj);
        }
        com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance other =
            (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) obj;

        if (!getMachineType().equals(other.getMachineType())) return false;
        if (!getServiceAccount().equals(other.getServiceAccount())) return false;
        if (!getServiceAccountScopesList().equals(other.getServiceAccountScopesList()))
          return false;
        if (!getTagsList().equals(other.getTagsList())) return false;
        if (getPoolSize() != other.getPoolSize()) return false;
        if (getPooledInstances() != other.getPooledInstances()) return false;
        if (getDisablePublicIpAddresses() != other.getDisablePublicIpAddresses()) return false;
        if (getEnableNestedVirtualization() != other.getEnableNestedVirtualization()) return false;
        if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
        if (hasShieldedInstanceConfig()) {
          if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
        }
        if (hasConfidentialInstanceConfig() != other.hasConfidentialInstanceConfig()) return false;
        if (hasConfidentialInstanceConfig()) {
          if (!getConfidentialInstanceConfig().equals(other.getConfidentialInstanceConfig()))
            return false;
        }
        if (getBootDiskSizeGb() != other.getBootDiskSizeGb()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getMachineType().hashCode();
        hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getServiceAccount().hashCode();
        if (getServiceAccountScopesCount() > 0) {
          hash = (37 * hash) + SERVICE_ACCOUNT_SCOPES_FIELD_NUMBER;
          hash = (53 * hash) + getServiceAccountScopesList().hashCode();
        }
        if (getTagsCount() > 0) {
          hash = (37 * hash) + TAGS_FIELD_NUMBER;
          hash = (53 * hash) + getTagsList().hashCode();
        }
        hash = (37 * hash) + POOL_SIZE_FIELD_NUMBER;
        hash = (53 * hash) + getPoolSize();
        hash = (37 * hash) + POOLED_INSTANCES_FIELD_NUMBER;
        hash = (53 * hash) + getPooledInstances();
        hash = (37 * hash) + DISABLE_PUBLIC_IP_ADDRESSES_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisablePublicIpAddresses());
        hash = (37 * hash) + ENABLE_NESTED_VIRTUALIZATION_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableNestedVirtualization());
        if (hasShieldedInstanceConfig()) {
          hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
        }
        if (hasConfidentialInstanceConfig()) {
          hash = (37 * hash) + CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getConfidentialInstanceConfig().hashCode();
        }
        hash = (37 * hash) + BOOT_DISK_SIZE_GB_FIELD_NUMBER;
        hash = (53 * hash) + getBootDiskSizeGb();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A runtime using a Compute Engine instance.
       * </pre>
       *
       * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.class,
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getShieldedInstanceConfigFieldBuilder();
            getConfidentialInstanceConfigFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          machineType_ = "";
          serviceAccount_ = "";
          serviceAccountScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
          poolSize_ = 0;
          pooledInstances_ = 0;
          disablePublicIpAddresses_ = false;
          enableNestedVirtualization_ = false;
          shieldedInstanceConfig_ = null;
          if (shieldedInstanceConfigBuilder_ != null) {
            shieldedInstanceConfigBuilder_.dispose();
            shieldedInstanceConfigBuilder_ = null;
          }
          confidentialInstanceConfig_ = null;
          if (confidentialInstanceConfigBuilder_ != null) {
            confidentialInstanceConfigBuilder_.dispose();
            confidentialInstanceConfigBuilder_ = null;
          }
          bootDiskSizeGb_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_GceInstance_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
            getDefaultInstanceForType() {
          return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance build() {
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance buildPartial() {
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance result =
              new com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.machineType_ = machineType_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.serviceAccount_ = serviceAccount_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            serviceAccountScopes_.makeImmutable();
            result.serviceAccountScopes_ = serviceAccountScopes_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            tags_.makeImmutable();
            result.tags_ = tags_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.poolSize_ = poolSize_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.pooledInstances_ = pooledInstances_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.disablePublicIpAddresses_ = disablePublicIpAddresses_;
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.enableNestedVirtualization_ = enableNestedVirtualization_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.shieldedInstanceConfig_ =
                shieldedInstanceConfigBuilder_ == null
                    ? shieldedInstanceConfig_
                    : shieldedInstanceConfigBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000200) != 0)) {
            result.confidentialInstanceConfig_ =
                confidentialInstanceConfigBuilder_ == null
                    ? confidentialInstanceConfig_
                    : confidentialInstanceConfigBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000400) != 0)) {
            result.bootDiskSizeGb_ = bootDiskSizeGb_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) {
            return mergeFrom(
                (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance other) {
          if (other
              == com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                  .getDefaultInstance()) return this;
          if (!other.getMachineType().isEmpty()) {
            machineType_ = other.machineType_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getServiceAccount().isEmpty()) {
            serviceAccount_ = other.serviceAccount_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.serviceAccountScopes_.isEmpty()) {
            if (serviceAccountScopes_.isEmpty()) {
              serviceAccountScopes_ = other.serviceAccountScopes_;
              bitField0_ |= 0x00000004;
            } else {
              ensureServiceAccountScopesIsMutable();
              serviceAccountScopes_.addAll(other.serviceAccountScopes_);
            }
            onChanged();
          }
          if (!other.tags_.isEmpty()) {
            if (tags_.isEmpty()) {
              tags_ = other.tags_;
              bitField0_ |= 0x00000008;
            } else {
              ensureTagsIsMutable();
              tags_.addAll(other.tags_);
            }
            onChanged();
          }
          if (other.getPoolSize() != 0) {
            setPoolSize(other.getPoolSize());
          }
          if (other.getPooledInstances() != 0) {
            setPooledInstances(other.getPooledInstances());
          }
          if (other.getDisablePublicIpAddresses() != false) {
            setDisablePublicIpAddresses(other.getDisablePublicIpAddresses());
          }
          if (other.getEnableNestedVirtualization() != false) {
            setEnableNestedVirtualization(other.getEnableNestedVirtualization());
          }
          if (other.hasShieldedInstanceConfig()) {
            mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
          }
          if (other.hasConfidentialInstanceConfig()) {
            mergeConfidentialInstanceConfig(other.getConfidentialInstanceConfig());
          }
          if (other.getBootDiskSizeGb() != 0) {
            setBootDiskSizeGb(other.getBootDiskSizeGb());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    machineType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    serviceAccount_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureServiceAccountScopesIsMutable();
                    serviceAccountScopes_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureTagsIsMutable();
                    tags_.add(s);
                    break;
                  } // case 34
                case 40:
                  {
                    poolSize_ = input.readInt32();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 40
                case 48:
                  {
                    disablePublicIpAddresses_ = input.readBool();
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 48
                case 56:
                  {
                    enableNestedVirtualization_ = input.readBool();
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 56
                case 66:
                  {
                    input.readMessage(
                        getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 66
                case 72:
                  {
                    bootDiskSizeGb_ = input.readInt32();
                    bitField0_ |= 0x00000400;
                    break;
                  } // case 72
                case 82:
                  {
                    input.readMessage(
                        getConfidentialInstanceConfigFieldBuilder().getBuilder(),
                        extensionRegistry);
                    bitField0_ |= 0x00000200;
                    break;
                  } // case 82
                case 96:
                  {
                    pooledInstances_ = input.readInt32();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 96
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object machineType_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The type of machine to use for VM instances—for example,
         * `"e2-standard-4"`. For more information about machine types that
         * Cloud Workstations supports, see the list of
         * [available machine
         * types](https://cloud.google.com/workstations/docs/available-machine-types).
         * </pre>
         *
         * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The machineType.
         */
        public java.lang.String getMachineType() {
          java.lang.Object ref = machineType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            machineType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The type of machine to use for VM instances—for example,
         * `"e2-standard-4"`. For more information about machine types that
         * Cloud Workstations supports, see the list of
         * [available machine
         * types](https://cloud.google.com/workstations/docs/available-machine-types).
         * </pre>
         *
         * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for machineType.
         */
        public com.google.protobuf.ByteString getMachineTypeBytes() {
          java.lang.Object ref = machineType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            machineType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The type of machine to use for VM instances—for example,
         * `"e2-standard-4"`. For more information about machine types that
         * Cloud Workstations supports, see the list of
         * [available machine
         * types](https://cloud.google.com/workstations/docs/available-machine-types).
         * </pre>
         *
         * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The machineType to set.
         * @return This builder for chaining.
         */
        public Builder setMachineType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          machineType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The type of machine to use for VM instances—for example,
         * `"e2-standard-4"`. For more information about machine types that
         * Cloud Workstations supports, see the list of
         * [available machine
         * types](https://cloud.google.com/workstations/docs/available-machine-types).
         * </pre>
         *
         * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMachineType() {
          machineType_ = getDefaultInstance().getMachineType();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The type of machine to use for VM instances—for example,
         * `"e2-standard-4"`. For more information about machine types that
         * Cloud Workstations supports, see the list of
         * [available machine
         * types](https://cloud.google.com/workstations/docs/available-machine-types).
         * </pre>
         *
         * <code>string machine_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for machineType to set.
         * @return This builder for chaining.
         */
        public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          machineType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object serviceAccount_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The email address of the service account for Cloud
         * Workstations VMs created with this configuration. When specified, be
         * sure that the service account has `logginglogEntries.create` permission
         * on the project so it can write logs out to Cloud Logging. If using a
         * custom container image, the service account must have permissions to
         * pull the specified image.
         *
         * If you as the administrator want to be able to `ssh` into the
         * underlying VM, you need to set this value to a service account
         * for which you have the `iam.serviceAccounts.actAs` permission.
         * Conversely, if you don't want anyone to be able to `ssh` into the
         * underlying VM, use a service account where no one has that
         * permission.
         *
         * If not set, VMs run with a service account provided by the
         * Cloud Workstations service, and the image must be publicly
         * accessible.
         * </pre>
         *
         * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The serviceAccount.
         */
        public java.lang.String getServiceAccount() {
          java.lang.Object ref = serviceAccount_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            serviceAccount_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The email address of the service account for Cloud
         * Workstations VMs created with this configuration. When specified, be
         * sure that the service account has `logginglogEntries.create` permission
         * on the project so it can write logs out to Cloud Logging. If using a
         * custom container image, the service account must have permissions to
         * pull the specified image.
         *
         * If you as the administrator want to be able to `ssh` into the
         * underlying VM, you need to set this value to a service account
         * for which you have the `iam.serviceAccounts.actAs` permission.
         * Conversely, if you don't want anyone to be able to `ssh` into the
         * underlying VM, use a service account where no one has that
         * permission.
         *
         * If not set, VMs run with a service account provided by the
         * Cloud Workstations service, and the image must be publicly
         * accessible.
         * </pre>
         *
         * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for serviceAccount.
         */
        public com.google.protobuf.ByteString getServiceAccountBytes() {
          java.lang.Object ref = serviceAccount_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            serviceAccount_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The email address of the service account for Cloud
         * Workstations VMs created with this configuration. When specified, be
         * sure that the service account has `logginglogEntries.create` permission
         * on the project so it can write logs out to Cloud Logging. If using a
         * custom container image, the service account must have permissions to
         * pull the specified image.
         *
         * If you as the administrator want to be able to `ssh` into the
         * underlying VM, you need to set this value to a service account
         * for which you have the `iam.serviceAccounts.actAs` permission.
         * Conversely, if you don't want anyone to be able to `ssh` into the
         * underlying VM, use a service account where no one has that
         * permission.
         *
         * If not set, VMs run with a service account provided by the
         * Cloud Workstations service, and the image must be publicly
         * accessible.
         * </pre>
         *
         * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The serviceAccount to set.
         * @return This builder for chaining.
         */
        public Builder setServiceAccount(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          serviceAccount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The email address of the service account for Cloud
         * Workstations VMs created with this configuration. When specified, be
         * sure that the service account has `logginglogEntries.create` permission
         * on the project so it can write logs out to Cloud Logging. If using a
         * custom container image, the service account must have permissions to
         * pull the specified image.
         *
         * If you as the administrator want to be able to `ssh` into the
         * underlying VM, you need to set this value to a service account
         * for which you have the `iam.serviceAccounts.actAs` permission.
         * Conversely, if you don't want anyone to be able to `ssh` into the
         * underlying VM, use a service account where no one has that
         * permission.
         *
         * If not set, VMs run with a service account provided by the
         * Cloud Workstations service, and the image must be publicly
         * accessible.
         * </pre>
         *
         * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearServiceAccount() {
          serviceAccount_ = getDefaultInstance().getServiceAccount();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The email address of the service account for Cloud
         * Workstations VMs created with this configuration. When specified, be
         * sure that the service account has `logginglogEntries.create` permission
         * on the project so it can write logs out to Cloud Logging. If using a
         * custom container image, the service account must have permissions to
         * pull the specified image.
         *
         * If you as the administrator want to be able to `ssh` into the
         * underlying VM, you need to set this value to a service account
         * for which you have the `iam.serviceAccounts.actAs` permission.
         * Conversely, if you don't want anyone to be able to `ssh` into the
         * underlying VM, use a service account where no one has that
         * permission.
         *
         * If not set, VMs run with a service account provided by the
         * Cloud Workstations service, and the image must be publicly
         * accessible.
         * </pre>
         *
         * <code>string service_account = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for serviceAccount to set.
         * @return This builder for chaining.
         */
        public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          serviceAccount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList serviceAccountScopes_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureServiceAccountScopesIsMutable() {
          if (!serviceAccountScopes_.isModifiable()) {
            serviceAccountScopes_ =
                new com.google.protobuf.LazyStringArrayList(serviceAccountScopes_);
          }
          bitField0_ |= 0x00000004;
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return A list containing the serviceAccountScopes.
         */
        public com.google.protobuf.ProtocolStringList getServiceAccountScopesList() {
          serviceAccountScopes_.makeImmutable();
          return serviceAccountScopes_;
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The count of serviceAccountScopes.
         */
        public int getServiceAccountScopesCount() {
          return serviceAccountScopes_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the element to return.
         * @return The serviceAccountScopes at the given index.
         */
        public java.lang.String getServiceAccountScopes(int index) {
          return serviceAccountScopes_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the serviceAccountScopes at the given index.
         */
        public com.google.protobuf.ByteString getServiceAccountScopesBytes(int index) {
          return serviceAccountScopes_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The serviceAccountScopes to set.
         * @return This builder for chaining.
         */
        public Builder setServiceAccountScopes(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureServiceAccountScopesIsMutable();
          serviceAccountScopes_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The serviceAccountScopes to add.
         * @return This builder for chaining.
         */
        public Builder addServiceAccountScopes(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureServiceAccountScopesIsMutable();
          serviceAccountScopes_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param values The serviceAccountScopes to add.
         * @return This builder for chaining.
         */
        public Builder addAllServiceAccountScopes(java.lang.Iterable<java.lang.String> values) {
          ensureServiceAccountScopesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccountScopes_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearServiceAccountScopes() {
          serviceAccountScopes_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Scopes to grant to the
         * [service_account][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.service_account].
         * Various scopes are automatically added based on feature usage. When
         * specified, users of workstations under this configuration must have
         * `iam.serviceAccounts.actAs` on the service account.
         * </pre>
         *
         * <code>
         * repeated string service_account_scopes = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The bytes of the serviceAccountScopes to add.
         * @return This builder for chaining.
         */
        public Builder addServiceAccountScopesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureServiceAccountScopesIsMutable();
          serviceAccountScopes_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringArrayList tags_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureTagsIsMutable() {
          if (!tags_.isModifiable()) {
            tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
          }
          bitField0_ |= 0x00000008;
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return A list containing the tags.
         */
        public com.google.protobuf.ProtocolStringList getTagsList() {
          tags_.makeImmutable();
          return tags_;
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The count of tags.
         */
        public int getTagsCount() {
          return tags_.size();
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the element to return.
         * @return The tags at the given index.
         */
        public java.lang.String getTags(int index) {
          return tags_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the tags at the given index.
         */
        public com.google.protobuf.ByteString getTagsBytes(int index) {
          return tags_.getByteString(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param index The index to set the value at.
         * @param value The tags to set.
         * @return This builder for chaining.
         */
        public Builder setTags(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.set(index, value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The tags to add.
         * @return This builder for chaining.
         */
        public Builder addTags(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param values The tags to add.
         * @return This builder for chaining.
         */
        public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
          ensureTagsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTags() {
          tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          ;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Network tags to add to the Compute Engine VMs backing the
         * workstations. This option applies
         * [network
         * tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
         * created with this configuration. These network tags enable the creation
         * of [firewall
         * rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
         * </pre>
         *
         * <code>repeated string tags = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes of the tags to add.
         * @return This builder for chaining.
         */
        public Builder addTagsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureTagsIsMutable();
          tags_.add(value);
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private int poolSize_;

        /**
         *
         *
         * <pre>
         * Optional. The number of VMs that the system should keep idle so that
         * new workstations can be started quickly for new users. Defaults to `0`
         * in the API.
         * </pre>
         *
         * <code>int32 pool_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The poolSize.
         */
        @java.lang.Override
        public int getPoolSize() {
          return poolSize_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The number of VMs that the system should keep idle so that
         * new workstations can be started quickly for new users. Defaults to `0`
         * in the API.
         * </pre>
         *
         * <code>int32 pool_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The poolSize to set.
         * @return This builder for chaining.
         */
        public Builder setPoolSize(int value) {

          poolSize_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The number of VMs that the system should keep idle so that
         * new workstations can be started quickly for new users. Defaults to `0`
         * in the API.
         * </pre>
         *
         * <code>int32 pool_size = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPoolSize() {
          bitField0_ = (bitField0_ & ~0x00000010);
          poolSize_ = 0;
          onChanged();
          return this;
        }

        private int pooledInstances_;

        /**
         *
         *
         * <pre>
         * Output only. Number of instances currently available in the pool for
         * faster workstation startup.
         * </pre>
         *
         * <code>int32 pooled_instances = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The pooledInstances.
         */
        @java.lang.Override
        public int getPooledInstances() {
          return pooledInstances_;
        }

        /**
         *
         *
         * <pre>
         * Output only. Number of instances currently available in the pool for
         * faster workstation startup.
         * </pre>
         *
         * <code>int32 pooled_instances = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The pooledInstances to set.
         * @return This builder for chaining.
         */
        public Builder setPooledInstances(int value) {

          pooledInstances_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. Number of instances currently available in the pool for
         * faster workstation startup.
         * </pre>
         *
         * <code>int32 pooled_instances = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPooledInstances() {
          bitField0_ = (bitField0_ & ~0x00000020);
          pooledInstances_ = 0;
          onChanged();
          return this;
        }

        private boolean disablePublicIpAddresses_;

        /**
         *
         *
         * <pre>
         * Optional. When set to true, disables public IP addresses for VMs. If
         * you disable public IP addresses, you must set up Private Google Access
         * or Cloud NAT on your network. If you use Private Google Access and you
         * use `private.googleapis.com` or `restricted.googleapis.com` for
         * Container Registry and Artifact Registry, make sure that you set
         * up DNS records for domains `*.gcr.io` and `*.pkg.dev`.
         * Defaults to false (VMs have public IP addresses).
         * </pre>
         *
         * <code>bool disable_public_ip_addresses = 6 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The disablePublicIpAddresses.
         */
        @java.lang.Override
        public boolean getDisablePublicIpAddresses() {
          return disablePublicIpAddresses_;
        }

        /**
         *
         *
         * <pre>
         * Optional. When set to true, disables public IP addresses for VMs. If
         * you disable public IP addresses, you must set up Private Google Access
         * or Cloud NAT on your network. If you use Private Google Access and you
         * use `private.googleapis.com` or `restricted.googleapis.com` for
         * Container Registry and Artifact Registry, make sure that you set
         * up DNS records for domains `*.gcr.io` and `*.pkg.dev`.
         * Defaults to false (VMs have public IP addresses).
         * </pre>
         *
         * <code>bool disable_public_ip_addresses = 6 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The disablePublicIpAddresses to set.
         * @return This builder for chaining.
         */
        public Builder setDisablePublicIpAddresses(boolean value) {

          disablePublicIpAddresses_ = value;
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. When set to true, disables public IP addresses for VMs. If
         * you disable public IP addresses, you must set up Private Google Access
         * or Cloud NAT on your network. If you use Private Google Access and you
         * use `private.googleapis.com` or `restricted.googleapis.com` for
         * Container Registry and Artifact Registry, make sure that you set
         * up DNS records for domains `*.gcr.io` and `*.pkg.dev`.
         * Defaults to false (VMs have public IP addresses).
         * </pre>
         *
         * <code>bool disable_public_ip_addresses = 6 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDisablePublicIpAddresses() {
          bitField0_ = (bitField0_ & ~0x00000040);
          disablePublicIpAddresses_ = false;
          onChanged();
          return this;
        }

        private boolean enableNestedVirtualization_;

        /**
         *
         *
         * <pre>
         * Optional. Whether to enable nested virtualization on Cloud Workstations
         * VMs created under this workstation configuration.
         *
         * Nested virtualization lets you run virtual machine (VM) instances
         * inside your workstation. Before enabling nested virtualization,
         * consider the following important considerations. Cloud Workstations
         * instances are subject to the [same restrictions as Compute Engine
         * instances](https://cloud.google.com/compute/docs/instances/nested-virtualization/overview#restrictions):
         *
         * * **Organization policy**: projects, folders, or
         * organizations may be restricted from creating nested VMs if the
         * **Disable VM nested virtualization** constraint is enforced in
         * the organization policy. For more information, see the
         * Compute Engine section,
         * [Checking whether nested virtualization is
         * allowed](https://cloud.google.com/compute/docs/instances/nested-virtualization/managing-constraint#checking_whether_nested_virtualization_is_allowed).
         * * **Performance**: nested VMs might experience a 10% or greater
         * decrease in performance for workloads that are CPU-bound and
         * possibly greater than a 10% decrease for workloads that are
         * input/output bound.
         * * **Machine Type**: nested virtualization can only be enabled on
         * workstation configurations that specify a
         * [machine_type][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.machine_type]
         * in the N1 or N2 machine series.
         * * **GPUs**: nested virtualization may not be enabled on workstation
         * configurations with accelerators.
         * * **Operating System**: Because
         * [Container-Optimized
         * OS](https://cloud.google.com/compute/docs/images/os-details#container-optimized_os_cos)
         * does not support nested virtualization, when nested virtualization is
         * enabled, the underlying Compute Engine VM instances boot from an
         * [Ubuntu
         * LTS](https://cloud.google.com/compute/docs/images/os-details#ubuntu_lts)
         * image.
         * </pre>
         *
         * <code>bool enable_nested_virtualization = 7 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enableNestedVirtualization.
         */
        @java.lang.Override
        public boolean getEnableNestedVirtualization() {
          return enableNestedVirtualization_;
        }

        /**
         *
         *
         * <pre>
         * Optional. Whether to enable nested virtualization on Cloud Workstations
         * VMs created under this workstation configuration.
         *
         * Nested virtualization lets you run virtual machine (VM) instances
         * inside your workstation. Before enabling nested virtualization,
         * consider the following important considerations. Cloud Workstations
         * instances are subject to the [same restrictions as Compute Engine
         * instances](https://cloud.google.com/compute/docs/instances/nested-virtualization/overview#restrictions):
         *
         * * **Organization policy**: projects, folders, or
         * organizations may be restricted from creating nested VMs if the
         * **Disable VM nested virtualization** constraint is enforced in
         * the organization policy. For more information, see the
         * Compute Engine section,
         * [Checking whether nested virtualization is
         * allowed](https://cloud.google.com/compute/docs/instances/nested-virtualization/managing-constraint#checking_whether_nested_virtualization_is_allowed).
         * * **Performance**: nested VMs might experience a 10% or greater
         * decrease in performance for workloads that are CPU-bound and
         * possibly greater than a 10% decrease for workloads that are
         * input/output bound.
         * * **Machine Type**: nested virtualization can only be enabled on
         * workstation configurations that specify a
         * [machine_type][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.machine_type]
         * in the N1 or N2 machine series.
         * * **GPUs**: nested virtualization may not be enabled on workstation
         * configurations with accelerators.
         * * **Operating System**: Because
         * [Container-Optimized
         * OS](https://cloud.google.com/compute/docs/images/os-details#container-optimized_os_cos)
         * does not support nested virtualization, when nested virtualization is
         * enabled, the underlying Compute Engine VM instances boot from an
         * [Ubuntu
         * LTS](https://cloud.google.com/compute/docs/images/os-details#ubuntu_lts)
         * image.
         * </pre>
         *
         * <code>bool enable_nested_virtualization = 7 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enableNestedVirtualization to set.
         * @return This builder for chaining.
         */
        public Builder setEnableNestedVirtualization(boolean value) {

          enableNestedVirtualization_ = value;
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Whether to enable nested virtualization on Cloud Workstations
         * VMs created under this workstation configuration.
         *
         * Nested virtualization lets you run virtual machine (VM) instances
         * inside your workstation. Before enabling nested virtualization,
         * consider the following important considerations. Cloud Workstations
         * instances are subject to the [same restrictions as Compute Engine
         * instances](https://cloud.google.com/compute/docs/instances/nested-virtualization/overview#restrictions):
         *
         * * **Organization policy**: projects, folders, or
         * organizations may be restricted from creating nested VMs if the
         * **Disable VM nested virtualization** constraint is enforced in
         * the organization policy. For more information, see the
         * Compute Engine section,
         * [Checking whether nested virtualization is
         * allowed](https://cloud.google.com/compute/docs/instances/nested-virtualization/managing-constraint#checking_whether_nested_virtualization_is_allowed).
         * * **Performance**: nested VMs might experience a 10% or greater
         * decrease in performance for workloads that are CPU-bound and
         * possibly greater than a 10% decrease for workloads that are
         * input/output bound.
         * * **Machine Type**: nested virtualization can only be enabled on
         * workstation configurations that specify a
         * [machine_type][google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.machine_type]
         * in the N1 or N2 machine series.
         * * **GPUs**: nested virtualization may not be enabled on workstation
         * configurations with accelerators.
         * * **Operating System**: Because
         * [Container-Optimized
         * OS](https://cloud.google.com/compute/docs/images/os-details#container-optimized_os_cos)
         * does not support nested virtualization, when nested virtualization is
         * enabled, the underlying Compute Engine VM instances boot from an
         * [Ubuntu
         * LTS](https://cloud.google.com/compute/docs/images/os-details#ubuntu_lts)
         * image.
         * </pre>
         *
         * <code>bool enable_nested_virtualization = 7 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEnableNestedVirtualization() {
          bitField0_ = (bitField0_ & ~0x00000080);
          enableNestedVirtualization_ = false;
          onChanged();
          return this;
        }

        private com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            shieldedInstanceConfig_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfigOrBuilder>
            shieldedInstanceConfigBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the shieldedInstanceConfig field is set.
         */
        public boolean hasShieldedInstanceConfig() {
          return ((bitField0_ & 0x00000100) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The shieldedInstanceConfig.
         */
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig
            getShieldedInstanceConfig() {
          if (shieldedInstanceConfigBuilder_ == null) {
            return shieldedInstanceConfig_ == null
                ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig.getDefaultInstance()
                : shieldedInstanceConfig_;
          } else {
            return shieldedInstanceConfigBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setShieldedInstanceConfig(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig
                value) {
          if (shieldedInstanceConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            shieldedInstanceConfig_ = value;
          } else {
            shieldedInstanceConfigBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setShieldedInstanceConfig(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig.Builder
                builderForValue) {
          if (shieldedInstanceConfigBuilder_ == null) {
            shieldedInstanceConfig_ = builderForValue.build();
          } else {
            shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeShieldedInstanceConfig(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig
                value) {
          if (shieldedInstanceConfigBuilder_ == null) {
            if (((bitField0_ & 0x00000100) != 0)
                && shieldedInstanceConfig_ != null
                && shieldedInstanceConfig_
                    != com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfig.getDefaultInstance()) {
              getShieldedInstanceConfigBuilder().mergeFrom(value);
            } else {
              shieldedInstanceConfig_ = value;
            }
          } else {
            shieldedInstanceConfigBuilder_.mergeFrom(value);
          }
          if (shieldedInstanceConfig_ != null) {
            bitField0_ |= 0x00000100;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearShieldedInstanceConfig() {
          bitField0_ = (bitField0_ & ~0x00000100);
          shieldedInstanceConfig_ = null;
          if (shieldedInstanceConfigBuilder_ != null) {
            shieldedInstanceConfigBuilder_.dispose();
            shieldedInstanceConfigBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfig.Builder
            getShieldedInstanceConfigBuilder() {
          bitField0_ |= 0x00000100;
          onChanged();
          return getShieldedInstanceConfigFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceShieldedInstanceConfigOrBuilder
            getShieldedInstanceConfigOrBuilder() {
          if (shieldedInstanceConfigBuilder_ != null) {
            return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
          } else {
            return shieldedInstanceConfig_ == null
                ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig.getDefaultInstance()
                : shieldedInstanceConfig_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Shielded instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceShieldedInstanceConfig shielded_instance_config = 8 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfig.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceShieldedInstanceConfigOrBuilder>
            getShieldedInstanceConfigFieldBuilder() {
          if (shieldedInstanceConfigBuilder_ == null) {
            shieldedInstanceConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfig,
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfig.Builder,
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceShieldedInstanceConfigOrBuilder>(
                    getShieldedInstanceConfig(), getParentForChildren(), isClean());
            shieldedInstanceConfig_ = null;
          }
          return shieldedInstanceConfigBuilder_;
        }

        private com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            confidentialInstanceConfig_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfigOrBuilder>
            confidentialInstanceConfigBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the confidentialInstanceConfig field is set.
         */
        public boolean hasConfidentialInstanceConfig() {
          return ((bitField0_ & 0x00000200) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The confidentialInstanceConfig.
         */
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig
            getConfidentialInstanceConfig() {
          if (confidentialInstanceConfigBuilder_ == null) {
            return confidentialInstanceConfig_ == null
                ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig.getDefaultInstance()
                : confidentialInstanceConfig_;
          } else {
            return confidentialInstanceConfigBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setConfidentialInstanceConfig(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig
                value) {
          if (confidentialInstanceConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            confidentialInstanceConfig_ = value;
          } else {
            confidentialInstanceConfigBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setConfidentialInstanceConfig(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig.Builder
                builderForValue) {
          if (confidentialInstanceConfigBuilder_ == null) {
            confidentialInstanceConfig_ = builderForValue.build();
          } else {
            confidentialInstanceConfigBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000200;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeConfidentialInstanceConfig(
            com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig
                value) {
          if (confidentialInstanceConfigBuilder_ == null) {
            if (((bitField0_ & 0x00000200) != 0)
                && confidentialInstanceConfig_ != null
                && confidentialInstanceConfig_
                    != com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfig.getDefaultInstance()) {
              getConfidentialInstanceConfigBuilder().mergeFrom(value);
            } else {
              confidentialInstanceConfig_ = value;
            }
          } else {
            confidentialInstanceConfigBuilder_.mergeFrom(value);
          }
          if (confidentialInstanceConfig_ != null) {
            bitField0_ |= 0x00000200;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearConfidentialInstanceConfig() {
          bitField0_ = (bitField0_ & ~0x00000200);
          confidentialInstanceConfig_ = null;
          if (confidentialInstanceConfigBuilder_ != null) {
            confidentialInstanceConfigBuilder_.dispose();
            confidentialInstanceConfigBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfig.Builder
            getConfidentialInstanceConfigBuilder() {
          bitField0_ |= 0x00000200;
          onChanged();
          return getConfidentialInstanceConfigFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                .GceConfidentialInstanceConfigOrBuilder
            getConfidentialInstanceConfigOrBuilder() {
          if (confidentialInstanceConfigBuilder_ != null) {
            return confidentialInstanceConfigBuilder_.getMessageOrBuilder();
          } else {
            return confidentialInstanceConfig_ == null
                ? com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig.getDefaultInstance()
                : confidentialInstanceConfig_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. A set of Compute Engine Confidential VM instance options.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.GceConfidentialInstanceConfig confidential_instance_config = 10 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfig.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .GceConfidentialInstanceConfigOrBuilder>
            getConfidentialInstanceConfigFieldBuilder() {
          if (confidentialInstanceConfigBuilder_ == null) {
            confidentialInstanceConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfig,
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfig.Builder,
                    com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                        .GceConfidentialInstanceConfigOrBuilder>(
                    getConfidentialInstanceConfig(), getParentForChildren(), isClean());
            confidentialInstanceConfig_ = null;
          }
          return confidentialInstanceConfigBuilder_;
        }

        private int bootDiskSizeGb_;

        /**
         *
         *
         * <pre>
         * Optional. The size of the boot disk for the VM in gigabytes (GB).
         * The minimum boot disk size is `30` GB. Defaults to `50` GB.
         * </pre>
         *
         * <code>int32 boot_disk_size_gb = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bootDiskSizeGb.
         */
        @java.lang.Override
        public int getBootDiskSizeGb() {
          return bootDiskSizeGb_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The size of the boot disk for the VM in gigabytes (GB).
         * The minimum boot disk size is `30` GB. Defaults to `50` GB.
         * </pre>
         *
         * <code>int32 boot_disk_size_gb = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bootDiskSizeGb to set.
         * @return This builder for chaining.
         */
        public Builder setBootDiskSizeGb(int value) {

          bootDiskSizeGb_ = value;
          bitField0_ |= 0x00000400;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The size of the boot disk for the VM in gigabytes (GB).
         * The minimum boot disk size is `30` GB. Defaults to `50` GB.
         * </pre>
         *
         * <code>int32 boot_disk_size_gb = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBootDiskSizeGb() {
          bitField0_ = (bitField0_ & ~0x00000400);
          bootDiskSizeGb_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)
      private static final com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance();
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GceInstance> PARSER =
          new com.google.protobuf.AbstractParser<GceInstance>() {
            @java.lang.Override
            public GceInstance parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GceInstance> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GceInstance> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int configCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object config_;

    public enum ConfigCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCE_INSTANCE(1),
      CONFIG_NOT_SET(0);
      private final int value;

      private ConfigCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ConfigCase valueOf(int value) {
        return forNumber(value);
      }

      public static ConfigCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCE_INSTANCE;
          case 0:
            return CONFIG_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public static final int GCE_INSTANCE_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Specifies a Compute Engine instance as the host.
     * </pre>
     *
     * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
     * </code>
     *
     * @return Whether the gceInstance field is set.
     */
    @java.lang.Override
    public boolean hasGceInstance() {
      return configCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Specifies a Compute Engine instance as the host.
     * </pre>
     *
     * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
     * </code>
     *
     * @return The gceInstance.
     */
    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance getGceInstance() {
      if (configCase_ == 1) {
        return (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_;
      }
      return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Specifies a Compute Engine instance as the host.
     * </pre>
     *
     * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder
        getGceInstanceOrBuilder() {
      if (configCase_ == 1) {
        return (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_;
      }
      return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (configCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (configCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workstations.v1.WorkstationConfig.Host)) {
        return super.equals(obj);
      }
      com.google.cloud.workstations.v1.WorkstationConfig.Host other =
          (com.google.cloud.workstations.v1.WorkstationConfig.Host) obj;

      if (!getConfigCase().equals(other.getConfigCase())) return false;
      switch (configCase_) {
        case 1:
          if (!getGceInstance().equals(other.getGceInstance())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (configCase_) {
        case 1:
          hash = (37 * hash) + GCE_INSTANCE_FIELD_NUMBER;
          hash = (53 * hash) + getGceInstance().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workstations.v1.WorkstationConfig.Host prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Runtime host for a workstation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.Host}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.Host)
        com.google.cloud.workstations.v1.WorkstationConfig.HostOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.Host.class,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder.class);
      }

      // Construct using com.google.cloud.workstations.v1.WorkstationConfig.Host.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gceInstanceBuilder_ != null) {
          gceInstanceBuilder_.clear();
        }
        configCase_ = 0;
        config_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Host_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host getDefaultInstanceForType() {
        return com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host build() {
        com.google.cloud.workstations.v1.WorkstationConfig.Host result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host buildPartial() {
        com.google.cloud.workstations.v1.WorkstationConfig.Host result =
            new com.google.cloud.workstations.v1.WorkstationConfig.Host(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.workstations.v1.WorkstationConfig.Host result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.workstations.v1.WorkstationConfig.Host result) {
        result.configCase_ = configCase_;
        result.config_ = this.config_;
        if (configCase_ == 1 && gceInstanceBuilder_ != null) {
          result.config_ = gceInstanceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workstations.v1.WorkstationConfig.Host) {
          return mergeFrom((com.google.cloud.workstations.v1.WorkstationConfig.Host) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.workstations.v1.WorkstationConfig.Host other) {
        if (other == com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance())
          return this;
        switch (other.getConfigCase()) {
          case GCE_INSTANCE:
            {
              mergeGceInstance(other.getGceInstance());
              break;
            }
          case CONFIG_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getGceInstanceFieldBuilder().getBuilder(), extensionRegistry);
                  configCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int configCase_ = 0;
      private java.lang.Object config_;

      public ConfigCase getConfigCase() {
        return ConfigCase.forNumber(configCase_);
      }

      public Builder clearConfig() {
        configCase_ = 0;
        config_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance,
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder,
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder>
          gceInstanceBuilder_;

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       *
       * @return Whether the gceInstance field is set.
       */
      @java.lang.Override
      public boolean hasGceInstance() {
        return configCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       *
       * @return The gceInstance.
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance getGceInstance() {
        if (gceInstanceBuilder_ == null) {
          if (configCase_ == 1) {
            return (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_;
          }
          return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .getDefaultInstance();
        } else {
          if (configCase_ == 1) {
            return gceInstanceBuilder_.getMessage();
          }
          return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      public Builder setGceInstance(
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance value) {
        if (gceInstanceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          config_ = value;
          onChanged();
        } else {
          gceInstanceBuilder_.setMessage(value);
        }
        configCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      public Builder setGceInstance(
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder
              builderForValue) {
        if (gceInstanceBuilder_ == null) {
          config_ = builderForValue.build();
          onChanged();
        } else {
          gceInstanceBuilder_.setMessage(builderForValue.build());
        }
        configCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      public Builder mergeGceInstance(
          com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance value) {
        if (gceInstanceBuilder_ == null) {
          if (configCase_ == 1
              && config_
                  != com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                      .getDefaultInstance()) {
            config_ =
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.newBuilder(
                        (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance)
                            config_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            config_ = value;
          }
          onChanged();
        } else {
          if (configCase_ == 1) {
            gceInstanceBuilder_.mergeFrom(value);
          } else {
            gceInstanceBuilder_.setMessage(value);
          }
        }
        configCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      public Builder clearGceInstance() {
        if (gceInstanceBuilder_ == null) {
          if (configCase_ == 1) {
            configCase_ = 0;
            config_ = null;
            onChanged();
          }
        } else {
          if (configCase_ == 1) {
            configCase_ = 0;
            config_ = null;
          }
          gceInstanceBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder
          getGceInstanceBuilder() {
        return getGceInstanceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder
          getGceInstanceOrBuilder() {
        if ((configCase_ == 1) && (gceInstanceBuilder_ != null)) {
          return gceInstanceBuilder_.getMessageOrBuilder();
        } else {
          if (configCase_ == 1) {
            return (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_;
          }
          return com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Specifies a Compute Engine instance as the host.
       * </pre>
       *
       * <code>.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance gce_instance = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance,
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder,
              com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder>
          getGceInstanceFieldBuilder() {
        if (gceInstanceBuilder_ == null) {
          if (!(configCase_ == 1)) {
            config_ =
                com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance
                    .getDefaultInstance();
          }
          gceInstanceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance,
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance.Builder,
                  com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstanceOrBuilder>(
                  (com.google.cloud.workstations.v1.WorkstationConfig.Host.GceInstance) config_,
                  getParentForChildren(),
                  isClean());
          config_ = null;
        }
        configCase_ = 1;
        onChanged();
        return gceInstanceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.Host)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.Host)
    private static final com.google.cloud.workstations.v1.WorkstationConfig.Host DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.WorkstationConfig.Host();
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Host getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Host> PARSER =
        new com.google.protobuf.AbstractParser<Host>() {
          @java.lang.Override
          public Host parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Host> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Host> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.Host getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PersistentDirectoryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine persistent disk.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
     * </code>
     *
     * @return Whether the gcePd field is set.
     */
    boolean hasGcePd();

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine persistent disk.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
     * </code>
     *
     * @return The gcePd.
     */
    com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk
        getGcePd();

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine persistent disk.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
     * </code>
     */
    com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
            .GceRegionalPersistentDiskOrBuilder
        getGcePdOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Location of this directory in the running workstation.
     * </pre>
     *
     * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mountPath.
     */
    java.lang.String getMountPath();

    /**
     *
     *
     * <pre>
     * Optional. Location of this directory in the running workstation.
     * </pre>
     *
     * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mountPath.
     */
    com.google.protobuf.ByteString getMountPathBytes();

    com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.DirectoryTypeCase
        getDirectoryTypeCase();
  }

  /**
   *
   *
   * <pre>
   * A directory to persist across workstation sessions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory}
   */
  public static final class PersistentDirectory extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory)
      PersistentDirectoryOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PersistentDirectory.newBuilder() to construct.
    private PersistentDirectory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PersistentDirectory() {
      mountPath_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PersistentDirectory();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.class,
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder.class);
    }

    public interface GceRegionalPersistentDiskOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The GB capacity of a persistent home directory for each
       * workstation created with this configuration. Must be empty if
       * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
       * is set.
       *
       * Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`.
       * Defaults to `200`. If less than `200` GB, the
       * [disk_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.disk_type]
       * must be
       * `"pd-balanced"` or `"pd-ssd"`.
       * </pre>
       *
       * <code>int32 size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The sizeGb.
       */
      int getSizeGb();

      /**
       *
       *
       * <pre>
       * Optional. Type of file system that the disk should be formatted with.
       * The workstation image must support this file system type. Must be empty
       * if
       * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
       * is set. Defaults to `"ext4"`.
       * </pre>
       *
       * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fsType.
       */
      java.lang.String getFsType();

      /**
       *
       *
       * <pre>
       * Optional. Type of file system that the disk should be formatted with.
       * The workstation image must support this file system type. Must be empty
       * if
       * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
       * is set. Defaults to `"ext4"`.
       * </pre>
       *
       * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for fsType.
       */
      com.google.protobuf.ByteString getFsTypeBytes();

      /**
       *
       *
       * <pre>
       * Optional. The [type of the persistent
       * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
       * home directory. Defaults to `"pd-standard"`.
       * </pre>
       *
       * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The diskType.
       */
      java.lang.String getDiskType();

      /**
       *
       *
       * <pre>
       * Optional. The [type of the persistent
       * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
       * home directory. Defaults to `"pd-standard"`.
       * </pre>
       *
       * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for diskType.
       */
      com.google.protobuf.ByteString getDiskTypeBytes();

      /**
       *
       *
       * <pre>
       * Optional. Name of the snapshot to use as the source for the disk. If
       * set,
       * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
       * and
       * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
       * must be empty.
       * </pre>
       *
       * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The sourceSnapshot.
       */
      java.lang.String getSourceSnapshot();

      /**
       *
       *
       * <pre>
       * Optional. Name of the snapshot to use as the source for the disk. If
       * set,
       * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
       * and
       * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
       * must be empty.
       * </pre>
       *
       * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for sourceSnapshot.
       */
      com.google.protobuf.ByteString getSourceSnapshotBytes();

      /**
       *
       *
       * <pre>
       * Optional. Whether the persistent disk should be deleted when the
       * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
       * Defaults to `DELETE`.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for reclaimPolicy.
       */
      int getReclaimPolicyValue();

      /**
       *
       *
       * <pre>
       * Optional. Whether the persistent disk should be deleted when the
       * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
       * Defaults to `DELETE`.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The reclaimPolicy.
       */
      com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.ReclaimPolicy
          getReclaimPolicy();
    }

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine regional persistent
     * disk. The
     * [persistent_directories][google.cloud.workstations.v1.WorkstationConfig.persistent_directories]
     * field is repeated, but it may contain only one entry. It creates a
     * [persistent
     * disk](https://cloud.google.com/compute/docs/disks/persistent-disks) that
     * mounts to the workstation VM at `/home` when the session starts and
     * detaches when the session ends. If this field is empty, workstations
     * created with this configuration do not have a persistent home
     * directory.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk}
     */
    public static final class GceRegionalPersistentDisk
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk)
        GceRegionalPersistentDiskOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use GceRegionalPersistentDisk.newBuilder() to construct.
      private GceRegionalPersistentDisk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GceRegionalPersistentDisk() {
        fsType_ = "";
        diskType_ = "";
        sourceSnapshot_ = "";
        reclaimPolicy_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GceRegionalPersistentDisk();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk.class,
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Value representing what should happen to the disk after the workstation
       * is deleted.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy}
       */
      public enum ReclaimPolicy implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Do not use.
         * </pre>
         *
         * <code>RECLAIM_POLICY_UNSPECIFIED = 0;</code>
         */
        RECLAIM_POLICY_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Delete the persistent disk when deleting the workstation.
         * </pre>
         *
         * <code>DELETE = 1;</code>
         */
        DELETE(1),
        /**
         *
         *
         * <pre>
         * Keep the persistent disk when deleting the workstation.
         * An administrator must manually delete the disk.
         * </pre>
         *
         * <code>RETAIN = 2;</code>
         */
        RETAIN(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Do not use.
         * </pre>
         *
         * <code>RECLAIM_POLICY_UNSPECIFIED = 0;</code>
         */
        public static final int RECLAIM_POLICY_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Delete the persistent disk when deleting the workstation.
         * </pre>
         *
         * <code>DELETE = 1;</code>
         */
        public static final int DELETE_VALUE = 1;

        /**
         *
         *
         * <pre>
         * Keep the persistent disk when deleting the workstation.
         * An administrator must manually delete the disk.
         * </pre>
         *
         * <code>RETAIN = 2;</code>
         */
        public static final int RETAIN_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ReclaimPolicy valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ReclaimPolicy forNumber(int value) {
          switch (value) {
            case 0:
              return RECLAIM_POLICY_UNSPECIFIED;
            case 1:
              return DELETE;
            case 2:
              return RETAIN;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ReclaimPolicy>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<ReclaimPolicy>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ReclaimPolicy>() {
                  public ReclaimPolicy findValueByNumber(int number) {
                    return ReclaimPolicy.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ReclaimPolicy[] VALUES = values();

        public static ReclaimPolicy valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ReclaimPolicy(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy)
      }

      public static final int SIZE_GB_FIELD_NUMBER = 1;
      private int sizeGb_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. The GB capacity of a persistent home directory for each
       * workstation created with this configuration. Must be empty if
       * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
       * is set.
       *
       * Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`.
       * Defaults to `200`. If less than `200` GB, the
       * [disk_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.disk_type]
       * must be
       * `"pd-balanced"` or `"pd-ssd"`.
       * </pre>
       *
       * <code>int32 size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The sizeGb.
       */
      @java.lang.Override
      public int getSizeGb() {
        return sizeGb_;
      }

      public static final int FS_TYPE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object fsType_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Type of file system that the disk should be formatted with.
       * The workstation image must support this file system type. Must be empty
       * if
       * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
       * is set. Defaults to `"ext4"`.
       * </pre>
       *
       * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fsType.
       */
      @java.lang.Override
      public java.lang.String getFsType() {
        java.lang.Object ref = fsType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fsType_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Type of file system that the disk should be formatted with.
       * The workstation image must support this file system type. Must be empty
       * if
       * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
       * is set. Defaults to `"ext4"`.
       * </pre>
       *
       * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for fsType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFsTypeBytes() {
        java.lang.Object ref = fsType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fsType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DISK_TYPE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object diskType_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The [type of the persistent
       * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
       * home directory. Defaults to `"pd-standard"`.
       * </pre>
       *
       * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The diskType.
       */
      @java.lang.Override
      public java.lang.String getDiskType() {
        java.lang.Object ref = diskType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          diskType_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The [type of the persistent
       * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
       * home directory. Defaults to `"pd-standard"`.
       * </pre>
       *
       * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for diskType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDiskTypeBytes() {
        java.lang.Object ref = diskType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          diskType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int SOURCE_SNAPSHOT_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private volatile java.lang.Object sourceSnapshot_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Name of the snapshot to use as the source for the disk. If
       * set,
       * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
       * and
       * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
       * must be empty.
       * </pre>
       *
       * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The sourceSnapshot.
       */
      @java.lang.Override
      public java.lang.String getSourceSnapshot() {
        java.lang.Object ref = sourceSnapshot_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceSnapshot_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Name of the snapshot to use as the source for the disk. If
       * set,
       * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
       * and
       * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
       * must be empty.
       * </pre>
       *
       * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for sourceSnapshot.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSourceSnapshotBytes() {
        java.lang.Object ref = sourceSnapshot_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceSnapshot_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RECLAIM_POLICY_FIELD_NUMBER = 4;
      private int reclaimPolicy_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. Whether the persistent disk should be deleted when the
       * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
       * Defaults to `DELETE`.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for reclaimPolicy.
       */
      @java.lang.Override
      public int getReclaimPolicyValue() {
        return reclaimPolicy_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Whether the persistent disk should be deleted when the
       * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
       * Defaults to `DELETE`.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The reclaimPolicy.
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.ReclaimPolicy
          getReclaimPolicy() {
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk.ReclaimPolicy
            result =
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk.ReclaimPolicy.forNumber(reclaimPolicy_);
        return result == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk.ReclaimPolicy.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (sizeGb_ != 0) {
          output.writeInt32(1, sizeGb_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fsType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fsType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, diskType_);
        }
        if (reclaimPolicy_
            != com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk.ReclaimPolicy.RECLAIM_POLICY_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(4, reclaimPolicy_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceSnapshot_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sourceSnapshot_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (sizeGb_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, sizeGb_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fsType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fsType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, diskType_);
        }
        if (reclaimPolicy_
            != com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk.ReclaimPolicy.RECLAIM_POLICY_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, reclaimPolicy_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceSnapshot_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, sourceSnapshot_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk)) {
          return super.equals(obj);
        }
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk
            other =
                (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                        .GceRegionalPersistentDisk)
                    obj;

        if (getSizeGb() != other.getSizeGb()) return false;
        if (!getFsType().equals(other.getFsType())) return false;
        if (!getDiskType().equals(other.getDiskType())) return false;
        if (!getSourceSnapshot().equals(other.getSourceSnapshot())) return false;
        if (reclaimPolicy_ != other.reclaimPolicy_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SIZE_GB_FIELD_NUMBER;
        hash = (53 * hash) + getSizeGb();
        hash = (37 * hash) + FS_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getFsType().hashCode();
        hash = (37 * hash) + DISK_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getDiskType().hashCode();
        hash = (37 * hash) + SOURCE_SNAPSHOT_FIELD_NUMBER;
        hash = (53 * hash) + getSourceSnapshot().hashCode();
        hash = (37 * hash) + RECLAIM_POLICY_FIELD_NUMBER;
        hash = (53 * hash) + reclaimPolicy_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine regional persistent
       * disk. The
       * [persistent_directories][google.cloud.workstations.v1.WorkstationConfig.persistent_directories]
       * field is repeated, but it may contain only one entry. It creates a
       * [persistent
       * disk](https://cloud.google.com/compute/docs/disks/persistent-disks) that
       * mounts to the workstation VM at `/home` when the session starts and
       * detaches when the session ends. If this field is empty, workstations
       * created with this configuration do not have a persistent home
       * directory.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk)
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDiskOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk.class,
                  com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk.Builder.class);
        }

        // Construct using
        // com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          sizeGb_ = 0;
          fsType_ = "";
          diskType_ = "";
          sourceSnapshot_ = "";
          reclaimPolicy_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.workstations.v1.WorkstationsProto
              .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_GceRegionalPersistentDisk_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk
            getDefaultInstanceForType() {
          return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk
            build() {
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk
            buildPartial() {
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk
              result =
                  new com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.sizeGb_ = sizeGb_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.fsType_ = fsType_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.diskType_ = diskType_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.sourceSnapshot_ = sourceSnapshot_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.reclaimPolicy_ = reclaimPolicy_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk) {
            return mergeFrom(
                (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                        .GceRegionalPersistentDisk)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk
                other) {
          if (other
              == com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk.getDefaultInstance()) return this;
          if (other.getSizeGb() != 0) {
            setSizeGb(other.getSizeGb());
          }
          if (!other.getFsType().isEmpty()) {
            fsType_ = other.fsType_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getDiskType().isEmpty()) {
            diskType_ = other.diskType_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getSourceSnapshot().isEmpty()) {
            sourceSnapshot_ = other.sourceSnapshot_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          if (other.reclaimPolicy_ != 0) {
            setReclaimPolicyValue(other.getReclaimPolicyValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    sizeGb_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    fsType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    diskType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 32:
                  {
                    reclaimPolicy_ = input.readEnum();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 32
                case 42:
                  {
                    sourceSnapshot_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int sizeGb_;

        /**
         *
         *
         * <pre>
         * Optional. The GB capacity of a persistent home directory for each
         * workstation created with this configuration. Must be empty if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set.
         *
         * Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`.
         * Defaults to `200`. If less than `200` GB, the
         * [disk_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.disk_type]
         * must be
         * `"pd-balanced"` or `"pd-ssd"`.
         * </pre>
         *
         * <code>int32 size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The sizeGb.
         */
        @java.lang.Override
        public int getSizeGb() {
          return sizeGb_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The GB capacity of a persistent home directory for each
         * workstation created with this configuration. Must be empty if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set.
         *
         * Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`.
         * Defaults to `200`. If less than `200` GB, the
         * [disk_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.disk_type]
         * must be
         * `"pd-balanced"` or `"pd-ssd"`.
         * </pre>
         *
         * <code>int32 size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The sizeGb to set.
         * @return This builder for chaining.
         */
        public Builder setSizeGb(int value) {

          sizeGb_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The GB capacity of a persistent home directory for each
         * workstation created with this configuration. Must be empty if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set.
         *
         * Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`.
         * Defaults to `200`. If less than `200` GB, the
         * [disk_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.disk_type]
         * must be
         * `"pd-balanced"` or `"pd-ssd"`.
         * </pre>
         *
         * <code>int32 size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSizeGb() {
          bitField0_ = (bitField0_ & ~0x00000001);
          sizeGb_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object fsType_ = "";

        /**
         *
         *
         * <pre>
         * Optional. Type of file system that the disk should be formatted with.
         * The workstation image must support this file system type. Must be empty
         * if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set. Defaults to `"ext4"`.
         * </pre>
         *
         * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The fsType.
         */
        public java.lang.String getFsType() {
          java.lang.Object ref = fsType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fsType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Type of file system that the disk should be formatted with.
         * The workstation image must support this file system type. Must be empty
         * if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set. Defaults to `"ext4"`.
         * </pre>
         *
         * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for fsType.
         */
        public com.google.protobuf.ByteString getFsTypeBytes() {
          java.lang.Object ref = fsType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fsType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Type of file system that the disk should be formatted with.
         * The workstation image must support this file system type. Must be empty
         * if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set. Defaults to `"ext4"`.
         * </pre>
         *
         * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The fsType to set.
         * @return This builder for chaining.
         */
        public Builder setFsType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          fsType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Type of file system that the disk should be formatted with.
         * The workstation image must support this file system type. Must be empty
         * if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set. Defaults to `"ext4"`.
         * </pre>
         *
         * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFsType() {
          fsType_ = getDefaultInstance().getFsType();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Type of file system that the disk should be formatted with.
         * The workstation image must support this file system type. Must be empty
         * if
         * [source_snapshot][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.source_snapshot]
         * is set. Defaults to `"ext4"`.
         * </pre>
         *
         * <code>string fs_type = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for fsType to set.
         * @return This builder for chaining.
         */
        public Builder setFsTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          fsType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object diskType_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The [type of the persistent
         * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
         * home directory. Defaults to `"pd-standard"`.
         * </pre>
         *
         * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The diskType.
         */
        public java.lang.String getDiskType() {
          java.lang.Object ref = diskType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            diskType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The [type of the persistent
         * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
         * home directory. Defaults to `"pd-standard"`.
         * </pre>
         *
         * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for diskType.
         */
        public com.google.protobuf.ByteString getDiskTypeBytes() {
          java.lang.Object ref = diskType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            diskType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The [type of the persistent
         * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
         * home directory. Defaults to `"pd-standard"`.
         * </pre>
         *
         * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The diskType to set.
         * @return This builder for chaining.
         */
        public Builder setDiskType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          diskType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The [type of the persistent
         * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
         * home directory. Defaults to `"pd-standard"`.
         * </pre>
         *
         * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDiskType() {
          diskType_ = getDefaultInstance().getDiskType();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The [type of the persistent
         * disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
         * home directory. Defaults to `"pd-standard"`.
         * </pre>
         *
         * <code>string disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for diskType to set.
         * @return This builder for chaining.
         */
        public Builder setDiskTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          diskType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object sourceSnapshot_ = "";

        /**
         *
         *
         * <pre>
         * Optional. Name of the snapshot to use as the source for the disk. If
         * set,
         * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
         * and
         * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
         * must be empty.
         * </pre>
         *
         * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The sourceSnapshot.
         */
        public java.lang.String getSourceSnapshot() {
          java.lang.Object ref = sourceSnapshot_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sourceSnapshot_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Name of the snapshot to use as the source for the disk. If
         * set,
         * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
         * and
         * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
         * must be empty.
         * </pre>
         *
         * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for sourceSnapshot.
         */
        public com.google.protobuf.ByteString getSourceSnapshotBytes() {
          java.lang.Object ref = sourceSnapshot_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            sourceSnapshot_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Name of the snapshot to use as the source for the disk. If
         * set,
         * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
         * and
         * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
         * must be empty.
         * </pre>
         *
         * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The sourceSnapshot to set.
         * @return This builder for chaining.
         */
        public Builder setSourceSnapshot(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          sourceSnapshot_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Name of the snapshot to use as the source for the disk. If
         * set,
         * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
         * and
         * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
         * must be empty.
         * </pre>
         *
         * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSourceSnapshot() {
          sourceSnapshot_ = getDefaultInstance().getSourceSnapshot();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Name of the snapshot to use as the source for the disk. If
         * set,
         * [size_gb][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.size_gb]
         * and
         * [fs_type][google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.fs_type]
         * must be empty.
         * </pre>
         *
         * <code>string source_snapshot = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for sourceSnapshot to set.
         * @return This builder for chaining.
         */
        public Builder setSourceSnapshotBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          sourceSnapshot_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        private int reclaimPolicy_ = 0;

        /**
         *
         *
         * <pre>
         * Optional. Whether the persistent disk should be deleted when the
         * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
         * Defaults to `DELETE`.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enum numeric value on the wire for reclaimPolicy.
         */
        @java.lang.Override
        public int getReclaimPolicyValue() {
          return reclaimPolicy_;
        }

        /**
         *
         *
         * <pre>
         * Optional. Whether the persistent disk should be deleted when the
         * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
         * Defaults to `DELETE`.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enum numeric value on the wire for reclaimPolicy to set.
         * @return This builder for chaining.
         */
        public Builder setReclaimPolicyValue(int value) {
          reclaimPolicy_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Whether the persistent disk should be deleted when the
         * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
         * Defaults to `DELETE`.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The reclaimPolicy.
         */
        @java.lang.Override
        public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk.ReclaimPolicy
            getReclaimPolicy() {
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk.ReclaimPolicy
              result =
                  com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk.ReclaimPolicy.forNumber(reclaimPolicy_);
          return result == null
              ? com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk.ReclaimPolicy.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Optional. Whether the persistent disk should be deleted when the
         * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
         * Defaults to `DELETE`.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The reclaimPolicy to set.
         * @return This builder for chaining.
         */
        public Builder setReclaimPolicy(
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk.ReclaimPolicy
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000010;
          reclaimPolicy_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. Whether the persistent disk should be deleted when the
         * workstation is deleted. Valid values are `DELETE` and `RETAIN`.
         * Defaults to `DELETE`.
         * </pre>
         *
         * <code>
         * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk.ReclaimPolicy reclaim_policy = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReclaimPolicy() {
          bitField0_ = (bitField0_ & ~0x00000010);
          reclaimPolicy_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk)
      private static final com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk();
      }

      public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GceRegionalPersistentDisk> PARSER =
          new com.google.protobuf.AbstractParser<GceRegionalPersistentDisk>() {
            @java.lang.Override
            public GceRegionalPersistentDisk parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GceRegionalPersistentDisk> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GceRegionalPersistentDisk> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int directoryTypeCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object directoryType_;

    public enum DirectoryTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCE_PD(2),
      DIRECTORYTYPE_NOT_SET(0);
      private final int value;

      private DirectoryTypeCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DirectoryTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static DirectoryTypeCase forNumber(int value) {
        switch (value) {
          case 2:
            return GCE_PD;
          case 0:
            return DIRECTORYTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DirectoryTypeCase getDirectoryTypeCase() {
      return DirectoryTypeCase.forNumber(directoryTypeCase_);
    }

    public static final int GCE_PD_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine persistent disk.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
     * </code>
     *
     * @return Whether the gcePd field is set.
     */
    @java.lang.Override
    public boolean hasGcePd() {
      return directoryTypeCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine persistent disk.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
     * </code>
     *
     * @return The gcePd.
     */
    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
            .GceRegionalPersistentDisk
        getGcePd() {
      if (directoryTypeCase_ == 2) {
        return (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk)
            directoryType_;
      }
      return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
          .GceRegionalPersistentDisk.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * A PersistentDirectory backed by a Compute Engine persistent disk.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
            .GceRegionalPersistentDiskOrBuilder
        getGcePdOrBuilder() {
      if (directoryTypeCase_ == 2) {
        return (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .GceRegionalPersistentDisk)
            directoryType_;
      }
      return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
          .GceRegionalPersistentDisk.getDefaultInstance();
    }

    public static final int MOUNT_PATH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object mountPath_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Location of this directory in the running workstation.
     * </pre>
     *
     * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mountPath.
     */
    @java.lang.Override
    public java.lang.String getMountPath() {
      java.lang.Object ref = mountPath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mountPath_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of this directory in the running workstation.
     * </pre>
     *
     * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mountPath.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMountPathBytes() {
      java.lang.Object ref = mountPath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mountPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mountPath_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mountPath_);
      }
      if (directoryTypeCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk)
                directoryType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mountPath_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mountPath_);
      }
      if (directoryTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                        .GceRegionalPersistentDisk)
                    directoryType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory)) {
        return super.equals(obj);
      }
      com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory other =
          (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory) obj;

      if (!getMountPath().equals(other.getMountPath())) return false;
      if (!getDirectoryTypeCase().equals(other.getDirectoryTypeCase())) return false;
      switch (directoryTypeCase_) {
        case 2:
          if (!getGcePd().equals(other.getGcePd())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MOUNT_PATH_FIELD_NUMBER;
      hash = (53 * hash) + getMountPath().hashCode();
      switch (directoryTypeCase_) {
        case 2:
          hash = (37 * hash) + GCE_PD_FIELD_NUMBER;
          hash = (53 * hash) + getGcePd().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A directory to persist across workstation sessions.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory)
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.class,
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (gcePdBuilder_ != null) {
          gcePdBuilder_.clear();
        }
        mountPath_ = "";
        directoryTypeCase_ = 0;
        directoryType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_PersistentDirectory_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
          getDefaultInstanceForType() {
        return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory build() {
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory buildPartial() {
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory result =
            new com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mountPath_ = mountPath_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory result) {
        result.directoryTypeCase_ = directoryTypeCase_;
        result.directoryType_ = this.directoryType_;
        if (directoryTypeCase_ == 2 && gcePdBuilder_ != null) {
          result.directoryType_ = gcePdBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory) {
          return mergeFrom(
              (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory other) {
        if (other
            == com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                .getDefaultInstance()) return this;
        if (!other.getMountPath().isEmpty()) {
          mountPath_ = other.mountPath_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getDirectoryTypeCase()) {
          case GCE_PD:
            {
              mergeGcePd(other.getGcePd());
              break;
            }
          case DIRECTORYTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  mountPath_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getGcePdFieldBuilder().getBuilder(), extensionRegistry);
                  directoryTypeCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int directoryTypeCase_ = 0;
      private java.lang.Object directoryType_;

      public DirectoryTypeCase getDirectoryTypeCase() {
        return DirectoryTypeCase.forNumber(directoryTypeCase_);
      }

      public Builder clearDirectoryType() {
        directoryTypeCase_ = 0;
        directoryType_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk,
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk.Builder,
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDiskOrBuilder>
          gcePdBuilder_;

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       *
       * @return Whether the gcePd field is set.
       */
      @java.lang.Override
      public boolean hasGcePd() {
        return directoryTypeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       *
       * @return The gcePd.
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk
          getGcePd() {
        if (gcePdBuilder_ == null) {
          if (directoryTypeCase_ == 2) {
            return (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk)
                directoryType_;
          }
          return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.getDefaultInstance();
        } else {
          if (directoryTypeCase_ == 2) {
            return gcePdBuilder_.getMessage();
          }
          return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      public Builder setGcePd(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk
              value) {
        if (gcePdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          directoryType_ = value;
          onChanged();
        } else {
          gcePdBuilder_.setMessage(value);
        }
        directoryTypeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      public Builder setGcePd(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk.Builder
              builderForValue) {
        if (gcePdBuilder_ == null) {
          directoryType_ = builderForValue.build();
          onChanged();
        } else {
          gcePdBuilder_.setMessage(builderForValue.build());
        }
        directoryTypeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      public Builder mergeGcePd(
          com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk
              value) {
        if (gcePdBuilder_ == null) {
          if (directoryTypeCase_ == 2
              && directoryType_
                  != com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk.getDefaultInstance()) {
            directoryType_ =
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk.newBuilder(
                        (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                                .GceRegionalPersistentDisk)
                            directoryType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            directoryType_ = value;
          }
          onChanged();
        } else {
          if (directoryTypeCase_ == 2) {
            gcePdBuilder_.mergeFrom(value);
          } else {
            gcePdBuilder_.setMessage(value);
          }
        }
        directoryTypeCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      public Builder clearGcePd() {
        if (gcePdBuilder_ == null) {
          if (directoryTypeCase_ == 2) {
            directoryTypeCase_ = 0;
            directoryType_ = null;
            onChanged();
          }
        } else {
          if (directoryTypeCase_ == 2) {
            directoryTypeCase_ = 0;
            directoryType_ = null;
          }
          gcePdBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.Builder
          getGcePdBuilder() {
        return getGcePdFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDiskOrBuilder
          getGcePdOrBuilder() {
        if ((directoryTypeCase_ == 2) && (gcePdBuilder_ != null)) {
          return gcePdBuilder_.getMessageOrBuilder();
        } else {
          if (directoryTypeCase_ == 2) {
            return (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk)
                directoryType_;
          }
          return com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
              .GceRegionalPersistentDisk.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * A PersistentDirectory backed by a Compute Engine persistent disk.
       * </pre>
       *
       * <code>
       * .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.GceRegionalPersistentDisk gce_pd = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk,
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDisk.Builder,
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .GceRegionalPersistentDiskOrBuilder>
          getGcePdFieldBuilder() {
        if (gcePdBuilder_ == null) {
          if (!(directoryTypeCase_ == 2)) {
            directoryType_ =
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                    .GceRegionalPersistentDisk.getDefaultInstance();
          }
          gcePdBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk,
                  com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDisk.Builder,
                  com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                      .GceRegionalPersistentDiskOrBuilder>(
                  (com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                          .GceRegionalPersistentDisk)
                      directoryType_,
                  getParentForChildren(),
                  isClean());
          directoryType_ = null;
        }
        directoryTypeCase_ = 2;
        onChanged();
        return gcePdBuilder_;
      }

      private java.lang.Object mountPath_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Location of this directory in the running workstation.
       * </pre>
       *
       * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The mountPath.
       */
      public java.lang.String getMountPath() {
        java.lang.Object ref = mountPath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mountPath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Location of this directory in the running workstation.
       * </pre>
       *
       * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for mountPath.
       */
      public com.google.protobuf.ByteString getMountPathBytes() {
        java.lang.Object ref = mountPath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mountPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Location of this directory in the running workstation.
       * </pre>
       *
       * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The mountPath to set.
       * @return This builder for chaining.
       */
      public Builder setMountPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        mountPath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Location of this directory in the running workstation.
       * </pre>
       *
       * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMountPath() {
        mountPath_ = getDefaultInstance().getMountPath();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Location of this directory in the running workstation.
       * </pre>
       *
       * <code>string mount_path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for mountPath to set.
       * @return This builder for chaining.
       */
      public Builder setMountPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        mountPath_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory)
    private static final com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory();
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PersistentDirectory> PARSER =
        new com.google.protobuf.AbstractParser<PersistentDirectory>() {
          @java.lang.Override
          public PersistentDirectory parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PersistentDirectory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PersistentDirectory> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ContainerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.Container)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A Docker container image that defines a custom environment.
     *
     * Cloud Workstations provides a number of
     * [preconfigured
     * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
     * but you can create your own
     * [custom container
     * images](https://cloud.google.com/workstations/docs/custom-container-images).
     * If using a private image, the `host.gceInstance.serviceAccount` field
     * must be specified in the workstation configuration and must have
     * permission to pull the specified image. Otherwise, the image must be
     * publicly accessible.
     * </pre>
     *
     * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The image.
     */
    java.lang.String getImage();

    /**
     *
     *
     * <pre>
     * Optional. A Docker container image that defines a custom environment.
     *
     * Cloud Workstations provides a number of
     * [preconfigured
     * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
     * but you can create your own
     * [custom container
     * images](https://cloud.google.com/workstations/docs/custom-container-images).
     * If using a private image, the `host.gceInstance.serviceAccount` field
     * must be specified in the workstation configuration and must have
     * permission to pull the specified image. Otherwise, the image must be
     * publicly accessible.
     * </pre>
     *
     * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for image.
     */
    com.google.protobuf.ByteString getImageBytes();

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the command.
     */
    java.util.List<java.lang.String> getCommandList();

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of command.
     */
    int getCommandCount();

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    java.lang.String getCommand(int index);

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    com.google.protobuf.ByteString getCommandBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the args.
     */
    java.util.List<java.lang.String> getArgsList();

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of args.
     */
    int getArgsCount();

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    java.lang.String getArgs(int index);

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    com.google.protobuf.ByteString getArgsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    int getEnvCount();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    boolean containsEnv(java.lang.String key);

    /** Use {@link #getEnvMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getEnv();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getEnvMap();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    /* nullable */
    java.lang.String getEnvOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    java.lang.String getEnvOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default DIR specified by the image.
     * </pre>
     *
     * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The workingDir.
     */
    java.lang.String getWorkingDir();

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default DIR specified by the image.
     * </pre>
     *
     * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for workingDir.
     */
    com.google.protobuf.ByteString getWorkingDirBytes();

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the USER specified in the image with the
     * given uid.
     * </pre>
     *
     * <code>int32 run_as_user = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The runAsUser.
     */
    int getRunAsUser();
  }

  /**
   *
   *
   * <pre>
   * A Docker container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.Container}
   */
  public static final class Container extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.Container)
      ContainerOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Container.newBuilder() to construct.
    private Container(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Container() {
      image_ = "";
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      workingDir_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Container();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_Container_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetEnv();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_Container_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationConfig.Container.class,
              com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder.class);
    }

    public static final int IMAGE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object image_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A Docker container image that defines a custom environment.
     *
     * Cloud Workstations provides a number of
     * [preconfigured
     * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
     * but you can create your own
     * [custom container
     * images](https://cloud.google.com/workstations/docs/custom-container-images).
     * If using a private image, the `host.gceInstance.serviceAccount` field
     * must be specified in the workstation configuration and must have
     * permission to pull the specified image. Otherwise, the image must be
     * publicly accessible.
     * </pre>
     *
     * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public java.lang.String getImage() {
      java.lang.Object ref = image_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        image_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A Docker container image that defines a custom environment.
     *
     * Cloud Workstations provides a number of
     * [preconfigured
     * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
     * but you can create your own
     * [custom container
     * images](https://cloud.google.com/workstations/docs/custom-container-images).
     * If using a private image, the `host.gceInstance.serviceAccount` field
     * must be specified in the workstation configuration and must have
     * permission to pull the specified image. Otherwise, the image must be
     * publicly accessible.
     * </pre>
     *
     * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for image.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageBytes() {
      java.lang.Object ref = image_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        image_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMMAND_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList command_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the command.
     */
    public com.google.protobuf.ProtocolStringList getCommandList() {
      return command_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of command.
     */
    public int getCommandCount() {
      return command_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    public java.lang.String getCommand(int index) {
      return command_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default ENTRYPOINT specified by the
     * image.
     * </pre>
     *
     * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    public com.google.protobuf.ByteString getCommandBytes(int index) {
      return command_.getByteString(index);
    }

    public static final int ARGS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      return args_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Arguments passed to the entrypoint.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }

    public static final int ENV_FIELD_NUMBER = 4;

    private static final class EnvDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.workstations.v1.WorkstationsProto
                  .internal_static_google_cloud_workstations_v1_WorkstationConfig_Container_EnvEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> env_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetEnv() {
      if (env_ == null) {
        return com.google.protobuf.MapField.emptyMapField(EnvDefaultEntryHolder.defaultEntry);
      }
      return env_;
    }

    public int getEnvCount() {
      return internalGetEnv().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsEnv(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnv().getMap().containsKey(key);
    }

    /** Use {@link #getEnvMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnv() {
      return getEnvMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvMap() {
      return internalGetEnv().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEnvOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnv().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables passed to the container's entrypoint.
     * </pre>
     *
     * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getEnvOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetEnv().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int WORKING_DIR_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object workingDir_ = "";

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default DIR specified by the image.
     * </pre>
     *
     * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The workingDir.
     */
    @java.lang.Override
    public java.lang.String getWorkingDir() {
      java.lang.Object ref = workingDir_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workingDir_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the default DIR specified by the image.
     * </pre>
     *
     * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for workingDir.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWorkingDirBytes() {
      java.lang.Object ref = workingDir_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workingDir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RUN_AS_USER_FIELD_NUMBER = 6;
    private int runAsUser_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. If set, overrides the USER specified in the image with the
     * given uid.
     * </pre>
     *
     * <code>int32 run_as_user = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The runAsUser.
     */
    @java.lang.Override
    public int getRunAsUser() {
      return runAsUser_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, image_);
      }
      for (int i = 0; i < command_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, command_.getRaw(i));
      }
      for (int i = 0; i < args_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetEnv(), EnvDefaultEntryHolder.defaultEntry, 4);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workingDir_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, workingDir_);
      }
      if (runAsUser_ != 0) {
        output.writeInt32(6, runAsUser_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, image_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < command_.size(); i++) {
          dataSize += computeStringSizeNoTag(command_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCommandList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < args_.size(); i++) {
          dataSize += computeStringSizeNoTag(args_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getArgsList().size();
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetEnv().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> env__ =
            EnvDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, env__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workingDir_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, workingDir_);
      }
      if (runAsUser_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, runAsUser_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workstations.v1.WorkstationConfig.Container)) {
        return super.equals(obj);
      }
      com.google.cloud.workstations.v1.WorkstationConfig.Container other =
          (com.google.cloud.workstations.v1.WorkstationConfig.Container) obj;

      if (!getImage().equals(other.getImage())) return false;
      if (!getCommandList().equals(other.getCommandList())) return false;
      if (!getArgsList().equals(other.getArgsList())) return false;
      if (!internalGetEnv().equals(other.internalGetEnv())) return false;
      if (!getWorkingDir().equals(other.getWorkingDir())) return false;
      if (getRunAsUser() != other.getRunAsUser()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getImage().hashCode();
      if (getCommandCount() > 0) {
        hash = (37 * hash) + COMMAND_FIELD_NUMBER;
        hash = (53 * hash) + getCommandList().hashCode();
      }
      if (getArgsCount() > 0) {
        hash = (37 * hash) + ARGS_FIELD_NUMBER;
        hash = (53 * hash) + getArgsList().hashCode();
      }
      if (!internalGetEnv().getMap().isEmpty()) {
        hash = (37 * hash) + ENV_FIELD_NUMBER;
        hash = (53 * hash) + internalGetEnv().hashCode();
      }
      hash = (37 * hash) + WORKING_DIR_FIELD_NUMBER;
      hash = (53 * hash) + getWorkingDir().hashCode();
      hash = (37 * hash) + RUN_AS_USER_FIELD_NUMBER;
      hash = (53 * hash) + getRunAsUser();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workstations.v1.WorkstationConfig.Container prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Docker container.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.Container}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.Container)
        com.google.cloud.workstations.v1.WorkstationConfig.ContainerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Container_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetEnv();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 4:
            return internalGetMutableEnv();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Container_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.Container.class,
                com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder.class);
      }

      // Construct using com.google.cloud.workstations.v1.WorkstationConfig.Container.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        image_ = "";
        command_ = com.google.protobuf.LazyStringArrayList.emptyList();
        args_ = com.google.protobuf.LazyStringArrayList.emptyList();
        internalGetMutableEnv().clear();
        workingDir_ = "";
        runAsUser_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_Container_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Container
          getDefaultInstanceForType() {
        return com.google.cloud.workstations.v1.WorkstationConfig.Container.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Container build() {
        com.google.cloud.workstations.v1.WorkstationConfig.Container result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.Container buildPartial() {
        com.google.cloud.workstations.v1.WorkstationConfig.Container result =
            new com.google.cloud.workstations.v1.WorkstationConfig.Container(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workstations.v1.WorkstationConfig.Container result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.image_ = image_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          command_.makeImmutable();
          result.command_ = command_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          args_.makeImmutable();
          result.args_ = args_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.env_ = internalGetEnv();
          result.env_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.workingDir_ = workingDir_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.runAsUser_ = runAsUser_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workstations.v1.WorkstationConfig.Container) {
          return mergeFrom((com.google.cloud.workstations.v1.WorkstationConfig.Container) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.workstations.v1.WorkstationConfig.Container other) {
        if (other
            == com.google.cloud.workstations.v1.WorkstationConfig.Container.getDefaultInstance())
          return this;
        if (!other.getImage().isEmpty()) {
          image_ = other.image_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.command_.isEmpty()) {
          if (command_.isEmpty()) {
            command_ = other.command_;
            bitField0_ |= 0x00000002;
          } else {
            ensureCommandIsMutable();
            command_.addAll(other.command_);
          }
          onChanged();
        }
        if (!other.args_.isEmpty()) {
          if (args_.isEmpty()) {
            args_ = other.args_;
            bitField0_ |= 0x00000004;
          } else {
            ensureArgsIsMutable();
            args_.addAll(other.args_);
          }
          onChanged();
        }
        internalGetMutableEnv().mergeFrom(other.internalGetEnv());
        bitField0_ |= 0x00000008;
        if (!other.getWorkingDir().isEmpty()) {
          workingDir_ = other.workingDir_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.getRunAsUser() != 0) {
          setRunAsUser(other.getRunAsUser());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  image_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCommandIsMutable();
                  command_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureArgsIsMutable();
                  args_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> env__ =
                      input.readMessage(
                          EnvDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                  internalGetMutableEnv().getMutableMap().put(env__.getKey(), env__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  workingDir_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 48:
                {
                  runAsUser_ = input.readInt32();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object image_ = "";

      /**
       *
       *
       * <pre>
       * Optional. A Docker container image that defines a custom environment.
       *
       * Cloud Workstations provides a number of
       * [preconfigured
       * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
       * but you can create your own
       * [custom container
       * images](https://cloud.google.com/workstations/docs/custom-container-images).
       * If using a private image, the `host.gceInstance.serviceAccount` field
       * must be specified in the workstation configuration and must have
       * permission to pull the specified image. Otherwise, the image must be
       * publicly accessible.
       * </pre>
       *
       * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The image.
       */
      public java.lang.String getImage() {
        java.lang.Object ref = image_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          image_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A Docker container image that defines a custom environment.
       *
       * Cloud Workstations provides a number of
       * [preconfigured
       * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
       * but you can create your own
       * [custom container
       * images](https://cloud.google.com/workstations/docs/custom-container-images).
       * If using a private image, the `host.gceInstance.serviceAccount` field
       * must be specified in the workstation configuration and must have
       * permission to pull the specified image. Otherwise, the image must be
       * publicly accessible.
       * </pre>
       *
       * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for image.
       */
      public com.google.protobuf.ByteString getImageBytes() {
        java.lang.Object ref = image_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          image_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A Docker container image that defines a custom environment.
       *
       * Cloud Workstations provides a number of
       * [preconfigured
       * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
       * but you can create your own
       * [custom container
       * images](https://cloud.google.com/workstations/docs/custom-container-images).
       * If using a private image, the `host.gceInstance.serviceAccount` field
       * must be specified in the workstation configuration and must have
       * permission to pull the specified image. Otherwise, the image must be
       * publicly accessible.
       * </pre>
       *
       * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The image to set.
       * @return This builder for chaining.
       */
      public Builder setImage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        image_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A Docker container image that defines a custom environment.
       *
       * Cloud Workstations provides a number of
       * [preconfigured
       * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
       * but you can create your own
       * [custom container
       * images](https://cloud.google.com/workstations/docs/custom-container-images).
       * If using a private image, the `host.gceInstance.serviceAccount` field
       * must be specified in the workstation configuration and must have
       * permission to pull the specified image. Otherwise, the image must be
       * publicly accessible.
       * </pre>
       *
       * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImage() {
        image_ = getDefaultInstance().getImage();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A Docker container image that defines a custom environment.
       *
       * Cloud Workstations provides a number of
       * [preconfigured
       * images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
       * but you can create your own
       * [custom container
       * images](https://cloud.google.com/workstations/docs/custom-container-images).
       * If using a private image, the `host.gceInstance.serviceAccount` field
       * must be specified in the workstation configuration and must have
       * permission to pull the specified image. Otherwise, the image must be
       * publicly accessible.
       * </pre>
       *
       * <code>string image = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for image to set.
       * @return This builder for chaining.
       */
      public Builder setImageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        image_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList command_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCommandIsMutable() {
        if (!command_.isModifiable()) {
          command_ = new com.google.protobuf.LazyStringArrayList(command_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the command.
       */
      public com.google.protobuf.ProtocolStringList getCommandList() {
        command_.makeImmutable();
        return command_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of command.
       */
      public int getCommandCount() {
        return command_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The command at the given index.
       */
      public java.lang.String getCommand(int index) {
        return command_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the command at the given index.
       */
      public com.google.protobuf.ByteString getCommandBytes(int index) {
        return command_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The command to set.
       * @return This builder for chaining.
       */
      public Builder setCommand(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommandIsMutable();
        command_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The command to add.
       * @return This builder for chaining.
       */
      public Builder addCommand(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommandIsMutable();
        command_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The command to add.
       * @return This builder for chaining.
       */
      public Builder addAllCommand(java.lang.Iterable<java.lang.String> values) {
        ensureCommandIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, command_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommand() {
        command_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default ENTRYPOINT specified by the
       * image.
       * </pre>
       *
       * <code>repeated string command = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the command to add.
       * @return This builder for chaining.
       */
      public Builder addCommandBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCommandIsMutable();
        command_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList args_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureArgsIsMutable() {
        if (!args_.isModifiable()) {
          args_ = new com.google.protobuf.LazyStringArrayList(args_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the args.
       */
      public com.google.protobuf.ProtocolStringList getArgsList() {
        args_.makeImmutable();
        return args_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of args.
       */
      public int getArgsCount() {
        return args_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The args at the given index.
       */
      public java.lang.String getArgs(int index) {
        return args_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the args at the given index.
       */
      public com.google.protobuf.ByteString getArgsBytes(int index) {
        return args_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The args to set.
       * @return This builder for chaining.
       */
      public Builder setArgs(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgsIsMutable();
        args_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The args to add.
       * @return This builder for chaining.
       */
      public Builder addArgs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArgsIsMutable();
        args_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The args to add.
       * @return This builder for chaining.
       */
      public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
        ensureArgsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearArgs() {
        args_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Arguments passed to the entrypoint.
       * </pre>
       *
       * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the args to add.
       * @return This builder for chaining.
       */
      public Builder addArgsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureArgsIsMutable();
        args_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> env_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetEnv() {
        if (env_ == null) {
          return com.google.protobuf.MapField.emptyMapField(EnvDefaultEntryHolder.defaultEntry);
        }
        return env_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableEnv() {
        if (env_ == null) {
          env_ = com.google.protobuf.MapField.newMapField(EnvDefaultEntryHolder.defaultEntry);
        }
        if (!env_.isMutable()) {
          env_ = env_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return env_;
      }

      public int getEnvCount() {
        return internalGetEnv().getMap().size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      @java.lang.Override
      public boolean containsEnv(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetEnv().getMap().containsKey(key);
      }

      /** Use {@link #getEnvMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getEnv() {
        return getEnvMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getEnvMap() {
        return internalGetEnv().getMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getEnvOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetEnv().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      @java.lang.Override
      public java.lang.String getEnvOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetEnv().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearEnv() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableEnv().getMutableMap().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder removeEnv(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableEnv().getMutableMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableEnv() {
        bitField0_ |= 0x00000008;
        return internalGetMutableEnv().getMutableMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder putEnv(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableEnv().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables passed to the container's entrypoint.
       * </pre>
       *
       * <code>map&lt;string, string&gt; env = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       */
      public Builder putAllEnv(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableEnv().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      private java.lang.Object workingDir_ = "";

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default DIR specified by the image.
       * </pre>
       *
       * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The workingDir.
       */
      public java.lang.String getWorkingDir() {
        java.lang.Object ref = workingDir_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          workingDir_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default DIR specified by the image.
       * </pre>
       *
       * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for workingDir.
       */
      public com.google.protobuf.ByteString getWorkingDirBytes() {
        java.lang.Object ref = workingDir_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          workingDir_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default DIR specified by the image.
       * </pre>
       *
       * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The workingDir to set.
       * @return This builder for chaining.
       */
      public Builder setWorkingDir(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        workingDir_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default DIR specified by the image.
       * </pre>
       *
       * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWorkingDir() {
        workingDir_ = getDefaultInstance().getWorkingDir();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the default DIR specified by the image.
       * </pre>
       *
       * <code>string working_dir = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for workingDir to set.
       * @return This builder for chaining.
       */
      public Builder setWorkingDirBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        workingDir_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private int runAsUser_;

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the USER specified in the image with the
       * given uid.
       * </pre>
       *
       * <code>int32 run_as_user = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The runAsUser.
       */
      @java.lang.Override
      public int getRunAsUser() {
        return runAsUser_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the USER specified in the image with the
       * given uid.
       * </pre>
       *
       * <code>int32 run_as_user = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The runAsUser to set.
       * @return This builder for chaining.
       */
      public Builder setRunAsUser(int value) {

        runAsUser_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set, overrides the USER specified in the image with the
       * given uid.
       * </pre>
       *
       * <code>int32 run_as_user = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRunAsUser() {
        bitField0_ = (bitField0_ & ~0x00000020);
        runAsUser_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.Container)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.Container)
    private static final com.google.cloud.workstations.v1.WorkstationConfig.Container
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.WorkstationConfig.Container();
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.Container
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Container> PARSER =
        new com.google.protobuf.AbstractParser<Container>() {
          @java.lang.Override
          public Container parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Container> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Container> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.Container
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CustomerEncryptionKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Immutable. The name of the Google Cloud KMS encryption key. For example,
     * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
     * The key must be in the same region as the workstation configuration.
     * </pre>
     *
     * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The kmsKey.
     */
    java.lang.String getKmsKey();

    /**
     *
     *
     * <pre>
     * Immutable. The name of the Google Cloud KMS encryption key. For example,
     * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
     * The key must be in the same region as the workstation configuration.
     * </pre>
     *
     * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for kmsKey.
     */
    com.google.protobuf.ByteString getKmsKeyBytes();

    /**
     *
     *
     * <pre>
     * Immutable. The service account to use with the specified
     * KMS key. We recommend that you use a separate service account
     * and follow KMS best practices. For more information, see
     * [Separation of
     * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
     * `gcloud kms keys add-iam-policy-binding`
     * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
     * </pre>
     *
     * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The kmsKeyServiceAccount.
     */
    java.lang.String getKmsKeyServiceAccount();

    /**
     *
     *
     * <pre>
     * Immutable. The service account to use with the specified
     * KMS key. We recommend that you use a separate service account
     * and follow KMS best practices. For more information, see
     * [Separation of
     * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
     * `gcloud kms keys add-iam-policy-binding`
     * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
     * </pre>
     *
     * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for kmsKeyServiceAccount.
     */
    com.google.protobuf.ByteString getKmsKeyServiceAccountBytes();
  }

  /**
   *
   *
   * <pre>
   * A customer-managed encryption key (CMEK) for the Compute Engine
   * resources of the associated workstation configuration. Specify the name of
   * your Cloud KMS encryption key and the default service account.
   * We recommend that you use a separate service account and follow
   * [Cloud KMS best
   * practices](https://cloud.google.com/kms/docs/separation-of-duties).
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey}
   */
  public static final class CustomerEncryptionKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey)
      CustomerEncryptionKeyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CustomerEncryptionKey.newBuilder() to construct.
    private CustomerEncryptionKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomerEncryptionKey() {
      kmsKey_ = "";
      kmsKeyServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomerEncryptionKey();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_CustomerEncryptionKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_CustomerEncryptionKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.class,
              com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder
                  .class);
    }

    public static final int KMS_KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKey_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The name of the Google Cloud KMS encryption key. For example,
     * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
     * The key must be in the same region as the workstation configuration.
     * </pre>
     *
     * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The kmsKey.
     */
    @java.lang.Override
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the Google Cloud KMS encryption key. For example,
     * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
     * The key must be in the same region as the workstation configuration.
     * </pre>
     *
     * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for kmsKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KMS_KEY_SERVICE_ACCOUNT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kmsKeyServiceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The service account to use with the specified
     * KMS key. We recommend that you use a separate service account
     * and follow KMS best practices. For more information, see
     * [Separation of
     * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
     * `gcloud kms keys add-iam-policy-binding`
     * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
     * </pre>
     *
     * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The kmsKeyServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getKmsKeyServiceAccount() {
      java.lang.Object ref = kmsKeyServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyServiceAccount_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The service account to use with the specified
     * KMS key. We recommend that you use a separate service account
     * and follow KMS best practices. For more information, see
     * [Separation of
     * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
     * `gcloud kms keys add-iam-policy-binding`
     * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
     * </pre>
     *
     * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for kmsKeyServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKmsKeyServiceAccountBytes() {
      java.lang.Object ref = kmsKeyServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kmsKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kmsKeyServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kmsKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kmsKeyServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey)) {
        return super.equals(obj);
      }
      com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey other =
          (com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey) obj;

      if (!getKmsKey().equals(other.getKmsKey())) return false;
      if (!getKmsKeyServiceAccount().equals(other.getKmsKeyServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKey().hashCode();
      hash = (37 * hash) + KMS_KEY_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getKmsKeyServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A customer-managed encryption key (CMEK) for the Compute Engine
     * resources of the associated workstation configuration. Specify the name of
     * your Cloud KMS encryption key and the default service account.
     * We recommend that you use a separate service account and follow
     * [Cloud KMS best
     * practices](https://cloud.google.com/kms/docs/separation-of-duties).
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey)
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_CustomerEncryptionKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_CustomerEncryptionKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.class,
                com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kmsKey_ = "";
        kmsKeyServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_CustomerEncryptionKey_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
          getDefaultInstanceForType() {
        return com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey build() {
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
          buildPartial() {
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey result =
            new com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kmsKey_ = kmsKey_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.kmsKeyServiceAccount_ = kmsKeyServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey) {
          return mergeFrom(
              (com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey other) {
        if (other
            == com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
                .getDefaultInstance()) return this;
        if (!other.getKmsKey().isEmpty()) {
          kmsKey_ = other.kmsKey_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getKmsKeyServiceAccount().isEmpty()) {
          kmsKeyServiceAccount_ = other.kmsKeyServiceAccount_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  kmsKey_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  kmsKeyServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object kmsKey_ = "";

      /**
       *
       *
       * <pre>
       * Immutable. The name of the Google Cloud KMS encryption key. For example,
       * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
       * The key must be in the same region as the workstation configuration.
       * </pre>
       *
       * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The kmsKey.
       */
      public java.lang.String getKmsKey() {
        java.lang.Object ref = kmsKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Immutable. The name of the Google Cloud KMS encryption key. For example,
       * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
       * The key must be in the same region as the workstation configuration.
       * </pre>
       *
       * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The bytes for kmsKey.
       */
      public com.google.protobuf.ByteString getKmsKeyBytes() {
        java.lang.Object ref = kmsKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Immutable. The name of the Google Cloud KMS encryption key. For example,
       * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
       * The key must be in the same region as the workstation configuration.
       * </pre>
       *
       * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The kmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Immutable. The name of the Google Cloud KMS encryption key. For example,
       * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
       * The key must be in the same region as the workstation configuration.
       * </pre>
       *
       * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKey() {
        kmsKey_ = getDefaultInstance().getKmsKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Immutable. The name of the Google Cloud KMS encryption key. For example,
       * `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
       * The key must be in the same region as the workstation configuration.
       * </pre>
       *
       * <code>string kms_key = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The bytes for kmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKey_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object kmsKeyServiceAccount_ = "";

      /**
       *
       *
       * <pre>
       * Immutable. The service account to use with the specified
       * KMS key. We recommend that you use a separate service account
       * and follow KMS best practices. For more information, see
       * [Separation of
       * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
       * `gcloud kms keys add-iam-policy-binding`
       * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
       * </pre>
       *
       * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The kmsKeyServiceAccount.
       */
      public java.lang.String getKmsKeyServiceAccount() {
        java.lang.Object ref = kmsKeyServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kmsKeyServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Immutable. The service account to use with the specified
       * KMS key. We recommend that you use a separate service account
       * and follow KMS best practices. For more information, see
       * [Separation of
       * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
       * `gcloud kms keys add-iam-policy-binding`
       * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
       * </pre>
       *
       * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return The bytes for kmsKeyServiceAccount.
       */
      public com.google.protobuf.ByteString getKmsKeyServiceAccountBytes() {
        java.lang.Object ref = kmsKeyServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kmsKeyServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Immutable. The service account to use with the specified
       * KMS key. We recommend that you use a separate service account
       * and follow KMS best practices. For more information, see
       * [Separation of
       * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
       * `gcloud kms keys add-iam-policy-binding`
       * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
       * </pre>
       *
       * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The kmsKeyServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kmsKeyServiceAccount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Immutable. The service account to use with the specified
       * KMS key. We recommend that you use a separate service account
       * and follow KMS best practices. For more information, see
       * [Separation of
       * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
       * `gcloud kms keys add-iam-policy-binding`
       * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
       * </pre>
       *
       * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKeyServiceAccount() {
        kmsKeyServiceAccount_ = getDefaultInstance().getKmsKeyServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Immutable. The service account to use with the specified
       * KMS key. We recommend that you use a separate service account
       * and follow KMS best practices. For more information, see
       * [Separation of
       * duties](https://cloud.google.com/kms/docs/separation-of-duties) and
       * `gcloud kms keys add-iam-policy-binding`
       * [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
       * </pre>
       *
       * <code>string kms_key_service_account = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
       *
       * @param value The bytes for kmsKeyServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kmsKeyServiceAccount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey)
    private static final com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey();
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomerEncryptionKey> PARSER =
        new com.google.protobuf.AbstractParser<CustomerEncryptionKey>() {
          @java.lang.Override
          public CustomerEncryptionKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomerEncryptionKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomerEncryptionKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadinessCheckOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Path to which the request should be sent.
     * </pre>
     *
     * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The path.
     */
    java.lang.String getPath();

    /**
     *
     *
     * <pre>
     * Optional. Path to which the request should be sent.
     * </pre>
     *
     * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Optional. Port to which the request should be sent.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The port.
     */
    int getPort();
  }

  /**
   *
   *
   * <pre>
   * A readiness check to be performed on a workstation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck}
   */
  public static final class ReadinessCheck extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck)
      ReadinessCheckOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReadinessCheck.newBuilder() to construct.
    private ReadinessCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadinessCheck() {
      path_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadinessCheck();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_ReadinessCheck_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_ReadinessCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.class,
              com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder.class);
    }

    public static final int PATH_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Path to which the request should be sent.
     * </pre>
     *
     * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Path to which the request should be sent.
     * </pre>
     *
     * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 2;
    private int port_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Port to which the request should be sent.
     * </pre>
     *
     * <code>int32 port = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_);
      }
      if (port_ != 0) {
        output.writeInt32(2, port_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, path_);
      }
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, port_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck)) {
        return super.equals(obj);
      }
      com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck other =
          (com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck) obj;

      if (!getPath().equals(other.getPath())) return false;
      if (getPort() != other.getPort()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A readiness check to be performed on a workstation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck)
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_ReadinessCheck_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_ReadinessCheck_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.class,
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder.class);
      }

      // Construct using
      // com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        path_ = "";
        port_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.workstations.v1.WorkstationsProto
            .internal_static_google_cloud_workstations_v1_WorkstationConfig_ReadinessCheck_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
          getDefaultInstanceForType() {
        return com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck build() {
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck buildPartial() {
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck result =
            new com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.path_ = path_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.port_ = port_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck) {
          return mergeFrom(
              (com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck other) {
        if (other
            == com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
                .getDefaultInstance()) return this;
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  port_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object path_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Path to which the request should be sent.
       * </pre>
       *
       * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Path to which the request should be sent.
       * </pre>
       *
       * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Path to which the request should be sent.
       * </pre>
       *
       * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Path to which the request should be sent.
       * </pre>
       *
       * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Path to which the request should be sent.
       * </pre>
       *
       * <code>string path = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int port_;

      /**
       *
       *
       * <pre>
       * Optional. Port to which the request should be sent.
       * </pre>
       *
       * <code>int32 port = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Port to which the request should be sent.
       * </pre>
       *
       * <code>int32 port = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Port to which the request should be sent.
       * </pre>
       *
       * <code>int32 port = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000002);
        port_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck)
    private static final com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck();
    }

    public static com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadinessCheck> PARSER =
        new com.google.protobuf.AbstractParser<ReadinessCheck>() {
          @java.lang.Override
          public ReadinessCheck parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadinessCheck> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadinessCheck> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Full name of this workstation configuration.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Full name of this workstation configuration.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Human-readable name for this workstation configuration.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Human-readable name for this workstation configuration.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A system-assigned unique identifier for this workstation
   * configuration.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A system-assigned unique identifier for this workstation
   * configuration.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECONCILING_FIELD_NUMBER = 4;
  private boolean reconciling_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this workstation configuration is currently
   * being updated to match its intended state.
   * </pre>
   *
   * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Client-specified annotations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 18;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.workstations.v1.WorkstationsProto
                .internal_static_google_cloud_workstations_v1_WorkstationConfig_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation configuration and that are also propagated
   * to the underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation configuration and that are also propagated
   * to the underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation configuration and that are also propagated
   * to the underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional.
   * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
   * are applied to the workstation configuration and that are also propagated
   * to the underlying Compute Engine resources.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was most recently
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when this workstation configuration was soft-deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Checksum computed by the server. May be sent on update and delete
   * requests to make sure that the client has an up-to-date value before
   * proceeding.
   * </pre>
   *
   * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Checksum computed by the server. May be sent on update and delete
   * requests to make sure that the client has an up-to-date value before
   * proceeding.
   * </pre>
   *
   * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IDLE_TIMEOUT_FIELD_NUMBER = 10;
  private com.google.protobuf.Duration idleTimeout_;

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds to wait before automatically stopping a
   * workstation after it last received user traffic.
   *
   * A value of `"0s"` indicates that Cloud Workstations VMs created with this
   * configuration should never time out due to idleness.
   * Provide
   * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
   * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
   * The default is `"1200s"` (20 minutes).
   * </pre>
   *
   * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the idleTimeout field is set.
   */
  @java.lang.Override
  public boolean hasIdleTimeout() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds to wait before automatically stopping a
   * workstation after it last received user traffic.
   *
   * A value of `"0s"` indicates that Cloud Workstations VMs created with this
   * configuration should never time out due to idleness.
   * Provide
   * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
   * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
   * The default is `"1200s"` (20 minutes).
   * </pre>
   *
   * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The idleTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getIdleTimeout() {
    return idleTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : idleTimeout_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds to wait before automatically stopping a
   * workstation after it last received user traffic.
   *
   * A value of `"0s"` indicates that Cloud Workstations VMs created with this
   * configuration should never time out due to idleness.
   * Provide
   * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
   * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
   * The default is `"1200s"` (20 minutes).
   * </pre>
   *
   * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getIdleTimeoutOrBuilder() {
    return idleTimeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : idleTimeout_;
  }

  public static final int RUNNING_TIMEOUT_FIELD_NUMBER = 11;
  private com.google.protobuf.Duration runningTimeout_;

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds that a workstation can run until it is
   * automatically shut down. We recommend that workstations be shut down daily
   * to reduce costs and so that security updates can be applied upon restart.
   * The
   * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
   * and
   * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
   * fields are independent of each other. Note that the
   * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
   * field shuts down VMs after the specified time, regardless of whether or not
   * the VMs are idle.
   *
   * Provide duration terminated by `s` for seconds—for example, `"54000s"`
   * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
   * that workstations using this configuration should never time out. If
   * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
   * is set, it must be greater than `"0s"` and less than
   * `"86400s"` (24 hours).
   *
   * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
   * with this configuration have no maximum running time. This is strongly
   * discouraged because you incur costs and will not pick up security updates.
   * </pre>
   *
   * <code>.google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runningTimeout field is set.
   */
  @java.lang.Override
  public boolean hasRunningTimeout() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds that a workstation can run until it is
   * automatically shut down. We recommend that workstations be shut down daily
   * to reduce costs and so that security updates can be applied upon restart.
   * The
   * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
   * and
   * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
   * fields are independent of each other. Note that the
   * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
   * field shuts down VMs after the specified time, regardless of whether or not
   * the VMs are idle.
   *
   * Provide duration terminated by `s` for seconds—for example, `"54000s"`
   * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
   * that workstations using this configuration should never time out. If
   * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
   * is set, it must be greater than `"0s"` and less than
   * `"86400s"` (24 hours).
   *
   * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
   * with this configuration have no maximum running time. This is strongly
   * discouraged because you incur costs and will not pick up security updates.
   * </pre>
   *
   * <code>.google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runningTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRunningTimeout() {
    return runningTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : runningTimeout_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Number of seconds that a workstation can run until it is
   * automatically shut down. We recommend that workstations be shut down daily
   * to reduce costs and so that security updates can be applied upon restart.
   * The
   * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
   * and
   * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
   * fields are independent of each other. Note that the
   * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
   * field shuts down VMs after the specified time, regardless of whether or not
   * the VMs are idle.
   *
   * Provide duration terminated by `s` for seconds—for example, `"54000s"`
   * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
   * that workstations using this configuration should never time out. If
   * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
   * is set, it must be greater than `"0s"` and less than
   * `"86400s"` (24 hours).
   *
   * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
   * with this configuration have no maximum running time. This is strongly
   * discouraged because you incur costs and will not pick up security updates.
   * </pre>
   *
   * <code>.google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRunningTimeoutOrBuilder() {
    return runningTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : runningTimeout_;
  }

  public static final int HOST_FIELD_NUMBER = 12;
  private com.google.cloud.workstations.v1.WorkstationConfig.Host host_;

  /**
   *
   *
   * <pre>
   * Optional. Runtime host for the workstation.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the host field is set.
   */
  @java.lang.Override
  public boolean hasHost() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Runtime host for the workstation.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The host.
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.Host getHost() {
    return host_ == null
        ? com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance()
        : host_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Runtime host for the workstation.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.HostOrBuilder getHostOrBuilder() {
    return host_ == null
        ? com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance()
        : host_;
  }

  public static final int PERSISTENT_DIRECTORIES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory>
      persistentDirectories_;

  /**
   *
   *
   * <pre>
   * Optional. Directories to persist across workstation sessions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory>
      getPersistentDirectoriesList() {
    return persistentDirectories_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Directories to persist across workstation sessions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder>
      getPersistentDirectoriesOrBuilderList() {
    return persistentDirectories_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Directories to persist across workstation sessions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPersistentDirectoriesCount() {
    return persistentDirectories_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Directories to persist across workstation sessions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
      getPersistentDirectories(int index) {
    return persistentDirectories_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Directories to persist across workstation sessions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder
      getPersistentDirectoriesOrBuilder(int index) {
    return persistentDirectories_.get(index);
  }

  public static final int CONTAINER_FIELD_NUMBER = 14;
  private com.google.cloud.workstations.v1.WorkstationConfig.Container container_;

  /**
   *
   *
   * <pre>
   * Optional. Container that runs upon startup for each workstation using this
   * workstation configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the container field is set.
   */
  @java.lang.Override
  public boolean hasContainer() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Container that runs upon startup for each workstation using this
   * workstation configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The container.
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.Container getContainer() {
    return container_ == null
        ? com.google.cloud.workstations.v1.WorkstationConfig.Container.getDefaultInstance()
        : container_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Container that runs upon startup for each workstation using this
   * workstation configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.ContainerOrBuilder
      getContainerOrBuilder() {
    return container_ == null
        ? com.google.cloud.workstations.v1.WorkstationConfig.Container.getDefaultInstance()
        : container_;
  }

  public static final int ENCRYPTION_KEY_FIELD_NUMBER = 17;
  private com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryptionKey_;

  /**
   *
   *
   * <pre>
   * Immutable. Encrypts resources of this workstation configuration using a
   * customer-managed encryption key (CMEK).
   *
   * If specified, the boot disk of the Compute Engine instance and the
   * persistent disk are encrypted using this encryption key. If
   * this field is not set, the disks are encrypted using a generated
   * key. Customer-managed encryption keys do not protect disk metadata.
   *
   * If the customer-managed encryption key is rotated, when the workstation
   * instance is stopped, the system attempts to recreate the
   * persistent disk with the new version of the key. Be sure to keep
   * older versions of the key until the persistent disk is recreated.
   * Otherwise, data on the persistent disk might be lost.
   *
   * If the encryption key is revoked, the workstation session automatically
   * stops within 7 hours.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the encryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionKey() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Immutable. Encrypts resources of this workstation configuration using a
   * customer-managed encryption key (CMEK).
   *
   * If specified, the boot disk of the Compute Engine instance and the
   * persistent disk are encrypted using this encryption key. If
   * this field is not set, the disks are encrypted using a generated
   * key. Customer-managed encryption keys do not protect disk metadata.
   *
   * If the customer-managed encryption key is rotated, when the workstation
   * instance is stopped, the system attempts to recreate the
   * persistent disk with the new version of the key. Be sure to keep
   * older versions of the key until the persistent disk is recreated.
   * Otherwise, data on the persistent disk might be lost.
   *
   * If the encryption key is revoked, the workstation session automatically
   * stops within 7 hours.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The encryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
      getEncryptionKey() {
    return encryptionKey_ == null
        ? com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
            .getDefaultInstance()
        : encryptionKey_;
  }

  /**
   *
   *
   * <pre>
   * Immutable. Encrypts resources of this workstation configuration using a
   * customer-managed encryption key (CMEK).
   *
   * If specified, the boot disk of the Compute Engine instance and the
   * persistent disk are encrypted using this encryption key. If
   * this field is not set, the disks are encrypted using a generated
   * key. Customer-managed encryption keys do not protect disk metadata.
   *
   * If the customer-managed encryption key is rotated, when the workstation
   * instance is stopped, the system attempts to recreate the
   * persistent disk with the new version of the key. Be sure to keep
   * older versions of the key until the persistent disk is recreated.
   * Otherwise, data on the persistent disk might be lost.
   *
   * If the encryption key is revoked, the workstation session automatically
   * stops within 7 hours.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKeyOrBuilder
      getEncryptionKeyOrBuilder() {
    return encryptionKey_ == null
        ? com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
            .getDefaultInstance()
        : encryptionKey_;
  }

  public static final int READINESS_CHECKS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck>
      readinessChecks_;

  /**
   *
   *
   * <pre>
   * Optional. Readiness checks to perform when starting a workstation using
   * this workstation configuration. Mark a workstation as running only after
   * all specified readiness checks return 200 status codes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck>
      getReadinessChecksList() {
    return readinessChecks_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Readiness checks to perform when starting a workstation using
   * this workstation configuration. Mark a workstation as running only after
   * all specified readiness checks return 200 status codes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder>
      getReadinessChecksOrBuilderList() {
    return readinessChecks_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Readiness checks to perform when starting a workstation using
   * this workstation configuration. Mark a workstation as running only after
   * all specified readiness checks return 200 status codes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getReadinessChecksCount() {
    return readinessChecks_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Readiness checks to perform when starting a workstation using
   * this workstation configuration. Mark a workstation as running only after
   * all specified readiness checks return 200 status codes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck getReadinessChecks(
      int index) {
    return readinessChecks_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Readiness checks to perform when starting a workstation using
   * this workstation configuration. Mark a workstation as running only after
   * all specified readiness checks return 200 status codes.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder
      getReadinessChecksOrBuilder(int index) {
    return readinessChecks_.get(index);
  }

  public static final int REPLICA_ZONES_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList replicaZones_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Specifies the zones used to replicate the VM and disk
   * resources within the region. If set, exactly two zones within the
   * workstation cluster's region must be specified—for example,
   * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
   * zones within the region are used.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return A list containing the replicaZones.
   */
  public com.google.protobuf.ProtocolStringList getReplicaZonesList() {
    return replicaZones_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Specifies the zones used to replicate the VM and disk
   * resources within the region. If set, exactly two zones within the
   * workstation cluster's region must be specified—for example,
   * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
   * zones within the region are used.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The count of replicaZones.
   */
  public int getReplicaZonesCount() {
    return replicaZones_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Specifies the zones used to replicate the VM and disk
   * resources within the region. If set, exactly two zones within the
   * workstation cluster's region must be specified—for example,
   * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
   * zones within the region are used.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The replicaZones at the given index.
   */
  public java.lang.String getReplicaZones(int index) {
    return replicaZones_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. Specifies the zones used to replicate the VM and disk
   * resources within the region. If set, exactly two zones within the
   * workstation cluster's region must be specified—for example,
   * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
   * zones within the region are used.
   *
   * Immutable after the workstation configuration is created.
   * </pre>
   *
   * <code>
   * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the replicaZones at the given index.
   */
  public com.google.protobuf.ByteString getReplicaZonesBytes(int index) {
    return replicaZones_.getByteString(index);
  }

  public static final int DEGRADED_FIELD_NUMBER = 15;
  private boolean degraded_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Whether this resource is degraded, in which case it may
   * require user action to restore full functionality. See also the
   * [conditions][google.cloud.workstations.v1.WorkstationConfig.conditions]
   * field.
   * </pre>
   *
   * <code>bool degraded = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The degraded.
   */
  @java.lang.Override
  public boolean getDegraded() {
    return degraded_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> conditions_;

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the current resource state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getConditionsList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the current resource state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getConditionsOrBuilderList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the current resource state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the current resource state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getConditions(int index) {
    return conditions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Status conditions describing the current resource state.
   * </pre>
   *
   * <code>repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uid_);
    }
    if (reconciling_ != false) {
      output.writeBool(4, reconciling_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, etag_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getIdleTimeout());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(11, getRunningTimeout());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(12, getHost());
    }
    for (int i = 0; i < persistentDirectories_.size(); i++) {
      output.writeMessage(13, persistentDirectories_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(14, getContainer());
    }
    if (degraded_ != false) {
      output.writeBool(15, degraded_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(16, conditions_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(17, getEncryptionKey());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 18);
    for (int i = 0; i < readinessChecks_.size(); i++) {
      output.writeMessage(19, readinessChecks_.get(i));
    }
    for (int i = 0; i < replicaZones_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, replicaZones_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uid_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, reconciling_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, etag_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getIdleTimeout());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getRunningTimeout());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getHost());
    }
    for (int i = 0; i < persistentDirectories_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, persistentDirectories_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getContainer());
    }
    if (degraded_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, degraded_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, conditions_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getEncryptionKey());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, labels__);
    }
    for (int i = 0; i < readinessChecks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, readinessChecks_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < replicaZones_.size(); i++) {
        dataSize += computeStringSizeNoTag(replicaZones_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getReplicaZonesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workstations.v1.WorkstationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.workstations.v1.WorkstationConfig other =
        (com.google.cloud.workstations.v1.WorkstationConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasIdleTimeout() != other.hasIdleTimeout()) return false;
    if (hasIdleTimeout()) {
      if (!getIdleTimeout().equals(other.getIdleTimeout())) return false;
    }
    if (hasRunningTimeout() != other.hasRunningTimeout()) return false;
    if (hasRunningTimeout()) {
      if (!getRunningTimeout().equals(other.getRunningTimeout())) return false;
    }
    if (hasHost() != other.hasHost()) return false;
    if (hasHost()) {
      if (!getHost().equals(other.getHost())) return false;
    }
    if (!getPersistentDirectoriesList().equals(other.getPersistentDirectoriesList())) return false;
    if (hasContainer() != other.hasContainer()) return false;
    if (hasContainer()) {
      if (!getContainer().equals(other.getContainer())) return false;
    }
    if (hasEncryptionKey() != other.hasEncryptionKey()) return false;
    if (hasEncryptionKey()) {
      if (!getEncryptionKey().equals(other.getEncryptionKey())) return false;
    }
    if (!getReadinessChecksList().equals(other.getReadinessChecksList())) return false;
    if (!getReplicaZonesList().equals(other.getReplicaZonesList())) return false;
    if (getDegraded() != other.getDegraded()) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasIdleTimeout()) {
      hash = (37 * hash) + IDLE_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getIdleTimeout().hashCode();
    }
    if (hasRunningTimeout()) {
      hash = (37 * hash) + RUNNING_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getRunningTimeout().hashCode();
    }
    if (hasHost()) {
      hash = (37 * hash) + HOST_FIELD_NUMBER;
      hash = (53 * hash) + getHost().hashCode();
    }
    if (getPersistentDirectoriesCount() > 0) {
      hash = (37 * hash) + PERSISTENT_DIRECTORIES_FIELD_NUMBER;
      hash = (53 * hash) + getPersistentDirectoriesList().hashCode();
    }
    if (hasContainer()) {
      hash = (37 * hash) + CONTAINER_FIELD_NUMBER;
      hash = (53 * hash) + getContainer().hashCode();
    }
    if (hasEncryptionKey()) {
      hash = (37 * hash) + ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionKey().hashCode();
    }
    if (getReadinessChecksCount() > 0) {
      hash = (37 * hash) + READINESS_CHECKS_FIELD_NUMBER;
      hash = (53 * hash) + getReadinessChecksList().hashCode();
    }
    if (getReplicaZonesCount() > 0) {
      hash = (37 * hash) + REPLICA_ZONES_FIELD_NUMBER;
      hash = (53 * hash) + getReplicaZonesList().hashCode();
    }
    hash = (37 * hash) + DEGRADED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDegraded());
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.workstations.v1.WorkstationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A workstation configuration resource in the Cloud Workstations API.
   *
   * Workstation configurations act as templates for workstations. The workstation
   * configuration defines details such as the workstation virtual machine (VM)
   * instance type, persistent storage, container image defining environment,
   * which IDE or Code Editor to use, and more. Administrators and platform teams
   * can also use [Identity and Access Management
   * (IAM)](https://cloud.google.com/iam/docs/overview) rules to grant access to
   * teams or to individual developers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1.WorkstationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1.WorkstationConfig)
      com.google.cloud.workstations.v1.WorkstationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetAnnotations();
        case 18:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableAnnotations();
        case 18:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1.WorkstationConfig.class,
              com.google.cloud.workstations.v1.WorkstationConfig.Builder.class);
    }

    // Construct using com.google.cloud.workstations.v1.WorkstationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
        getIdleTimeoutFieldBuilder();
        getRunningTimeoutFieldBuilder();
        getHostFieldBuilder();
        getPersistentDirectoriesFieldBuilder();
        getContainerFieldBuilder();
        getEncryptionKeyFieldBuilder();
        getReadinessChecksFieldBuilder();
        getConditionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      uid_ = "";
      reconciling_ = false;
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      etag_ = "";
      idleTimeout_ = null;
      if (idleTimeoutBuilder_ != null) {
        idleTimeoutBuilder_.dispose();
        idleTimeoutBuilder_ = null;
      }
      runningTimeout_ = null;
      if (runningTimeoutBuilder_ != null) {
        runningTimeoutBuilder_.dispose();
        runningTimeoutBuilder_ = null;
      }
      host_ = null;
      if (hostBuilder_ != null) {
        hostBuilder_.dispose();
        hostBuilder_ = null;
      }
      if (persistentDirectoriesBuilder_ == null) {
        persistentDirectories_ = java.util.Collections.emptyList();
      } else {
        persistentDirectories_ = null;
        persistentDirectoriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      container_ = null;
      if (containerBuilder_ != null) {
        containerBuilder_.dispose();
        containerBuilder_ = null;
      }
      encryptionKey_ = null;
      if (encryptionKeyBuilder_ != null) {
        encryptionKeyBuilder_.dispose();
        encryptionKeyBuilder_ = null;
      }
      if (readinessChecksBuilder_ == null) {
        readinessChecks_ = java.util.Collections.emptyList();
      } else {
        readinessChecks_ = null;
        readinessChecksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      replicaZones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      degraded_ = false;
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00080000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workstations.v1.WorkstationsProto
          .internal_static_google_cloud_workstations_v1_WorkstationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig getDefaultInstanceForType() {
      return com.google.cloud.workstations.v1.WorkstationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig build() {
      com.google.cloud.workstations.v1.WorkstationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1.WorkstationConfig buildPartial() {
      com.google.cloud.workstations.v1.WorkstationConfig result =
          new com.google.cloud.workstations.v1.WorkstationConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.workstations.v1.WorkstationConfig result) {
      if (persistentDirectoriesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          persistentDirectories_ = java.util.Collections.unmodifiableList(persistentDirectories_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.persistentDirectories_ = persistentDirectories_;
      } else {
        result.persistentDirectories_ = persistentDirectoriesBuilder_.build();
      }
      if (readinessChecksBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          readinessChecks_ = java.util.Collections.unmodifiableList(readinessChecks_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.readinessChecks_ = readinessChecks_;
      } else {
        result.readinessChecks_ = readinessChecksBuilder_.build();
      }
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00080000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.workstations.v1.WorkstationConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.idleTimeout_ =
            idleTimeoutBuilder_ == null ? idleTimeout_ : idleTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.runningTimeout_ =
            runningTimeoutBuilder_ == null ? runningTimeout_ : runningTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.host_ = hostBuilder_ == null ? host_ : hostBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.container_ = containerBuilder_ == null ? container_ : containerBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.encryptionKey_ =
            encryptionKeyBuilder_ == null ? encryptionKey_ : encryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        replicaZones_.makeImmutable();
        result.replicaZones_ = replicaZones_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.degraded_ = degraded_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workstations.v1.WorkstationConfig) {
        return mergeFrom((com.google.cloud.workstations.v1.WorkstationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.workstations.v1.WorkstationConfig other) {
      if (other == com.google.cloud.workstations.v1.WorkstationConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasIdleTimeout()) {
        mergeIdleTimeout(other.getIdleTimeout());
      }
      if (other.hasRunningTimeout()) {
        mergeRunningTimeout(other.getRunningTimeout());
      }
      if (other.hasHost()) {
        mergeHost(other.getHost());
      }
      if (persistentDirectoriesBuilder_ == null) {
        if (!other.persistentDirectories_.isEmpty()) {
          if (persistentDirectories_.isEmpty()) {
            persistentDirectories_ = other.persistentDirectories_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensurePersistentDirectoriesIsMutable();
            persistentDirectories_.addAll(other.persistentDirectories_);
          }
          onChanged();
        }
      } else {
        if (!other.persistentDirectories_.isEmpty()) {
          if (persistentDirectoriesBuilder_.isEmpty()) {
            persistentDirectoriesBuilder_.dispose();
            persistentDirectoriesBuilder_ = null;
            persistentDirectories_ = other.persistentDirectories_;
            bitField0_ = (bitField0_ & ~0x00002000);
            persistentDirectoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPersistentDirectoriesFieldBuilder()
                    : null;
          } else {
            persistentDirectoriesBuilder_.addAllMessages(other.persistentDirectories_);
          }
        }
      }
      if (other.hasContainer()) {
        mergeContainer(other.getContainer());
      }
      if (other.hasEncryptionKey()) {
        mergeEncryptionKey(other.getEncryptionKey());
      }
      if (readinessChecksBuilder_ == null) {
        if (!other.readinessChecks_.isEmpty()) {
          if (readinessChecks_.isEmpty()) {
            readinessChecks_ = other.readinessChecks_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureReadinessChecksIsMutable();
            readinessChecks_.addAll(other.readinessChecks_);
          }
          onChanged();
        }
      } else {
        if (!other.readinessChecks_.isEmpty()) {
          if (readinessChecksBuilder_.isEmpty()) {
            readinessChecksBuilder_.dispose();
            readinessChecksBuilder_ = null;
            readinessChecks_ = other.readinessChecks_;
            bitField0_ = (bitField0_ & ~0x00010000);
            readinessChecksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReadinessChecksFieldBuilder()
                    : null;
          } else {
            readinessChecksBuilder_.addAllMessages(other.readinessChecks_);
          }
        }
      }
      if (!other.replicaZones_.isEmpty()) {
        if (replicaZones_.isEmpty()) {
          replicaZones_ = other.replicaZones_;
          bitField0_ |= 0x00020000;
        } else {
          ensureReplicaZonesIsMutable();
          replicaZones_.addAll(other.replicaZones_);
        }
        onChanged();
      }
      if (other.getDegraded() != false) {
        setDegraded(other.getDegraded());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00080000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00080000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getIdleTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getRunningTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getHostFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory m =
                    input.readMessage(
                        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                            .parser(),
                        extensionRegistry);
                if (persistentDirectoriesBuilder_ == null) {
                  ensurePersistentDirectoriesIsMutable();
                  persistentDirectories_.add(m);
                } else {
                  persistentDirectoriesBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getContainerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 114
            case 120:
              {
                degraded_ = input.readBool();
                bitField0_ |= 0x00040000;
                break;
              } // case 120
            case 130:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            case 146:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 146
            case 154:
              {
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck m =
                    input.readMessage(
                        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.parser(),
                        extensionRegistry);
                if (readinessChecksBuilder_ == null) {
                  ensureReadinessChecksIsMutable();
                  readinessChecks_.add(m);
                } else {
                  readinessChecksBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 186:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReplicaZonesIsMutable();
                replicaZones_.add(s);
                break;
              } // case 186
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Full name of this workstation configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Full name of this workstation configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation configuration.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation configuration.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation configuration.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation configuration.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human-readable name for this workstation configuration.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * configuration.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * configuration.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * configuration.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * configuration.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-assigned unique identifier for this workstation
     * configuration.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean reconciling_;

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation configuration is currently
     * being updated to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation configuration is currently
     * being updated to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this workstation configuration is currently
     * being updated to match its intended state.
     * </pre>
     *
     * <code>bool reconciling = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000008);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Client-specified annotations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional.
     * [Labels](https://cloud.google.com/workstations/docs/label-resources) that
     * are applied to the workstation configuration and that are also propagated
     * to the underlying Compute Engine resources.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was most recently
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when this workstation configuration was soft-deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Checksum computed by the server. May be sent on update and delete
     * requests to make sure that the client has an up-to-date value before
     * proceeding.
     * </pre>
     *
     * <code>string etag = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration idleTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        idleTimeoutBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the idleTimeout field is set.
     */
    public boolean hasIdleTimeout() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The idleTimeout.
     */
    public com.google.protobuf.Duration getIdleTimeout() {
      if (idleTimeoutBuilder_ == null) {
        return idleTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : idleTimeout_;
      } else {
        return idleTimeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIdleTimeout(com.google.protobuf.Duration value) {
      if (idleTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        idleTimeout_ = value;
      } else {
        idleTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIdleTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (idleTimeoutBuilder_ == null) {
        idleTimeout_ = builderForValue.build();
      } else {
        idleTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeIdleTimeout(com.google.protobuf.Duration value) {
      if (idleTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && idleTimeout_ != null
            && idleTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getIdleTimeoutBuilder().mergeFrom(value);
        } else {
          idleTimeout_ = value;
        }
      } else {
        idleTimeoutBuilder_.mergeFrom(value);
      }
      if (idleTimeout_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIdleTimeout() {
      bitField0_ = (bitField0_ & ~0x00000400);
      idleTimeout_ = null;
      if (idleTimeoutBuilder_ != null) {
        idleTimeoutBuilder_.dispose();
        idleTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getIdleTimeoutBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getIdleTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getIdleTimeoutOrBuilder() {
      if (idleTimeoutBuilder_ != null) {
        return idleTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return idleTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : idleTimeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds to wait before automatically stopping a
     * workstation after it last received user traffic.
     *
     * A value of `"0s"` indicates that Cloud Workstations VMs created with this
     * configuration should never time out due to idleness.
     * Provide
     * [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
     * terminated by `s` for seconds—for example, `"7200s"` (2 hours).
     * The default is `"1200s"` (20 minutes).
     * </pre>
     *
     * <code>.google.protobuf.Duration idle_timeout = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getIdleTimeoutFieldBuilder() {
      if (idleTimeoutBuilder_ == null) {
        idleTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getIdleTimeout(), getParentForChildren(), isClean());
        idleTimeout_ = null;
      }
      return idleTimeoutBuilder_;
    }

    private com.google.protobuf.Duration runningTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        runningTimeoutBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runningTimeout field is set.
     */
    public boolean hasRunningTimeout() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runningTimeout.
     */
    public com.google.protobuf.Duration getRunningTimeout() {
      if (runningTimeoutBuilder_ == null) {
        return runningTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : runningTimeout_;
      } else {
        return runningTimeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRunningTimeout(com.google.protobuf.Duration value) {
      if (runningTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runningTimeout_ = value;
      } else {
        runningTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRunningTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (runningTimeoutBuilder_ == null) {
        runningTimeout_ = builderForValue.build();
      } else {
        runningTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRunningTimeout(com.google.protobuf.Duration value) {
      if (runningTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && runningTimeout_ != null
            && runningTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getRunningTimeoutBuilder().mergeFrom(value);
        } else {
          runningTimeout_ = value;
        }
      } else {
        runningTimeoutBuilder_.mergeFrom(value);
      }
      if (runningTimeout_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRunningTimeout() {
      bitField0_ = (bitField0_ & ~0x00000800);
      runningTimeout_ = null;
      if (runningTimeoutBuilder_ != null) {
        runningTimeoutBuilder_.dispose();
        runningTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getRunningTimeoutBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRunningTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getRunningTimeoutOrBuilder() {
      if (runningTimeoutBuilder_ != null) {
        return runningTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return runningTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : runningTimeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of seconds that a workstation can run until it is
     * automatically shut down. We recommend that workstations be shut down daily
     * to reduce costs and so that security updates can be applied upon restart.
     * The
     * [idle_timeout][google.cloud.workstations.v1.WorkstationConfig.idle_timeout]
     * and
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * fields are independent of each other. Note that the
     * [running_timeout][google.cloud.workstations.v1.WorkstationConfig.running_timeout]
     * field shuts down VMs after the specified time, regardless of whether or not
     * the VMs are idle.
     *
     * Provide duration terminated by `s` for seconds—for example, `"54000s"`
     * (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
     * that workstations using this configuration should never time out. If
     * [encryption_key][google.cloud.workstations.v1.WorkstationConfig.encryption_key]
     * is set, it must be greater than `"0s"` and less than
     * `"86400s"` (24 hours).
     *
     * Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
     * with this configuration have no maximum running time. This is strongly
     * discouraged because you incur costs and will not pick up security updates.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration running_timeout = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRunningTimeoutFieldBuilder() {
      if (runningTimeoutBuilder_ == null) {
        runningTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getRunningTimeout(), getParentForChildren(), isClean());
        runningTimeout_ = null;
      }
      return runningTimeoutBuilder_;
    }

    private com.google.cloud.workstations.v1.WorkstationConfig.Host host_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.Host,
            com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.HostOrBuilder>
        hostBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the host field is set.
     */
    public boolean hasHost() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The host.
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Host getHost() {
      if (hostBuilder_ == null) {
        return host_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance()
            : host_;
      } else {
        return hostBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHost(com.google.cloud.workstations.v1.WorkstationConfig.Host value) {
      if (hostBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        host_ = value;
      } else {
        hostBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHost(
        com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder builderForValue) {
      if (hostBuilder_ == null) {
        host_ = builderForValue.build();
      } else {
        hostBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHost(com.google.cloud.workstations.v1.WorkstationConfig.Host value) {
      if (hostBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && host_ != null
            && host_
                != com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance()) {
          getHostBuilder().mergeFrom(value);
        } else {
          host_ = value;
        }
      } else {
        hostBuilder_.mergeFrom(value);
      }
      if (host_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHost() {
      bitField0_ = (bitField0_ & ~0x00001000);
      host_ = null;
      if (hostBuilder_ != null) {
        hostBuilder_.dispose();
        hostBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder getHostBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getHostFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.HostOrBuilder getHostOrBuilder() {
      if (hostBuilder_ != null) {
        return hostBuilder_.getMessageOrBuilder();
      } else {
        return host_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Host.getDefaultInstance()
            : host_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Runtime host for the workstation.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Host host = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.Host,
            com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.HostOrBuilder>
        getHostFieldBuilder() {
      if (hostBuilder_ == null) {
        hostBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.Host,
                com.google.cloud.workstations.v1.WorkstationConfig.Host.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.HostOrBuilder>(
                getHost(), getParentForChildren(), isClean());
        host_ = null;
      }
      return hostBuilder_;
    }

    private java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory>
        persistentDirectories_ = java.util.Collections.emptyList();

    private void ensurePersistentDirectoriesIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        persistentDirectories_ =
            new java.util.ArrayList<
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory>(
                persistentDirectories_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory,
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder>
        persistentDirectoriesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory>
        getPersistentDirectoriesList() {
      if (persistentDirectoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(persistentDirectories_);
      } else {
        return persistentDirectoriesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPersistentDirectoriesCount() {
      if (persistentDirectoriesBuilder_ == null) {
        return persistentDirectories_.size();
      } else {
        return persistentDirectoriesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
        getPersistentDirectories(int index) {
      if (persistentDirectoriesBuilder_ == null) {
        return persistentDirectories_.get(index);
      } else {
        return persistentDirectoriesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPersistentDirectories(
        int index, com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory value) {
      if (persistentDirectoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.set(index, value);
        onChanged();
      } else {
        persistentDirectoriesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPersistentDirectories(
        int index,
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
            builderForValue) {
      if (persistentDirectoriesBuilder_ == null) {
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.set(index, builderForValue.build());
        onChanged();
      } else {
        persistentDirectoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPersistentDirectories(
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory value) {
      if (persistentDirectoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.add(value);
        onChanged();
      } else {
        persistentDirectoriesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPersistentDirectories(
        int index, com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory value) {
      if (persistentDirectoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.add(index, value);
        onChanged();
      } else {
        persistentDirectoriesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPersistentDirectories(
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
            builderForValue) {
      if (persistentDirectoriesBuilder_ == null) {
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.add(builderForValue.build());
        onChanged();
      } else {
        persistentDirectoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPersistentDirectories(
        int index,
        com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
            builderForValue) {
      if (persistentDirectoriesBuilder_ == null) {
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.add(index, builderForValue.build());
        onChanged();
      } else {
        persistentDirectoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPersistentDirectories(
        java.lang.Iterable<
                ? extends com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory>
            values) {
      if (persistentDirectoriesBuilder_ == null) {
        ensurePersistentDirectoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, persistentDirectories_);
        onChanged();
      } else {
        persistentDirectoriesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPersistentDirectories() {
      if (persistentDirectoriesBuilder_ == null) {
        persistentDirectories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        persistentDirectoriesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePersistentDirectories(int index) {
      if (persistentDirectoriesBuilder_ == null) {
        ensurePersistentDirectoriesIsMutable();
        persistentDirectories_.remove(index);
        onChanged();
      } else {
        persistentDirectoriesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
        getPersistentDirectoriesBuilder(int index) {
      return getPersistentDirectoriesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder
        getPersistentDirectoriesOrBuilder(int index) {
      if (persistentDirectoriesBuilder_ == null) {
        return persistentDirectories_.get(index);
      } else {
        return persistentDirectoriesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder>
        getPersistentDirectoriesOrBuilderList() {
      if (persistentDirectoriesBuilder_ != null) {
        return persistentDirectoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(persistentDirectories_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
        addPersistentDirectoriesBuilder() {
      return getPersistentDirectoriesFieldBuilder()
          .addBuilder(
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder
        addPersistentDirectoriesBuilder(int index) {
      return getPersistentDirectoriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Directories to persist across workstation sessions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory persistent_directories = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder>
        getPersistentDirectoriesBuilderList() {
      return getPersistentDirectoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory,
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder>
        getPersistentDirectoriesFieldBuilder() {
      if (persistentDirectoriesBuilder_ == null) {
        persistentDirectoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory,
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectory.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.PersistentDirectoryOrBuilder>(
                persistentDirectories_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        persistentDirectories_ = null;
      }
      return persistentDirectoriesBuilder_;
    }

    private com.google.cloud.workstations.v1.WorkstationConfig.Container container_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.Container,
            com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.ContainerOrBuilder>
        containerBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the container field is set.
     */
    public boolean hasContainer() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The container.
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Container getContainer() {
      if (containerBuilder_ == null) {
        return container_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Container.getDefaultInstance()
            : container_;
      } else {
        return containerBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContainer(
        com.google.cloud.workstations.v1.WorkstationConfig.Container value) {
      if (containerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        container_ = value;
      } else {
        containerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContainer(
        com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder builderForValue) {
      if (containerBuilder_ == null) {
        container_ = builderForValue.build();
      } else {
        containerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeContainer(
        com.google.cloud.workstations.v1.WorkstationConfig.Container value) {
      if (containerBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && container_ != null
            && container_
                != com.google.cloud.workstations.v1.WorkstationConfig.Container
                    .getDefaultInstance()) {
          getContainerBuilder().mergeFrom(value);
        } else {
          container_ = value;
        }
      } else {
        containerBuilder_.mergeFrom(value);
      }
      if (container_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContainer() {
      bitField0_ = (bitField0_ & ~0x00004000);
      container_ = null;
      if (containerBuilder_ != null) {
        containerBuilder_.dispose();
        containerBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder
        getContainerBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getContainerFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.ContainerOrBuilder
        getContainerOrBuilder() {
      if (containerBuilder_ != null) {
        return containerBuilder_.getMessageOrBuilder();
      } else {
        return container_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.Container.getDefaultInstance()
            : container_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Container that runs upon startup for each workstation using this
     * workstation configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.Container container = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.Container,
            com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.ContainerOrBuilder>
        getContainerFieldBuilder() {
      if (containerBuilder_ == null) {
        containerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.Container,
                com.google.cloud.workstations.v1.WorkstationConfig.Container.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.ContainerOrBuilder>(
                getContainer(), getParentForChildren(), isClean());
        container_ = null;
      }
      return containerBuilder_;
    }

    private com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey,
            com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKeyOrBuilder>
        encryptionKeyBuilder_;

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the encryptionKey field is set.
     */
    public boolean hasEncryptionKey() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The encryptionKey.
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
        getEncryptionKey() {
      if (encryptionKeyBuilder_ == null) {
        return encryptionKey_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
                .getDefaultInstance()
            : encryptionKey_;
      } else {
        return encryptionKeyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEncryptionKey(
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey value) {
      if (encryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionKey_ = value;
      } else {
        encryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setEncryptionKey(
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder
            builderForValue) {
      if (encryptionKeyBuilder_ == null) {
        encryptionKey_ = builderForValue.build();
      } else {
        encryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeEncryptionKey(
        com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey value) {
      if (encryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && encryptionKey_ != null
            && encryptionKey_
                != com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
                    .getDefaultInstance()) {
          getEncryptionKeyBuilder().mergeFrom(value);
        } else {
          encryptionKey_ = value;
        }
      } else {
        encryptionKeyBuilder_.mergeFrom(value);
      }
      if (encryptionKey_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00008000);
      encryptionKey_ = null;
      if (encryptionKeyBuilder_ != null) {
        encryptionKeyBuilder_.dispose();
        encryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder
        getEncryptionKeyBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getEncryptionKeyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKeyOrBuilder
        getEncryptionKeyOrBuilder() {
      if (encryptionKeyBuilder_ != null) {
        return encryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return encryptionKey_ == null
            ? com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey
                .getDefaultInstance()
            : encryptionKey_;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Encrypts resources of this workstation configuration using a
     * customer-managed encryption key (CMEK).
     *
     * If specified, the boot disk of the Compute Engine instance and the
     * persistent disk are encrypted using this encryption key. If
     * this field is not set, the disks are encrypted using a generated
     * key. Customer-managed encryption keys do not protect disk metadata.
     *
     * If the customer-managed encryption key is rotated, when the workstation
     * instance is stopped, the system attempts to recreate the
     * persistent disk with the new version of the key. Be sure to keep
     * older versions of the key until the persistent disk is recreated.
     * Otherwise, data on the persistent disk might be lost.
     *
     * If the encryption key is revoked, the workstation session automatically
     * stops within 7 hours.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * .google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey encryption_key = 17 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey,
            com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKeyOrBuilder>
        getEncryptionKeyFieldBuilder() {
      if (encryptionKeyBuilder_ == null) {
        encryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey,
                com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKey.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.CustomerEncryptionKeyOrBuilder>(
                getEncryptionKey(), getParentForChildren(), isClean());
        encryptionKey_ = null;
      }
      return encryptionKeyBuilder_;
    }

    private java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck>
        readinessChecks_ = java.util.Collections.emptyList();

    private void ensureReadinessChecksIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        readinessChecks_ =
            new java.util.ArrayList<
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck>(
                readinessChecks_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck,
            com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder>
        readinessChecksBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck>
        getReadinessChecksList() {
      if (readinessChecksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(readinessChecks_);
      } else {
        return readinessChecksBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getReadinessChecksCount() {
      if (readinessChecksBuilder_ == null) {
        return readinessChecks_.size();
      } else {
        return readinessChecksBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck getReadinessChecks(
        int index) {
      if (readinessChecksBuilder_ == null) {
        return readinessChecks_.get(index);
      } else {
        return readinessChecksBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadinessChecks(
        int index, com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck value) {
      if (readinessChecksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReadinessChecksIsMutable();
        readinessChecks_.set(index, value);
        onChanged();
      } else {
        readinessChecksBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadinessChecks(
        int index,
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder builderForValue) {
      if (readinessChecksBuilder_ == null) {
        ensureReadinessChecksIsMutable();
        readinessChecks_.set(index, builderForValue.build());
        onChanged();
      } else {
        readinessChecksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReadinessChecks(
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck value) {
      if (readinessChecksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReadinessChecksIsMutable();
        readinessChecks_.add(value);
        onChanged();
      } else {
        readinessChecksBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReadinessChecks(
        int index, com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck value) {
      if (readinessChecksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReadinessChecksIsMutable();
        readinessChecks_.add(index, value);
        onChanged();
      } else {
        readinessChecksBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReadinessChecks(
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder builderForValue) {
      if (readinessChecksBuilder_ == null) {
        ensureReadinessChecksIsMutable();
        readinessChecks_.add(builderForValue.build());
        onChanged();
      } else {
        readinessChecksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addReadinessChecks(
        int index,
        com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder builderForValue) {
      if (readinessChecksBuilder_ == null) {
        ensureReadinessChecksIsMutable();
        readinessChecks_.add(index, builderForValue.build());
        onChanged();
      } else {
        readinessChecksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllReadinessChecks(
        java.lang.Iterable<
                ? extends com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck>
            values) {
      if (readinessChecksBuilder_ == null) {
        ensureReadinessChecksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, readinessChecks_);
        onChanged();
      } else {
        readinessChecksBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReadinessChecks() {
      if (readinessChecksBuilder_ == null) {
        readinessChecks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        readinessChecksBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeReadinessChecks(int index) {
      if (readinessChecksBuilder_ == null) {
        ensureReadinessChecksIsMutable();
        readinessChecks_.remove(index);
        onChanged();
      } else {
        readinessChecksBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder
        getReadinessChecksBuilder(int index) {
      return getReadinessChecksFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder
        getReadinessChecksOrBuilder(int index) {
      if (readinessChecksBuilder_ == null) {
        return readinessChecks_.get(index);
      } else {
        return readinessChecksBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder>
        getReadinessChecksOrBuilderList() {
      if (readinessChecksBuilder_ != null) {
        return readinessChecksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(readinessChecks_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder
        addReadinessChecksBuilder() {
      return getReadinessChecksFieldBuilder()
          .addBuilder(
              com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder
        addReadinessChecksBuilder(int index) {
      return getReadinessChecksFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Readiness checks to perform when starting a workstation using
     * this workstation configuration. Mark a workstation as running only after
     * all specified readiness checks return 200 status codes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck readiness_checks = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder>
        getReadinessChecksBuilderList() {
      return getReadinessChecksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck,
            com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder,
            com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder>
        getReadinessChecksFieldBuilder() {
      if (readinessChecksBuilder_ == null) {
        readinessChecksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck,
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheck.Builder,
                com.google.cloud.workstations.v1.WorkstationConfig.ReadinessCheckOrBuilder>(
                readinessChecks_,
                ((bitField0_ & 0x00010000) != 0),
                getParentForChildren(),
                isClean());
        readinessChecks_ = null;
      }
      return readinessChecksBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList replicaZones_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReplicaZonesIsMutable() {
      if (!replicaZones_.isModifiable()) {
        replicaZones_ = new com.google.protobuf.LazyStringArrayList(replicaZones_);
      }
      bitField0_ |= 0x00020000;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return A list containing the replicaZones.
     */
    public com.google.protobuf.ProtocolStringList getReplicaZonesList() {
      replicaZones_.makeImmutable();
      return replicaZones_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The count of replicaZones.
     */
    public int getReplicaZonesCount() {
      return replicaZones_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The replicaZones at the given index.
     */
    public java.lang.String getReplicaZones(int index) {
      return replicaZones_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the replicaZones at the given index.
     */
    public com.google.protobuf.ByteString getReplicaZonesBytes(int index) {
      return replicaZones_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The replicaZones to set.
     * @return This builder for chaining.
     */
    public Builder setReplicaZones(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReplicaZonesIsMutable();
      replicaZones_.set(index, value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The replicaZones to add.
     * @return This builder for chaining.
     */
    public Builder addReplicaZones(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReplicaZonesIsMutable();
      replicaZones_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param values The replicaZones to add.
     * @return This builder for chaining.
     */
    public Builder addAllReplicaZones(java.lang.Iterable<java.lang.String> values) {
      ensureReplicaZonesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicaZones_);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicaZones() {
      replicaZones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00020000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. Specifies the zones used to replicate the VM and disk
     * resources within the region. If set, exactly two zones within the
     * workstation cluster's region must be specified—for example,
     * `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
     * zones within the region are used.
     *
     * Immutable after the workstation configuration is created.
     * </pre>
     *
     * <code>
     * repeated string replica_zones = 23 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes of the replicaZones to add.
     * @return This builder for chaining.
     */
    public Builder addReplicaZonesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReplicaZonesIsMutable();
      replicaZones_.add(value);
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private boolean degraded_;

    /**
     *
     *
     * <pre>
     * Output only. Whether this resource is degraded, in which case it may
     * require user action to restore full functionality. See also the
     * [conditions][google.cloud.workstations.v1.WorkstationConfig.conditions]
     * field.
     * </pre>
     *
     * <code>bool degraded = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The degraded.
     */
    @java.lang.Override
    public boolean getDegraded() {
      return degraded_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether this resource is degraded, in which case it may
     * require user action to restore full functionality. See also the
     * [conditions][google.cloud.workstations.v1.WorkstationConfig.conditions]
     * field.
     * </pre>
     *
     * <code>bool degraded = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The degraded to set.
     * @return This builder for chaining.
     */
    public Builder setDegraded(boolean value) {

      degraded_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether this resource is degraded, in which case it may
     * require user action to restore full functionality. See also the
     * [conditions][google.cloud.workstations.v1.WorkstationConfig.conditions]
     * field.
     * </pre>
     *
     * <code>bool degraded = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDegraded() {
      bitField0_ = (bitField0_ & ~0x00040000);
      degraded_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> conditions_ = java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00080000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.rpc.Status>(conditions_);
        bitField0_ |= 0x00080000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.rpc.Status value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.rpc.Status.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.rpc.Status value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.rpc.Status value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.rpc.Status.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.rpc.Status.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConditions(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00080000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Status conditions describing the current resource state.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status conditions = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                conditions_, ((bitField0_ & 0x00080000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1.WorkstationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1.WorkstationConfig)
  private static final com.google.cloud.workstations.v1.WorkstationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workstations.v1.WorkstationConfig();
  }

  public static com.google.cloud.workstations.v1.WorkstationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkstationConfig> PARSER =
      new com.google.protobuf.AbstractParser<WorkstationConfig>() {
        @java.lang.Override
        public WorkstationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkstationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkstationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workstations.v1.WorkstationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
