/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkstationClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKSTATION_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workstationClusters/{workstation_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workstationCluster;

    @Deprecated
    protected WorkstationClusterName() {
        this.project = null;
        this.location = null;
        this.workstationCluster = null;
    }

    private WorkstationClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workstationCluster = (String)Preconditions.checkNotNull((Object)builder.getWorkstationCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkstationCluster() {
        return this.workstationCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkstationClusterName of(String project, String location, String workstationCluster) {
        return WorkstationClusterName.newBuilder().setProject(project).setLocation(location).setWorkstationCluster(workstationCluster).build();
    }

    public static String format(String project, String location, String workstationCluster) {
        return WorkstationClusterName.newBuilder().setProject(project).setLocation(location).setWorkstationCluster(workstationCluster).build().toString();
    }

    public static WorkstationClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKSTATION_CLUSTER.validatedMatch(formattedString, "WorkstationClusterName.parse: formattedString not in valid format");
        return WorkstationClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workstation_cluster"));
    }

    public static List<WorkstationClusterName> parseList(List<String> formattedStrings) {
        ArrayList<WorkstationClusterName> list = new ArrayList<WorkstationClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkstationClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkstationClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkstationClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKSTATION_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkstationClusterName workstationClusterName = this;
            synchronized (workstationClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workstationCluster != null) {
                        fieldMapBuilder.put((Object)"workstation_cluster", (Object)this.workstationCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKSTATION_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "workstation_cluster", this.workstationCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkstationClusterName that = (WorkstationClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workstationCluster, that.workstationCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workstationCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workstationCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkstationCluster() {
            return this.workstationCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkstationCluster(String workstationCluster) {
            this.workstationCluster = workstationCluster;
            return this;
        }

        private Builder(WorkstationClusterName workstationClusterName) {
            this.project = workstationClusterName.project;
            this.location = workstationClusterName.location;
            this.workstationCluster = workstationClusterName.workstationCluster;
        }

        public WorkstationClusterName build() {
            return new WorkstationClusterName(this);
        }
    }
}

