/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/workstations/v1beta/workstations.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.workstations.v1beta;

/**
 *
 *
 * <pre>
 * Response message for ListWorkstations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.workstations.v1beta.ListWorkstationsResponse}
 */
public final class ListWorkstationsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.workstations.v1beta.ListWorkstationsResponse)
    ListWorkstationsResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListWorkstationsResponse.newBuilder() to construct.
  private ListWorkstationsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListWorkstationsResponse() {
    workstations_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListWorkstationsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.workstations.v1beta.WorkstationsProto
        .internal_static_google_cloud_workstations_v1beta_ListWorkstationsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.workstations.v1beta.WorkstationsProto
        .internal_static_google_cloud_workstations_v1beta_ListWorkstationsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.workstations.v1beta.ListWorkstationsResponse.class,
            com.google.cloud.workstations.v1beta.ListWorkstationsResponse.Builder.class);
  }

  public static final int WORKSTATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.workstations.v1beta.Workstation> workstations_;

  /**
   *
   *
   * <pre>
   * The requested workstations.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.workstations.v1beta.Workstation> getWorkstationsList() {
    return workstations_;
  }

  /**
   *
   *
   * <pre>
   * The requested workstations.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.workstations.v1beta.WorkstationOrBuilder>
      getWorkstationsOrBuilderList() {
    return workstations_;
  }

  /**
   *
   *
   * <pre>
   * The requested workstations.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
   */
  @java.lang.Override
  public int getWorkstationsCount() {
    return workstations_.size();
  }

  /**
   *
   *
   * <pre>
   * The requested workstations.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1beta.Workstation getWorkstations(int index) {
    return workstations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The requested workstations.
   * </pre>
   *
   * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.workstations.v1beta.WorkstationOrBuilder getWorkstationsOrBuilder(
      int index) {
    return workstations_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Token to retrieve the next page of results, or empty if there are
   * no more results in the list.
   * </pre>
   *
   * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Token to retrieve the next page of results, or empty if there are
   * no more results in the list.
   * </pre>
   *
   * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unreachable_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Unreachable resources.
   * </pre>
   *
   * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < workstations_.size(); i++) {
      output.writeMessage(1, workstations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < workstations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, workstations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.workstations.v1beta.ListWorkstationsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.workstations.v1beta.ListWorkstationsResponse other =
        (com.google.cloud.workstations.v1beta.ListWorkstationsResponse) obj;

    if (!getWorkstationsList().equals(other.getWorkstationsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getWorkstationsCount() > 0) {
      hash = (37 * hash) + WORKSTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getWorkstationsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.workstations.v1beta.ListWorkstationsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for ListWorkstations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.workstations.v1beta.ListWorkstationsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.workstations.v1beta.ListWorkstationsResponse)
      com.google.cloud.workstations.v1beta.ListWorkstationsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.workstations.v1beta.WorkstationsProto
          .internal_static_google_cloud_workstations_v1beta_ListWorkstationsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.workstations.v1beta.WorkstationsProto
          .internal_static_google_cloud_workstations_v1beta_ListWorkstationsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.workstations.v1beta.ListWorkstationsResponse.class,
              com.google.cloud.workstations.v1beta.ListWorkstationsResponse.Builder.class);
    }

    // Construct using com.google.cloud.workstations.v1beta.ListWorkstationsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (workstationsBuilder_ == null) {
        workstations_ = java.util.Collections.emptyList();
      } else {
        workstations_ = null;
        workstationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.workstations.v1beta.WorkstationsProto
          .internal_static_google_cloud_workstations_v1beta_ListWorkstationsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1beta.ListWorkstationsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.workstations.v1beta.ListWorkstationsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1beta.ListWorkstationsResponse build() {
      com.google.cloud.workstations.v1beta.ListWorkstationsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.workstations.v1beta.ListWorkstationsResponse buildPartial() {
      com.google.cloud.workstations.v1beta.ListWorkstationsResponse result =
          new com.google.cloud.workstations.v1beta.ListWorkstationsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.workstations.v1beta.ListWorkstationsResponse result) {
      if (workstationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          workstations_ = java.util.Collections.unmodifiableList(workstations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.workstations_ = workstations_;
      } else {
        result.workstations_ = workstationsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.workstations.v1beta.ListWorkstationsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        unreachable_.makeImmutable();
        result.unreachable_ = unreachable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.workstations.v1beta.ListWorkstationsResponse) {
        return mergeFrom((com.google.cloud.workstations.v1beta.ListWorkstationsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.workstations.v1beta.ListWorkstationsResponse other) {
      if (other
          == com.google.cloud.workstations.v1beta.ListWorkstationsResponse.getDefaultInstance())
        return this;
      if (workstationsBuilder_ == null) {
        if (!other.workstations_.isEmpty()) {
          if (workstations_.isEmpty()) {
            workstations_ = other.workstations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWorkstationsIsMutable();
            workstations_.addAll(other.workstations_);
          }
          onChanged();
        }
      } else {
        if (!other.workstations_.isEmpty()) {
          if (workstationsBuilder_.isEmpty()) {
            workstationsBuilder_.dispose();
            workstationsBuilder_ = null;
            workstations_ = other.workstations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            workstationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWorkstationsFieldBuilder()
                    : null;
          } else {
            workstationsBuilder_.addAllMessages(other.workstations_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ |= 0x00000004;
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.workstations.v1beta.Workstation m =
                    input.readMessage(
                        com.google.cloud.workstations.v1beta.Workstation.parser(),
                        extensionRegistry);
                if (workstationsBuilder_ == null) {
                  ensureWorkstationsIsMutable();
                  workstations_.add(m);
                } else {
                  workstationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.workstations.v1beta.Workstation> workstations_ =
        java.util.Collections.emptyList();

    private void ensureWorkstationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        workstations_ =
            new java.util.ArrayList<com.google.cloud.workstations.v1beta.Workstation>(
                workstations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1beta.Workstation,
            com.google.cloud.workstations.v1beta.Workstation.Builder,
            com.google.cloud.workstations.v1beta.WorkstationOrBuilder>
        workstationsBuilder_;

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public java.util.List<com.google.cloud.workstations.v1beta.Workstation> getWorkstationsList() {
      if (workstationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(workstations_);
      } else {
        return workstationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public int getWorkstationsCount() {
      if (workstationsBuilder_ == null) {
        return workstations_.size();
      } else {
        return workstationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public com.google.cloud.workstations.v1beta.Workstation getWorkstations(int index) {
      if (workstationsBuilder_ == null) {
        return workstations_.get(index);
      } else {
        return workstationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder setWorkstations(
        int index, com.google.cloud.workstations.v1beta.Workstation value) {
      if (workstationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkstationsIsMutable();
        workstations_.set(index, value);
        onChanged();
      } else {
        workstationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder setWorkstations(
        int index, com.google.cloud.workstations.v1beta.Workstation.Builder builderForValue) {
      if (workstationsBuilder_ == null) {
        ensureWorkstationsIsMutable();
        workstations_.set(index, builderForValue.build());
        onChanged();
      } else {
        workstationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder addWorkstations(com.google.cloud.workstations.v1beta.Workstation value) {
      if (workstationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkstationsIsMutable();
        workstations_.add(value);
        onChanged();
      } else {
        workstationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder addWorkstations(
        int index, com.google.cloud.workstations.v1beta.Workstation value) {
      if (workstationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWorkstationsIsMutable();
        workstations_.add(index, value);
        onChanged();
      } else {
        workstationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder addWorkstations(
        com.google.cloud.workstations.v1beta.Workstation.Builder builderForValue) {
      if (workstationsBuilder_ == null) {
        ensureWorkstationsIsMutable();
        workstations_.add(builderForValue.build());
        onChanged();
      } else {
        workstationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder addWorkstations(
        int index, com.google.cloud.workstations.v1beta.Workstation.Builder builderForValue) {
      if (workstationsBuilder_ == null) {
        ensureWorkstationsIsMutable();
        workstations_.add(index, builderForValue.build());
        onChanged();
      } else {
        workstationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder addAllWorkstations(
        java.lang.Iterable<? extends com.google.cloud.workstations.v1beta.Workstation> values) {
      if (workstationsBuilder_ == null) {
        ensureWorkstationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, workstations_);
        onChanged();
      } else {
        workstationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder clearWorkstations() {
      if (workstationsBuilder_ == null) {
        workstations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        workstationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public Builder removeWorkstations(int index) {
      if (workstationsBuilder_ == null) {
        ensureWorkstationsIsMutable();
        workstations_.remove(index);
        onChanged();
      } else {
        workstationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public com.google.cloud.workstations.v1beta.Workstation.Builder getWorkstationsBuilder(
        int index) {
      return getWorkstationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public com.google.cloud.workstations.v1beta.WorkstationOrBuilder getWorkstationsOrBuilder(
        int index) {
      if (workstationsBuilder_ == null) {
        return workstations_.get(index);
      } else {
        return workstationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.workstations.v1beta.WorkstationOrBuilder>
        getWorkstationsOrBuilderList() {
      if (workstationsBuilder_ != null) {
        return workstationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(workstations_);
      }
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public com.google.cloud.workstations.v1beta.Workstation.Builder addWorkstationsBuilder() {
      return getWorkstationsFieldBuilder()
          .addBuilder(com.google.cloud.workstations.v1beta.Workstation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public com.google.cloud.workstations.v1beta.Workstation.Builder addWorkstationsBuilder(
        int index) {
      return getWorkstationsFieldBuilder()
          .addBuilder(index, com.google.cloud.workstations.v1beta.Workstation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The requested workstations.
     * </pre>
     *
     * <code>repeated .google.cloud.workstations.v1beta.Workstation workstations = 1;</code>
     */
    public java.util.List<com.google.cloud.workstations.v1beta.Workstation.Builder>
        getWorkstationsBuilderList() {
      return getWorkstationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.workstations.v1beta.Workstation,
            com.google.cloud.workstations.v1beta.Workstation.Builder,
            com.google.cloud.workstations.v1beta.WorkstationOrBuilder>
        getWorkstationsFieldBuilder() {
      if (workstationsBuilder_ == null) {
        workstationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.workstations.v1beta.Workstation,
                com.google.cloud.workstations.v1beta.Workstation.Builder,
                com.google.cloud.workstations.v1beta.WorkstationOrBuilder>(
                workstations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        workstations_ = null;
      }
      return workstationsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Token to retrieve the next page of results, or empty if there are
     * no more results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Token to retrieve the next page of results, or empty if there are
     * no more results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Token to retrieve the next page of results, or empty if there are
     * no more results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Token to retrieve the next page of results, or empty if there are
     * no more results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Token to retrieve the next page of results, or empty if there are
     * no more results in the list.
     * </pre>
     *
     * <code>string next_page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList unreachable_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnreachableIsMutable() {
      if (!unreachable_.isModifiable()) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      unreachable_.makeImmutable();
      return unreachable_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unreachable resources.
     * </pre>
     *
     * <code>repeated string unreachable = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.workstations.v1beta.ListWorkstationsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.workstations.v1beta.ListWorkstationsResponse)
  private static final com.google.cloud.workstations.v1beta.ListWorkstationsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.workstations.v1beta.ListWorkstationsResponse();
  }

  public static com.google.cloud.workstations.v1beta.ListWorkstationsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListWorkstationsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListWorkstationsResponse>() {
        @java.lang.Override
        public ListWorkstationsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListWorkstationsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListWorkstationsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.workstations.v1beta.ListWorkstationsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
