/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/rpc/error_details.proto

// Protobuf Java Version: 3.25.3
package com.google.rpc;

/**
 *
 *
 * <pre>
 * Describes violations in a client request. This error type focuses on the
 * syntactic aspects of the request.
 * </pre>
 *
 * Protobuf type {@code google.rpc.BadRequest}
 */
public final class BadRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.rpc.BadRequest)
    BadRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BadRequest.newBuilder() to construct.
  private BadRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BadRequest() {
    fieldViolations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BadRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_BadRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_BadRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.rpc.BadRequest.class, com.google.rpc.BadRequest.Builder.class);
  }

  public interface FieldViolationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.rpc.BadRequest.FieldViolation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A path that leads to a field in the request body. The value will be a
     * sequence of dot-separated identifiers that identify a protocol buffer
     * field.
     *
     * Consider the following:
     *
     *     message CreateContactRequest {
     *       message EmailAddress {
     *         enum Type {
     *           TYPE_UNSPECIFIED = 0;
     *           HOME = 1;
     *           WORK = 2;
     *         }
     *
     *         optional string email = 1;
     *         repeated EmailType type = 2;
     *       }
     *
     *       string full_name = 1;
     *       repeated EmailAddress email_addresses = 2;
     *     }
     *
     * In this example, in proto `field` could take one of the following values:
     *
     * * `full_name` for a violation in the `full_name` value
     * * `email_addresses[1].email` for a violation in the `email` field of the
     *   first `email_addresses` message
     * * `email_addresses[3].type[2]` for a violation in the second `type`
     *   value in the third `email_addresses` message.
     *
     * In JSON, the same values are represented as:
     *
     * * `fullName` for a violation in the `fullName` value
     * * `emailAddresses[1].email` for a violation in the `email` field of the
     *   first `emailAddresses` message
     * * `emailAddresses[3].type[2]` for a violation in the second `type`
     *   value in the third `emailAddresses` message.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The field.
     */
    java.lang.String getField();
    /**
     *
     *
     * <pre>
     * A path that leads to a field in the request body. The value will be a
     * sequence of dot-separated identifiers that identify a protocol buffer
     * field.
     *
     * Consider the following:
     *
     *     message CreateContactRequest {
     *       message EmailAddress {
     *         enum Type {
     *           TYPE_UNSPECIFIED = 0;
     *           HOME = 1;
     *           WORK = 2;
     *         }
     *
     *         optional string email = 1;
     *         repeated EmailType type = 2;
     *       }
     *
     *       string full_name = 1;
     *       repeated EmailAddress email_addresses = 2;
     *     }
     *
     * In this example, in proto `field` could take one of the following values:
     *
     * * `full_name` for a violation in the `full_name` value
     * * `email_addresses[1].email` for a violation in the `email` field of the
     *   first `email_addresses` message
     * * `email_addresses[3].type[2]` for a violation in the second `type`
     *   value in the third `email_addresses` message.
     *
     * In JSON, the same values are represented as:
     *
     * * `fullName` for a violation in the `fullName` value
     * * `emailAddresses[1].email` for a violation in the `email` field of the
     *   first `emailAddresses` message
     * * `emailAddresses[3].type[2]` for a violation in the second `type`
     *   value in the third `emailAddresses` message.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The bytes for field.
     */
    com.google.protobuf.ByteString getFieldBytes();

    /**
     *
     *
     * <pre>
     * A description of why the request element is bad.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();
    /**
     *
     *
     * <pre>
     * A description of why the request element is bad.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();
  }
  /**
   *
   *
   * <pre>
   * A message type used to describe a single bad request field.
   * </pre>
   *
   * Protobuf type {@code google.rpc.BadRequest.FieldViolation}
   */
  public static final class FieldViolation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.rpc.BadRequest.FieldViolation)
      FieldViolationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FieldViolation.newBuilder() to construct.
    private FieldViolation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldViolation() {
      field_ = "";
      description_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FieldViolation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.ErrorDetailsProto
          .internal_static_google_rpc_BadRequest_FieldViolation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.ErrorDetailsProto
          .internal_static_google_rpc_BadRequest_FieldViolation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.BadRequest.FieldViolation.class,
              com.google.rpc.BadRequest.FieldViolation.Builder.class);
    }

    public static final int FIELD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object field_ = "";
    /**
     *
     *
     * <pre>
     * A path that leads to a field in the request body. The value will be a
     * sequence of dot-separated identifiers that identify a protocol buffer
     * field.
     *
     * Consider the following:
     *
     *     message CreateContactRequest {
     *       message EmailAddress {
     *         enum Type {
     *           TYPE_UNSPECIFIED = 0;
     *           HOME = 1;
     *           WORK = 2;
     *         }
     *
     *         optional string email = 1;
     *         repeated EmailType type = 2;
     *       }
     *
     *       string full_name = 1;
     *       repeated EmailAddress email_addresses = 2;
     *     }
     *
     * In this example, in proto `field` could take one of the following values:
     *
     * * `full_name` for a violation in the `full_name` value
     * * `email_addresses[1].email` for a violation in the `email` field of the
     *   first `email_addresses` message
     * * `email_addresses[3].type[2]` for a violation in the second `type`
     *   value in the third `email_addresses` message.
     *
     * In JSON, the same values are represented as:
     *
     * * `fullName` for a violation in the `fullName` value
     * * `emailAddresses[1].email` for a violation in the `email` field of the
     *   first `emailAddresses` message
     * * `emailAddresses[3].type[2]` for a violation in the second `type`
     *   value in the third `emailAddresses` message.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The field.
     */
    @java.lang.Override
    public java.lang.String getField() {
      java.lang.Object ref = field_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        field_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A path that leads to a field in the request body. The value will be a
     * sequence of dot-separated identifiers that identify a protocol buffer
     * field.
     *
     * Consider the following:
     *
     *     message CreateContactRequest {
     *       message EmailAddress {
     *         enum Type {
     *           TYPE_UNSPECIFIED = 0;
     *           HOME = 1;
     *           WORK = 2;
     *         }
     *
     *         optional string email = 1;
     *         repeated EmailType type = 2;
     *       }
     *
     *       string full_name = 1;
     *       repeated EmailAddress email_addresses = 2;
     *     }
     *
     * In this example, in proto `field` could take one of the following values:
     *
     * * `full_name` for a violation in the `full_name` value
     * * `email_addresses[1].email` for a violation in the `email` field of the
     *   first `email_addresses` message
     * * `email_addresses[3].type[2]` for a violation in the second `type`
     *   value in the third `email_addresses` message.
     *
     * In JSON, the same values are represented as:
     *
     * * `fullName` for a violation in the `fullName` value
     * * `emailAddresses[1].email` for a violation in the `email` field of the
     *   first `emailAddresses` message
     * * `emailAddresses[3].type[2]` for a violation in the second `type`
     *   value in the third `emailAddresses` message.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The bytes for field.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFieldBytes() {
      java.lang.Object ref = field_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        field_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of why the request element is bad.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of why the request element is bad.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, field_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, field_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.rpc.BadRequest.FieldViolation)) {
        return super.equals(obj);
      }
      com.google.rpc.BadRequest.FieldViolation other =
          (com.google.rpc.BadRequest.FieldViolation) obj;

      if (!getField().equals(other.getField())) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getField().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.rpc.BadRequest.FieldViolation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.rpc.BadRequest.FieldViolation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A message type used to describe a single bad request field.
     * </pre>
     *
     * Protobuf type {@code google.rpc.BadRequest.FieldViolation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.rpc.BadRequest.FieldViolation)
        com.google.rpc.BadRequest.FieldViolationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.rpc.ErrorDetailsProto
            .internal_static_google_rpc_BadRequest_FieldViolation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.rpc.ErrorDetailsProto
            .internal_static_google_rpc_BadRequest_FieldViolation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.rpc.BadRequest.FieldViolation.class,
                com.google.rpc.BadRequest.FieldViolation.Builder.class);
      }

      // Construct using com.google.rpc.BadRequest.FieldViolation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        field_ = "";
        description_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.rpc.ErrorDetailsProto
            .internal_static_google_rpc_BadRequest_FieldViolation_descriptor;
      }

      @java.lang.Override
      public com.google.rpc.BadRequest.FieldViolation getDefaultInstanceForType() {
        return com.google.rpc.BadRequest.FieldViolation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.rpc.BadRequest.FieldViolation build() {
        com.google.rpc.BadRequest.FieldViolation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.rpc.BadRequest.FieldViolation buildPartial() {
        com.google.rpc.BadRequest.FieldViolation result =
            new com.google.rpc.BadRequest.FieldViolation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.rpc.BadRequest.FieldViolation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.field_ = field_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.rpc.BadRequest.FieldViolation) {
          return mergeFrom((com.google.rpc.BadRequest.FieldViolation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.rpc.BadRequest.FieldViolation other) {
        if (other == com.google.rpc.BadRequest.FieldViolation.getDefaultInstance()) return this;
        if (!other.getField().isEmpty()) {
          field_ = other.field_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  field_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object field_ = "";
      /**
       *
       *
       * <pre>
       * A path that leads to a field in the request body. The value will be a
       * sequence of dot-separated identifiers that identify a protocol buffer
       * field.
       *
       * Consider the following:
       *
       *     message CreateContactRequest {
       *       message EmailAddress {
       *         enum Type {
       *           TYPE_UNSPECIFIED = 0;
       *           HOME = 1;
       *           WORK = 2;
       *         }
       *
       *         optional string email = 1;
       *         repeated EmailType type = 2;
       *       }
       *
       *       string full_name = 1;
       *       repeated EmailAddress email_addresses = 2;
       *     }
       *
       * In this example, in proto `field` could take one of the following values:
       *
       * * `full_name` for a violation in the `full_name` value
       * * `email_addresses[1].email` for a violation in the `email` field of the
       *   first `email_addresses` message
       * * `email_addresses[3].type[2]` for a violation in the second `type`
       *   value in the third `email_addresses` message.
       *
       * In JSON, the same values are represented as:
       *
       * * `fullName` for a violation in the `fullName` value
       * * `emailAddresses[1].email` for a violation in the `email` field of the
       *   first `emailAddresses` message
       * * `emailAddresses[3].type[2]` for a violation in the second `type`
       *   value in the third `emailAddresses` message.
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @return The field.
       */
      public java.lang.String getField() {
        java.lang.Object ref = field_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          field_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A path that leads to a field in the request body. The value will be a
       * sequence of dot-separated identifiers that identify a protocol buffer
       * field.
       *
       * Consider the following:
       *
       *     message CreateContactRequest {
       *       message EmailAddress {
       *         enum Type {
       *           TYPE_UNSPECIFIED = 0;
       *           HOME = 1;
       *           WORK = 2;
       *         }
       *
       *         optional string email = 1;
       *         repeated EmailType type = 2;
       *       }
       *
       *       string full_name = 1;
       *       repeated EmailAddress email_addresses = 2;
       *     }
       *
       * In this example, in proto `field` could take one of the following values:
       *
       * * `full_name` for a violation in the `full_name` value
       * * `email_addresses[1].email` for a violation in the `email` field of the
       *   first `email_addresses` message
       * * `email_addresses[3].type[2]` for a violation in the second `type`
       *   value in the third `email_addresses` message.
       *
       * In JSON, the same values are represented as:
       *
       * * `fullName` for a violation in the `fullName` value
       * * `emailAddresses[1].email` for a violation in the `email` field of the
       *   first `emailAddresses` message
       * * `emailAddresses[3].type[2]` for a violation in the second `type`
       *   value in the third `emailAddresses` message.
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @return The bytes for field.
       */
      public com.google.protobuf.ByteString getFieldBytes() {
        java.lang.Object ref = field_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          field_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A path that leads to a field in the request body. The value will be a
       * sequence of dot-separated identifiers that identify a protocol buffer
       * field.
       *
       * Consider the following:
       *
       *     message CreateContactRequest {
       *       message EmailAddress {
       *         enum Type {
       *           TYPE_UNSPECIFIED = 0;
       *           HOME = 1;
       *           WORK = 2;
       *         }
       *
       *         optional string email = 1;
       *         repeated EmailType type = 2;
       *       }
       *
       *       string full_name = 1;
       *       repeated EmailAddress email_addresses = 2;
       *     }
       *
       * In this example, in proto `field` could take one of the following values:
       *
       * * `full_name` for a violation in the `full_name` value
       * * `email_addresses[1].email` for a violation in the `email` field of the
       *   first `email_addresses` message
       * * `email_addresses[3].type[2]` for a violation in the second `type`
       *   value in the third `email_addresses` message.
       *
       * In JSON, the same values are represented as:
       *
       * * `fullName` for a violation in the `fullName` value
       * * `emailAddresses[1].email` for a violation in the `email` field of the
       *   first `emailAddresses` message
       * * `emailAddresses[3].type[2]` for a violation in the second `type`
       *   value in the third `emailAddresses` message.
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @param value The field to set.
       * @return This builder for chaining.
       */
      public Builder setField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        field_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A path that leads to a field in the request body. The value will be a
       * sequence of dot-separated identifiers that identify a protocol buffer
       * field.
       *
       * Consider the following:
       *
       *     message CreateContactRequest {
       *       message EmailAddress {
       *         enum Type {
       *           TYPE_UNSPECIFIED = 0;
       *           HOME = 1;
       *           WORK = 2;
       *         }
       *
       *         optional string email = 1;
       *         repeated EmailType type = 2;
       *       }
       *
       *       string full_name = 1;
       *       repeated EmailAddress email_addresses = 2;
       *     }
       *
       * In this example, in proto `field` could take one of the following values:
       *
       * * `full_name` for a violation in the `full_name` value
       * * `email_addresses[1].email` for a violation in the `email` field of the
       *   first `email_addresses` message
       * * `email_addresses[3].type[2]` for a violation in the second `type`
       *   value in the third `email_addresses` message.
       *
       * In JSON, the same values are represented as:
       *
       * * `fullName` for a violation in the `fullName` value
       * * `emailAddresses[1].email` for a violation in the `email` field of the
       *   first `emailAddresses` message
       * * `emailAddresses[3].type[2]` for a violation in the second `type`
       *   value in the third `emailAddresses` message.
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearField() {
        field_ = getDefaultInstance().getField();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A path that leads to a field in the request body. The value will be a
       * sequence of dot-separated identifiers that identify a protocol buffer
       * field.
       *
       * Consider the following:
       *
       *     message CreateContactRequest {
       *       message EmailAddress {
       *         enum Type {
       *           TYPE_UNSPECIFIED = 0;
       *           HOME = 1;
       *           WORK = 2;
       *         }
       *
       *         optional string email = 1;
       *         repeated EmailType type = 2;
       *       }
       *
       *       string full_name = 1;
       *       repeated EmailAddress email_addresses = 2;
       *     }
       *
       * In this example, in proto `field` could take one of the following values:
       *
       * * `full_name` for a violation in the `full_name` value
       * * `email_addresses[1].email` for a violation in the `email` field of the
       *   first `email_addresses` message
       * * `email_addresses[3].type[2]` for a violation in the second `type`
       *   value in the third `email_addresses` message.
       *
       * In JSON, the same values are represented as:
       *
       * * `fullName` for a violation in the `fullName` value
       * * `emailAddresses[1].email` for a violation in the `email` field of the
       *   first `emailAddresses` message
       * * `emailAddresses[3].type[2]` for a violation in the second `type`
       *   value in the third `emailAddresses` message.
       * </pre>
       *
       * <code>string field = 1;</code>
       *
       * @param value The bytes for field to set.
       * @return This builder for chaining.
       */
      public Builder setFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        field_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       *
       *
       * <pre>
       * A description of why the request element is bad.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A description of why the request element is bad.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A description of why the request element is bad.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A description of why the request element is bad.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A description of why the request element is bad.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.rpc.BadRequest.FieldViolation)
    }

    // @@protoc_insertion_point(class_scope:google.rpc.BadRequest.FieldViolation)
    private static final com.google.rpc.BadRequest.FieldViolation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.rpc.BadRequest.FieldViolation();
    }

    public static com.google.rpc.BadRequest.FieldViolation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldViolation> PARSER =
        new com.google.protobuf.AbstractParser<FieldViolation>() {
          @java.lang.Override
          public FieldViolation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FieldViolation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldViolation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.rpc.BadRequest.FieldViolation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FIELD_VIOLATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.BadRequest.FieldViolation> fieldViolations_;
  /**
   *
   *
   * <pre>
   * Describes all violations in a client request.
   * </pre>
   *
   * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.BadRequest.FieldViolation> getFieldViolationsList() {
    return fieldViolations_;
  }
  /**
   *
   *
   * <pre>
   * Describes all violations in a client request.
   * </pre>
   *
   * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.BadRequest.FieldViolationOrBuilder>
      getFieldViolationsOrBuilderList() {
    return fieldViolations_;
  }
  /**
   *
   *
   * <pre>
   * Describes all violations in a client request.
   * </pre>
   *
   * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
   */
  @java.lang.Override
  public int getFieldViolationsCount() {
    return fieldViolations_.size();
  }
  /**
   *
   *
   * <pre>
   * Describes all violations in a client request.
   * </pre>
   *
   * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.BadRequest.FieldViolation getFieldViolations(int index) {
    return fieldViolations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Describes all violations in a client request.
   * </pre>
   *
   * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.BadRequest.FieldViolationOrBuilder getFieldViolationsOrBuilder(int index) {
    return fieldViolations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < fieldViolations_.size(); i++) {
      output.writeMessage(1, fieldViolations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < fieldViolations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, fieldViolations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.rpc.BadRequest)) {
      return super.equals(obj);
    }
    com.google.rpc.BadRequest other = (com.google.rpc.BadRequest) obj;

    if (!getFieldViolationsList().equals(other.getFieldViolationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFieldViolationsCount() > 0) {
      hash = (37 * hash) + FIELD_VIOLATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldViolationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.rpc.BadRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.BadRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.BadRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.BadRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.BadRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.BadRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.BadRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.rpc.BadRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.BadRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.rpc.BadRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.BadRequest parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.rpc.BadRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.rpc.BadRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes violations in a client request. This error type focuses on the
   * syntactic aspects of the request.
   * </pre>
   *
   * Protobuf type {@code google.rpc.BadRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.rpc.BadRequest)
      com.google.rpc.BadRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_BadRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.ErrorDetailsProto
          .internal_static_google_rpc_BadRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.BadRequest.class, com.google.rpc.BadRequest.Builder.class);
    }

    // Construct using com.google.rpc.BadRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (fieldViolationsBuilder_ == null) {
        fieldViolations_ = java.util.Collections.emptyList();
      } else {
        fieldViolations_ = null;
        fieldViolationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.rpc.ErrorDetailsProto.internal_static_google_rpc_BadRequest_descriptor;
    }

    @java.lang.Override
    public com.google.rpc.BadRequest getDefaultInstanceForType() {
      return com.google.rpc.BadRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.rpc.BadRequest build() {
      com.google.rpc.BadRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.rpc.BadRequest buildPartial() {
      com.google.rpc.BadRequest result = new com.google.rpc.BadRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.rpc.BadRequest result) {
      if (fieldViolationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          fieldViolations_ = java.util.Collections.unmodifiableList(fieldViolations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.fieldViolations_ = fieldViolations_;
      } else {
        result.fieldViolations_ = fieldViolationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.rpc.BadRequest result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.rpc.BadRequest) {
        return mergeFrom((com.google.rpc.BadRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.rpc.BadRequest other) {
      if (other == com.google.rpc.BadRequest.getDefaultInstance()) return this;
      if (fieldViolationsBuilder_ == null) {
        if (!other.fieldViolations_.isEmpty()) {
          if (fieldViolations_.isEmpty()) {
            fieldViolations_ = other.fieldViolations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFieldViolationsIsMutable();
            fieldViolations_.addAll(other.fieldViolations_);
          }
          onChanged();
        }
      } else {
        if (!other.fieldViolations_.isEmpty()) {
          if (fieldViolationsBuilder_.isEmpty()) {
            fieldViolationsBuilder_.dispose();
            fieldViolationsBuilder_ = null;
            fieldViolations_ = other.fieldViolations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            fieldViolationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldViolationsFieldBuilder()
                    : null;
          } else {
            fieldViolationsBuilder_.addAllMessages(other.fieldViolations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.rpc.BadRequest.FieldViolation m =
                    input.readMessage(
                        com.google.rpc.BadRequest.FieldViolation.parser(), extensionRegistry);
                if (fieldViolationsBuilder_ == null) {
                  ensureFieldViolationsIsMutable();
                  fieldViolations_.add(m);
                } else {
                  fieldViolationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.rpc.BadRequest.FieldViolation> fieldViolations_ =
        java.util.Collections.emptyList();

    private void ensureFieldViolationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fieldViolations_ =
            new java.util.ArrayList<com.google.rpc.BadRequest.FieldViolation>(fieldViolations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.BadRequest.FieldViolation,
            com.google.rpc.BadRequest.FieldViolation.Builder,
            com.google.rpc.BadRequest.FieldViolationOrBuilder>
        fieldViolationsBuilder_;

    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public java.util.List<com.google.rpc.BadRequest.FieldViolation> getFieldViolationsList() {
      if (fieldViolationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fieldViolations_);
      } else {
        return fieldViolationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public int getFieldViolationsCount() {
      if (fieldViolationsBuilder_ == null) {
        return fieldViolations_.size();
      } else {
        return fieldViolationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public com.google.rpc.BadRequest.FieldViolation getFieldViolations(int index) {
      if (fieldViolationsBuilder_ == null) {
        return fieldViolations_.get(index);
      } else {
        return fieldViolationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder setFieldViolations(int index, com.google.rpc.BadRequest.FieldViolation value) {
      if (fieldViolationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldViolationsIsMutable();
        fieldViolations_.set(index, value);
        onChanged();
      } else {
        fieldViolationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder setFieldViolations(
        int index, com.google.rpc.BadRequest.FieldViolation.Builder builderForValue) {
      if (fieldViolationsBuilder_ == null) {
        ensureFieldViolationsIsMutable();
        fieldViolations_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldViolationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder addFieldViolations(com.google.rpc.BadRequest.FieldViolation value) {
      if (fieldViolationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldViolationsIsMutable();
        fieldViolations_.add(value);
        onChanged();
      } else {
        fieldViolationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder addFieldViolations(int index, com.google.rpc.BadRequest.FieldViolation value) {
      if (fieldViolationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldViolationsIsMutable();
        fieldViolations_.add(index, value);
        onChanged();
      } else {
        fieldViolationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder addFieldViolations(
        com.google.rpc.BadRequest.FieldViolation.Builder builderForValue) {
      if (fieldViolationsBuilder_ == null) {
        ensureFieldViolationsIsMutable();
        fieldViolations_.add(builderForValue.build());
        onChanged();
      } else {
        fieldViolationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder addFieldViolations(
        int index, com.google.rpc.BadRequest.FieldViolation.Builder builderForValue) {
      if (fieldViolationsBuilder_ == null) {
        ensureFieldViolationsIsMutable();
        fieldViolations_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldViolationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder addAllFieldViolations(
        java.lang.Iterable<? extends com.google.rpc.BadRequest.FieldViolation> values) {
      if (fieldViolationsBuilder_ == null) {
        ensureFieldViolationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fieldViolations_);
        onChanged();
      } else {
        fieldViolationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder clearFieldViolations() {
      if (fieldViolationsBuilder_ == null) {
        fieldViolations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        fieldViolationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public Builder removeFieldViolations(int index) {
      if (fieldViolationsBuilder_ == null) {
        ensureFieldViolationsIsMutable();
        fieldViolations_.remove(index);
        onChanged();
      } else {
        fieldViolationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public com.google.rpc.BadRequest.FieldViolation.Builder getFieldViolationsBuilder(int index) {
      return getFieldViolationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public com.google.rpc.BadRequest.FieldViolationOrBuilder getFieldViolationsOrBuilder(
        int index) {
      if (fieldViolationsBuilder_ == null) {
        return fieldViolations_.get(index);
      } else {
        return fieldViolationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public java.util.List<? extends com.google.rpc.BadRequest.FieldViolationOrBuilder>
        getFieldViolationsOrBuilderList() {
      if (fieldViolationsBuilder_ != null) {
        return fieldViolationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fieldViolations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public com.google.rpc.BadRequest.FieldViolation.Builder addFieldViolationsBuilder() {
      return getFieldViolationsFieldBuilder()
          .addBuilder(com.google.rpc.BadRequest.FieldViolation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public com.google.rpc.BadRequest.FieldViolation.Builder addFieldViolationsBuilder(int index) {
      return getFieldViolationsFieldBuilder()
          .addBuilder(index, com.google.rpc.BadRequest.FieldViolation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Describes all violations in a client request.
     * </pre>
     *
     * <code>repeated .google.rpc.BadRequest.FieldViolation field_violations = 1;</code>
     */
    public java.util.List<com.google.rpc.BadRequest.FieldViolation.Builder>
        getFieldViolationsBuilderList() {
      return getFieldViolationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.BadRequest.FieldViolation,
            com.google.rpc.BadRequest.FieldViolation.Builder,
            com.google.rpc.BadRequest.FieldViolationOrBuilder>
        getFieldViolationsFieldBuilder() {
      if (fieldViolationsBuilder_ == null) {
        fieldViolationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.BadRequest.FieldViolation,
                com.google.rpc.BadRequest.FieldViolation.Builder,
                com.google.rpc.BadRequest.FieldViolationOrBuilder>(
                fieldViolations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        fieldViolations_ = null;
      }
      return fieldViolationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.rpc.BadRequest)
  }

  // @@protoc_insertion_point(class_scope:google.rpc.BadRequest)
  private static final com.google.rpc.BadRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.rpc.BadRequest();
  }

  public static com.google.rpc.BadRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BadRequest> PARSER =
      new com.google.protobuf.AbstractParser<BadRequest>() {
        @java.lang.Override
        public BadRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BadRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BadRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.rpc.BadRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
