/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Options related to model extraction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModelExtractOptions extends com.google.api.client.json.GenericJson {

  /**
   * The 1-based ID of the trial to be exported from a hyperparameter tuning model. If not
   * specified, the trial with id =
   * [Model](/bigquery/docs/reference/rest/v2/models#resource:-model).defaultTrialId is exported.
   * This field is ignored for models not trained with hyperparameter tuning.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long trialId;

  /**
   * The 1-based ID of the trial to be exported from a hyperparameter tuning model. If not
   * specified, the trial with id =
   * [Model](/bigquery/docs/reference/rest/v2/models#resource:-model).defaultTrialId is exported.
   * This field is ignored for models not trained with hyperparameter tuning.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTrialId() {
    return trialId;
  }

  /**
   * The 1-based ID of the trial to be exported from a hyperparameter tuning model. If not
   * specified, the trial with id =
   * [Model](/bigquery/docs/reference/rest/v2/models#resource:-model).defaultTrialId is exported.
   * This field is ignored for models not trained with hyperparameter tuning.
   * @param trialId trialId or {@code null} for none
   */
  public ModelExtractOptions setTrialId(java.lang.Long trialId) {
    this.trialId = trialId;
    return this;
  }

  @Override
  public ModelExtractOptions set(String fieldName, Object value) {
    return (ModelExtractOptions) super.set(fieldName, value);
  }

  @Override
  public ModelExtractOptions clone() {
    return (ModelExtractOptions) super.clone();
  }

}
