/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.books;

import com.google.api.client.googleapis.GoogleUrl;
import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.services.books.Books;
import java.io.IOException;

class ApiClient {
    private Boolean prettyPrint;
    private String fields;
    private String quotaUser;
    private String oauthToken;
    private String key;
    private String userIp;
    private String alt;
    final HttpRequestFactory requestFactory;
    final JsonFactory jsonFactory;
    private String baseServer;
    private String basePath;
    final JsonHttpParser jsonParser;
    private String userAgent;
    private final MethodOverride methodOverride = new MethodOverride();

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String getQuotaUser() {
        return this.quotaUser;
    }

    public void setQuotaUser(String quotaUser) {
        this.quotaUser = quotaUser;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public void setBaseServer(String baseServer) {
        this.baseServer = baseServer;
    }

    public String getBaseServer() {
        return this.baseServer;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    protected ApiClient(String baseServer, String basePath, HttpTransport transport, HttpRequestInitializer requestInitializer, JsonFactory jsonFactory) {
        this.baseServer = baseServer;
        this.basePath = basePath;
        this.jsonFactory = jsonFactory;
        this.jsonParser = new JsonHttpParser(this.jsonFactory);
        this.requestFactory = transport.createRequestFactory(requestInitializer);
    }

    public void setApplicationName(String name) {
        this.userAgent = name;
    }

    HttpRequest buildHttpRequest(HttpMethod method, String requestUrl, Books.RemoteRequest request) throws IOException {
        GoogleUrl url = GoogleUrl.create((String)(this.baseServer + this.basePath), (String)requestUrl, (Object)((Object)request));
        url.key = this.key;
        url.alt = "json";
        url.prettyprint = this.prettyPrint;
        url.userip = this.userIp;
        HttpRequest httpRequest = this.requestFactory.buildRequest(method, (GenericUrl)url, null);
        if (this.userAgent != null) {
            httpRequest.getHeaders().setUserAgent(this.userAgent);
        }
        this.methodOverride.intercept(httpRequest);
        return httpRequest;
    }

    JsonHttpContent createSerializer(Object body) {
        return new JsonHttpContent(this.jsonFactory, body);
    }
}

