/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.books;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.services.books.ApiClient;
import com.google.api.services.books.model.Bookshelf;
import com.google.api.services.books.model.Volume;
import java.io.IOException;

public class Books
extends ApiClient {
    final Books self;
    public final Bookshelves bookshelves = new Bookshelves();
    public final Volumes volumes = new Volumes();
    public final Mylibrary mylibrary = new Mylibrary();

    public Books(HttpTransport transport, HttpRequestInitializer requestInitializer, JsonFactory jsonFactory) {
        super("https://www.googleapis.com", "/books/v1/", transport, requestInitializer, jsonFactory);
        this.self = this;
    }

    public Books(HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
    }

    public Books(String appName, HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
        this.setApplicationName(appName);
    }

    class RemoteRequest
    extends GenericData {
        @Key
        private String fields;

        RemoteRequest() {
            this.fields = Books.this.getFields();
        }

        public String getFields() {
            return this.fields;
        }

        public void setFields(String fields) {
            this.fields = fields;
        }

        HttpResponse execute(HttpMethod method, String requestUrl) throws IOException {
            HttpRequest request = Books.this.self.buildHttpRequest(method, requestUrl, this);
            if (method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH) {
                request.setContent((HttpContent)ByteArrayContent.fromString((String)"application/json", (String)" "));
            }
            return request.execute();
        }

        HttpResponse execute(HttpMethod method, String requestUrl, Object body) throws IOException {
            HttpRequest request = Books.this.self.buildHttpRequest(method, requestUrl, this);
            request.setContent((HttpContent)Books.this.self.createSerializer(body));
            request.setEnableGZipContent(true);
            return request.execute();
        }
    }

    public class Mylibrary {
        public final Bookshelves bookshelves = new Bookshelves();

        public class Bookshelves {
            public final Volumes volumes = new Volumes();

            public ClearVolumes clearVolumes(String shelf) {
                return new ClearVolumes(shelf);
            }

            public RemoveVolume removeVolume(String shelf, String volumeId) {
                return new RemoveVolume(shelf, volumeId);
            }

            public List list() {
                return new List();
            }

            public AddVolume addVolume(String shelf, String volumeId) {
                return new AddVolume(shelf, volumeId);
            }

            public Get get(String shelf) {
                return new Get(shelf);
            }

            public class Volumes {
                public List list() {
                    return new List();
                }

                public class List
                extends RemoteRequest {
                    private static final String REST_PATH = "mylibrary/bookshelves/{shelf}/volumes";
                    @Key(value="shelf")
                    private String shelf;
                    @Key(value="projection")
                    private String projection;
                    @Key(value="country")
                    private String country;
                    @Key(value="maxResults")
                    private Long maxResults;
                    @Key(value="q")
                    private String q;
                    @Key(value="source")
                    private String source;
                    @Key(value="startIndex")
                    private Long startIndex;

                    private List() {
                    }

                    public com.google.api.services.books.model.Volumes execute() throws IOException {
                        HttpResponse response = this.executeUnparsed();
                        com.google.api.services.books.model.Volumes result = (com.google.api.services.books.model.Volumes)((Object)Books.this.jsonParser.parse(response, com.google.api.services.books.model.Volumes.class));
                        result.setResponseHeaders(response.getHeaders());
                        return result;
                    }

                    public HttpResponse executeUnparsed() throws IOException {
                        return super.execute(HttpMethod.GET, REST_PATH);
                    }

                    public String getShelf() {
                        return this.shelf;
                    }

                    public List setShelf(String shelf) {
                        this.shelf = shelf;
                        return this;
                    }

                    public String getProjection() {
                        return this.projection;
                    }

                    public List setProjection(String projection) {
                        this.projection = projection;
                        return this;
                    }

                    public String getCountry() {
                        return this.country;
                    }

                    public List setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Long getMaxResults() {
                        return this.maxResults;
                    }

                    public List setMaxResults(Long maxResults) {
                        this.maxResults = maxResults;
                        return this;
                    }

                    public String getQ() {
                        return this.q;
                    }

                    public List setQ(String q) {
                        this.q = q;
                        return this;
                    }

                    public String getSource() {
                        return this.source;
                    }

                    public List setSource(String source) {
                        this.source = source;
                        return this;
                    }

                    public Long getStartIndex() {
                        return this.startIndex;
                    }

                    public List setStartIndex(Long startIndex) {
                        this.startIndex = startIndex;
                        return this;
                    }
                }
            }

            public class Get
            extends RemoteRequest {
                private static final String REST_PATH = "mylibrary/bookshelves/{shelf}";
                @Key(value="shelf")
                private String shelf;
                @Key(value="country")
                private String country;
                @Key(value="source")
                private String source;

                private Get(String shelf) {
                    this.shelf = shelf;
                }

                public Bookshelf execute() throws IOException {
                    HttpResponse response = this.executeUnparsed();
                    Bookshelf result = (Bookshelf)((Object)Books.this.jsonParser.parse(response, Bookshelf.class));
                    result.setResponseHeaders(response.getHeaders());
                    return result;
                }

                public HttpResponse executeUnparsed() throws IOException {
                    return super.execute(HttpMethod.GET, REST_PATH);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public Get setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public Get setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public Get setSource(String source) {
                    this.source = source;
                    return this;
                }
            }

            public class AddVolume
            extends RemoteRequest {
                private static final String REST_PATH = "mylibrary/bookshelves/{shelf}/addVolume";
                @Key(value="shelf")
                private String shelf;
                @Key(value="volumeId")
                private String volumeId;
                @Key(value="country")
                private String country;
                @Key(value="source")
                private String source;

                private AddVolume(String shelf, String volumeId) {
                    this.shelf = shelf;
                    this.volumeId = volumeId;
                }

                public void execute() throws IOException {
                    HttpResponse response = this.executeUnparsed();
                    response.ignore();
                }

                public HttpResponse executeUnparsed() throws IOException {
                    return super.execute(HttpMethod.POST, REST_PATH);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public AddVolume setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public AddVolume setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public AddVolume setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public AddVolume setSource(String source) {
                    this.source = source;
                    return this;
                }
            }

            public class List
            extends RemoteRequest {
                private static final String REST_PATH = "mylibrary/bookshelves";
                @Key(value="country")
                private String country;
                @Key(value="source")
                private String source;

                private List() {
                }

                public com.google.api.services.books.model.Bookshelves execute() throws IOException {
                    HttpResponse response = this.executeUnparsed();
                    com.google.api.services.books.model.Bookshelves result = (com.google.api.services.books.model.Bookshelves)((Object)Books.this.jsonParser.parse(response, com.google.api.services.books.model.Bookshelves.class));
                    result.setResponseHeaders(response.getHeaders());
                    return result;
                }

                public HttpResponse executeUnparsed() throws IOException {
                    return super.execute(HttpMethod.GET, REST_PATH);
                }

                public String getCountry() {
                    return this.country;
                }

                public List setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }
            }

            public class RemoveVolume
            extends RemoteRequest {
                private static final String REST_PATH = "mylibrary/bookshelves/{shelf}/removeVolume";
                @Key(value="shelf")
                private String shelf;
                @Key(value="volumeId")
                private String volumeId;
                @Key(value="country")
                private String country;
                @Key(value="source")
                private String source;

                private RemoveVolume(String shelf, String volumeId) {
                    this.shelf = shelf;
                    this.volumeId = volumeId;
                }

                public void execute() throws IOException {
                    HttpResponse response = this.executeUnparsed();
                    response.ignore();
                }

                public HttpResponse executeUnparsed() throws IOException {
                    return super.execute(HttpMethod.POST, REST_PATH);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public RemoveVolume setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getVolumeId() {
                    return this.volumeId;
                }

                public RemoveVolume setVolumeId(String volumeId) {
                    this.volumeId = volumeId;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public RemoveVolume setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public RemoveVolume setSource(String source) {
                    this.source = source;
                    return this;
                }
            }

            public class ClearVolumes
            extends RemoteRequest {
                private static final String REST_PATH = "mylibrary/bookshelves/{shelf}/clearVolumes";
                @Key(value="shelf")
                private String shelf;
                @Key(value="country")
                private String country;
                @Key(value="source")
                private String source;

                private ClearVolumes(String shelf) {
                    this.shelf = shelf;
                }

                public void execute() throws IOException {
                    HttpResponse response = this.executeUnparsed();
                    response.ignore();
                }

                public HttpResponse executeUnparsed() throws IOException {
                    return super.execute(HttpMethod.POST, REST_PATH);
                }

                public String getShelf() {
                    return this.shelf;
                }

                public ClearVolumes setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public ClearVolumes setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public ClearVolumes setSource(String source) {
                    this.source = source;
                    return this;
                }
            }
        }
    }

    public class Volumes {
        public List list(String q) {
            return new List(q);
        }

        public Get get(String volumeId) {
            return new Get(volumeId);
        }

        public class Get
        extends RemoteRequest {
            private static final String REST_PATH = "volumes/{volumeId}";
            @Key(value="volumeId")
            private String volumeId;
            @Key(value="source")
            private String source;
            @Key(value="country")
            private String country;
            @Key(value="projection")
            private String projection;
            @Key(value="partner")
            private String partner;

            private Get(String volumeId) {
                this.volumeId = volumeId;
            }

            public Volume execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Volume result = (Volume)((Object)Books.this.jsonParser.parse(response, Volume.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getVolumeId() {
                return this.volumeId;
            }

            public Get setVolumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Get setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getPartner() {
                return this.partner;
            }

            public Get setPartner(String partner) {
                this.partner = partner;
                return this;
            }
        }

        public class List
        extends RemoteRequest {
            private static final String REST_PATH = "volumes";
            @Key(value="q")
            private String q;
            @Key(value="orderBy")
            private String orderBy;
            @Key(value="projection")
            private String projection;
            @Key(value="libraryRestrict")
            private String libraryRestrict;
            @Key(value="langRestrict")
            private String langRestrict;
            @Key(value="country")
            private String country;
            @Key(value="printType")
            private String printType;
            @Key(value="maxResults")
            private Long maxResults;
            @Key(value="filter")
            private String filter;
            @Key(value="source")
            private String source;
            @Key(value="startIndex")
            private Long startIndex;
            @Key(value="download")
            private String download;
            @Key(value="partner")
            private String partner;

            private List(String q) {
                this.q = q;
            }

            public com.google.api.services.books.model.Volumes execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.books.model.Volumes result = (com.google.api.services.books.model.Volumes)((Object)Books.this.jsonParser.parse(response, com.google.api.services.books.model.Volumes.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String projection) {
                this.projection = projection;
                return this;
            }

            public String getLibraryRestrict() {
                return this.libraryRestrict;
            }

            public List setLibraryRestrict(String libraryRestrict) {
                this.libraryRestrict = libraryRestrict;
                return this;
            }

            public String getLangRestrict() {
                return this.langRestrict;
            }

            public List setLangRestrict(String langRestrict) {
                this.langRestrict = langRestrict;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public List setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getPrintType() {
                return this.printType;
            }

            public List setPrintType(String printType) {
                this.printType = printType;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String source) {
                this.source = source;
                return this;
            }

            public Long getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(Long startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public String getDownload() {
                return this.download;
            }

            public List setDownload(String download) {
                this.download = download;
                return this;
            }

            public String getPartner() {
                return this.partner;
            }

            public List setPartner(String partner) {
                this.partner = partner;
                return this;
            }
        }
    }

    public class Bookshelves {
        public final Volumes volumes = new Volumes();

        public List list(String userId) {
            return new List(userId);
        }

        public Get get(String userId, String shelf) {
            return new Get(userId, shelf);
        }

        public class Volumes {
            public List list(String userId, String shelf) {
                return new List(userId, shelf);
            }

            public class List
            extends RemoteRequest {
                private static final String REST_PATH = "users/{userId}/bookshelves/{shelf}/volumes";
                @Key(value="userId")
                private String userId;
                @Key(value="shelf")
                private String shelf;
                @Key(value="country")
                private String country;
                @Key(value="maxResults")
                private Long maxResults;
                @Key(value="source")
                private String source;
                @Key(value="startIndex")
                private Long startIndex;

                private List(String userId, String shelf) {
                    this.userId = userId;
                    this.shelf = shelf;
                }

                public com.google.api.services.books.model.Volumes execute() throws IOException {
                    HttpResponse response = this.executeUnparsed();
                    com.google.api.services.books.model.Volumes result = (com.google.api.services.books.model.Volumes)((Object)Books.this.jsonParser.parse(response, com.google.api.services.books.model.Volumes.class));
                    result.setResponseHeaders(response.getHeaders());
                    return result;
                }

                public HttpResponse executeUnparsed() throws IOException {
                    return super.execute(HttpMethod.GET, REST_PATH);
                }

                public String getUserId() {
                    return this.userId;
                }

                public List setUserId(String userId) {
                    this.userId = userId;
                    return this;
                }

                public String getShelf() {
                    return this.shelf;
                }

                public List setShelf(String shelf) {
                    this.shelf = shelf;
                    return this;
                }

                public String getCountry() {
                    return this.country;
                }

                public List setCountry(String country) {
                    this.country = country;
                    return this;
                }

                public Long getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Long maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getSource() {
                    return this.source;
                }

                public List setSource(String source) {
                    this.source = source;
                    return this;
                }

                public Long getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Long startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }
            }
        }

        public class Get
        extends RemoteRequest {
            private static final String REST_PATH = "users/{userId}/bookshelves/{shelf}";
            @Key(value="userId")
            private String userId;
            @Key(value="shelf")
            private String shelf;
            @Key(value="country")
            private String country;
            @Key(value="source")
            private String source;

            private Get(String userId, String shelf) {
                this.userId = userId;
                this.shelf = shelf;
            }

            public Bookshelf execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Bookshelf result = (Bookshelf)((Object)Books.this.jsonParser.parse(response, Bookshelf.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getShelf() {
                return this.shelf;
            }

            public Get setShelf(String shelf) {
                this.shelf = shelf;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Get setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public Get setSource(String source) {
                this.source = source;
                return this;
            }
        }

        public class List
        extends RemoteRequest {
            private static final String REST_PATH = "users/{userId}/bookshelves";
            @Key(value="userId")
            private String userId;
            @Key(value="country")
            private String country;
            @Key(value="source")
            private String source;

            private List(String userId) {
                this.userId = userId;
            }

            public com.google.api.services.books.model.Bookshelves execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.books.model.Bookshelves result = (com.google.api.services.books.model.Bookshelves)((Object)Books.this.jsonParser.parse(response, com.google.api.services.books.model.Bookshelves.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public HttpResponse executeUnparsed() throws IOException {
                return super.execute(HttpMethod.GET, REST_PATH);
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public List setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public List setSource(String source) {
                this.source = source;
                return this;
            }
        }
    }
}

