/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-19 at 06:21:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EntryPoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EntryPoint extends com.google.api.client.json.GenericJson {

  /**
   * The access code to access the conference. The maximum length is 128 characters. When creating
   * new conference data, populate only the subset of {meetingCode, accessCode, passcode, password,
   * pin} fields that match the terminology that the conference provider uses. Only the populated
   * fields should be displayed. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accessCode;

  /**
   * Features of the entry point, such as being toll or toll-free. One entry point can have multiple
   * features. However, toll and toll-free cannot be both set on the same entry point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> entryPointFeatures;

  /**
   * The type of the conference entry point. Possible values are:   - "video" - joining a conference
   * over HTTP. A conference can have zero or one video entry point. - "phone" - joining a
   * conference by dialing a phone number. A conference can have zero or more phone entry points. -
   * "sip" - joining a conference over SIP. A conference can have zero or one sip entry point. -
   * "more" - further conference joining instructions, for example additional phone numbers. A
   * conference can have zero or one more entry point. A conference with only a more entry point is
   * not a valid conference.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String entryPointType;

  /**
   * The label for the URI. Visible to end users. Not localized. The maximum length is 512
   * characters. Examples:   - for video: meet.google.com/aaa-bbbb-ccc - for phone: +1 123 268 2601
   * - for sip: 12345678@altostrat.com - for more: should not be filled   Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * The meeting code to access the conference. The maximum length is 128 characters. When creating
   * new conference data, populate only the subset of {meetingCode, accessCode, passcode, password,
   * pin} fields that match the terminology that the conference provider uses. Only the populated
   * fields should be displayed. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String meetingCode;

  /**
   * The passcode to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String passcode;

  /**
   * The password to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String password;

  /**
   * The PIN to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pin;

  /**
   * The CLDR/ISO 3166 region code for the country associated with this phone access. Example: "SE"
   * for Sweden. Calendar backend will populate this field only for EntryPointType.PHONE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regionCode;

  /**
   * The URI of the entry point. The maximum length is 1300 characters. Format:   - for video, http:
   * or https: schema is required. - for phone, tel: schema is required. The URI should include the
   * entire dial sequence (e.g., tel:+12345678900,,,123456789;1234). - for sip, sip: schema is
   * required, e.g., sip:12345678@myprovider.com. - for more, http: or https: schema is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * The access code to access the conference. The maximum length is 128 characters. When creating
   * new conference data, populate only the subset of {meetingCode, accessCode, passcode, password,
   * pin} fields that match the terminology that the conference provider uses. Only the populated
   * fields should be displayed. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccessCode() {
    return accessCode;
  }

  /**
   * The access code to access the conference. The maximum length is 128 characters. When creating
   * new conference data, populate only the subset of {meetingCode, accessCode, passcode, password,
   * pin} fields that match the terminology that the conference provider uses. Only the populated
   * fields should be displayed. Optional.
   * @param accessCode accessCode or {@code null} for none
   */
  public EntryPoint setAccessCode(java.lang.String accessCode) {
    this.accessCode = accessCode;
    return this;
  }

  /**
   * Features of the entry point, such as being toll or toll-free. One entry point can have multiple
   * features. However, toll and toll-free cannot be both set on the same entry point.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getEntryPointFeatures() {
    return entryPointFeatures;
  }

  /**
   * Features of the entry point, such as being toll or toll-free. One entry point can have multiple
   * features. However, toll and toll-free cannot be both set on the same entry point.
   * @param entryPointFeatures entryPointFeatures or {@code null} for none
   */
  public EntryPoint setEntryPointFeatures(java.util.List<java.lang.String> entryPointFeatures) {
    this.entryPointFeatures = entryPointFeatures;
    return this;
  }

  /**
   * The type of the conference entry point. Possible values are:   - "video" - joining a conference
   * over HTTP. A conference can have zero or one video entry point. - "phone" - joining a
   * conference by dialing a phone number. A conference can have zero or more phone entry points. -
   * "sip" - joining a conference over SIP. A conference can have zero or one sip entry point. -
   * "more" - further conference joining instructions, for example additional phone numbers. A
   * conference can have zero or one more entry point. A conference with only a more entry point is
   * not a valid conference.
   * @return value or {@code null} for none
   */
  public java.lang.String getEntryPointType() {
    return entryPointType;
  }

  /**
   * The type of the conference entry point. Possible values are:   - "video" - joining a conference
   * over HTTP. A conference can have zero or one video entry point. - "phone" - joining a
   * conference by dialing a phone number. A conference can have zero or more phone entry points. -
   * "sip" - joining a conference over SIP. A conference can have zero or one sip entry point. -
   * "more" - further conference joining instructions, for example additional phone numbers. A
   * conference can have zero or one more entry point. A conference with only a more entry point is
   * not a valid conference.
   * @param entryPointType entryPointType or {@code null} for none
   */
  public EntryPoint setEntryPointType(java.lang.String entryPointType) {
    this.entryPointType = entryPointType;
    return this;
  }

  /**
   * The label for the URI. Visible to end users. Not localized. The maximum length is 512
   * characters. Examples:   - for video: meet.google.com/aaa-bbbb-ccc - for phone: +1 123 268 2601
   * - for sip: 12345678@altostrat.com - for more: should not be filled   Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The label for the URI. Visible to end users. Not localized. The maximum length is 512
   * characters. Examples:   - for video: meet.google.com/aaa-bbbb-ccc - for phone: +1 123 268 2601
   * - for sip: 12345678@altostrat.com - for more: should not be filled   Optional.
   * @param label label or {@code null} for none
   */
  public EntryPoint setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * The meeting code to access the conference. The maximum length is 128 characters. When creating
   * new conference data, populate only the subset of {meetingCode, accessCode, passcode, password,
   * pin} fields that match the terminology that the conference provider uses. Only the populated
   * fields should be displayed. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeetingCode() {
    return meetingCode;
  }

  /**
   * The meeting code to access the conference. The maximum length is 128 characters. When creating
   * new conference data, populate only the subset of {meetingCode, accessCode, passcode, password,
   * pin} fields that match the terminology that the conference provider uses. Only the populated
   * fields should be displayed. Optional.
   * @param meetingCode meetingCode or {@code null} for none
   */
  public EntryPoint setMeetingCode(java.lang.String meetingCode) {
    this.meetingCode = meetingCode;
    return this;
  }

  /**
   * The passcode to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed.
   * @return value or {@code null} for none
   */
  public java.lang.String getPasscode() {
    return passcode;
  }

  /**
   * The passcode to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed.
   * @param passcode passcode or {@code null} for none
   */
  public EntryPoint setPasscode(java.lang.String passcode) {
    this.passcode = passcode;
    return this;
  }

  /**
   * The password to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getPassword() {
    return password;
  }

  /**
   * The password to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed. Optional.
   * @param password password or {@code null} for none
   */
  public EntryPoint setPassword(java.lang.String password) {
    this.password = password;
    return this;
  }

  /**
   * The PIN to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getPin() {
    return pin;
  }

  /**
   * The PIN to access the conference. The maximum length is 128 characters. When creating new
   * conference data, populate only the subset of {meetingCode, accessCode, passcode, password, pin}
   * fields that match the terminology that the conference provider uses. Only the populated fields
   * should be displayed. Optional.
   * @param pin pin or {@code null} for none
   */
  public EntryPoint setPin(java.lang.String pin) {
    this.pin = pin;
    return this;
  }

  /**
   * The CLDR/ISO 3166 region code for the country associated with this phone access. Example: "SE"
   * for Sweden. Calendar backend will populate this field only for EntryPointType.PHONE.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegionCode() {
    return regionCode;
  }

  /**
   * The CLDR/ISO 3166 region code for the country associated with this phone access. Example: "SE"
   * for Sweden. Calendar backend will populate this field only for EntryPointType.PHONE.
   * @param regionCode regionCode or {@code null} for none
   */
  public EntryPoint setRegionCode(java.lang.String regionCode) {
    this.regionCode = regionCode;
    return this;
  }

  /**
   * The URI of the entry point. The maximum length is 1300 characters. Format:   - for video, http:
   * or https: schema is required. - for phone, tel: schema is required. The URI should include the
   * entire dial sequence (e.g., tel:+12345678900,,,123456789;1234). - for sip, sip: schema is
   * required, e.g., sip:12345678@myprovider.com. - for more, http: or https: schema is required.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * The URI of the entry point. The maximum length is 1300 characters. Format:   - for video, http:
   * or https: schema is required. - for phone, tel: schema is required. The URI should include the
   * entire dial sequence (e.g., tel:+12345678900,,,123456789;1234). - for sip, sip: schema is
   * required, e.g., sip:12345678@myprovider.com. - for more, http: or https: schema is required.
   * @param uri uri or {@code null} for none
   */
  public EntryPoint setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public EntryPoint set(String fieldName, Object value) {
    return (EntryPoint) super.set(fieldName, value);
  }

  @Override
  public EntryPoint clone() {
    return (EntryPoint) super.clone();
  }

}
