/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.discovery;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonErrorContainer;
import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.services.discovery.DiscoveryRequest;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class Discovery
extends GoogleClient {
    public static final String DEFAULT_BASE_PATH = "/discovery/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/discovery/v1/";

    public Discovery(HttpTransport httpTransport, JsonFactory jsonFactory) {
        super(httpTransport, jsonFactory, DEFAULT_BASE_URL);
    }

    Discovery(HttpTransport httpTransport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String string, String string2) {
        super(httpTransport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, string, string2);
    }

    public static Builder builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
        return new Builder(httpTransport, jsonFactory);
    }

    public Apis apis() {
        return new Apis();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        Builder(HttpTransport httpTransport, JsonFactory jsonFactory) {
            super(httpTransport, jsonFactory, new GenericUrl(Discovery.DEFAULT_BASE_URL));
        }

        public Discovery build() {
            return new Discovery(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getBaseUrl().build(), this.getApplicationName());
        }

        public Builder setBaseUrl(GenericUrl genericUrl) {
            super.setBaseUrl(genericUrl);
            return this;
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String string) {
            super.setApplicationName(string);
            return this;
        }
    }

    public class Apis {
        public GetRest getRest(String string, String string2) throws IOException {
            GetRest getRest = new GetRest(string, string2);
            Discovery.this.initialize(getRest);
            return getRest;
        }

        public List list() throws IOException {
            List list = new List();
            Discovery.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DiscoveryRequest {
            private static final String REST_PATH = "apis";
            @Key
            private String name;
            @Key
            private Boolean preferred;
            @Key
            private String label;

            private List() {
                super((JsonHttpClient)Discovery.this, HttpMethod.GET, REST_PATH, null);
            }

            public DirectoryList execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                DirectoryList directoryList = (DirectoryList)((Object)httpResponse.parseAs(DirectoryList.class));
                directoryList.setResponseHeaders(httpResponse.getHeaders());
                return directoryList;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<DirectoryList> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), DirectoryList.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                this.name = string;
                return this;
            }

            public Boolean getPreferred() {
                return this.preferred;
            }

            public List setPreferred(Boolean bl) {
                this.preferred = bl;
                return this;
            }

            public String getLabel() {
                return this.label;
            }

            public List setLabel(String string) {
                this.label = string;
                return this;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetRest
        extends DiscoveryRequest {
            private static final String REST_PATH = "apis/{api}/{version}/rest";
            @Key
            private String api;
            @Key
            private String version;

            private GetRest(String string, String string2) {
                super((JsonHttpClient)Discovery.this, HttpMethod.GET, REST_PATH, null);
                this.api = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter api must be specified.");
                this.version = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter version must be specified.");
            }

            public RestDescription execute() throws IOException {
                HttpResponse httpResponse = this.executeUnparsed();
                RestDescription restDescription = (RestDescription)((Object)httpResponse.parseAs(RestDescription.class));
                restDescription.setResponseHeaders(httpResponse.getHeaders());
                return restDescription;
            }

            public void queue(BatchRequest batchRequest, JsonBatchCallback<RestDescription> jsonBatchCallback) throws IOException {
                batchRequest.queue(this.buildHttpRequest(), RestDescription.class, GoogleJsonErrorContainer.class, jsonBatchCallback);
            }

            public String getApi() {
                return this.api;
            }

            public GetRest setApi(String string) {
                this.api = string;
                return this;
            }

            public String getVersion() {
                return this.version;
            }

            public GetRest setVersion(String string) {
                this.version = string;
                return this;
            }
        }
    }
}

