/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-30 at 19:00:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dns.model;

/**
 * Model definition for ManagedZonesListResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud DNS API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedZonesListResponse extends com.google.api.client.json.GenericJson {

  /**
   * Type of resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The managed zone resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ManagedZone> managedZones;

  static {
    // hack to force ProGuard to consider ManagedZone used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ManagedZone.class);
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * page token.
   *
   * In this way you can retrieve the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned will be an inconsistent view of the collection.
   * There is no way to retrieve a consistent snapshot of a collection larger than the maximum page
   * size.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Type of resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of resource.
   * @param kind kind or {@code null} for none
   */
  public ManagedZonesListResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The managed zone resources.
   * @return value or {@code null} for none
   */
  public java.util.List<ManagedZone> getManagedZones() {
    return managedZones;
  }

  /**
   * The managed zone resources.
   * @param managedZones managedZones or {@code null} for none
   */
  public ManagedZonesListResponse setManagedZones(java.util.List<ManagedZone> managedZones) {
    this.managedZones = managedZones;
    return this;
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * page token.
   *
   * In this way you can retrieve the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned will be an inconsistent view of the collection.
   * There is no way to retrieve a consistent snapshot of a collection larger than the maximum page
   * size.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The presence of this field indicates that there exist more results following your last page of
   * results in pagination order. To fetch them, make another list request using this value as your
   * page token.
   *
   * In this way you can retrieve the complete contents of even very large collections one page at a
   * time. However, if the contents of the collection change between the first and last paginated
   * list request, the set of all elements returned will be an inconsistent view of the collection.
   * There is no way to retrieve a consistent snapshot of a collection larger than the maximum page
   * size.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ManagedZonesListResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ManagedZonesListResponse set(String fieldName, Object value) {
    return (ManagedZonesListResponse) super.set(fieldName, value);
  }

  @Override
  public ManagedZonesListResponse clone() {
    return (ManagedZonesListResponse) super.clone();
  }

}
