/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.3.0 (build: 2013-03-20 15:12:36 UTC)
 *  on 2013-03-22 at 00:00:18 UTC 
 */

package com.google.api.services.oauth2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

/**
 * Service definition for Oauth2 (v1).
 *
 * <p>
 * Lets you access OAuth2 protocol related APIs.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/accounts/docs/OAuth2" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link Oauth2RequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * <p>
 * Upgrade warning: this class now extends {@link AbstractGoogleJsonClient}, whereas in prior
 * version 1.8 it extended {@link com.google.api.client.googleapis.services.GoogleClient}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Oauth2 extends AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    Preconditions.checkState(GoogleUtils.VERSION.equals("1.13.2-beta"),
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.13.2-beta of google-api-client to run version " +
        "1.13.2-beta of the Google OAuth2 API library.", GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.13)
   */
  @Deprecated
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport
   * @param jsonFactory JSON factory
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Oauth2(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport,
        jsonFactory,
        DEFAULT_ROOT_URL,
        DEFAULT_SERVICE_PATH,
        httpRequestInitializer,
        false);
  }

  /**
   * @param transport HTTP transport
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @param rootUrl root URL of the service
   * @param servicePath service path
   * @param jsonObjectParser JSON object parser
   * @param googleClientRequestInitializer Google request initializer or {@code null} for none
   * @param applicationName application name to be sent in the User-Agent header of requests or
   *        {@code null} for none
   * @param suppressPatternChecks whether discovery pattern checks should be suppressed on required
   *        parameters
   */
  Oauth2(HttpTransport transport,
      HttpRequestInitializer httpRequestInitializer,
      String rootUrl,
      String servicePath,
      JsonObjectParser jsonObjectParser,
      GoogleClientRequestInitializer googleClientRequestInitializer,
      String applicationName,
      boolean suppressPatternChecks) {
    super(transport,
        httpRequestInitializer,
        rootUrl,
        servicePath,
        jsonObjectParser,
        googleClientRequestInitializer,
        applicationName,
        suppressPatternChecks);
  }

  @Override
  protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Userinfo collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Oauth2 oauth2 = new Oauth2(...);}
   *   {@code Oauth2.Userinfo.List request = oauth2.userinfo().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Userinfo userinfo() {
    return new Userinfo();
  }

  /**
   * The "userinfo" collection of methods.
   */
  public class Userinfo {

    /**
     * Get user info
     *
     * Create a request for the method "userinfo.get".
     *
     * This request holds the parameters needed by the the oauth2 server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Get get() throws java.io.IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }

    public class Get extends Oauth2Request<com.google.api.services.oauth2.model.Userinfo> {

      private static final String REST_PATH = "oauth2/v1/userinfo";

      /**
       * Get user info
       *
       * Create a request for the method "userinfo.get".
       *
       * This request holds the parameters needed by the the oauth2 server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Get() {
        super(Oauth2.this, "GET", REST_PATH, null, com.google.api.services.oauth2.model.Userinfo.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

    }

    /**
     * An accessor for creating requests from the V2 collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Oauth2 oauth2 = new Oauth2(...);}
     *   {@code Oauth2.V2.List request = oauth2.v2().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public V2 v2() {
      return new V2();
    }

    /**
     * The "v2" collection of methods.
     */
    public class V2 {

      /**
       * An accessor for creating requests from the Me collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Oauth2 oauth2 = new Oauth2(...);}
       *   {@code Oauth2.Me.List request = oauth2.me().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Me me() {
        return new Me();
      }

      /**
       * The "me" collection of methods.
       */
      public class Me {

        /**
         * Get user info
         *
         * Create a request for the method "me.get".
         *
         * This request holds the parameters needed by the the oauth2 server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @return the request
         */
        public Get get() throws java.io.IOException {
          Get result = new Get();
          initialize(result);
          return result;
        }

        public class Get extends Oauth2Request<com.google.api.services.oauth2.model.Userinfo> {

          private static final String REST_PATH = "userinfo/v2/me";

          /**
           * Get user info
           *
           * Create a request for the method "me.get".
           *
           * This request holds the parameters needed by the the oauth2 server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
           * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
           * immediately after invoking the constructor. </p>
           *
           * @since 1.13
           */
          protected Get() {
            super(Oauth2.this, "GET", REST_PATH, null, com.google.api.services.oauth2.model.Userinfo.class);
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get setAlt(String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setFields(String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUserIp(String userIp) {
            return (Get) super.setUserIp(userIp);
          }

        }

      }
    }
  }

  /**
   * Get token info
   *
   * Create a request for the method "tokeninfo".
   *
   * This request holds the parameters needed by the the oauth2 server.  After setting any optional
   * parameters, call the {@link Tokeninfo#execute()} method to invoke the remote operation.
   *
   * @return the request
   */
  public Tokeninfo tokeninfo() throws java.io.IOException {
    Tokeninfo result = new Tokeninfo();
    initialize(result);
    return result;
  }

  public class Tokeninfo extends Oauth2Request<com.google.api.services.oauth2.model.Tokeninfo> {

    private static final String REST_PATH = "oauth2/v1/tokeninfo";

    /**
     * Get token info
     *
     * Create a request for the method "tokeninfo".
     *
     * This request holds the parameters needed by the the oauth2 server.  After setting any optional
     * parameters, call the {@link Tokeninfo#execute()} method to invoke the remote operation. <p>
     * {@link Tokeninfo#initialize(AbstractGoogleClientRequest)} must be called to initialize this
     * instance immediately after invoking the constructor. </p>
     *
     * @since 1.13
     */
    protected Tokeninfo() {
      super(Oauth2.this, "POST", REST_PATH, null, com.google.api.services.oauth2.model.Tokeninfo.class);
    }

    @Override
    public Tokeninfo setAlt(String alt) {
      return (Tokeninfo) super.setAlt(alt);
    }

    @Override
    public Tokeninfo setFields(String fields) {
      return (Tokeninfo) super.setFields(fields);
    }

    @Override
    public Tokeninfo setKey(String key) {
      return (Tokeninfo) super.setKey(key);
    }

    @Override
    public Tokeninfo setOauthToken(String oauthToken) {
      return (Tokeninfo) super.setOauthToken(oauthToken);
    }

    @Override
    public Tokeninfo setPrettyPrint(Boolean prettyPrint) {
      return (Tokeninfo) super.setPrettyPrint(prettyPrint);
    }

    @Override
    public Tokeninfo setQuotaUser(String quotaUser) {
      return (Tokeninfo) super.setQuotaUser(quotaUser);
    }

    @Override
    public Tokeninfo setUserIp(String userIp) {
      return (Tokeninfo) super.setUserIp(userIp);
    }

    /** The oauth2 access token */
    @com.google.api.client.util.Key("access_token")
    private String accessToken;

    /** The oauth2 access token
     */
    public String getAccessToken() {
      return accessToken;
    }

    /** The oauth2 access token */
    public Tokeninfo setAccessToken(String accessToken) {
      this.accessToken = accessToken;
      return this;
    }

    /** The ID token */
    @com.google.api.client.util.Key("id_token")
    private String idToken;

    /** The ID token
     */
    public String getIdToken() {
      return idToken;
    }

    /** The ID token */
    public Tokeninfo setIdToken(String idToken) {
      this.idToken = idToken;
      return this;
    }

  }

  /**
   * Builder for {@link Oauth2}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport
     * @param jsonFactory JSON factory
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Oauth2}. */
    @Override
    public Oauth2 build() {
      return new Oauth2(getTransport(),
          getHttpRequestInitializer(),
          getRootUrl(),
          getServicePath(),
          getObjectParser(),
          getGoogleClientRequestInitializer(),
          getApplicationName(),
          getSuppressPatternChecks());
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    /**
     * Set the {@link Oauth2RequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setOauth2RequestInitializer(
        Oauth2RequestInitializer oauth2RequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(oauth2RequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
