/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.1.1 (build: 2012-06-25 20:14:04 UTC)
 *  on 2012-06-28 at 17:08:27 UTC 
 */

package com.google.api.services.oauth2;


import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

import java.io.IOException;


/**
 * Service definition for Oauth2 (v2).
 *
 * <p>
 * OAuth2 API
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link JsonHttpRequestInitializer} to initialize global parameters via its
 * {@link Builder}. Sample usage:
 * </p>
 *
 * <pre>
  public class Oauth2RequestInitializer implements JsonHttpRequestInitializer {
      public void initialize(JsonHttpRequest request) {
        Oauth2Request oauth2Request = (Oauth2Request)request;
        oauth2Request.setPrettyPrint(true);
        oauth2Request.setKey(ClientCredentials.KEY);
    }
  }
 * </pre>
 *
 * @since 1.3.0
 * @author Google, Inc.
 */
public class Oauth2 extends GoogleClient {

  /**
   * The default encoded base path of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.8) Use "/" + {@link #DEFAULT_SERVICE_PATH}.
   */
  @Deprecated
  public static final String DEFAULT_BASE_PATH = "//";

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Construct a Oauth2 instance to connect to the Oauth2 service.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @deprecated (scheduled to be removed in 1.8) Use
   *             {@link #Oauth2(HttpTransport, JsonFactory, HttpRequestInitializer)}.
   */
  @Deprecated
  public Oauth2(HttpTransport transport, JsonFactory jsonFactory) {
    super(transport, jsonFactory, DEFAULT_BASE_URL);
  }

  /**
   * Construct a Oauth2 instance to connect to the Oauth2 service.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param httpRequestInitializer The HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Oauth2(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer);
  }

  /**
   * Construct a Oauth2 instance to connect to the Oauth2 service.
   *
   * @param transport The transport to use for requests
   * @param jsonHttpRequestInitializer The initializer to use when creating an JSON HTTP request
   * @param httpRequestInitializer The initializer to use when creating an {@link HttpRequest}
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param jsonObjectParser JSON parser to use or {@code null} if unused
   * @param baseUrl The base URL of the service on the server
   * @param applicationName The application name to be sent in the User-Agent header of requests
   */
  @Deprecated
  Oauth2(
      HttpTransport transport,
      JsonHttpRequestInitializer jsonHttpRequestInitializer,
      HttpRequestInitializer httpRequestInitializer,
      JsonFactory jsonFactory,
      JsonObjectParser jsonObjectParser,
      String baseUrl,
      String applicationName) {
      super(transport,
          jsonHttpRequestInitializer,
          httpRequestInitializer,
          jsonFactory,
          jsonObjectParser,
          baseUrl,
          applicationName);
  }

  /**
   * Construct a Oauth2 instance to connect to the Oauth2 service.
   *
   * @param transport The transport to use for requests
   * @param jsonHttpRequestInitializer The initializer to use when creating an JSON HTTP request
   * @param httpRequestInitializer The initializer to use when creating an {@link HttpRequest}
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @param jsonObjectParser JSON parser to use or {@code null} if unused
   * @param rootUrl The root URL of the service on the server
   * @param servicePath The service path of the service on the server
   * @param applicationName The application name to be sent in the User-Agent header of requests
   */
  Oauth2(
      HttpTransport transport,
      JsonHttpRequestInitializer jsonHttpRequestInitializer,
      HttpRequestInitializer httpRequestInitializer,
      JsonFactory jsonFactory,
      JsonObjectParser jsonObjectParser,
      String rootUrl,
      String servicePath,
      String applicationName) {
      super(transport,
          jsonHttpRequestInitializer,
          httpRequestInitializer,
          jsonFactory,
          jsonObjectParser,
          rootUrl,
          servicePath,
          applicationName);
  }

  @Override
  protected void initialize(JsonHttpRequest jsonHttpRequest) throws IOException {
    super.initialize(jsonHttpRequest);
  }


  /**
   * Returns an instance of a new builder.
   *
   * @param transport The transport to use for requests
   * @param jsonFactory A factory for creating JSON parsers and serializers
   * @deprecated (scheduled to removed in 1.8) Use
   *             {@link Builder#Builder(HttpTransport, JsonFactory, HttpRequestInitializer)}.
   */
   @Deprecated
   public static Builder builder(HttpTransport transport, JsonFactory jsonFactory) {
     return new Builder(transport, jsonFactory, new GenericUrl(DEFAULT_BASE_URL));
   }

  /**
   * An accessor for creating requests from the Userinfo collection.
   *
   * The typical use is:<pre>
   *   {@code Oauth2 oauth2 = new Oauth2(...);}
   *   {@code Oauth2.Userinfo.List request = oauth2.userinfo().list(parameters ...)}</pre>
   *
   * @return the resource collection
   */
  public Userinfo userinfo() {
    return new Userinfo();
  }

  /**
   * The "userinfo" collection of methods.
   */
  public class Userinfo {

    /**
     * Create a request for the method "userinfo.get".
     *
     * This request holds the parameters needed by the the oauth2 server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     * @throws IOException if the initialization of the request fails
     */
    public Get get() throws IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }


    public class Get extends Oauth2Request {

      private static final String REST_PATH = "oauth2/v2/userinfo";

      /**
       * Internal constructor.  Use the convenience method instead.
       */
      Get() {
        super(Oauth2.this, HttpMethod.GET, REST_PATH, null);
      }



      /**
       * Sends the "get" request to the Oauth2 server.
       *
       * @return the {@link com.google.api.services.oauth2.model.Userinfo} response
       * @throws IOException if the request fails
       */
      public com.google.api.services.oauth2.model.Userinfo execute() throws IOException {
        HttpResponse response = executeUnparsed();
        com.google.api.services.oauth2.model.Userinfo result = response.parseAs(
            com.google.api.services.oauth2.model.Userinfo.class);
        result.setResponseHeaders(response.getHeaders());
        return result;
      }

      /**
       * Queues the "get" request to the Oauth2 server into the given batch request.
       *
       * <p>
       * Example usage:
       * </p>
       *
       * <pre>
         request.queue(batchRequest, new JsonBatchCallback&lt;Userinfo&gt;() {

           public void onSuccess(Userinfo content, GoogleHeaders responseHeaders) {
             log("Success");
           }

           public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
             log(e.getMessage());
           }
         });
       * </pre>
       *
       * @param batch a single batch of requests
       * @param callback batch callback
       * @since 1.6
       */
      public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
          com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.oauth2.model.Userinfo> callback)
          throws IOException {
        batch.queue(buildHttpRequest(), com.google.api.services.oauth2.model.Userinfo.class,
            com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
      }

      /**
       * @since 1.7
       */
      @Override
      public Get setFields(String fields) {
        super.setFields(fields);
        return this;
      }



    }

    /**
     * An accessor for creating requests from the V2 collection.
     *
     * The typical use is:<pre>
     *   {@code Oauth2 oauth2 = new Oauth2(...);}
     *   {@code Oauth2.V2.List request = oauth2.v2().list(parameters ...)}</pre>
     *
     * @return the resource collection
     */
    public V2 v2() {
      return new V2();
    }

    /**
     * The "v2" collection of methods.
     */
    public class V2 {


      /**
       * An accessor for creating requests from the Me collection.
       *
       * The typical use is:<pre>
       *   {@code Oauth2 oauth2 = new Oauth2(...);}
       *   {@code Oauth2.Me.List request = oauth2.me().list(parameters ...)}</pre>
       *
       * @return the resource collection
       */
      public Me me() {
        return new Me();
      }

      /**
       * The "me" collection of methods.
       */
      public class Me {

        /**
         * Create a request for the method "me.get".
         *
         * This request holds the parameters needed by the the oauth2 server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @return the request
         * @throws IOException if the initialization of the request fails
         */
        public Get get() throws IOException {
          Get result = new Get();
          initialize(result);
          return result;
        }


        public class Get extends Oauth2Request {

          private static final String REST_PATH = "userinfo/v2/me";

          /**
           * Internal constructor.  Use the convenience method instead.
           */
          Get() {
            super(Oauth2.this, HttpMethod.GET, REST_PATH, null);
          }



          /**
           * Sends the "get" request to the Oauth2 server.
           *
           * @return the {@link com.google.api.services.oauth2.model.Userinfo} response
           * @throws IOException if the request fails
           */
          public com.google.api.services.oauth2.model.Userinfo execute() throws IOException {
            HttpResponse response = executeUnparsed();
            com.google.api.services.oauth2.model.Userinfo result = response.parseAs(
                com.google.api.services.oauth2.model.Userinfo.class);
            result.setResponseHeaders(response.getHeaders());
            return result;
          }

          /**
           * Queues the "get" request to the Oauth2 server into the given batch request.
           *
           * <p>
           * Example usage:
           * </p>
           *
           * <pre>
             request.queue(batchRequest, new JsonBatchCallback&lt;Userinfo&gt;() {

               public void onSuccess(Userinfo content, GoogleHeaders responseHeaders) {
                 log("Success");
               }

               public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
                 log(e.getMessage());
               }
             });
           * </pre>
           *
           * @param batch a single batch of requests
           * @param callback batch callback
           * @since 1.6
           */
          public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
              com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.oauth2.model.Userinfo> callback)
              throws IOException {
            batch.queue(buildHttpRequest(), com.google.api.services.oauth2.model.Userinfo.class,
                com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
          }

          /**
           * @since 1.7
           */
          @Override
          public Get setFields(String fields) {
            super.setFields(fields);
            return this;
          }



        }

      }
    }
  }


  /**
   * Create a request for the method "tokeninfo".
   *
   * This request holds the parameters needed by the the oauth2 server.  After setting any optional
   * parameters, call the {@link Tokeninfo#execute()} method to invoke the remote operation.
   *
   * @return the request
   * @throws IOException if the initialization of the request fails
   */
  public Tokeninfo tokeninfo() throws IOException {
    Tokeninfo result = new Tokeninfo();
    initialize(result);
    return result;
  }


  public class Tokeninfo extends Oauth2Request {

    private static final String REST_PATH = "oauth2/v2/tokeninfo";

    /**
     * Internal constructor.  Use the convenience method instead.
     */
    Tokeninfo() {
      super(Oauth2.this, HttpMethod.POST, REST_PATH, null);
    }



    /**
     * Sends the "tokeninfo" request to the Oauth2 server.
     *
     * @return the {@link com.google.api.services.oauth2.model.Tokeninfo} response
     * @throws IOException if the request fails
     */
    public com.google.api.services.oauth2.model.Tokeninfo execute() throws IOException {
      HttpResponse response = executeUnparsed();
      com.google.api.services.oauth2.model.Tokeninfo result = response.parseAs(
          com.google.api.services.oauth2.model.Tokeninfo.class);
      result.setResponseHeaders(response.getHeaders());
      return result;
    }

    /**
     * Queues the "tokeninfo" request to the Oauth2 server into the given batch request.
     *
     * <p>
     * Example usage:
     * </p>
     *
     * <pre>
       request.queue(batchRequest, new JsonBatchCallback&lt;Tokeninfo&gt;() {

         public void onSuccess(Tokeninfo content, GoogleHeaders responseHeaders) {
           log("Success");
         }

         public void onFailure(GoogleJsonError e, GoogleHeaders responseHeaders) {
           log(e.getMessage());
         }
       });
     * </pre>
     *
     * @param batch a single batch of requests
     * @param callback batch callback
     * @since 1.6
     */
    public void queue(com.google.api.client.googleapis.batch.BatchRequest batch,
        com.google.api.client.googleapis.batch.json.JsonBatchCallback<com.google.api.services.oauth2.model.Tokeninfo> callback)
        throws IOException {
      batch.queue(buildHttpRequest(), com.google.api.services.oauth2.model.Tokeninfo.class,
          com.google.api.client.googleapis.json.GoogleJsonErrorContainer.class, callback);
    }

    /**
     * @since 1.7
     */
    @Override
    public Tokeninfo setFields(String fields) {
      super.setFields(fields);
      return this;
    }


    @com.google.api.client.util.Key("access_token")
    private String accessToken;

    /**

     */
    public String getAccessToken() {
      return accessToken;
    }


    public Tokeninfo setAccessToken(String accessToken) {
      this.accessToken = accessToken;
      return this;
    }


    @com.google.api.client.util.Key("id_token")
    private String idToken;

    /**

     */
    public String getIdToken() {
      return idToken;
    }


    public Tokeninfo setIdToken(String idToken) {
      this.idToken = idToken;
      return this;
    }



  }


  /**
   * Builder for {@link Oauth2}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends GoogleClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport The transport to use for requests
     * @param jsonFactory A factory for creating JSON parsers and serializers
     * @param baseUrl The base URL of the service. Must end with a "/"
     */
    @Deprecated
    Builder(HttpTransport transport, JsonFactory jsonFactory, GenericUrl baseUrl) {
      super(transport, jsonFactory, baseUrl);
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport The transport to use for requests
     * @param jsonFactory A factory for creating JSON parsers and serializers
     * @param httpRequestInitializer The HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(transport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer);
    }

    /** Builds a new instance of {@link Oauth2}. */
    @SuppressWarnings("deprecation")
    @Override
    public Oauth2 build() {
      if (isBaseUrlUsed()) {
        return new Oauth2(
            getTransport(),
            getJsonHttpRequestInitializer(),
            getHttpRequestInitializer(),
            getJsonFactory(),
            getObjectParser(),
            getBaseUrl().build(),
            getApplicationName());
      }
      return new Oauth2(
          getTransport(),
          getJsonHttpRequestInitializer(),
          getHttpRequestInitializer(),
          getJsonFactory(),
          getObjectParser(),
          getRootUrl(),
          getServicePath(),
          getApplicationName());
    }

    @Override
    @Deprecated
    public Builder setBaseUrl(GenericUrl baseUrl) {
      super.setBaseUrl(baseUrl);
      return this;
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      super.setRootUrl(rootUrl);
      return this;
    }

    @Override
    public Builder setServicePath(String servicePath) {
      super.setServicePath(servicePath);
      return this;
    }

    @Override
    public Builder setJsonHttpRequestInitializer(
        JsonHttpRequestInitializer jsonHttpRequestInitializer) {
      super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
      return this;
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      super.setHttpRequestInitializer(httpRequestInitializer);
      return this;
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      super.setApplicationName(applicationName);
      return this;
    }

    @Override
    public Builder setObjectParser(JsonObjectParser parser) {
      super.setObjectParser(parser);
      return this;
    }
  }
}
