/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-04-29 14:08:19 UTC)
 * on 2013-05-01 at 03:11:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.plus.model;

/**
 * Model definition for MomentsFeed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MomentsFeed extends com.google.api.client.json.GenericJson {

  /**
   * ETag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The moments in this page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Moment> items;

  static {
    // hack to force ProGuard to consider Moment used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Moment.class);
  }

  /**
   * Identifies this resource as a collection of moments. Value: "plus#momentsFeed".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Link to the next page of moments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextLink;

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Link to this page of moments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The title of this collection of moments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The RFC 339 timestamp for when this collection of moments was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * ETag of this response for caching purposes.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of this response for caching purposes.
   * @param etag etag or {@code null} for none
   */
  public MomentsFeed setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The moments in this page of results.
   * @return value or {@code null} for none
   */
  public java.util.List<Moment> getItems() {
    return items;
  }

  /**
   * The moments in this page of results.
   * @param items items or {@code null} for none
   */
  public MomentsFeed setItems(java.util.List<Moment> items) {
    this.items = items;
    return this;
  }

  /**
   * Identifies this resource as a collection of moments. Value: "plus#momentsFeed".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a collection of moments. Value: "plus#momentsFeed".
   * @param kind kind or {@code null} for none
   */
  public MomentsFeed setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to the next page of moments.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextLink() {
    return nextLink;
  }

  /**
   * Link to the next page of moments.
   * @param nextLink nextLink or {@code null} for none
   */
  public MomentsFeed setNextLink(java.lang.String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The continuation token, which is used to page through large result sets. Provide this value in
   * a subsequent request to return the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public MomentsFeed setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Link to this page of moments.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this page of moments.
   * @param selfLink selfLink or {@code null} for none
   */
  public MomentsFeed setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The title of this collection of moments.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of this collection of moments.
   * @param title title or {@code null} for none
   */
  public MomentsFeed setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The RFC 339 timestamp for when this collection of moments was last updated.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * The RFC 339 timestamp for when this collection of moments was last updated.
   * @param updated updated or {@code null} for none
   */
  public MomentsFeed setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public MomentsFeed set(String fieldName, Object value) {
    return (MomentsFeed) super.set(fieldName, value);
  }

  @Override
  public MomentsFeed clone() {
    return (MomentsFeed) super.clone();
  }

}
