/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-25 at 21:38:37 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Request for the ModifyAckDeadline method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Pub/Sub API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ModifyAckDeadlineRequest extends com.google.api.client.json.GenericJson {

  /**
   * The new ack deadline with respect to the time this request was sent to the Pub/Sub system. For
   * example, if the value is 10, the new ack deadline will expire 10 seconds after the
   * `ModifyAckDeadline` call was made. Specifying zero may immediately make the message available
   * for another pull request. The minimum deadline you can specify is 0 seconds. The maximum
   * deadline you can specify is 600 seconds (10 minutes).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ackDeadlineSeconds;

  /**
   * List of acknowledgment IDs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ackIds;

  /**
   * The new ack deadline with respect to the time this request was sent to the Pub/Sub system. For
   * example, if the value is 10, the new ack deadline will expire 10 seconds after the
   * `ModifyAckDeadline` call was made. Specifying zero may immediately make the message available
   * for another pull request. The minimum deadline you can specify is 0 seconds. The maximum
   * deadline you can specify is 600 seconds (10 minutes).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAckDeadlineSeconds() {
    return ackDeadlineSeconds;
  }

  /**
   * The new ack deadline with respect to the time this request was sent to the Pub/Sub system. For
   * example, if the value is 10, the new ack deadline will expire 10 seconds after the
   * `ModifyAckDeadline` call was made. Specifying zero may immediately make the message available
   * for another pull request. The minimum deadline you can specify is 0 seconds. The maximum
   * deadline you can specify is 600 seconds (10 minutes).
   * @param ackDeadlineSeconds ackDeadlineSeconds or {@code null} for none
   */
  public ModifyAckDeadlineRequest setAckDeadlineSeconds(java.lang.Integer ackDeadlineSeconds) {
    this.ackDeadlineSeconds = ackDeadlineSeconds;
    return this;
  }

  /**
   * List of acknowledgment IDs.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAckIds() {
    return ackIds;
  }

  /**
   * List of acknowledgment IDs.
   * @param ackIds ackIds or {@code null} for none
   */
  public ModifyAckDeadlineRequest setAckIds(java.util.List<java.lang.String> ackIds) {
    this.ackIds = ackIds;
    return this;
  }

  @Override
  public ModifyAckDeadlineRequest set(String fieldName, Object value) {
    return (ModifyAckDeadlineRequest) super.set(fieldName, value);
  }

  @Override
  public ModifyAckDeadlineRequest clone() {
    return (ModifyAckDeadlineRequest) super.clone();
  }

}
