/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.pubsub;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.pubsub.PubsubRequest;
import com.google.api.services.pubsub.PubsubRequestInitializer;
import com.google.api.services.pubsub.model.AcknowledgeRequest;
import com.google.api.services.pubsub.model.Empty;
import com.google.api.services.pubsub.model.ListSubscriptionsResponse;
import com.google.api.services.pubsub.model.ListTopicsResponse;
import com.google.api.services.pubsub.model.ModifyAckDeadlineRequest;
import com.google.api.services.pubsub.model.ModifyPushConfigRequest;
import com.google.api.services.pubsub.model.PublishBatchRequest;
import com.google.api.services.pubsub.model.PublishBatchResponse;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PullBatchRequest;
import com.google.api.services.pubsub.model.PullBatchResponse;
import com.google.api.services.pubsub.model.PullRequest;
import com.google.api.services.pubsub.model.PullResponse;
import com.google.api.services.pubsub.model.Subscription;
import com.google.api.services.pubsub.model.Topic;
import java.io.IOException;
import java.util.regex.Pattern;

public class Pubsub
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://pubsub.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://pubsub.googleapis.com/";

    public Pubsub(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Pubsub(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Subscriptions subscriptions() {
        return new Subscriptions();
    }

    public Topics topics() {
        return new Topics();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.26.0 of the Cloud Pub/Sub API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://pubsub.googleapis.com/", Pubsub.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Pubsub.DEFAULT_BATCH_PATH);
        }

        public Pubsub build() {
            return new Pubsub(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setPubsubRequestInitializer(PubsubRequestInitializer pubsubRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)pubsubRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Topics {
        public Create create(Topic content) throws IOException {
            Create result = new Create(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String topic) throws IOException {
            Delete result = new Delete(topic);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String topic) throws IOException {
            Get result = new Get(topic);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Publish publish(PublishRequest content) throws IOException {
            Publish result = new Publish(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public PublishBatch publishBatch(PublishBatchRequest content) throws IOException {
            PublishBatch result = new PublishBatch(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class PublishBatch
        extends PubsubRequest<PublishBatchResponse> {
            private static final String REST_PATH = "v1beta1a/topics/publishBatch";

            protected PublishBatch(PublishBatchRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, PublishBatchResponse.class);
            }

            public PublishBatch set$Xgafv(String $Xgafv) {
                return (PublishBatch)super.set$Xgafv($Xgafv);
            }

            public PublishBatch setAccessToken(String accessToken) {
                return (PublishBatch)super.setAccessToken(accessToken);
            }

            public PublishBatch setAlt(String alt) {
                return (PublishBatch)super.setAlt(alt);
            }

            public PublishBatch setCallback(String callback) {
                return (PublishBatch)super.setCallback(callback);
            }

            public PublishBatch setFields(String fields) {
                return (PublishBatch)super.setFields(fields);
            }

            public PublishBatch setKey(String key) {
                return (PublishBatch)super.setKey(key);
            }

            public PublishBatch setOauthToken(String oauthToken) {
                return (PublishBatch)super.setOauthToken(oauthToken);
            }

            public PublishBatch setPrettyPrint(Boolean prettyPrint) {
                return (PublishBatch)super.setPrettyPrint(prettyPrint);
            }

            public PublishBatch setQuotaUser(String quotaUser) {
                return (PublishBatch)super.setQuotaUser(quotaUser);
            }

            public PublishBatch setUploadType(String uploadType) {
                return (PublishBatch)super.setUploadType(uploadType);
            }

            public PublishBatch setUploadProtocol(String uploadProtocol) {
                return (PublishBatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public PublishBatch set(String parameterName, Object value) {
                return (PublishBatch)super.set(parameterName, value);
            }
        }

        public class Publish
        extends PubsubRequest<Empty> {
            private static final String REST_PATH = "v1beta1a/topics/publish";

            protected Publish(PublishRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public Publish set$Xgafv(String $Xgafv) {
                return (Publish)super.set$Xgafv($Xgafv);
            }

            public Publish setAccessToken(String accessToken) {
                return (Publish)super.setAccessToken(accessToken);
            }

            public Publish setAlt(String alt) {
                return (Publish)super.setAlt(alt);
            }

            public Publish setCallback(String callback) {
                return (Publish)super.setCallback(callback);
            }

            public Publish setFields(String fields) {
                return (Publish)super.setFields(fields);
            }

            public Publish setKey(String key) {
                return (Publish)super.setKey(key);
            }

            public Publish setOauthToken(String oauthToken) {
                return (Publish)super.setOauthToken(oauthToken);
            }

            public Publish setPrettyPrint(Boolean prettyPrint) {
                return (Publish)super.setPrettyPrint(prettyPrint);
            }

            public Publish setQuotaUser(String quotaUser) {
                return (Publish)super.setQuotaUser(quotaUser);
            }

            public Publish setUploadType(String uploadType) {
                return (Publish)super.setUploadType(uploadType);
            }

            public Publish setUploadProtocol(String uploadProtocol) {
                return (Publish)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Publish set(String parameterName, Object value) {
                return (Publish)super.set(parameterName, value);
            }
        }

        public class List
        extends PubsubRequest<ListTopicsResponse> {
            private static final String REST_PATH = "v1beta1a/topics";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String query;

            protected List() {
                super(Pubsub.this, "GET", REST_PATH, null, ListTopicsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PubsubRequest<Topic> {
            private static final String REST_PATH = "v1beta1a/topics/{+topic}";
            private final Pattern TOPIC_PATTERN;
            @Key
            private String topic;

            protected Get(String topic) {
                super(Pubsub.this, "GET", REST_PATH, null, Topic.class);
                this.TOPIC_PATTERN = Pattern.compile("^.+$");
                this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^.+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getTopic() {
                return this.topic;
            }

            public Get setTopic(String topic) {
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^.+$");
                }
                this.topic = topic;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends PubsubRequest<Empty> {
            private static final String REST_PATH = "v1beta1a/topics/{+topic}";
            private final Pattern TOPIC_PATTERN;
            @Key
            private String topic;

            protected Delete(String topic) {
                super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                this.TOPIC_PATTERN = Pattern.compile("^.+$");
                this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"Required parameter topic must be specified.");
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^.+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getTopic() {
                return this.topic;
            }

            public Delete setTopic(String topic) {
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TOPIC_PATTERN.matcher(topic).matches(), (Object)"Parameter topic must conform to the pattern ^.+$");
                }
                this.topic = topic;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends PubsubRequest<Topic> {
            private static final String REST_PATH = "v1beta1a/topics";

            protected Create(Topic content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, Topic.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Subscriptions {
        public Acknowledge acknowledge(AcknowledgeRequest content) throws IOException {
            Acknowledge result = new Acknowledge(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Subscription content) throws IOException {
            Create result = new Create(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String subscription) throws IOException {
            Delete result = new Delete(subscription);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String subscription) throws IOException {
            Get result = new Get(subscription);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ModifyAckDeadline modifyAckDeadline(ModifyAckDeadlineRequest content) throws IOException {
            ModifyAckDeadline result = new ModifyAckDeadline(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ModifyPushConfig modifyPushConfig(ModifyPushConfigRequest content) throws IOException {
            ModifyPushConfig result = new ModifyPushConfig(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Pull pull(PullRequest content) throws IOException {
            Pull result = new Pull(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public PullBatch pullBatch(PullBatchRequest content) throws IOException {
            PullBatch result = new PullBatch(content);
            Pubsub.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class PullBatch
        extends PubsubRequest<PullBatchResponse> {
            private static final String REST_PATH = "v1beta1a/subscriptions/pullBatch";

            protected PullBatch(PullBatchRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, PullBatchResponse.class);
            }

            public PullBatch set$Xgafv(String $Xgafv) {
                return (PullBatch)super.set$Xgafv($Xgafv);
            }

            public PullBatch setAccessToken(String accessToken) {
                return (PullBatch)super.setAccessToken(accessToken);
            }

            public PullBatch setAlt(String alt) {
                return (PullBatch)super.setAlt(alt);
            }

            public PullBatch setCallback(String callback) {
                return (PullBatch)super.setCallback(callback);
            }

            public PullBatch setFields(String fields) {
                return (PullBatch)super.setFields(fields);
            }

            public PullBatch setKey(String key) {
                return (PullBatch)super.setKey(key);
            }

            public PullBatch setOauthToken(String oauthToken) {
                return (PullBatch)super.setOauthToken(oauthToken);
            }

            public PullBatch setPrettyPrint(Boolean prettyPrint) {
                return (PullBatch)super.setPrettyPrint(prettyPrint);
            }

            public PullBatch setQuotaUser(String quotaUser) {
                return (PullBatch)super.setQuotaUser(quotaUser);
            }

            public PullBatch setUploadType(String uploadType) {
                return (PullBatch)super.setUploadType(uploadType);
            }

            public PullBatch setUploadProtocol(String uploadProtocol) {
                return (PullBatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public PullBatch set(String parameterName, Object value) {
                return (PullBatch)super.set(parameterName, value);
            }
        }

        public class Pull
        extends PubsubRequest<PullResponse> {
            private static final String REST_PATH = "v1beta1a/subscriptions/pull";

            protected Pull(PullRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, PullResponse.class);
            }

            public Pull set$Xgafv(String $Xgafv) {
                return (Pull)super.set$Xgafv($Xgafv);
            }

            public Pull setAccessToken(String accessToken) {
                return (Pull)super.setAccessToken(accessToken);
            }

            public Pull setAlt(String alt) {
                return (Pull)super.setAlt(alt);
            }

            public Pull setCallback(String callback) {
                return (Pull)super.setCallback(callback);
            }

            public Pull setFields(String fields) {
                return (Pull)super.setFields(fields);
            }

            public Pull setKey(String key) {
                return (Pull)super.setKey(key);
            }

            public Pull setOauthToken(String oauthToken) {
                return (Pull)super.setOauthToken(oauthToken);
            }

            public Pull setPrettyPrint(Boolean prettyPrint) {
                return (Pull)super.setPrettyPrint(prettyPrint);
            }

            public Pull setQuotaUser(String quotaUser) {
                return (Pull)super.setQuotaUser(quotaUser);
            }

            public Pull setUploadType(String uploadType) {
                return (Pull)super.setUploadType(uploadType);
            }

            public Pull setUploadProtocol(String uploadProtocol) {
                return (Pull)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Pull set(String parameterName, Object value) {
                return (Pull)super.set(parameterName, value);
            }
        }

        public class ModifyPushConfig
        extends PubsubRequest<Empty> {
            private static final String REST_PATH = "v1beta1a/subscriptions/modifyPushConfig";

            protected ModifyPushConfig(ModifyPushConfigRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public ModifyPushConfig set$Xgafv(String $Xgafv) {
                return (ModifyPushConfig)super.set$Xgafv($Xgafv);
            }

            public ModifyPushConfig setAccessToken(String accessToken) {
                return (ModifyPushConfig)super.setAccessToken(accessToken);
            }

            public ModifyPushConfig setAlt(String alt) {
                return (ModifyPushConfig)super.setAlt(alt);
            }

            public ModifyPushConfig setCallback(String callback) {
                return (ModifyPushConfig)super.setCallback(callback);
            }

            public ModifyPushConfig setFields(String fields) {
                return (ModifyPushConfig)super.setFields(fields);
            }

            public ModifyPushConfig setKey(String key) {
                return (ModifyPushConfig)super.setKey(key);
            }

            public ModifyPushConfig setOauthToken(String oauthToken) {
                return (ModifyPushConfig)super.setOauthToken(oauthToken);
            }

            public ModifyPushConfig setPrettyPrint(Boolean prettyPrint) {
                return (ModifyPushConfig)super.setPrettyPrint(prettyPrint);
            }

            public ModifyPushConfig setQuotaUser(String quotaUser) {
                return (ModifyPushConfig)super.setQuotaUser(quotaUser);
            }

            public ModifyPushConfig setUploadType(String uploadType) {
                return (ModifyPushConfig)super.setUploadType(uploadType);
            }

            public ModifyPushConfig setUploadProtocol(String uploadProtocol) {
                return (ModifyPushConfig)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public ModifyPushConfig set(String parameterName, Object value) {
                return (ModifyPushConfig)super.set(parameterName, value);
            }
        }

        public class ModifyAckDeadline
        extends PubsubRequest<Empty> {
            private static final String REST_PATH = "v1beta1a/subscriptions/modifyAckDeadline";

            protected ModifyAckDeadline(ModifyAckDeadlineRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public ModifyAckDeadline set$Xgafv(String $Xgafv) {
                return (ModifyAckDeadline)super.set$Xgafv($Xgafv);
            }

            public ModifyAckDeadline setAccessToken(String accessToken) {
                return (ModifyAckDeadline)super.setAccessToken(accessToken);
            }

            public ModifyAckDeadline setAlt(String alt) {
                return (ModifyAckDeadline)super.setAlt(alt);
            }

            public ModifyAckDeadline setCallback(String callback) {
                return (ModifyAckDeadline)super.setCallback(callback);
            }

            public ModifyAckDeadline setFields(String fields) {
                return (ModifyAckDeadline)super.setFields(fields);
            }

            public ModifyAckDeadline setKey(String key) {
                return (ModifyAckDeadline)super.setKey(key);
            }

            public ModifyAckDeadline setOauthToken(String oauthToken) {
                return (ModifyAckDeadline)super.setOauthToken(oauthToken);
            }

            public ModifyAckDeadline setPrettyPrint(Boolean prettyPrint) {
                return (ModifyAckDeadline)super.setPrettyPrint(prettyPrint);
            }

            public ModifyAckDeadline setQuotaUser(String quotaUser) {
                return (ModifyAckDeadline)super.setQuotaUser(quotaUser);
            }

            public ModifyAckDeadline setUploadType(String uploadType) {
                return (ModifyAckDeadline)super.setUploadType(uploadType);
            }

            public ModifyAckDeadline setUploadProtocol(String uploadProtocol) {
                return (ModifyAckDeadline)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public ModifyAckDeadline set(String parameterName, Object value) {
                return (ModifyAckDeadline)super.set(parameterName, value);
            }
        }

        public class List
        extends PubsubRequest<ListSubscriptionsResponse> {
            private static final String REST_PATH = "v1beta1a/subscriptions";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String query;

            protected List() {
                super(Pubsub.this, "GET", REST_PATH, null, ListSubscriptionsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends PubsubRequest<Subscription> {
            private static final String REST_PATH = "v1beta1a/subscriptions/{+subscription}";
            private final Pattern SUBSCRIPTION_PATTERN;
            @Key
            private String subscription;

            protected Get(String subscription) {
                super(Pubsub.this, "GET", REST_PATH, null, Subscription.class);
                this.SUBSCRIPTION_PATTERN = Pattern.compile("^.+$");
                this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^.+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getSubscription() {
                return this.subscription;
            }

            public Get setSubscription(String subscription) {
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^.+$");
                }
                this.subscription = subscription;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends PubsubRequest<Empty> {
            private static final String REST_PATH = "v1beta1a/subscriptions/{+subscription}";
            private final Pattern SUBSCRIPTION_PATTERN;
            @Key
            private String subscription;

            protected Delete(String subscription) {
                super(Pubsub.this, "DELETE", REST_PATH, null, Empty.class);
                this.SUBSCRIPTION_PATTERN = Pattern.compile("^.+$");
                this.subscription = (String)Preconditions.checkNotNull((Object)subscription, (Object)"Required parameter subscription must be specified.");
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^.+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getSubscription() {
                return this.subscription;
            }

            public Delete setSubscription(String subscription) {
                if (!Pubsub.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBSCRIPTION_PATTERN.matcher(subscription).matches(), (Object)"Parameter subscription must conform to the pattern ^.+$");
                }
                this.subscription = subscription;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends PubsubRequest<Subscription> {
            private static final String REST_PATH = "v1beta1a/subscriptions";

            protected Create(Subscription content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, Subscription.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class Acknowledge
        extends PubsubRequest<Empty> {
            private static final String REST_PATH = "v1beta1a/subscriptions/acknowledge";

            protected Acknowledge(AcknowledgeRequest content) {
                super(Pubsub.this, "POST", REST_PATH, (Object)content, Empty.class);
            }

            public Acknowledge set$Xgafv(String $Xgafv) {
                return (Acknowledge)super.set$Xgafv($Xgafv);
            }

            public Acknowledge setAccessToken(String accessToken) {
                return (Acknowledge)super.setAccessToken(accessToken);
            }

            public Acknowledge setAlt(String alt) {
                return (Acknowledge)super.setAlt(alt);
            }

            public Acknowledge setCallback(String callback) {
                return (Acknowledge)super.setCallback(callback);
            }

            public Acknowledge setFields(String fields) {
                return (Acknowledge)super.setFields(fields);
            }

            public Acknowledge setKey(String key) {
                return (Acknowledge)super.setKey(key);
            }

            public Acknowledge setOauthToken(String oauthToken) {
                return (Acknowledge)super.setOauthToken(oauthToken);
            }

            public Acknowledge setPrettyPrint(Boolean prettyPrint) {
                return (Acknowledge)super.setPrettyPrint(prettyPrint);
            }

            public Acknowledge setQuotaUser(String quotaUser) {
                return (Acknowledge)super.setQuotaUser(quotaUser);
            }

            public Acknowledge setUploadType(String uploadType) {
                return (Acknowledge)super.setUploadType(uploadType);
            }

            public Acknowledge setUploadProtocol(String uploadProtocol) {
                return (Acknowledge)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Acknowledge set(String parameterName, Object value) {
                return (Acknowledge)super.set(parameterName, value);
            }
        }
    }
}

