/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A Relocate Bucket request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RelocateBucketRequest extends com.google.api.client.json.GenericJson {

  /**
   * The bucket's new custom placement configuration if relocating to a Custom Dual Region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DestinationCustomPlacementConfig destinationCustomPlacementConfig;

  /**
   * The new location the bucket will be relocated to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destinationLocation;

  /**
   * If true, validate the operation, but do not actually relocate the bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean validateOnly;

  /**
   * The bucket's new custom placement configuration if relocating to a Custom Dual Region.
   * @return value or {@code null} for none
   */
  public DestinationCustomPlacementConfig getDestinationCustomPlacementConfig() {
    return destinationCustomPlacementConfig;
  }

  /**
   * The bucket's new custom placement configuration if relocating to a Custom Dual Region.
   * @param destinationCustomPlacementConfig destinationCustomPlacementConfig or {@code null} for none
   */
  public RelocateBucketRequest setDestinationCustomPlacementConfig(DestinationCustomPlacementConfig destinationCustomPlacementConfig) {
    this.destinationCustomPlacementConfig = destinationCustomPlacementConfig;
    return this;
  }

  /**
   * The new location the bucket will be relocated to.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestinationLocation() {
    return destinationLocation;
  }

  /**
   * The new location the bucket will be relocated to.
   * @param destinationLocation destinationLocation or {@code null} for none
   */
  public RelocateBucketRequest setDestinationLocation(java.lang.String destinationLocation) {
    this.destinationLocation = destinationLocation;
    return this;
  }

  /**
   * If true, validate the operation, but do not actually relocate the bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getValidateOnly() {
    return validateOnly;
  }

  /**
   * If true, validate the operation, but do not actually relocate the bucket.
   * @param validateOnly validateOnly or {@code null} for none
   */
  public RelocateBucketRequest setValidateOnly(java.lang.Boolean validateOnly) {
    this.validateOnly = validateOnly;
    return this;
  }

  @Override
  public RelocateBucketRequest set(String fieldName, Object value) {
    return (RelocateBucketRequest) super.set(fieldName, value);
  }

  @Override
  public RelocateBucketRequest clone() {
    return (RelocateBucketRequest) super.clone();
  }

  /**
   * The bucket's new custom placement configuration if relocating to a Custom Dual Region.
   */
  public static final class DestinationCustomPlacementConfig extends com.google.api.client.json.GenericJson {

    /**
     * The list of regional locations in which data is placed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> dataLocations;

    /**
     * The list of regional locations in which data is placed.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getDataLocations() {
      return dataLocations;
    }

    /**
     * The list of regional locations in which data is placed.
     * @param dataLocations dataLocations or {@code null} for none
     */
    public DestinationCustomPlacementConfig setDataLocations(java.util.List<java.lang.String> dataLocations) {
      this.dataLocations = dataLocations;
      return this;
    }

    @Override
    public DestinationCustomPlacementConfig set(String fieldName, Object value) {
      return (DestinationCustomPlacementConfig) super.set(fieldName, value);
    }

    @Override
    public DestinationCustomPlacementConfig clone() {
      return (DestinationCustomPlacementConfig) super.clone();
    }

  }

}
