/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A managed folder.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedFolder extends com.google.api.client.json.GenericJson {

  /**
   * The name of the bucket containing this managed folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * The creation time of the managed folder in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createTime;

  /**
   * The ID of the managed folder, including the bucket name and managed folder name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of item this is. For managed folders, this is always storage#managedFolder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The version of the metadata for this managed folder. Used for preconditions and for detecting
   * changes in metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long metageneration;

  /**
   * The name of the managed folder. Required if not specified by URL parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The link to this managed folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The last update time of the managed folder metadata in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updateTime;

  /**
   * The name of the bucket containing this managed folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket containing this managed folder.
   * @param bucket bucket or {@code null} for none
   */
  public ManagedFolder setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The creation time of the managed folder in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreateTime() {
    return createTime;
  }

  /**
   * The creation time of the managed folder in RFC 3339 format.
   * @param createTime createTime or {@code null} for none
   */
  public ManagedFolder setCreateTime(com.google.api.client.util.DateTime createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The ID of the managed folder, including the bucket name and managed folder name.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the managed folder, including the bucket name and managed folder name.
   * @param id id or {@code null} for none
   */
  public ManagedFolder setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For managed folders, this is always storage#managedFolder.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For managed folders, this is always storage#managedFolder.
   * @param kind kind or {@code null} for none
   */
  public ManagedFolder setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The version of the metadata for this managed folder. Used for preconditions and for detecting
   * changes in metadata.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMetageneration() {
    return metageneration;
  }

  /**
   * The version of the metadata for this managed folder. Used for preconditions and for detecting
   * changes in metadata.
   * @param metageneration metageneration or {@code null} for none
   */
  public ManagedFolder setMetageneration(java.lang.Long metageneration) {
    this.metageneration = metageneration;
    return this;
  }

  /**
   * The name of the managed folder. Required if not specified by URL parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the managed folder. Required if not specified by URL parameter.
   * @param name name or {@code null} for none
   */
  public ManagedFolder setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The link to this managed folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this managed folder.
   * @param selfLink selfLink or {@code null} for none
   */
  public ManagedFolder setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The last update time of the managed folder metadata in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdateTime() {
    return updateTime;
  }

  /**
   * The last update time of the managed folder metadata in RFC 3339 format.
   * @param updateTime updateTime or {@code null} for none
   */
  public ManagedFolder setUpdateTime(com.google.api.client.util.DateTime updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public ManagedFolder set(String fieldName, Object value) {
    return (ManagedFolder) super.set(fieldName, value);
  }

  @Override
  public ManagedFolder clone() {
    return (ManagedFolder) super.clone();
  }

}
